/*
 * Decompiled with CFR 0.152.
 */
package ecgberht.BehaviourTrees.Training;

import bwem.Base;
import ecgberht.GameState;
import ecgberht.Util.Util;
import java.util.Map;
import org.iaie.btree.BehavioralTree;
import org.iaie.btree.task.leaf.Action;
import org.openbw.bwapi4j.type.Race;
import org.openbw.bwapi4j.type.UnitType;
import org.openbw.bwapi4j.unit.Barracks;
import org.openbw.bwapi4j.unit.CommandCenter;

public class ChooseSCV
extends Action {
    public ChooseSCV(String name, GameState gh) {
        super(name, gh);
    }

    @Override
    public BehavioralTree.State execute() {
        try {
            String strat = this.gameState.getStrat().name;
            if (strat.equals("ProxyBBS") || strat.equals("ProxyEightRax")) {
                boolean notTraining = false;
                for (Barracks b : this.gameState.MBs) {
                    if (b.isTraining()) continue;
                    notTraining = true;
                    break;
                }
                if (notTraining) {
                    return BehavioralTree.State.FAILURE;
                }
            }
            if (this.gameState.enemyRace == Race.Zerg && this.gameState.learningManager.isNaughty() && Util.countBuildingAll(UnitType.Terran_Barracks) > 0 && Util.countBuildingAll(UnitType.Terran_Bunker) < 1 && (Integer)this.gameState.getCash().first < 150) {
                return BehavioralTree.State.FAILURE;
            }
            if (Util.countUnitTypeSelf(UnitType.Terran_SCV) <= 65 && Util.countUnitTypeSelf(UnitType.Terran_SCV) <= this.gameState.mineralsAssigned.size() * 2 + this.gameState.refineriesAssigned.size() * 3 + this.gameState.getStrat().extraSCVs && !this.gameState.CCs.isEmpty()) {
                for (Map.Entry<Base, CommandCenter> b : this.gameState.islandCCs.entrySet()) {
                    if (b.getValue().isTraining() || b.getValue().isBuildingAddon() || !Util.hasFreePatches(b.getKey())) continue;
                    this.gameState.chosenUnit = UnitType.Terran_SCV;
                    this.gameState.chosenTrainingFacility = b.getValue();
                    return BehavioralTree.State.SUCCESS;
                }
                for (Map.Entry<Base, CommandCenter> b : this.gameState.CCs.entrySet()) {
                    if (b.getValue().isTraining() || b.getValue().isBuildingAddon() || !Util.hasFreePatches(b.getKey())) continue;
                    this.gameState.chosenUnit = UnitType.Terran_SCV;
                    this.gameState.chosenTrainingFacility = b.getValue();
                    return BehavioralTree.State.SUCCESS;
                }
            }
            return BehavioralTree.State.FAILURE;
        }
        catch (Exception e) {
            System.err.println(this.getClass().getSimpleName());
            e.printStackTrace();
            return BehavioralTree.State.ERROR;
        }
    }
}

