/*
 * Decompiled with CFR 0.152.
 */
package ecgberht.BehaviourTrees.Training;

import ecgberht.GameState;
import ecgberht.Util.Util;
import java.util.Set;
import org.iaie.btree.BehavioralTree;
import org.iaie.btree.task.leaf.Action;
import org.openbw.bwapi4j.type.UnitType;
import org.openbw.bwapi4j.unit.Academy;
import org.openbw.bwapi4j.unit.Barracks;
import org.openbw.bwapi4j.unit.ResearchingFacility;

public class ChooseMedic
extends Action {
    public ChooseMedic(String name, GameState gh) {
        super(name, gh);
    }

    @Override
    public BehavioralTree.State execute() {
        try {
            if (this.gameState.UBs.isEmpty()) {
                return BehavioralTree.State.FAILURE;
            }
            for (ResearchingFacility u : this.gameState.UBs) {
                if (!(u instanceof Academy)) continue;
                int marine_count = 0;
                if (!this.gameState.DBs.isEmpty()) {
                    marine_count = this.gameState.DBs.values().stream().mapToInt(Set::size).sum();
                }
                if (this.gameState.MBs.isEmpty() || Util.countUnitTypeSelf(UnitType.Terran_Medic) * 4 >= Util.countUnitTypeSelf(UnitType.Terran_Marine) - marine_count) break;
                for (Barracks b : this.gameState.MBs) {
                    if (b.isTraining()) continue;
                    this.gameState.chosenUnit = UnitType.Terran_Medic;
                    this.gameState.chosenTrainingFacility = b;
                    return BehavioralTree.State.SUCCESS;
                }
            }
            return BehavioralTree.State.FAILURE;
        }
        catch (Exception e) {
            System.err.println(this.getClass().getSimpleName());
            e.printStackTrace();
            return BehavioralTree.State.ERROR;
        }
    }
}

