/*
 * Decompiled with CFR 0.152.
 */
package ecgberht.BehaviourTrees.Training;

import ecgberht.GameState;
import ecgberht.Util.Util;
import org.iaie.btree.BehavioralTree;
import org.iaie.btree.task.leaf.Action;
import org.openbw.bwapi4j.type.Race;
import org.openbw.bwapi4j.type.UnitType;
import org.openbw.bwapi4j.unit.Academy;
import org.openbw.bwapi4j.unit.Barracks;
import org.openbw.bwapi4j.unit.Firebat;
import org.openbw.bwapi4j.unit.ResearchingFacility;
import org.openbw.bwapi4j.unit.Unit;

public class ChooseFireBat
extends Action {
    public ChooseFireBat(String name, GameState gh) {
        super(name, gh);
    }

    @Override
    public BehavioralTree.State execute() {
        try {
            if (this.gameState.enemyRace != Race.Zerg || this.gameState.UBs.isEmpty()) {
                return BehavioralTree.State.FAILURE;
            }
            if (Util.countUnitTypeSelf(UnitType.Terran_Marine) >= 4) {
                for (ResearchingFacility r : this.gameState.UBs) {
                    if (!(r instanceof Academy)) continue;
                    int count = 0;
                    for (Unit unit : this.gameState.getGame().getUnits(this.gameState.getPlayer())) {
                        if (!unit.exists()) continue;
                        if (unit instanceof Firebat) {
                            ++count;
                        }
                        if (count < this.gameState.maxBats) continue;
                        return BehavioralTree.State.FAILURE;
                    }
                    for (Barracks barracks : this.gameState.MBs) {
                        if (barracks.isTraining()) continue;
                        this.gameState.chosenUnit = UnitType.Terran_Firebat;
                        this.gameState.chosenTrainingFacility = barracks;
                        return BehavioralTree.State.SUCCESS;
                    }
                }
            }
            return BehavioralTree.State.FAILURE;
        }
        catch (Exception e) {
            System.err.println(this.getClass().getSimpleName());
            e.printStackTrace();
            return BehavioralTree.State.ERROR;
        }
    }
}

