/*
 * Decompiled with CFR 0.152.
 */
package ecgberht.BehaviourTrees.Scouting;

import ecgberht.GameState;
import ecgberht.Squad;
import ecgberht.UnitInfo;
import org.iaie.btree.BehavioralTree;
import org.iaie.btree.task.leaf.Action;
import org.openbw.bwapi4j.unit.MineralPatch;
import org.openbw.bwapi4j.unit.MobileUnit;
import org.openbw.bwapi4j.unit.Worker;
import org.openbw.bwapi4j.unit.Wraith;

public class ChooseScout
extends Action {
    public ChooseScout(String name, GameState gh) {
        super(name, gh);
    }

    @Override
    public BehavioralTree.State execute() {
        try {
            if (this.gameState.getStrat().name.equals("PlasmaWraithHell")) {
                for (Squad s : this.gameState.sqManager.squads.values()) {
                    for (UnitInfo u : s.members) {
                        if (!(u.unit instanceof Wraith)) continue;
                        this.gameState.chosenScout = (MobileUnit)u.unit;
                        s.members.remove(u);
                        return BehavioralTree.State.SUCCESS;
                    }
                }
            }
            if (!this.gameState.workerIdle.isEmpty()) {
                Worker chosen = this.gameState.workerIdle.iterator().next();
                this.gameState.chosenScout = chosen;
                this.gameState.workerIdle.remove(chosen);
            }
            if (this.gameState.chosenScout == null) {
                for (Worker u : this.gameState.workerMining.keySet()) {
                    if (u.isCarryingMinerals()) continue;
                    this.gameState.chosenScout = u;
                    MineralPatch mineral = this.gameState.workerMining.get(u);
                    if (this.gameState.mineralsAssigned.containsKey(mineral)) {
                        --this.gameState.mining;
                        this.gameState.mineralsAssigned.put(mineral, this.gameState.mineralsAssigned.get(mineral) - 1);
                    }
                    this.gameState.workerMining.remove(u);
                    break;
                }
            }
            if (this.gameState.chosenScout != null) {
                return BehavioralTree.State.SUCCESS;
            }
            return BehavioralTree.State.FAILURE;
        }
        catch (Exception e) {
            System.err.println(this.getClass().getSimpleName());
            e.printStackTrace();
            return BehavioralTree.State.ERROR;
        }
    }
}

