/*
 * Decompiled with CFR 0.152.
 */
package ecgberht.BehaviourTrees.Repair;

import bwem.Area;
import bwem.Base;
import ecgberht.GameState;
import ecgberht.IntelligenceAgency;
import ecgberht.Squad;
import ecgberht.UnitInfo;
import ecgberht.Util.Util;
import java.util.ArrayList;
import java.util.Map;
import org.iaie.btree.BehavioralTree;
import org.iaie.btree.task.leaf.Action;
import org.openbw.bwapi4j.type.Order;
import org.openbw.bwapi4j.type.UnitType;
import org.openbw.bwapi4j.unit.Barracks;
import org.openbw.bwapi4j.unit.Bunker;
import org.openbw.bwapi4j.unit.CommandCenter;
import org.openbw.bwapi4j.unit.ComsatStation;
import org.openbw.bwapi4j.unit.Factory;
import org.openbw.bwapi4j.unit.Mechanical;
import org.openbw.bwapi4j.unit.MissileTurret;
import org.openbw.bwapi4j.unit.ResearchingFacility;
import org.openbw.bwapi4j.unit.SCV;
import org.openbw.bwapi4j.unit.Starport;
import org.openbw.bwapi4j.unit.SupplyDepot;

public class CheckBuildingFlames
extends Action {
    public CheckBuildingFlames(String name, GameState gh) {
        super(name, gh);
    }

    @Override
    public BehavioralTree.State execute() {
        try {
            ArrayList<SCV> toRemove = new ArrayList<SCV>();
            for (Map.Entry<SCV, Mechanical> u : this.gameState.repairerTask.entrySet()) {
                if (u.getValue().maxHitPoints() != u.getValue().getHitPoints()) {
                    if (u.getKey().getOrder() == Order.Follow || u.getKey().getOrder() == Order.Repair) continue;
                    u.getKey().rightClick(u.getValue(), false);
                    continue;
                }
                if (Util.countBuildingAll(UnitType.Terran_Command_Center) < 2 && u.getValue() instanceof Bunker && IntelligenceAgency.getEnemyStrat() == IntelligenceAgency.EnemyStrats.ZealotRush && (double)this.gameState.frameCount >= 3168.0000000000005) {
                    if (u.getKey().getDistance(u.getValue()) <= 96) continue;
                    u.getKey().move(u.getValue().getPosition());
                    continue;
                }
                if (Util.countBuildingAll(UnitType.Terran_Command_Center) == 2 && this.gameState.CCs.size() < 2 && u.getValue() instanceof Bunker) {
                    if (u.getKey().getDistance(u.getValue()) <= 96) continue;
                    u.getKey().move(u.getValue().getPosition());
                    continue;
                }
                u.getKey().stop(false);
                this.gameState.workerIdle.add(u.getKey());
                toRemove.add(u.getKey());
            }
            for (SCV s : toRemove) {
                this.gameState.repairerTask.remove(s);
            }
            boolean cheesed = IntelligenceAgency.getEnemyStrat() == IntelligenceAgency.EnemyStrats.ZealotRush && (double)this.gameState.frameCount >= 3168.0000000000005;
            boolean fastExpanding = this.gameState.getStrat().name.contains("GreedyFE") && Util.countBuildingAll(UnitType.Terran_Command_Center) == 2 && this.gameState.CCs.size() < 2 && this.gameState.firstExpand;
            for (Bunker bunker : this.gameState.DBs.keySet()) {
                int count = 0;
                if (UnitType.Terran_Bunker.maxHitPoints() == bunker.getHitPoints() && (!cheesed || Util.countBuildingAll(UnitType.Terran_Command_Center) >= 2) && !fastExpanding) continue;
                for (Mechanical r : this.gameState.repairerTask.values()) {
                    if (!bunker.equals(r)) continue;
                    ++count;
                }
                if (count < 2 && (this.gameState.defense || cheesed || fastExpanding)) {
                    this.gameState.chosenUnitRepair = bunker;
                    return BehavioralTree.State.SUCCESS;
                }
                if (count != 0) continue;
                this.gameState.chosenUnitRepair = bunker;
                return BehavioralTree.State.SUCCESS;
            }
            boolean isBeingRepaired = false;
            for (MissileTurret missileTurret : this.gameState.Ts) {
                if (UnitType.Terran_Missile_Turret.maxHitPoints() == missileTurret.getHitPoints()) continue;
                for (Mechanical r : this.gameState.repairerTask.values()) {
                    if (!missileTurret.equals(r)) continue;
                    isBeingRepaired = true;
                }
                if (isBeingRepaired) continue;
                this.gameState.chosenUnitRepair = missileTurret;
                return BehavioralTree.State.SUCCESS;
            }
            isBeingRepaired = false;
            for (Squad squad : this.gameState.sqManager.squads.values()) {
                if (squad.status != Squad.Status.IDLE) continue;
                for (UnitInfo u : squad.members) {
                    if (!(u.unit instanceof Mechanical) || u.health == u.unitType.maxHitPoints()) continue;
                    Area unitArea = this.gameState.bwem.getMap().getArea(u.tileposition);
                    for (Base b : this.gameState.CCs.keySet()) {
                        if (unitArea == null || !b.getArea().equals(unitArea)) continue;
                        for (Mechanical r : this.gameState.repairerTask.values()) {
                            if (!u.unit.equals(r)) continue;
                            isBeingRepaired = true;
                        }
                        if (isBeingRepaired) continue;
                        this.gameState.chosenUnitRepair = (Mechanical)u.unit;
                        return BehavioralTree.State.SUCCESS;
                    }
                }
            }
            if (!this.gameState.getStrat().proxy) {
                isBeingRepaired = false;
                for (Barracks barracks : this.gameState.MBs) {
                    if (UnitType.Terran_Barracks.maxHitPoints() == barracks.getHitPoints()) continue;
                    for (Mechanical r : this.gameState.repairerTask.values()) {
                        if (!barracks.equals(r)) continue;
                        isBeingRepaired = true;
                    }
                    if (isBeingRepaired) continue;
                    this.gameState.chosenUnitRepair = barracks;
                    return BehavioralTree.State.SUCCESS;
                }
            }
            isBeingRepaired = false;
            for (Factory factory : this.gameState.Fs) {
                if (factory.equals(this.gameState.proxyBuilding) || UnitType.Terran_Factory.maxHitPoints() == factory.getHitPoints()) continue;
                for (Mechanical r : this.gameState.repairerTask.values()) {
                    if (!factory.equals(r)) continue;
                    isBeingRepaired = true;
                }
                if (isBeingRepaired) continue;
                this.gameState.chosenUnitRepair = factory;
                return BehavioralTree.State.SUCCESS;
            }
            isBeingRepaired = false;
            for (ResearchingFacility researchingFacility : this.gameState.UBs) {
                if (researchingFacility.getType().maxHitPoints() == researchingFacility.getHitPoints()) continue;
                for (Mechanical r : this.gameState.repairerTask.values()) {
                    if (!researchingFacility.equals(r)) continue;
                    isBeingRepaired = true;
                }
                if (isBeingRepaired) continue;
                this.gameState.chosenUnitRepair = (Mechanical)((Object)researchingFacility);
                return BehavioralTree.State.SUCCESS;
            }
            isBeingRepaired = false;
            for (SupplyDepot supplyDepot : this.gameState.SBs) {
                if (UnitType.Terran_Supply_Depot.maxHitPoints() == supplyDepot.getHitPoints()) continue;
                for (Mechanical r : this.gameState.repairerTask.values()) {
                    if (!supplyDepot.equals(r)) continue;
                    isBeingRepaired = true;
                }
                if (isBeingRepaired) continue;
                this.gameState.chosenUnitRepair = supplyDepot;
                return BehavioralTree.State.SUCCESS;
            }
            isBeingRepaired = false;
            for (CommandCenter commandCenter : this.gameState.CCs.values()) {
                if (UnitType.Terran_Command_Center.maxHitPoints() == commandCenter.getHitPoints()) continue;
                for (Mechanical r : this.gameState.repairerTask.values()) {
                    if (!commandCenter.equals(r)) continue;
                    isBeingRepaired = true;
                }
                if (isBeingRepaired) continue;
                this.gameState.chosenUnitRepair = commandCenter;
                return BehavioralTree.State.SUCCESS;
            }
            isBeingRepaired = false;
            for (ComsatStation comsatStation : this.gameState.CSs) {
                if (UnitType.Terran_Comsat_Station.maxHitPoints() == comsatStation.getHitPoints()) continue;
                for (Mechanical r : this.gameState.repairerTask.values()) {
                    if (!comsatStation.equals(r)) continue;
                    isBeingRepaired = true;
                }
                if (isBeingRepaired) continue;
                this.gameState.chosenUnitRepair = comsatStation;
                return BehavioralTree.State.SUCCESS;
            }
            isBeingRepaired = false;
            for (Starport starport : this.gameState.Ps) {
                if (UnitType.Terran_Starport.maxHitPoints() == starport.getHitPoints()) continue;
                for (Mechanical r : this.gameState.repairerTask.values()) {
                    if (!starport.equals(r)) continue;
                    isBeingRepaired = true;
                }
                if (isBeingRepaired) continue;
                this.gameState.chosenUnitRepair = starport;
                return BehavioralTree.State.SUCCESS;
            }
            return BehavioralTree.State.FAILURE;
        }
        catch (Exception e) {
            System.err.println(this.getClass().getSimpleName());
            e.printStackTrace();
            return BehavioralTree.State.ERROR;
        }
    }
}

