/*
 * Decompiled with CFR 0.152.
 */
package ecgberht.BehaviourTrees.Recollection;

import ecgberht.GameState;
import java.util.Map;
import org.iaie.btree.BehavioralTree;
import org.iaie.btree.task.leaf.Action;
import org.openbw.bwapi4j.unit.MineralPatch;
import org.openbw.bwapi4j.unit.Worker;

public class CollectMineral
extends Action {
    public CollectMineral(String name, GameState gh) {
        super(name, gh);
    }

    @Override
    public BehavioralTree.State execute() {
        try {
            Worker chosen = this.gameState.chosenWorker;
            if (!this.gameState.mineralsAssigned.isEmpty()) {
                MineralPatch closestMineral = null;
                int workerPerPatch = 2;
                if (this.gameState.workerMining.size() < 7) {
                    workerPerPatch = 1;
                }
                for (Map.Entry<MineralPatch, Integer> m : this.gameState.mineralsAssigned.entrySet()) {
                    if (closestMineral != null && chosen.getDistance(m.getKey()) >= chosen.getDistance(closestMineral) || m.getValue() >= workerPerPatch) continue;
                    closestMineral = m.getKey();
                }
                if (closestMineral != null && chosen.gather(closestMineral, false)) {
                    this.gameState.mineralsAssigned.put(closestMineral, this.gameState.mineralsAssigned.get(closestMineral) + 1);
                    this.gameState.workerMining.put(chosen, closestMineral);
                    this.gameState.workerIdle.remove(chosen);
                    this.gameState.chosenWorker = null;
                    ++this.gameState.mining;
                    return BehavioralTree.State.SUCCESS;
                }
            }
            return BehavioralTree.State.FAILURE;
        }
        catch (Exception e) {
            System.err.println(this.getClass().getSimpleName());
            e.printStackTrace();
            return BehavioralTree.State.ERROR;
        }
    }
}

