/*
 * Decompiled with CFR 0.152.
 */
package ecgberht.BehaviourTrees.IslandExpansion;

import ecgberht.GameState;
import java.util.Collections;
import java.util.TreeSet;
import org.iaie.btree.BehavioralTree;
import org.iaie.btree.task.leaf.Action;
import org.openbw.bwapi4j.unit.MineralPatch;
import org.openbw.bwapi4j.unit.Unit;
import org.openbw.bwapi4j.unit.Worker;

public class SendToDrop
extends Action {
    public SendToDrop(String name, GameState gh) {
        super(name, gh);
    }

    @Override
    public BehavioralTree.State execute() {
        try {
            if (this.gameState.chosenDropShip != null && this.gameState.chosenWorker != null) {
                Worker chosen = this.gameState.chosenWorker;
                if (this.gameState.workerIdle.contains(chosen)) {
                    this.gameState.workerIdle.remove(chosen);
                } else if (this.gameState.workerMining.containsKey(chosen)) {
                    MineralPatch mineral = this.gameState.workerMining.get(chosen);
                    this.gameState.workerMining.remove(chosen);
                    if (this.gameState.mineralsAssigned.containsKey(mineral)) {
                        --this.gameState.mining;
                        this.gameState.mineralsAssigned.put(mineral, this.gameState.mineralsAssigned.get(mineral) - 1);
                    }
                }
                this.gameState.chosenDropShip.setCargo(new TreeSet<Unit>(Collections.singletonList(this.gameState.chosenWorker)));
                this.gameState.chosenDropShip.setTarget(this.gameState.chosenIsland.getLocation().toPosition());
                this.gameState.chosenWorkerDrop = this.gameState.chosenWorker;
                this.gameState.chosenWorker = null;
                return BehavioralTree.State.SUCCESS;
            }
            this.gameState.chosenDropShip = null;
            this.gameState.chosenWorker = null;
            this.gameState.chosenIsland = null;
            return BehavioralTree.State.FAILURE;
        }
        catch (Exception e) {
            System.err.println(this.getClass().getSimpleName());
            e.printStackTrace();
            return BehavioralTree.State.ERROR;
        }
    }
}

