/*
 * Decompiled with CFR 0.152.
 */
package ecgberht.BehaviourTrees.IslandExpansion;

import ecgberht.GameState;
import org.iaie.btree.BehavioralTree;
import org.iaie.btree.task.leaf.Action;
import org.openbw.bwapi4j.Position;
import org.openbw.bwapi4j.unit.Worker;

public class ChooseWorkerDrop
extends Action {
    public ChooseWorkerDrop(String name, GameState gh) {
        super(name, gh);
    }

    @Override
    public BehavioralTree.State execute() {
        try {
            Worker closestWorker = null;
            int frame = this.gameState.frameCount;
            Position chosen = this.gameState.chosenDropShip.unit.getPosition();
            if (!this.gameState.workerIdle.isEmpty()) {
                for (Worker u : this.gameState.workerIdle) {
                    if (u.isCarryingMinerals() || u.getLastCommandFrame() == frame || closestWorker != null && !(u.getDistance(chosen) < closestWorker.getDistance(chosen))) continue;
                    closestWorker = u;
                }
            }
            if (!this.gameState.workerMining.isEmpty()) {
                for (Worker u : this.gameState.workerMining.keySet()) {
                    if (u.isCarryingMinerals() || u.getLastCommandFrame() == frame || closestWorker != null && !(u.getDistance(chosen) < closestWorker.getDistance(chosen)) || u.isCarryingMinerals()) continue;
                    closestWorker = u;
                }
            }
            if (closestWorker != null) {
                this.gameState.chosenWorker = closestWorker;
                return BehavioralTree.State.SUCCESS;
            }
            this.gameState.chosenDropShip = null;
            this.gameState.chosenWorker = null;
            this.gameState.chosenIsland = null;
            return BehavioralTree.State.FAILURE;
        }
        catch (Exception e) {
            System.err.println(this.getClass().getSimpleName());
            e.printStackTrace();
            return BehavioralTree.State.ERROR;
        }
    }
}

