/*
 * Decompiled with CFR 0.152.
 */
package ecgberht.BehaviourTrees.IslandExpansion;

import bwem.Base;
import ecgberht.GameState;
import ecgberht.Util.Util;
import org.iaie.btree.BehavioralTree;
import org.iaie.btree.task.leaf.Action;
import org.openbw.bwapi4j.Position;

public class ChooseIsland
extends Action {
    public ChooseIsland(String name, GameState gh) {
        super(name, gh);
    }

    @Override
    public BehavioralTree.State execute() {
        try {
            Base chosen = null;
            double distMax = Double.MAX_VALUE;
            Position drop = this.gameState.chosenDropShip.unit.getPosition();
            for (Base b : this.gameState.islandBases) {
                double dist;
                if (this.gameState.islandCCs.containsKey(b) || !((dist = Util.broodWarDistance(b.getLocation().toPosition(), drop)) < distMax)) continue;
                distMax = dist;
                chosen = b;
            }
            if (chosen != null) {
                this.gameState.chosenIsland = chosen;
                return BehavioralTree.State.SUCCESS;
            }
            this.gameState.chosenDropShip = null;
            this.gameState.chosenWorker = null;
            this.gameState.chosenIsland = null;
            return BehavioralTree.State.FAILURE;
        }
        catch (Exception e) {
            System.err.println(this.getClass().getSimpleName());
            e.printStackTrace();
            return BehavioralTree.State.ERROR;
        }
    }
}

