/*
 * Decompiled with CFR 0.152.
 */
package ecgberht.BehaviourTrees.Harass;

import ecgberht.GameState;
import ecgberht.IntelligenceAgency;
import ecgberht.UnitInfo;
import ecgberht.Util.UtilMicro;
import java.util.Comparator;
import java.util.Optional;
import java.util.TreeSet;
import org.iaie.btree.BehavioralTree;
import org.iaie.btree.task.leaf.Conditional;
import org.openbw.bwapi4j.Position;
import org.openbw.bwapi4j.unit.Attacker;
import org.openbw.bwapi4j.unit.Building;
import org.openbw.bwapi4j.unit.Worker;

public class CheckHarasserAttacked
extends Conditional {
    public CheckHarasserAttacked(String name, GameState gh) {
        super(name, gh);
    }

    @Override
    public BehavioralTree.State execute() {
        try {
            if (this.gameState.enemyMainBase == null) {
                this.gameState.chosenUnitToHarass = null;
                this.gameState.chosenHarasser = null;
                return BehavioralTree.State.FAILURE;
            }
            if (this.gameState.chosenUnitToHarass != null && !this.gameState.bw.getBWMap().isValidPosition(this.gameState.chosenUnitToHarass.getPosition())) {
                this.gameState.chosenUnitToHarass = null;
            }
            UnitInfo attacker = null;
            int workers = 0;
            TreeSet<UnitInfo> attackers = new TreeSet<UnitInfo>();
            for (UnitInfo u2 : this.gameState.unitStorage.getAllyUnits().get((Object)this.gameState.chosenHarasser).attackers) {
                if (u2.unit instanceof Building || !(u2.unit instanceof Attacker) || !u2.unit.exists()) continue;
                if (u2.unit instanceof Worker) {
                    ++workers;
                    attacker = u2;
                }
                attackers.add(u2);
            }
            if (workers > 1) {
                this.gameState.learningManager.setHarass(true);
                this.gameState.chosenUnitToHarass = null;
                return BehavioralTree.State.FAILURE;
            }
            if (attackers.isEmpty()) {
                if (!this.gameState.getGame().getBWMap().isVisible(this.gameState.enemyMainBase.getLocation()) && this.gameState.chosenUnitToHarass == null) {
                    this.gameState.chosenHarasser.move(this.gameState.enemyMainBase.getLocation().toPosition());
                }
                return BehavioralTree.State.SUCCESS;
            }
            boolean winHarass = this.gameState.sim.simulateHarass(this.gameState.chosenHarasser, attackers, 70);
            if (winHarass) {
                if (workers == 1 && !attacker.unit.equals(this.gameState.chosenUnitToHarass)) {
                    UtilMicro.attack(this.gameState.chosenHarasser, attacker);
                    this.gameState.chosenUnitToHarass = attacker.unit;
                    return BehavioralTree.State.SUCCESS;
                }
            } else {
                if (IntelligenceAgency.getEnemyStrat() == IntelligenceAgency.EnemyStrats.Unknown) {
                    this.gameState.explore = true;
                    this.gameState.chosenUnitToHarass = null;
                    this.gameState.chosenHarasser.stop(false);
                    return BehavioralTree.State.FAILURE;
                }
                if (this.gameState.chosenHarasser.getHitPoints() <= 15) {
                    this.gameState.workerIdle.add(this.gameState.chosenHarasser);
                    this.gameState.chosenHarasser.stop(false);
                    this.gameState.chosenHarasser = null;
                    this.gameState.chosenUnitToHarass = null;
                } else {
                    Optional<UnitInfo> closestUnit = attackers.stream().min(Comparator.comparing(u -> u.getDistance(this.gameState.chosenHarasser)));
                    Position kite = closestUnit.map(unit1 -> UtilMicro.kiteAwayAlt(this.gameState.chosenHarasser.getPosition(), unit1.position)).orElse(null);
                    if (kite != null && this.gameState.bw.getBWMap().isValidPosition(kite)) {
                        UtilMicro.move(this.gameState.chosenHarasser, kite);
                        this.gameState.chosenUnitToHarass = null;
                    } else {
                        kite = UtilMicro.kiteAway(this.gameState.chosenHarasser, attackers);
                        if (kite != null && this.gameState.bw.getBWMap().isValidPosition(kite)) {
                            UtilMicro.move(this.gameState.chosenHarasser, kite);
                            this.gameState.chosenUnitToHarass = null;
                        }
                    }
                }
                return BehavioralTree.State.FAILURE;
            }
            return BehavioralTree.State.SUCCESS;
        }
        catch (Exception e) {
            System.err.println(this.getClass().getSimpleName());
            e.printStackTrace();
            return BehavioralTree.State.ERROR;
        }
    }
}

