/*
 * Decompiled with CFR 0.152.
 */
package ecgberht.BehaviourTrees.Defense;

import ecgberht.GameState;
import ecgberht.Util.Util;
import org.iaie.btree.BehavioralTree;
import org.iaie.btree.task.leaf.Conditional;
import org.openbw.bwapi4j.Position;
import org.openbw.bwapi4j.unit.Building;
import org.openbw.bwapi4j.unit.Bunker;
import org.openbw.bwapi4j.unit.Mechanical;
import org.openbw.bwapi4j.unit.Organic;
import org.openbw.bwapi4j.unit.Transporter;
import org.openbw.bwapi4j.unit.Unit;
import org.openbw.bwapi4j.unit.Worker;

public class ChooseDefensePosition
extends Conditional {
    public ChooseDefensePosition(String name, GameState gh) {
        super(name, gh);
    }

    private Position getDefensePosition() {
        if (this.gameState.defendPosition != null) {
            return this.gameState.defendPosition;
        }
        if (this.gameState.initDefensePosition != null) {
            return this.gameState.initDefensePosition.toPosition();
        }
        if (this.gameState.mainChoke != null) {
            return this.gameState.mainChoke.getCenter().toPosition();
        }
        return this.gameState.getPlayer().getStartLocation().toPosition();
    }

    private Position chooseDefensePosition() {
        Position chosen = null;
        double maxScore = 0.0;
        for (Unit b : this.gameState.enemyInBase) {
            double influence = this.getScore(b);
            double score = influence / (2.5 * (double)Util.getGroundDistance(this.getDefensePosition(), b.getPosition()));
            if (!(score > maxScore)) continue;
            chosen = b.getPosition();
            maxScore = score;
        }
        return chosen;
    }

    private double getScore(Unit unit) {
        if (unit instanceof Building && unit.getType().canAttack() || unit instanceof Bunker) {
            return 6.0;
        }
        if (unit instanceof Building) {
            return 5.0;
        }
        if (unit instanceof Organic) {
            return 2.0;
        }
        if (unit instanceof Worker) {
            return 1.0;
        }
        if (unit instanceof Mechanical) {
            return 3.0;
        }
        if (unit instanceof Transporter) {
            return 4.0;
        }
        return 1.0;
    }

    @Override
    public BehavioralTree.State execute() {
        try {
            Position chosenDefensePosition;
            if (this.gameState.defense && (chosenDefensePosition = this.chooseDefensePosition()) != null) {
                this.gameState.attackPosition = chosenDefensePosition;
                return BehavioralTree.State.SUCCESS;
            }
            return BehavioralTree.State.FAILURE;
        }
        catch (Exception e) {
            System.err.println(this.getClass().getSimpleName());
            e.printStackTrace();
            return BehavioralTree.State.ERROR;
        }
    }
}

