/*
 * Decompiled with CFR 0.152.
 */
package ecgberht.BehaviourTrees.Build;

import bwem.Base;
import ecgberht.Agents.Agent;
import ecgberht.Agents.DropShipAgent;
import ecgberht.GameState;
import ecgberht.UnitInfo;
import ecgberht.Util.MutablePair;
import ecgberht.Util.Util;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import org.iaie.btree.BehavioralTree;
import org.iaie.btree.task.leaf.Action;
import org.openbw.bwapi4j.Player;
import org.openbw.bwapi4j.TilePosition;
import org.openbw.bwapi4j.type.Race;
import org.openbw.bwapi4j.type.UnitType;
import org.openbw.bwapi4j.unit.Attacker;
import org.openbw.bwapi4j.unit.Unit;
import org.openbw.bwapi4j.unit.UnitImpl;
import org.openbw.bwapi4j.unit.VespeneGeyser;
import org.openbw.bwapi4j.unit.Worker;

public class ChoosePosition
extends Action {
    public ChoosePosition(String name, GameState gh) {
        super(name, gh);
    }

    @Override
    public BehavioralTree.State execute() {
        try {
            if (this.gameState.chosenToBuild == UnitType.None) {
                return BehavioralTree.State.FAILURE;
            }
            Player self = this.gameState.getPlayer();
            if (this.gameState.chosenToBuild.isRefinery()) {
                if (!this.gameState.vespeneGeysers.isEmpty()) {
                    for (Map.Entry<VespeneGeyser, Boolean> g : this.gameState.vespeneGeysers.entrySet()) {
                        if (g.getValue().booleanValue()) continue;
                        this.gameState.chosenPosition = g.getKey().getTilePosition();
                        return BehavioralTree.State.SUCCESS;
                    }
                }
            } else {
                TilePosition origin;
                if (this.gameState.chosenToBuild == UnitType.Terran_Command_Center) {
                    if (!this.gameState.islandBases.isEmpty() && this.gameState.islandCCs.size() < this.gameState.islandBases.size()) {
                        if (this.gameState.islandExpand) {
                            return BehavioralTree.State.FAILURE;
                        }
                        for (Agent u2 : this.gameState.agents.values()) {
                            if (!(u2 instanceof DropShipAgent) || !u2.statusToString().equals("IDLE")) continue;
                            this.gameState.islandExpand = true;
                            return BehavioralTree.State.FAILURE;
                        }
                    }
                    TilePosition main = this.gameState.mainCC != null ? ((Unit)this.gameState.mainCC.second).getTilePosition() : this.gameState.getPlayer().getStartLocation();
                    ArrayList<Base> valid = new ArrayList<Base>();
                    if (this.gameState.getStrat().name.equals("PlasmaWraithHell")) {
                        for (Base b : this.gameState.specialBLs) {
                            if (this.gameState.CCs.containsKey(b)) continue;
                            this.gameState.chosenPosition = b.getLocation();
                            return BehavioralTree.State.SUCCESS;
                        }
                    }
                    for (Base b : this.gameState.BLs) {
                        if (this.gameState.CCs.containsKey(b) || !Util.isConnected(b.getLocation(), main)) continue;
                        valid.add(b);
                    }
                    ArrayList<Base> remove = new ArrayList<Base>();
                    block6: for (Base b : valid) {
                        if (this.gameState.getGame().getBWMap().isVisible(b.getLocation()) && !this.gameState.getGame().getBWMap().isBuildable(b.getLocation(), true)) {
                            remove.add(b);
                            continue;
                        }
                        if (b.getArea() == this.gameState.naturalArea) continue;
                        for (Unit unit : this.gameState.enemyCombatUnitMemory) {
                            if (this.gameState.bwem.getMap().getArea(unit.getTilePosition()) == null || !(unit instanceof Attacker) || unit instanceof Worker || !this.gameState.bwem.getMap().getArea(unit.getTilePosition()).equals(b.getArea())) continue;
                            remove.add(b);
                            break;
                        }
                        for (UnitInfo unitInfo : this.gameState.unitStorage.getEnemyUnits().values().stream().filter(u -> u.unitType.isBuilding()).collect(Collectors.toSet())) {
                            if (this.gameState.bwem.getMap().getArea(unitInfo.tileposition) == null || !this.gameState.bwem.getMap().getArea(unitInfo.tileposition).equals(b.getArea())) continue;
                            remove.add(b);
                            continue block6;
                        }
                    }
                    valid.removeAll(remove);
                    if (valid.isEmpty()) {
                        return BehavioralTree.State.FAILURE;
                    }
                    this.gameState.chosenPosition = ((Base)valid.get(0)).getLocation();
                    return BehavioralTree.State.SUCCESS;
                }
                if (!this.gameState.workerBuild.isEmpty()) {
                    for (MutablePair<UnitType, TilePosition> w : this.gameState.workerBuild.values()) {
                        this.gameState.testMap.updateMap((TilePosition)w.second, (UnitType)w.first, false);
                    }
                }
                if (!this.gameState.chosenToBuild.equals(UnitType.Terran_Bunker) && !this.gameState.chosenToBuild.equals(UnitType.Terran_Missile_Turret)) {
                    origin = this.gameState.getStrat().proxy && this.gameState.chosenToBuild == UnitType.Terran_Barracks ? this.gameState.mapCenter.toTilePosition() : (this.gameState.mainCC != null && this.gameState.mainCC.first != null ? ((Base)this.gameState.mainCC.first).getLocation() : self.getStartLocation());
                } else if (this.gameState.chosenToBuild.equals(UnitType.Terran_Missile_Turret)) {
                    origin = this.gameState.defendPosition != null ? this.gameState.defendPosition.toTilePosition() : (this.gameState.DBs.isEmpty() ? Util.getClosestChokepoint(self.getStartLocation().toPosition()).getCenter().toTilePosition() : (TilePosition)this.gameState.DBs.keySet().stream().findFirst().map(UnitImpl::getTilePosition).orElse(null));
                } else if (this.gameState.learningManager.isNaughty() && this.gameState.enemyRace == Race.Zerg) {
                    origin = this.gameState.getBunkerPositionAntiPool();
                    if (origin != null) {
                        this.gameState.testMap = this.gameState.map.clone();
                        this.gameState.chosenPosition = origin;
                        return BehavioralTree.State.SUCCESS;
                    }
                    origin = this.gameState.testMap.findBunkerPositionAntiPool();
                    if (origin != null) {
                        this.gameState.testMap = this.gameState.map.clone();
                        this.gameState.chosenPosition = origin;
                        return BehavioralTree.State.SUCCESS;
                    }
                    origin = this.gameState.mainCC != null ? ((Unit)this.gameState.mainCC.second).getTilePosition() : this.gameState.getPlayer().getStartLocation();
                } else if (this.gameState.Ts.isEmpty()) {
                    if (this.gameState.defendPosition != null && this.gameState.naturalChoke != null && this.gameState.defendPosition.equals(this.gameState.naturalChoke.getCenter().toPosition()) && (origin = this.gameState.testMap.findBunkerPosition(this.gameState.naturalChoke)) != null) {
                        this.gameState.testMap = this.gameState.map.clone();
                        this.gameState.chosenPosition = origin;
                        return BehavioralTree.State.SUCCESS;
                    }
                    if (!(this.gameState.mainChoke == null || this.gameState.getStrat().name.equals("MechGreedyFE") || this.gameState.getStrat().name.equals("BioGreedyFE") || this.gameState.getStrat().name.equals("14CC") || this.gameState.getStrat().name.equals("BioMechGreedyFE"))) {
                        origin = this.gameState.testMap.findBunkerPosition(this.gameState.mainChoke);
                        if (origin != null) {
                            this.gameState.testMap = this.gameState.map.clone();
                            this.gameState.chosenPosition = origin;
                            return BehavioralTree.State.SUCCESS;
                        }
                        origin = this.gameState.mainChoke.getCenter().toTilePosition();
                    } else if (this.gameState.naturalChoke != null) {
                        origin = this.gameState.testMap.findBunkerPosition(this.gameState.naturalChoke);
                        if (origin != null) {
                            this.gameState.testMap = this.gameState.map.clone();
                            this.gameState.chosenPosition = origin;
                            return BehavioralTree.State.SUCCESS;
                        }
                        origin = this.gameState.mainChoke.getCenter().toTilePosition();
                    } else {
                        origin = this.gameState.testMap.findBunkerPosition(this.gameState.mainChoke);
                        if (origin != null) {
                            this.gameState.testMap = this.gameState.map.clone();
                            this.gameState.chosenPosition = origin;
                            return BehavioralTree.State.SUCCESS;
                        }
                        origin = this.gameState.mainChoke.getCenter().toTilePosition();
                    }
                } else {
                    origin = this.gameState.Ts.stream().findFirst().map(UnitImpl::getTilePosition).orElse(null);
                }
                TilePosition position = this.gameState.testMap.findPositionNew(this.gameState.chosenToBuild, origin);
                this.gameState.testMap = this.gameState.map.clone();
                if (position != null) {
                    this.gameState.chosenPosition = position;
                    return BehavioralTree.State.SUCCESS;
                }
            }
            return BehavioralTree.State.FAILURE;
        }
        catch (Exception e) {
            System.err.println(this.getClass().getSimpleName());
            e.printStackTrace();
            return BehavioralTree.State.ERROR;
        }
    }
}

