/*
 * Decompiled with CFR 0.152.
 */
package ecgberht.BehaviourTrees.Build;

import ecgberht.GameState;
import ecgberht.Util.MutablePair;
import ecgberht.Util.Util;
import org.iaie.btree.BehavioralTree;
import org.iaie.btree.task.leaf.Action;
import org.openbw.bwapi4j.TilePosition;
import org.openbw.bwapi4j.type.Race;
import org.openbw.bwapi4j.type.TechType;
import org.openbw.bwapi4j.type.UnitType;
import org.openbw.bwapi4j.unit.Barracks;
import org.openbw.bwapi4j.unit.Building;
import org.openbw.bwapi4j.unit.Factory;

public class ChooseBarracks
extends Action {
    public ChooseBarracks(String name, GameState gh) {
        super(name, gh);
    }

    @Override
    public BehavioralTree.State execute() {
        try {
            String strat = this.gameState.getStrat().name;
            if ((strat.equals("BioGreedyFE") || strat.equals("MechGreedyFE") || strat.equals("BioMechGreedyFE")) && Util.countBuildingAll(UnitType.Terran_Command_Center) == 1 && Util.countBuildingAll(UnitType.Terran_Barracks) > 1 && this.gameState.frameCount <= 5760) {
                return BehavioralTree.State.FAILURE;
            }
            if (strat.equals("14CC") && Util.countBuildingAll(UnitType.Terran_Command_Center) < 2) {
                return BehavioralTree.State.FAILURE;
            }
            if (!this.gameState.getStrat().techToResearch.contains(TechType.Stim_Packs) && this.gameState.getStrat().raxPerCC == 1 && this.gameState.MBs.size() > 0) {
                return BehavioralTree.State.FAILURE;
            }
            if (this.gameState.learningManager.isNaughty() && this.gameState.enemyRace == Race.Zerg && Util.countBuildingAll(UnitType.Terran_Barracks) == 1 && Util.countBuildingAll(UnitType.Terran_Bunker) < 1) {
                return BehavioralTree.State.FAILURE;
            }
            if (!strat.equals("ProxyBBS") && !strat.equals("ProxyEightRax")) {
                if (!this.gameState.MBs.isEmpty() && Util.countBuildingAll(UnitType.Terran_Barracks) == this.gameState.getStrat().numRaxForAca && Util.countBuildingAll(UnitType.Terran_Academy) == 0) {
                    return BehavioralTree.State.FAILURE;
                }
                if (Util.countBuildingAll(UnitType.Terran_Barracks) == this.gameState.getStrat().numRaxForAca && Util.countBuildingAll(UnitType.Terran_Refinery) == 0) {
                    return BehavioralTree.State.FAILURE;
                }
            } else if (this.gameState.getPlayer().supplyUsed() < 16) {
                return BehavioralTree.State.FAILURE;
            }
            if (this.gameState.getStrat().buildUnits.contains(UnitType.Terran_Factory)) {
                int count = 0;
                boolean found = false;
                for (MutablePair<UnitType, TilePosition> mutablePair : this.gameState.workerBuild.values()) {
                    if (mutablePair.first == UnitType.Terran_Barracks) {
                        ++count;
                    }
                    if (mutablePair.first != UnitType.Terran_Factory) continue;
                    found = true;
                }
                for (Building building : this.gameState.workerTask.values()) {
                    if (building instanceof Barracks) {
                        ++count;
                    }
                    if (!(building instanceof Factory)) continue;
                    found = true;
                }
                if (!this.gameState.Fs.isEmpty()) {
                    found = true;
                }
                if (count + this.gameState.MBs.size() > this.gameState.getStrat().numRaxForFac && !found) {
                    return BehavioralTree.State.FAILURE;
                }
            }
            if (Util.countBuildingAll(UnitType.Terran_Academy) == 0 && Util.countBuildingAll(UnitType.Terran_Barracks) >= 2) {
                return BehavioralTree.State.FAILURE;
            }
            if (Util.countBuildingAll(UnitType.Terran_Barracks) == this.gameState.MBs.size() && this.gameState.getPlayer().minerals() >= 600) {
                this.gameState.chosenToBuild = UnitType.Terran_Barracks;
                return BehavioralTree.State.SUCCESS;
            }
            if (Util.countBuildingAll(UnitType.Terran_Barracks) < this.gameState.getStrat().raxPerCC * Util.getNumberCCs()) {
                this.gameState.chosenToBuild = UnitType.Terran_Barracks;
                return BehavioralTree.State.SUCCESS;
            }
            return BehavioralTree.State.FAILURE;
        }
        catch (Exception e) {
            System.err.println(this.getClass().getSimpleName());
            e.printStackTrace();
            return BehavioralTree.State.ERROR;
        }
    }
}

