/*
 * Decompiled with CFR 0.152.
 */
package ecgberht.BehaviourTrees.Build;

import ecgberht.GameState;
import ecgberht.Util.MutablePair;
import ecgberht.Util.Util;
import org.iaie.btree.BehavioralTree;
import org.iaie.btree.task.leaf.Action;
import org.openbw.bwapi4j.TilePosition;
import org.openbw.bwapi4j.type.TechType;
import org.openbw.bwapi4j.type.UnitType;
import org.openbw.bwapi4j.unit.Armory;
import org.openbw.bwapi4j.unit.Building;

public class ChooseArmory
extends Action {
    public ChooseArmory(String name, GameState gh) {
        super(name, gh);
    }

    @Override
    public BehavioralTree.State execute() {
        try {
            if (this.gameState.Fs.isEmpty() || !this.gameState.getPlayer().hasResearched(TechType.Tank_Siege_Mode)) {
                return BehavioralTree.State.FAILURE;
            }
            if (this.gameState.Fs.size() < this.gameState.getStrat().facForArmory) {
                return BehavioralTree.State.FAILURE;
            }
            if (Util.countUnitTypeSelf(UnitType.Terran_Armory) < this.gameState.getStrat().numArmories) {
                for (MutablePair<UnitType, TilePosition> mutablePair : this.gameState.workerBuild.values()) {
                    if (mutablePair.first != UnitType.Terran_Armory) continue;
                    return BehavioralTree.State.FAILURE;
                }
                for (Building building : this.gameState.workerTask.values()) {
                    if (!(building instanceof Armory)) continue;
                    return BehavioralTree.State.FAILURE;
                }
                this.gameState.chosenToBuild = UnitType.Terran_Armory;
                return BehavioralTree.State.SUCCESS;
            }
            return BehavioralTree.State.FAILURE;
        }
        catch (Exception e) {
            System.err.println(this.getClass().getSimpleName());
            e.printStackTrace();
            return BehavioralTree.State.ERROR;
        }
    }
}

