/*
 * Decompiled with CFR 0.152.
 */
package ecgberht.BehaviourTrees.Build;

import ecgberht.GameState;
import ecgberht.IntelligenceAgency;
import ecgberht.Strategy;
import ecgberht.Util.MutablePair;
import ecgberht.Util.Util;
import org.iaie.btree.BehavioralTree;
import org.iaie.btree.task.leaf.Action;
import org.openbw.bwapi4j.TilePosition;
import org.openbw.bwapi4j.type.UnitType;
import org.openbw.bwapi4j.unit.Academy;
import org.openbw.bwapi4j.unit.Building;

public class ChooseAcademy
extends Action {
    public ChooseAcademy(String name, GameState gh) {
        super(name, gh);
    }

    @Override
    public BehavioralTree.State execute() {
        try {
            if (Util.countBuildingAll(UnitType.Terran_Refinery) == 0 || Util.countBuildingAll(UnitType.Terran_Academy) > 0) {
                return BehavioralTree.State.FAILURE;
            }
            Strategy strat = this.gameState.getStrat();
            if (strat.name.equals("FullMech") || strat.name.equals("MechGreedyFE")) {
                if (this.gameState.Fs.size() >= strat.facPerCC || IntelligenceAgency.enemyHasType(UnitType.Protoss_Dark_Templar) || IntelligenceAgency.enemyHasType(UnitType.Zerg_Lurker)) {
                    this.gameState.chosenToBuild = UnitType.Terran_Academy;
                    return BehavioralTree.State.SUCCESS;
                }
                return BehavioralTree.State.FAILURE;
            }
            if (Util.countBuildingAll(UnitType.Terran_Barracks) >= this.gameState.getStrat().numRaxForAca) {
                for (MutablePair<UnitType, TilePosition> mutablePair : this.gameState.workerBuild.values()) {
                    if (mutablePair.first != UnitType.Terran_Academy) continue;
                    return BehavioralTree.State.FAILURE;
                }
                for (Building building : this.gameState.workerTask.values()) {
                    if (!(building instanceof Academy)) continue;
                    return BehavioralTree.State.FAILURE;
                }
                this.gameState.chosenToBuild = UnitType.Terran_Academy;
                return BehavioralTree.State.SUCCESS;
            }
            return BehavioralTree.State.FAILURE;
        }
        catch (Exception e) {
            System.err.println(this.getClass().getSimpleName());
            e.printStackTrace();
            return BehavioralTree.State.ERROR;
        }
    }
}

