/*
 * Decompiled with CFR 0.152.
 */
package ecgberht.BehaviourTrees.Build;

import ecgberht.GameState;
import ecgberht.Util.MutablePair;
import ecgberht.Util.Util;
import org.iaie.btree.BehavioralTree;
import org.iaie.btree.task.leaf.Conditional;
import org.openbw.bwapi4j.Position;
import org.openbw.bwapi4j.TilePosition;
import org.openbw.bwapi4j.type.UnitType;
import org.openbw.bwapi4j.unit.Worker;

public class CheckResourcesBuilding
extends Conditional {
    public CheckResourcesBuilding(String name, GameState gh) {
        super(name, gh);
    }

    @Override
    public BehavioralTree.State execute() {
        try {
            if (this.gameState.chosenPosition == null) {
                this.gameState.chosenWorker = null;
                return BehavioralTree.State.FAILURE;
            }
            MutablePair<Integer, Integer> cash = this.gameState.getCash();
            Worker chosen = this.gameState.chosenWorker;
            TilePosition start = chosen.getTilePosition();
            TilePosition end = this.gameState.chosenPosition;
            Position realEnd = Util.getUnitCenterPosition(end.toPosition(), this.gameState.chosenToBuild);
            if (this.gameState.getStrat().name.equals("ProxyBBS") && this.gameState.chosenToBuild == UnitType.Terran_Barracks) {
                if (Util.countBuildingAll(UnitType.Terran_Barracks) < 1 ? (Integer)cash.first + this.gameState.getMineralsWhenReaching(start, realEnd.toTilePosition()) >= this.gameState.chosenToBuild.mineralPrice() * 2 + 40 + (Integer)this.gameState.deltaCash.first && (Integer)cash.second >= this.gameState.chosenToBuild.gasPrice() * 2 + (Integer)this.gameState.deltaCash.second : Util.countBuildingAll(UnitType.Terran_Barracks) == 1) {
                    return BehavioralTree.State.SUCCESS;
                }
                return BehavioralTree.State.FAILURE;
            }
            if ((Integer)cash.first + this.gameState.getMineralsWhenReaching(start, realEnd.toTilePosition()) >= this.gameState.chosenToBuild.mineralPrice() + (Integer)this.gameState.deltaCash.first && (Integer)cash.second >= this.gameState.chosenToBuild.gasPrice() + (Integer)this.gameState.deltaCash.second) {
                return BehavioralTree.State.SUCCESS;
            }
            this.gameState.chosenWorker = null;
            this.gameState.chosenPosition = null;
            return BehavioralTree.State.FAILURE;
        }
        catch (Exception e) {
            System.err.println(this.getClass().getSimpleName());
            e.printStackTrace();
            return BehavioralTree.State.ERROR;
        }
    }
}

