/*
 * Decompiled with CFR 0.152.
 */
package cameraModule;

import java.util.List;
import org.openbw.bwapi4j.BW;
import org.openbw.bwapi4j.Player;
import org.openbw.bwapi4j.Position;
import org.openbw.bwapi4j.TilePosition;
import org.openbw.bwapi4j.type.UnitType;
import org.openbw.bwapi4j.unit.NuclearMissile;
import org.openbw.bwapi4j.unit.PlayerUnit;
import org.openbw.bwapi4j.unit.Transporter;
import org.openbw.bwapi4j.unit.Unit;
import org.openbw.bwapi4j.unit.Worker;

public class CameraModule {
    private Position myStartLocation;
    private int scrWidth = 640;
    private int scrHeight = 480;
    private int cameraMoveTime = 150;
    private int cameraMoveTimeMin = 50;
    private int watchScoutWorkerUntil = 7500;
    private int lastMoved = 0;
    private int lastMovedPriority = 0;
    private Position currentCameraPosition;
    private Position cameraFocusPosition;
    private Unit cameraFocusUnit = null;
    private boolean followUnit = false;
    private boolean enabled = false;
    private BW game;
    private Player self;

    public CameraModule(TilePosition startPos, BW game) {
        this.myStartLocation = startPos.toPosition();
        this.cameraFocusPosition = startPos.toPosition();
        this.currentCameraPosition = startPos.toPosition();
        this.game = game;
        this.self = game.getInteractionHandler().self();
    }

    public void onFrame() {
        if (this.enabled) {
            this.moveCameraFallingNuke();
            this.moveCameraIsUnderAttack();
            this.moveCameraIsAttacking();
            if (this.game.getInteractionHandler().getFrameCount() <= this.watchScoutWorkerUntil) {
                this.moveCameraScoutWorker();
            }
            this.moveCameraArmy();
            this.moveCameraDrop();
            this.updateCameraPosition();
        }
    }

    private boolean isNearStartLocation(Position pos) {
        int distance = 1000;
        List<TilePosition> startLocations = this.game.getBWMap().getStartPositions();
        for (TilePosition it : startLocations) {
            Position startLocation = it.toPosition();
            if (this.isNearOwnStartLocation(startLocation) || startLocation.getDistance(pos) > distance) continue;
            return true;
        }
        return false;
    }

    private boolean isNearOwnStartLocation(Position pos) {
        int distance = 320;
        return this.myStartLocation.getDistance(pos) <= distance;
    }

    private boolean isArmyUnit(Unit unit) {
        UnitType type = unit.getType();
        return !type.isWorker() && !type.isBuilding() && type != UnitType.Terran_Vulture_Spider_Mine && type != UnitType.Zerg_Overlord && type != UnitType.Zerg_Larva;
    }

    private boolean shouldMoveCamera(int priority) {
        boolean isTimeToMove = this.game.getInteractionHandler().getFrameCount() - this.lastMoved >= this.cameraMoveTime;
        boolean isTimeToMoveIfHigherPrio = this.game.getInteractionHandler().getFrameCount() - this.lastMoved >= this.cameraMoveTimeMin;
        boolean isHigherPrio = this.lastMovedPriority < priority;
        return isTimeToMove || isHigherPrio && isTimeToMoveIfHigherPrio;
    }

    private void moveCamera(Position pos, int priority) {
        if (!this.shouldMoveCamera(priority)) {
            return;
        }
        if (!this.followUnit && this.cameraFocusPosition == pos) {
            return;
        }
        this.cameraFocusPosition = pos;
        this.lastMoved = this.game.getInteractionHandler().getFrameCount();
        this.lastMovedPriority = priority;
        this.followUnit = false;
    }

    private void moveCamera(Unit unit, int priority) {
        if (!this.shouldMoveCamera(priority)) {
            return;
        }
        if (this.followUnit && this.cameraFocusUnit == unit) {
            return;
        }
        this.cameraFocusUnit = unit;
        this.lastMoved = this.game.getInteractionHandler().getFrameCount();
        this.lastMovedPriority = priority;
        this.followUnit = true;
    }

    private void moveCameraIsAttacking() {
        int prio = 3;
        if (!this.shouldMoveCamera(prio)) {
            return;
        }
        for (PlayerUnit unit : this.game.getUnits(this.self)) {
            if (!unit.isAttacking()) continue;
            this.moveCamera(unit, prio);
        }
    }

    private void moveCameraIsUnderAttack() {
        int prio = 3;
        if (!this.shouldMoveCamera(prio)) {
            return;
        }
        for (PlayerUnit unit : this.game.getUnits(this.self)) {
            if (!unit.isUnderAttack()) continue;
            this.moveCamera(unit, prio);
        }
    }

    private void moveCameraScoutWorker() {
        int highPrio = 2;
        int lowPrio = 0;
        if (!this.shouldMoveCamera(lowPrio)) {
            return;
        }
        for (PlayerUnit unit : this.game.getUnits(this.self)) {
            if (!unit.exists() || !(unit instanceof Worker) || !unit.isCompleted()) continue;
            if (this.isNearStartLocation(unit.getPosition())) {
                this.moveCamera(unit, highPrio);
                continue;
            }
            if (this.isNearOwnStartLocation(unit.getPosition())) continue;
            this.moveCamera(unit, lowPrio);
        }
    }

    private void moveCameraFallingNuke() {
        int prio = 5;
        if (!this.shouldMoveCamera(prio)) {
            return;
        }
        for (Unit unit : this.game.getAllUnits()) {
            if (!(unit instanceof NuclearMissile) || !(((NuclearMissile)unit).getVelocityY() > 0.0)) continue;
            this.moveCamera(unit, prio);
            return;
        }
    }

    public void moveCameraNukeDetect(Position target) {
        int prio = 4;
        if (this.shouldMoveCamera(prio)) {
            this.moveCamera(target, prio);
        }
    }

    private void moveCameraDrop() {
        int prio = 2;
        if (!this.shouldMoveCamera(prio)) {
            return;
        }
        for (PlayerUnit unit : this.game.getUnits(this.self)) {
            if (!unit.exists() || unit.isCompleted() || !(unit instanceof Transporter) || !this.isNearStartLocation(unit.getPosition()) || ((Transporter)unit).getLoadedUnits().size() <= 0) continue;
            this.moveCamera(unit, prio);
        }
    }

    private void moveCameraArmy() {
        int prio = 1;
        if (!this.shouldMoveCamera(prio)) {
            return;
        }
        int radius = 50;
        Unit bestPosUnit = null;
        int mostUnitsNearby = 0;
        for (Unit unit : this.game.getAllUnits()) {
            if (!unit.exists() || !(unit instanceof PlayerUnit) || !this.isArmyUnit(unit)) continue;
            int nrUnitsNearby = 0;
            for (Unit unit2 : unit.getUnitsInRadius(radius, this.game.getAllUnits())) {
                if (!unit2.exists() || !(unit2 instanceof PlayerUnit) || !this.isArmyUnit(unit2)) continue;
                ++nrUnitsNearby;
            }
            if (nrUnitsNearby <= mostUnitsNearby) continue;
            mostUnitsNearby = nrUnitsNearby;
            bestPosUnit = unit;
        }
        if (mostUnitsNearby > 1) {
            this.moveCamera(bestPosUnit, prio);
        }
    }

    public void moveCameraUnitCompleted(Unit unit) {
        int prio;
        if (this.enabled && unit != null && this.shouldMoveCamera(prio = 1) && unit instanceof PlayerUnit && ((PlayerUnit)unit).getPlayer().equals(this.self) && !(unit instanceof Worker)) {
            this.moveCamera(unit, prio);
        }
    }

    private void updateCameraPosition() {
        double moveFactor = 0.1;
        if (this.followUnit && this.game.getBWMap().isValidPosition(this.cameraFocusUnit.getPosition())) {
            this.cameraFocusPosition = this.cameraFocusUnit.getPosition();
        }
        this.currentCameraPosition = this.currentCameraPosition.add(new Position((int)(moveFactor * (double)(this.cameraFocusPosition.getX() - this.currentCameraPosition.getX())), (int)(moveFactor * (double)(this.cameraFocusPosition.getY() - this.currentCameraPosition.getY()))));
        Position currentMovedPosition = this.currentCameraPosition.subtract(new Position(this.scrWidth / 2, this.scrHeight / 2 - 40));
        if (this.game.getBWMap().isValidPosition(this.currentCameraPosition)) {
            this.game.getInteractionHandler().setScreenPosition(currentMovedPosition);
        }
    }

    public void toggle() {
        this.enabled = !this.enabled;
    }
}

