/*
 * Decompiled with CFR 0.152.
 */
package bwem;

import bwem.Altitude;
import bwem.AreaId;
import bwem.Asserter;
import bwem.Neutral;
import bwem.util.Markable;
import bwem.util.StaticMarkable;

public final class Tile {
    private static final StaticMarkable staticMarkable = new StaticMarkable();
    private final Markable markable = new Markable(staticMarkable);
    private Neutral neutral = null;
    private Altitude lowestAltitude = Altitude.ZERO;
    private AreaId areaId = AreaId.ZERO;
    private int internalData = 0;
    private GroundHeight groundHeight = GroundHeight.LOW_GROUND;
    private boolean isBuildable = false;
    private boolean isDoodad = false;
    private final Asserter asserter;

    Tile(Asserter asserter) {
        this.asserter = asserter;
    }

    static StaticMarkable getStaticMarkable() {
        return staticMarkable;
    }

    Markable getMarkable() {
        return this.markable;
    }

    public boolean isBuildable() {
        return this.isBuildable;
    }

    public AreaId getAreaId() {
        return this.areaId;
    }

    void setAreaId(AreaId areaId) {
        if (areaId.intValue() != -1 && (this.getAreaId().intValue() != 0 || areaId.intValue() == 0)) {
            this.asserter.throwIllegalStateException("");
        }
        this.areaId = areaId;
    }

    public Altitude getLowestAltitude() {
        return this.lowestAltitude;
    }

    void setLowestAltitude(Altitude lowestAltitude) {
        if (lowestAltitude.intValue() < 0) {
            this.asserter.throwIllegalStateException("");
        }
        this.lowestAltitude = lowestAltitude;
    }

    public boolean isWalkable() {
        return this.getAreaId().intValue() != 0;
    }

    public boolean isTerrain() {
        return this.isWalkable();
    }

    public GroundHeight getGroundHeight() {
        return this.groundHeight;
    }

    void setGroundHeight(int groundHeight) {
        this.groundHeight = GroundHeight.parseGroundHeight(groundHeight);
    }

    public boolean isDoodad() {
        return this.isDoodad;
    }

    public Neutral getNeutral() {
        return this.neutral;
    }

    public int getStackedNeutralCount() {
        int stackSize = 0;
        for (Neutral stackedNeutral = this.getNeutral(); stackedNeutral != null; stackedNeutral = stackedNeutral.getNextStacked()) {
            ++stackSize;
        }
        return stackSize;
    }

    void setBuildable() {
        this.isBuildable = true;
    }

    void setDoodad() {
        this.isDoodad = true;
    }

    void addNeutral(Neutral neutral) {
        if (this.getNeutral() != null || neutral == null) {
            this.asserter.throwIllegalStateException("");
        }
        this.neutral = neutral;
    }

    void resetAreaId() {
        this.areaId = AreaId.ZERO;
    }

    void removeNeutral(Neutral neutral) {
        if (!this.getNeutral().equals(neutral)) {
            this.asserter.throwIllegalStateException("");
        }
        this.neutral = null;
    }

    int getInternalData() {
        return this.internalData;
    }

    void setInternalData(int internalData) {
        this.internalData = internalData;
    }

    public static enum GroundHeight {
        LOW_GROUND,
        HIGH_GROUND,
        VERY_HIGH_GROUND;


        static GroundHeight parseGroundHeight(int height) {
            return GroundHeight.values()[height];
        }
    }
}

