/*
 * Decompiled with CFR 0.152.
 */
package bwem;

import bwem.BWMap;
import bwem.Geyser;
import bwem.Mineral;
import bwem.StaticBuilding;
import java.util.ArrayList;
import java.util.List;
import org.openbw.bwapi4j.type.UnitType;
import org.openbw.bwapi4j.unit.Unit;

public final class NeutralData {
    private final List<Mineral> minerals = new ArrayList<Mineral>();
    private final List<Geyser> geysers;
    private final List<StaticBuilding> staticBuildings;

    NeutralData(BWMap map, List<Unit> mineralPatches, List<Unit> vespeneGeysers, List<Unit> neutralUnits) {
        for (Unit mineralPatch : mineralPatches) {
            this.minerals.add(new Mineral(mineralPatch, map));
        }
        this.geysers = new ArrayList<Geyser>();
        for (Unit vespeneGeyser : vespeneGeysers) {
            this.geysers.add(new Geyser(vespeneGeyser, map));
        }
        this.staticBuildings = new ArrayList<StaticBuilding>();
        for (Unit neutralUnit : neutralUnits) {
            if (neutralUnit.getType().isBuilding()) {
                this.staticBuildings.add(new StaticBuilding(neutralUnit, map));
            }
            if (neutralUnit.getType() != UnitType.Special_Pit_Door && neutralUnit.getType() != UnitType.Special_Right_Pit_Door) continue;
            this.staticBuildings.add(new StaticBuilding(neutralUnit, map));
        }
    }

    public List<Mineral> getMinerals() {
        return this.minerals;
    }

    public Mineral getMineral(Unit unit) {
        for (Mineral mineral : this.getMinerals()) {
            if (!mineral.getUnit().equals(unit)) continue;
            return mineral;
        }
        return null;
    }

    public List<Geyser> getGeysers() {
        return this.geysers;
    }

    public Geyser getGeyser(Unit unit) {
        for (Geyser geyser : this.getGeysers()) {
            if (!geyser.getUnit().equals(unit)) continue;
            return geyser;
        }
        return null;
    }

    public List<StaticBuilding> getStaticBuildings() {
        return this.staticBuildings;
    }
}

