/*
 * Decompiled with CFR 0.152.
 */
package bwem;

import bwem.Area;
import bwem.BWMap;
import bwem.CPPath;
import bwem.Graph;
import bwem.Neutral;
import bwem.util.CheckMode;
import bwem.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.openbw.bwapi4j.WalkPosition;

public final class ChokePoint {
    private final Graph graph;
    private final boolean isPseudo;
    private final int index;
    private final Pair<Area, Area> areas;
    private final WalkPosition[] nodes;
    private final List<Pair<WalkPosition, WalkPosition>> nodesInArea;
    private final List<WalkPosition> geometry;
    private boolean isBlocked;
    private Neutral blockingNeutral;
    private ChokePoint pathBackTrace = null;

    ChokePoint(Graph graph, int index, Area area1, Area area2, List<WalkPosition> geometry, Neutral blockingNeutral) {
        int i;
        if (geometry.isEmpty()) {
            graph.getMap().asserter.throwIllegalStateException("");
        }
        this.graph = graph;
        this.index = index;
        this.areas = new Pair<Area, Area>(area1, area2);
        this.geometry = geometry;
        this.blockingNeutral = blockingNeutral != null ? this.getMap().getData().getTile(blockingNeutral.getTopLeft()).getNeutral() : blockingNeutral;
        this.isPseudo = this.isBlocked = blockingNeutral != null;
        this.nodes = new WalkPosition[Node.NODE_COUNT.ordinal()];
        this.nodes[Node.END1.ordinal()] = geometry.get(0);
        this.nodes[Node.END2.ordinal()] = geometry.get(geometry.size() - 1);
        this.nodesInArea = new ArrayList<Pair<WalkPosition, WalkPosition>>(Node.NODE_COUNT.ordinal());
        for (i = 0; i < Node.NODE_COUNT.ordinal(); ++i) {
            this.nodesInArea.add(new Pair<WalkPosition, WalkPosition>(new WalkPosition(0, 0), new WalkPosition(0, 0)));
        }
        for (i = geometry.size() / 2; i > 0 && this.getMap().getData().getMiniTile(geometry.get(i - 1)).getAltitude().intValue() > this.getMap().getData().getMiniTile(geometry.get(i)).getAltitude().intValue(); --i) {
        }
        while (i < geometry.size() - 1 && this.getMap().getData().getMiniTile(geometry.get(i + 1)).getAltitude().intValue() > this.getMap().getData().getMiniTile(geometry.get(i)).getAltitude().intValue()) {
            ++i;
        }
        this.nodes[Node.MIDDLE.ordinal()] = geometry.get(i);
        BWMap map = this.getMap();
        for (int n = 0; n < Node.NODE_COUNT.ordinal(); ++n) {
            for (Area area : new Area[]{area1, area2}) {
                WalkPosition nodeInArea = this.getGraph().getMap().breadthFirstSearch(this.nodes[n], (miniTile, w) -> miniTile.getAreaId().equals(area.getId()) && map.getData().getTile(w.toTilePosition(), CheckMode.NO_CHECK).getNeutral() == null, (miniTile, w) -> miniTile.getAreaId().equals(area.getId()) || this.isBlocked() && (miniTile.isBlocked() || map.getData().getTile(w.toTilePosition(), CheckMode.NO_CHECK).getNeutral() != null));
                WalkPosition left = this.nodesInArea.get(n).getLeft();
                WalkPosition right = this.nodesInArea.get(n).getRight();
                Pair<WalkPosition, WalkPosition> replacementPair = new Pair<WalkPosition, WalkPosition>(left, right);
                if (area.equals(this.areas.getLeft())) {
                    replacementPair.setLeft(nodeInArea);
                } else {
                    replacementPair.setRight(nodeInArea);
                }
                this.nodesInArea.set(n, replacementPair);
            }
        }
    }

    ChokePoint(Graph graph, int index, Area area1, Area area2, List<WalkPosition> geometry) {
        this(graph, index, area1, area2, geometry, null);
    }

    private BWMap getMap() {
        return this.graph.getMap();
    }

    private Graph getGraph() {
        return this.graph;
    }

    public boolean isPseudo() {
        return this.isPseudo;
    }

    public Pair<Area, Area> getAreas() {
        return this.areas;
    }

    public WalkPosition getCenter() {
        return this.getNodePosition(Node.MIDDLE);
    }

    public WalkPosition getNodePosition(Node node) {
        if (node.ordinal() >= Node.NODE_COUNT.ordinal()) {
            this.graph.getMap().asserter.throwIllegalStateException("");
        }
        return this.nodes[node.ordinal()];
    }

    public WalkPosition getNodePositionInArea(Node node, Area area) {
        if (!area.equals(this.areas.getLeft()) && !area.equals(this.areas.getRight())) {
            this.graph.getMap().asserter.throwIllegalStateException("");
        }
        return area.equals(this.areas.getLeft()) ? this.nodesInArea.get(node.ordinal()).getLeft() : this.nodesInArea.get(node.ordinal()).getRight();
    }

    public List<WalkPosition> getGeometry() {
        return this.geometry;
    }

    public boolean isBlocked() {
        return this.isBlocked;
    }

    public Neutral getBlockingNeutral() {
        return this.blockingNeutral;
    }

    public int distanceFrom(ChokePoint chokePoint) {
        return this.getGraph().distance(this, chokePoint);
    }

    public boolean accessibleFrom(ChokePoint chokePoint) {
        return this.distanceFrom(chokePoint) >= 0;
    }

    public CPPath getPathTo(ChokePoint cp) {
        return this.getGraph().getPath(this, cp);
    }

    void onBlockingNeutralDestroyed(Neutral pBlocking) {
        if (pBlocking == null) {
            throw new IllegalStateException();
        }
        if (!pBlocking.isBlocking()) {
            this.graph.getMap().asserter.throwIllegalStateException("");
        }
        if (pBlocking.equals(this.blockingNeutral)) {
            this.blockingNeutral = this.getMap().getData().getTile(this.blockingNeutral.getTopLeft()).getNeutral();
            if (this.blockingNeutral == null && this.getGraph().getMap().automaticPathUpdate()) {
                this.isBlocked = false;
            }
        }
    }

    int getIndex() {
        return this.index;
    }

    ChokePoint getPathBackTrace() {
        return this.pathBackTrace;
    }

    void setPathBackTrace(ChokePoint pathBackTrace) {
        this.pathBackTrace = pathBackTrace;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ChokePoint)) {
            return false;
        }
        ChokePoint that = (ChokePoint)object;
        boolean lel = this.areas.getLeft().equals(that.areas.getLeft());
        boolean ler = this.areas.getLeft().equals(that.areas.getRight());
        boolean rer = this.areas.getRight().equals(that.areas.getRight());
        boolean rel = this.areas.getRight().equals(that.areas.getLeft());
        return lel && rer || ler && rel;
    }

    public int hashCode() {
        int idRight;
        int idLeft = this.areas.getLeft().getId().intValue();
        if (idLeft > (idRight = this.areas.getRight().getId().intValue())) {
            int idLeftTmp = idLeft;
            idLeft = idRight;
            idRight = idLeftTmp;
        }
        return Objects.hash(idLeft, idRight);
    }

    public static enum Node {
        END1,
        MIDDLE,
        END2,
        NODE_COUNT;

    }
}

