/*
 * Decompiled with CFR 0.152.
 */
package bwem;

import bwem.Altitude;
import bwem.Area;
import bwem.AreaId;
import bwem.Asserter;
import bwem.BWMap;
import bwem.ChokePoint;
import bwem.MapData;
import bwem.Mineral;
import bwem.MiniTile;
import bwem.Neutral;
import bwem.NeutralData;
import bwem.StaticBuilding;
import bwem.TempAreaInfo;
import bwem.TerrainData;
import bwem.TileData;
import bwem.util.BwemExt;
import bwem.util.CheckMode;
import bwem.util.Pair;
import bwem.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openbw.bwapi4j.BW;
import org.openbw.bwapi4j.TilePosition;
import org.openbw.bwapi4j.WalkPosition;
import org.openbw.bwapi4j.unit.Unit;

class BWMapInitializer
extends BWMap {
    BWMapInitializer(BW game, Asserter asserter) {
        super(game, asserter);
    }

    void initialize() {
        this.initializeTerrainData(this.game.getBWMap().mapWidth(), this.game.getBWMap().mapHeight(), this.game.getBWMap().getStartPositions());
        TerrainData initializer = this.getData();
        initializer.markUnwalkableMiniTiles(this.game);
        initializer.markBuildableTilesAndGroundHeight(this.game);
        initializer.decideSeasOrLakes();
        this.initializeNeutralData(this.mineralPatches, this.vespeneGeysers, this.filterNeutralPlayerUnits(this.units, this.players));
        this.computeAltitude(this.getData());
        this.processBlockingNeutrals(this.getCandidates(this.getNeutralData().getStaticBuildings(), this.getNeutralData().getMinerals()));
        this.computeAreas(this.computeTempAreas(this.getSortedMiniTilesByDescendingAltitude()));
        this.getGraph().createChokePoints(this.getNeutralData().getStaticBuildings(), this.getNeutralData().getMinerals(), this.getRawFrontier());
        this.getGraph().computeChokePointDistanceMatrix();
        this.getGraph().collectInformation();
        this.getGraph().createBases(this.getData());
    }

    private void initializeTerrainData(int mapTileWidth, int mapTileHeight, List<TilePosition> startingLocations) {
        MapData mapData = new MapData(mapTileWidth, mapTileHeight, startingLocations);
        TileData tileData = new TileData(mapData.getTileSize().getX() * mapData.getTileSize().getY(), mapData.getWalkSize().getX() * mapData.getWalkSize().getY(), this.asserter);
        this.terrainData = new TerrainData(mapData, tileData);
    }

    private void initializeNeutralData(List<Unit> mineralPatches, List<Unit> vespeneGeysers, List<Unit> neutralUnits) {
        this.neutralData = new NeutralData(this, mineralPatches, vespeneGeysers, neutralUnits);
    }

    private void computeAltitude(TerrainData terrainData) {
        int altitudeScale = 8;
        List<Pair<WalkPosition, Altitude>> deltasByAscendingAltitude = this.getSortedDeltasByAscendingAltitude(terrainData.getMapData().getWalkSize().getX(), terrainData.getMapData().getWalkSize().getY(), 8);
        List<Pair<WalkPosition, Altitude>> activeSeaSides = this.getActiveSeaSideList(terrainData);
        this.highestAltitude = this.setAltitudesAndGetUpdatedHighestAltitude(this.getHighestAltitude(), terrainData, deltasByAscendingAltitude, activeSeaSides, 8);
    }

    private List<Pair<WalkPosition, Altitude>> getSortedDeltasByAscendingAltitude(int mapWalkTileWidth, int mapWalkTileHeight, int altitudeScale) {
        int range = Math.max(mapWalkTileWidth, mapWalkTileHeight) / 2 + 3;
        ArrayList<Pair<WalkPosition, Altitude>> deltasByAscendingAltitude = new ArrayList<Pair<WalkPosition, Altitude>>();
        for (int dy = 0; dy <= range; ++dy) {
            for (int dx = dy; dx <= range; ++dx) {
                if (dx == 0 && dy == 0) continue;
                deltasByAscendingAltitude.add(new Pair<WalkPosition, Altitude>(new WalkPosition(dx, dy), new Altitude((int)Math.round(Utils.norm(dx, dy) * (double)altitudeScale))));
            }
        }
        deltasByAscendingAltitude.sort(Altitude.BY_ALTITUDE_ORDER);
        return deltasByAscendingAltitude;
    }

    private List<Pair<WalkPosition, Altitude>> getActiveSeaSideList(TerrainData terrainData) {
        ArrayList<Pair<WalkPosition, Altitude>> activeSeaSideList = new ArrayList<Pair<WalkPosition, Altitude>>();
        for (int y = -1; y <= terrainData.getMapData().getWalkSize().getY(); ++y) {
            for (int x = -1; x <= terrainData.getMapData().getWalkSize().getX(); ++x) {
                WalkPosition walkPosition = new WalkPosition(x, y);
                if (terrainData.getMapData().isValid(walkPosition) && !terrainData.isSeaWithNonSeaNeighbors(walkPosition)) continue;
                activeSeaSideList.add(new Pair<WalkPosition, Altitude>(walkPosition, Altitude.ZERO));
            }
        }
        return activeSeaSideList;
    }

    private Altitude setAltitudesAndGetUpdatedHighestAltitude(Altitude currentHighestAltitude, TerrainData terrainData, List<Pair<WalkPosition, Altitude>> deltasByAscendingAltitude, List<Pair<WalkPosition, Altitude>> activeSeaSideList, int altitudeScale) {
        Altitude updatedHighestAltitude = currentHighestAltitude;
        for (Pair<WalkPosition, Altitude> deltaAltitude : deltasByAscendingAltitude) {
            WalkPosition d = deltaAltitude.getLeft();
            Altitude altitude = deltaAltitude.getRight();
            for (int i = 0; i < activeSeaSideList.size(); ++i) {
                WalkPosition[] deltas;
                Pair<WalkPosition, Altitude> current = activeSeaSideList.get(i);
                if (altitude.intValue() - current.getRight().intValue() >= 2 * altitudeScale) {
                    Utils.fastErase(activeSeaSideList, i--);
                    continue;
                }
                for (WalkPosition delta : deltas = new WalkPosition[]{new WalkPosition(d.getX(), d.getY()), new WalkPosition(-d.getX(), d.getY()), new WalkPosition(d.getX(), -d.getY()), new WalkPosition(-d.getX(), -d.getY()), new WalkPosition(d.getY(), d.getX()), new WalkPosition(-d.getY(), d.getX()), new WalkPosition(d.getY(), -d.getX()), new WalkPosition(-d.getY(), -d.getX())}) {
                    MiniTile miniTile;
                    WalkPosition w = current.getLeft().add(delta);
                    if (!terrainData.getMapData().isValid(w) || !(miniTile = terrainData.getMiniTile(w, CheckMode.NO_CHECK)).isAltitudeMissing()) continue;
                    if (updatedHighestAltitude != null && updatedHighestAltitude.intValue() > altitude.intValue()) {
                        this.asserter.throwIllegalStateException("");
                    }
                    updatedHighestAltitude = altitude;
                    current.setRight(altitude);
                    miniTile.setAltitude(altitude);
                }
            }
        }
        return updatedHighestAltitude;
    }

    private void processBlockingNeutrals(List<Neutral> candidates) {
        for (Neutral pCandidate : candidates) {
            if (pCandidate.getNextStacked() != null) continue;
            List<WalkPosition> border = this.trimOuterMiniTileBorder(this.getOuterMiniTileBorderOfNeutral(pCandidate));
            List<WalkPosition> doors = this.getDoors(border);
            List<WalkPosition> trueDoors = this.getTrueDoors(doors, pCandidate);
            this.markBlockingStackedNeutrals(pCandidate, trueDoors);
        }
    }

    private List<Neutral> getCandidates(List<StaticBuilding> staticBuildings, List<Mineral> minerals) {
        ArrayList<Neutral> candidates = new ArrayList<Neutral>();
        candidates.addAll(staticBuildings);
        candidates.addAll(minerals);
        return candidates;
    }

    private List<WalkPosition> getOuterMiniTileBorderOfNeutral(Neutral pCandidate) {
        return BwemExt.outerMiniTileBorder(pCandidate.getTopLeft(), pCandidate.getSize());
    }

    private List<WalkPosition> trimOuterMiniTileBorder(List<WalkPosition> border) {
        border.removeIf(w -> !this.getData().getMapData().isValid((WalkPosition)w) || !this.getData().getMiniTile((WalkPosition)w, CheckMode.NO_CHECK).isWalkable() || this.getData().getTile(w.toTilePosition(), CheckMode.NO_CHECK).getNeutral() != null);
        return border;
    }

    private List<WalkPosition> getDoors(List<WalkPosition> border) {
        ArrayList<WalkPosition> doors = new ArrayList<WalkPosition>();
        while (!border.isEmpty()) {
            WalkPosition door = border.remove(border.size() - 1);
            doors.add(door);
            ArrayList<WalkPosition> toVisit = new ArrayList<WalkPosition>();
            toVisit.add(door);
            ArrayList<WalkPosition> visited = new ArrayList<WalkPosition>();
            visited.add(door);
            while (!toVisit.isEmpty()) {
                WalkPosition[] deltas;
                WalkPosition current = (WalkPosition)toVisit.remove(toVisit.size() - 1);
                for (WalkPosition delta : deltas = new WalkPosition[]{new WalkPosition(0, -1), new WalkPosition(-1, 0), new WalkPosition(1, 0), new WalkPosition(0, 1)}) {
                    WalkPosition next = current.add(delta);
                    if (!this.getData().getMapData().isValid(next) || visited.contains(next) || !this.getData().getMiniTile(next, CheckMode.NO_CHECK).isWalkable() || this.getData().getTile(next.toPosition().toTilePosition(), CheckMode.NO_CHECK).getNeutral() != null || !BwemExt.adjoins8SomeLakeOrNeutral(next, this)) continue;
                    toVisit.add(next);
                    visited.add(next);
                }
            }
            border.removeIf(visited::contains);
        }
        return doors;
    }

    private List<WalkPosition> getTrueDoors(List<WalkPosition> doors, Neutral pCandidate) {
        ArrayList<WalkPosition> trueDoors = new ArrayList<WalkPosition>();
        if (doors.size() >= 2) {
            for (WalkPosition door : doors) {
                int limit;
                ArrayList<WalkPosition> toVisit = new ArrayList<WalkPosition>();
                toVisit.add(door);
                ArrayList<WalkPosition> visited = new ArrayList<WalkPosition>();
                visited.add(door);
                int n = limit = pCandidate instanceof StaticBuilding ? 10 : 400;
                while (!toVisit.isEmpty() && visited.size() < limit) {
                    WalkPosition[] deltas;
                    WalkPosition current = (WalkPosition)toVisit.remove(toVisit.size() - 1);
                    for (WalkPosition delta : deltas = new WalkPosition[]{new WalkPosition(0, -1), new WalkPosition(-1, 0), new WalkPosition(1, 0), new WalkPosition(0, 1)}) {
                        WalkPosition next = current.add(delta);
                        if (!this.getData().getMapData().isValid(next) || visited.contains(next) || !this.getData().getMiniTile(next, CheckMode.NO_CHECK).isWalkable() || this.getData().getTile(next.toTilePosition(), CheckMode.NO_CHECK).getNeutral() != null) continue;
                        toVisit.add(next);
                        visited.add(next);
                    }
                }
                if (visited.size() < limit) continue;
                trueDoors.add(door);
            }
        }
        return trueDoors;
    }

    private void markBlockingStackedNeutrals(Neutral pCandidate, List<WalkPosition> trueDoors) {
        if (trueDoors.size() >= 2) {
            for (Neutral pNeutral = this.getData().getTile(pCandidate.getTopLeft()).getNeutral(); pNeutral != null; pNeutral = pNeutral.getNextStacked()) {
                pNeutral.setBlocking(trueDoors);
            }
            WalkPosition pCandidateW = pCandidate.getSize().toWalkPosition();
            for (int dy = 0; dy < pCandidateW.getY(); ++dy) {
                for (int dx = 0; dx < pCandidateW.getX(); ++dx) {
                    MiniTile miniTile = this.getData().getMiniTile(pCandidate.getTopLeft().toPosition().toWalkPosition().add(new WalkPosition(dx, dy)));
                    if (!miniTile.isWalkable()) continue;
                    miniTile.setBlocked();
                }
            }
        }
    }

    private void computeAreas(List<TempAreaInfo> tempAreaList) {
        this.createAreas(tempAreaList, 64);
        this.setAreaIdAndLowestAltitudeInTiles();
    }

    private List<Pair<WalkPosition, MiniTile>> getSortedMiniTilesByDescendingAltitude() {
        ArrayList<Pair<WalkPosition, MiniTile>> miniTilesByDescendingAltitude = new ArrayList<Pair<WalkPosition, MiniTile>>();
        for (int y = 0; y < this.getData().getMapData().getWalkSize().getY(); ++y) {
            for (int x = 0; x < this.getData().getMapData().getWalkSize().getX(); ++x) {
                WalkPosition w = new WalkPosition(x, y);
                MiniTile miniTile = this.getData().getMiniTile(w, CheckMode.NO_CHECK);
                if (!miniTile.isAreaIdMissing()) continue;
                miniTilesByDescendingAltitude.add(new Pair<WalkPosition, MiniTile>(w, miniTile));
            }
        }
        miniTilesByDescendingAltitude.sort(MiniTile.BY_ALTITUDE_ORDER);
        Collections.reverse(miniTilesByDescendingAltitude);
        return miniTilesByDescendingAltitude;
    }

    private List<TempAreaInfo> computeTempAreas(List<Pair<WalkPosition, MiniTile>> miniTilesByDescendingAltitude) {
        ArrayList<TempAreaInfo> tempAreaList = new ArrayList<TempAreaInfo>();
        tempAreaList.add(new TempAreaInfo(this.asserter));
        for (Pair<WalkPosition, MiniTile> current : miniTilesByDescendingAltitude) {
            WalkPosition pos = new WalkPosition(current.getLeft().getX(), current.getLeft().getY());
            MiniTile cur = current.getRight();
            Pair<AreaId, AreaId> neighboringAreas = this.findNeighboringAreas(pos);
            if (neighboringAreas.getLeft() == null) {
                tempAreaList.add(new TempAreaInfo(new AreaId(tempAreaList.size()), cur, pos, this.asserter));
                continue;
            }
            if (neighboringAreas.getRight() == null) {
                ((TempAreaInfo)tempAreaList.get(neighboringAreas.getLeft().intValue())).add(cur);
                continue;
            }
            AreaId smaller = neighboringAreas.getLeft();
            AreaId bigger = neighboringAreas.getRight();
            if (((TempAreaInfo)tempAreaList.get(smaller.intValue())).getSize() > ((TempAreaInfo)tempAreaList.get(bigger.intValue())).getSize()) {
                AreaId smallerTmp = smaller;
                smaller = bigger;
                bigger = smallerTmp;
            }
            boolean cppAlgorithmStdAnyOf = this.getData().getMapData().getStartingLocations().stream().anyMatch(startingLoc -> BwemExt.dist(pos.toTilePosition(), startingLoc.add(new TilePosition(2, 1))) <= 3.0);
            int curAltitude = cur.getAltitude().intValue();
            int biggerHighestAltitude = ((TempAreaInfo)tempAreaList.get(bigger.intValue())).getHighestAltitude().intValue();
            int smallerHighestAltitude = ((TempAreaInfo)tempAreaList.get(smaller.intValue())).getHighestAltitude().intValue();
            if (((TempAreaInfo)tempAreaList.get(smaller.intValue())).getSize() < 80 || smallerHighestAltitude < 80 || (double)curAltitude / (double)biggerHighestAltitude >= 0.9 || (double)curAltitude / (double)smallerHighestAltitude >= 0.9 || cppAlgorithmStdAnyOf) {
                ((TempAreaInfo)tempAreaList.get(bigger.intValue())).add(cur);
                this.replaceAreaIds(((TempAreaInfo)tempAreaList.get(smaller.intValue())).getWalkPositionWithHighestAltitude(), bigger);
                ((TempAreaInfo)tempAreaList.get(bigger.intValue())).merge((TempAreaInfo)tempAreaList.get(smaller.intValue()));
                continue;
            }
            ((TempAreaInfo)tempAreaList.get(this.chooseNeighboringArea(smaller, bigger).intValue())).add(cur);
            this.rawFrontier.add(new Pair<Pair<AreaId, AreaId>, WalkPosition>(neighboringAreas, pos));
        }
        this.rawFrontier.removeIf(f -> ((AreaId)((Pair)f.getLeft()).getLeft()).equals(((Pair)f.getLeft()).getRight()));
        return tempAreaList;
    }

    private void replaceAreaIds(WalkPosition p, AreaId newAreaId) {
        MiniTile origin = this.getData().getMiniTile(p, CheckMode.NO_CHECK);
        AreaId oldAreaId = origin.getAreaId();
        origin.replaceAreaId(newAreaId);
        ArrayList<WalkPosition> toSearch = new ArrayList<WalkPosition>();
        toSearch.add(p);
        while (!toSearch.isEmpty()) {
            WalkPosition[] deltas;
            WalkPosition current = (WalkPosition)toSearch.remove(toSearch.size() - 1);
            for (WalkPosition delta : deltas = new WalkPosition[]{new WalkPosition(0, -1), new WalkPosition(-1, 0), new WalkPosition(1, 0), new WalkPosition(0, 1)}) {
                MiniTile miniTile;
                WalkPosition next = current.add(delta);
                if (!this.getData().getMapData().isValid(next) || !(miniTile = this.getData().getMiniTile(next, CheckMode.NO_CHECK)).getAreaId().equals(oldAreaId)) continue;
                toSearch.add(next);
                miniTile.replaceAreaId(newAreaId);
            }
        }
        if (newAreaId.intValue() > 0) {
            for (Pair<Pair<AreaId, AreaId>, WalkPosition> f : this.rawFrontier) {
                if (f.getLeft().getLeft().equals(oldAreaId)) {
                    f.getLeft().setLeft(newAreaId);
                }
                if (!f.getLeft().getRight().equals(oldAreaId)) continue;
                f.getLeft().setRight(newAreaId);
            }
        }
    }

    private void createAreas(List<TempAreaInfo> tempAreaList, int areaMinMiniTiles) {
        ArrayList<Pair<WalkPosition, Integer>> areasList = new ArrayList<Pair<WalkPosition, Integer>>();
        int newAreaId = 1;
        int newTinyAreaId = -2;
        for (TempAreaInfo tempArea : tempAreaList) {
            if (!tempArea.isValid()) continue;
            if (tempArea.getSize() >= areaMinMiniTiles) {
                if (newAreaId > tempArea.getId().intValue()) {
                    this.asserter.throwIllegalStateException("");
                }
                if (newAreaId != tempArea.getId().intValue()) {
                    this.replaceAreaIds(tempArea.getWalkPositionWithHighestAltitude(), new AreaId(newAreaId));
                }
                areasList.add(new Pair<WalkPosition, Integer>(tempArea.getWalkPositionWithHighestAltitude(), tempArea.getSize()));
                ++newAreaId;
                continue;
            }
            this.replaceAreaIds(tempArea.getWalkPositionWithHighestAltitude(), new AreaId(newTinyAreaId));
            --newTinyAreaId;
        }
        this.getGraph().createAreas(areasList);
    }

    private void setLowestAltitudeInTile(TilePosition t) {
        Altitude lowestAltitude = new Altitude(Integer.MAX_VALUE);
        for (int dy = 0; dy < 4; ++dy) {
            for (int dx = 0; dx < 4; ++dx) {
                Altitude altitude = this.getData().getMiniTile(t.toPosition().toWalkPosition().add(new WalkPosition(dx, dy)), CheckMode.NO_CHECK).getAltitude();
                if (altitude.intValue() >= lowestAltitude.intValue()) continue;
                lowestAltitude = altitude;
            }
        }
        this.getData().getTile(t).setLowestAltitude(lowestAltitude);
    }

    private void setAreaIdAndLowestAltitudeInTiles() {
        for (int y = 0; y < this.getData().getMapData().getTileSize().getY(); ++y) {
            for (int x = 0; x < this.getData().getMapData().getTileSize().getX(); ++x) {
                TilePosition t = new TilePosition(x, y);
                this.setAreaIdInTile(t);
                this.setLowestAltitudeInTile(t);
            }
        }
    }

    void onBlockingNeutralDestroyed(Neutral pBlocking) {
        int dy;
        if (pBlocking == null) {
            throw new IllegalStateException();
        }
        if (!pBlocking.isBlocking()) {
            this.asserter.throwIllegalStateException("");
        }
        for (Area pArea : pBlocking.getBlockedAreas()) {
            for (ChokePoint cp : pArea.getChokePoints()) {
                cp.onBlockingNeutralDestroyed(pBlocking);
            }
        }
        if (this.getData().getTile(pBlocking.getTopLeft()).getNeutral() != null) {
            return;
        }
        AreaId newId = pBlocking.getBlockedAreas().iterator().next().getId();
        WalkPosition pBlockingW = pBlocking.getSize().toWalkPosition();
        for (dy = 0; dy < pBlockingW.getY(); ++dy) {
            for (int dx = 0; dx < pBlockingW.getX(); ++dx) {
                MiniTile miniTile = this.getData().getMiniTile(pBlocking.getTopLeft().toWalkPosition().add(new WalkPosition(dx, dy)));
                if (!miniTile.isWalkable()) continue;
                miniTile.replaceBlockedAreaId(newId);
            }
        }
        for (dy = 0; dy < pBlocking.getSize().getY(); ++dy) {
            for (int dx = 0; dx < pBlocking.getSize().getX(); ++dx) {
                this.getData().getTile(pBlocking.getTopLeft().add(new TilePosition(dx, dy))).resetAreaId();
                this.setAreaIdInTile(pBlocking.getTopLeft().add(new TilePosition(dx, dy)));
            }
        }
        if (this.automaticPathUpdate()) {
            this.getGraph().computeChokePointDistanceMatrix();
        }
    }
}

