/*
 * Decompiled with CFR 0.152.
 */
package bwem;

import bwem.Area;
import bwem.AreaId;
import bwem.BWMap;
import bwem.Base;
import bwem.ChokePoint;
import bwem.Geyser;
import bwem.Mineral;
import bwem.MiniTile;
import bwem.Neutral;
import bwem.Resource;
import bwem.StaticBuilding;
import bwem.TerrainData;
import bwem.Tile;
import bwem.util.BwemExt;
import bwem.util.CheckMode;
import bwem.util.Markable;
import bwem.util.Pair;
import bwem.util.StaticMarkable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import org.openbw.bwapi4j.TilePosition;
import org.openbw.bwapi4j.WalkPosition;
import org.openbw.bwapi4j.type.UnitType;

final class AreaInitializer
extends Area {
    private static final StaticMarkable staticMarkable = new StaticMarkable();
    private final Markable markable = new Markable(staticMarkable);

    AreaInitializer(BWMap map, AreaId areaId, WalkPosition top, int miniTileCount) {
        super(areaId, top, miniTileCount, map);
        MiniTile topMiniTile;
        if (areaId.intValue() <= 0) {
            map.asserter.throwIllegalStateException("");
        }
        if (!(topMiniTile = this.map.getData().getMiniTile(top)).getAreaId().equals(areaId)) {
            map.asserter.throwIllegalStateException("assert failed: topMiniTile.AreaId().equals(areaId): expected: " + topMiniTile.getAreaId().intValue() + ", actual: " + areaId.intValue());
        }
        this.highestAltitude = topMiniTile.getAltitude();
    }

    static StaticMarkable getStaticMarkable() {
        return staticMarkable;
    }

    Markable getMarkable() {
        return this.markable;
    }

    void addChokePoints(Area area, List<ChokePoint> chokePoints) {
        if (this.chokePointsByArea.get(area) != null || chokePoints == null) {
            this.map.asserter.throwIllegalStateException("");
        }
        this.chokePointsByArea.put(area, chokePoints);
        this.chokePoints.addAll(chokePoints);
    }

    void addMineral(Mineral mineral) {
        if (mineral == null || this.minerals.contains(mineral)) {
            this.map.asserter.throwIllegalStateException("");
        }
        this.minerals.add(mineral);
    }

    void addGeyser(Geyser geyser) {
        if (geyser == null || this.geysers.contains(geyser)) {
            this.map.asserter.throwIllegalStateException("");
        }
        this.geysers.add(geyser);
    }

    void addTileInformation(TilePosition tilePosition, Tile tile) {
        ++this.tileCount;
        if (tile.isBuildable()) {
            ++this.buildableTileCount;
        }
        if (tile.getGroundHeight() == Tile.GroundHeight.HIGH_GROUND) {
            ++this.highGroundTileCount;
        } else if (tile.getGroundHeight() == Tile.GroundHeight.VERY_HIGH_GROUND) {
            ++this.veryHighGroundTileCount;
        }
        if (tilePosition.getX() < this.topLeft.getX()) {
            this.topLeft = new TilePosition(tilePosition.getX(), this.topLeft.getY());
        }
        if (tilePosition.getY() < this.topLeft.getY()) {
            this.topLeft = new TilePosition(this.topLeft.getX(), tilePosition.getY());
        }
        if (tilePosition.getX() > this.bottomRight.getX()) {
            this.bottomRight = new TilePosition(tilePosition.getX(), this.bottomRight.getY());
        }
        if (tilePosition.getY() > this.bottomRight.getY()) {
            this.bottomRight = new TilePosition(this.bottomRight.getX(), tilePosition.getY());
        }
    }

    void setGroupId(int gid) {
        this.groupId = gid;
    }

    int[] computeDistances(ChokePoint startCP, List<ChokePoint> targetCPs) {
        if (targetCPs.contains(startCP)) {
            this.map.asserter.throwIllegalStateException("");
        }
        TilePosition start = this.map.breadthFirstSearch(startCP.getNodePositionInArea(ChokePoint.Node.MIDDLE, this).toTilePosition(), (tile, unused) -> tile.getAreaId().equals(this.getId()), (tile, unused) -> true);
        ArrayList<TilePosition> targets = new ArrayList<TilePosition>();
        for (ChokePoint cp : targetCPs) {
            TilePosition t = this.map.breadthFirstSearch(cp.getNodePositionInArea(ChokePoint.Node.MIDDLE, this).toTilePosition(), (tile, position) -> tile.getAreaId().equals(this.getId()), (tile, unused) -> true);
            targets.add(t);
        }
        return this.computeDistances(start, targets);
    }

    private int[] computeDistances(TilePosition start, List<TilePosition> targets) {
        int[] distances = new int[targets.size()];
        Tile.getStaticMarkable().unmarkAll();
        PriorityQueue<Pair> toVisit = new PriorityQueue<Pair>(Comparator.comparingInt(Pair::getLeft));
        toVisit.offer(new Pair<Integer, TilePosition>(0, start));
        int remainingTargets = targets.size();
        while (!toVisit.isEmpty()) {
            TilePosition[] deltas;
            Pair distanceAndTilePosition = (Pair)toVisit.poll();
            int currentDist = (Integer)distanceAndTilePosition.getLeft();
            TilePosition current = (TilePosition)distanceAndTilePosition.getRight();
            Tile currentTile = this.map.getData().getTile(current, CheckMode.NO_CHECK);
            if (currentTile.getInternalData() != currentDist) {
                this.map.asserter.throwIllegalStateException("currentTile.InternalData().intValue()=" + currentTile.getInternalData() + ", currentDist=" + currentDist);
            }
            currentTile.setInternalData(0);
            currentTile.getMarkable().setMarked();
            for (int i = 0; i < targets.size(); ++i) {
                if (!current.equals(targets.get(i))) continue;
                distances[i] = (int)Math.round((double)currentDist * 32.0 / 10000.0);
                --remainingTargets;
            }
            if (remainingTargets == 0) break;
            for (TilePosition delta : deltas = new TilePosition[]{new TilePosition(-1, -1), new TilePosition(0, -1), new TilePosition(1, -1), new TilePosition(-1, 0), new TilePosition(1, 0), new TilePosition(-1, 1), new TilePosition(0, 1), new TilePosition(1, 1)}) {
                Tile nextTile;
                boolean diagonalMove = delta.getX() != 0 && delta.getY() != 0;
                int newNextDist = currentDist + (diagonalMove ? 14142 : 10000);
                TilePosition next = current.add(delta);
                if (!this.map.getData().getMapData().isValid(next) || !(nextTile = this.map.getData().getTile(next, CheckMode.NO_CHECK)).getMarkable().isUnmarked()) continue;
                if (nextTile.getInternalData() != 0) {
                    if (newNextDist >= nextTile.getInternalData()) continue;
                    boolean removed = toVisit.remove(new Pair<Integer, TilePosition>(nextTile.getInternalData(), next));
                    if (!removed) {
                        this.map.asserter.throwIllegalStateException("");
                    }
                    nextTile.setInternalData(newNextDist);
                    toVisit.offer(new Pair<Integer, TilePosition>(newNextDist, next));
                    continue;
                }
                if (!nextTile.getAreaId().equals(this.getId()) && !nextTile.getAreaId().equals(AreaId.UNINITIALIZED)) continue;
                nextTile.setInternalData(newNextDist);
                toVisit.offer(new Pair<Integer, TilePosition>(newNextDist, next));
            }
        }
        if (remainingTargets != 0) {
            this.map.asserter.throwIllegalStateException("");
        }
        for (Pair distanceAndTilePosition : toVisit) {
            Tile tileToUpdate = this.map.getData().getTile((TilePosition)distanceAndTilePosition.getRight(), CheckMode.NO_CHECK);
            tileToUpdate.setInternalData(0);
        }
        return distances;
    }

    void updateAccessibleNeighbors() {
        this.accessibleNeighbors.clear();
        block0: for (Area area : this.getChokePointsByArea().keySet()) {
            for (ChokePoint cp : this.getChokePointsByArea().get(area)) {
                if (cp.isBlocked()) continue;
                this.accessibleNeighbors.add(area);
                continue block0;
            }
        }
    }

    void createBases(TerrainData terrainData) {
        TilePosition resourceDepotDimensions = UnitType.Terran_Command_Center.tileSize();
        ArrayList<Resource> remainingResources = new ArrayList<Resource>();
        for (Mineral mineral : this.getMinerals()) {
            if (mineral.getInitialAmount() < 40 || mineral.isBlocking()) continue;
            remainingResources.add(mineral);
        }
        for (Geyser geyser : this.getGeysers()) {
            if (geyser.getInitialAmount() < 300 || geyser.isBlocking()) continue;
            remainingResources.add(geyser);
        }
        while (!remainingResources.isEmpty()) {
            TilePosition deltaTilePosition;
            int dx;
            int dy;
            TilePosition topLeftResources = new TilePosition(Integer.MAX_VALUE, Integer.MAX_VALUE);
            TilePosition bottomRightResources = new TilePosition(Integer.MIN_VALUE, Integer.MIN_VALUE);
            for (Resource r : remainingResources) {
                Pair<TilePosition, TilePosition> pair1 = BwemExt.makeBoundingBoxIncludePoint(topLeftResources, bottomRightResources, r.getTopLeft());
                topLeftResources = pair1.getLeft();
                bottomRightResources = pair1.getRight();
                Iterator pair2 = BwemExt.makeBoundingBoxIncludePoint(topLeftResources, bottomRightResources, r.getBottomRight());
                topLeftResources = ((Pair)((Object)pair2)).getLeft();
                bottomRightResources = ((Pair)((Object)pair2)).getRight();
            }
            TilePosition dimensionsBetweenResourceDepotAndResources = new TilePosition(10, 10);
            TilePosition topLeftSearchBoundingBox = topLeftResources.subtract(resourceDepotDimensions).subtract(dimensionsBetweenResourceDepotAndResources);
            TilePosition bottomRightSearchBoundingBox = bottomRightResources.add(new TilePosition(1, 1)).add(dimensionsBetweenResourceDepotAndResources);
            topLeftSearchBoundingBox = BwemExt.makePointFitToBoundingBox(topLeftSearchBoundingBox, this.getTopLeft(), this.getBottomRight().subtract(resourceDepotDimensions).add(new TilePosition(1, 1)));
            bottomRightSearchBoundingBox = BwemExt.makePointFitToBoundingBox(bottomRightSearchBoundingBox, this.getTopLeft(), this.getBottomRight().subtract(resourceDepotDimensions).add(new TilePosition(1, 1)));
            for (Resource r : remainingResources) {
                for (dy = -resourceDepotDimensions.getY() - 10; dy < r.getSize().getY() + resourceDepotDimensions.getY() + 10; ++dy) {
                    for (dx = -resourceDepotDimensions.getX() - 10; dx < r.getSize().getX() + resourceDepotDimensions.getX() + 10; ++dx) {
                        deltaTilePosition = r.getTopLeft().add(new TilePosition(dx, dy));
                        if (!terrainData.getMapData().isValid(deltaTilePosition)) continue;
                        Tile tile = terrainData.getTile(deltaTilePosition, CheckMode.NO_CHECK);
                        int dist = (BwemExt.distToRectangle(BwemExt.center(deltaTilePosition), r.getTopLeft().toPosition(), r.getSize().toPosition()) + 16) / 32;
                        int score = Math.max(13 - dist, 0);
                        if (r instanceof Geyser) {
                            score *= 3;
                        }
                        if (!tile.getAreaId().equals(this.getId())) continue;
                        tile.setInternalData(tile.getInternalData() + score);
                    }
                }
            }
            for (Resource r : remainingResources) {
                for (dy = -3; dy < r.getSize().getY() + 3; ++dy) {
                    for (dx = -3; dx < r.getSize().getX() + 3; ++dx) {
                        deltaTilePosition = r.getTopLeft().add(new TilePosition(dx, dy));
                        if (!terrainData.getMapData().isValid(deltaTilePosition)) continue;
                        Tile tileToUpdate = terrainData.getTile(deltaTilePosition, CheckMode.NO_CHECK);
                        tileToUpdate.setInternalData(-1);
                    }
                }
            }
            TilePosition bestLocation = null;
            int bestScore = 0;
            ArrayList<Mineral> blockingMinerals = new ArrayList<Mineral>();
            for (int y = topLeftSearchBoundingBox.getY(); y <= bottomRightSearchBoundingBox.getY(); ++y) {
                for (int x = topLeftSearchBoundingBox.getX(); x <= bottomRightSearchBoundingBox.getX(); ++x) {
                    int score = this.computeBaseLocationScore(terrainData, new TilePosition(x, y));
                    if (score <= bestScore || !this.validateBaseLocation(terrainData, new TilePosition(x, y), blockingMinerals)) continue;
                    bestScore = score;
                    bestLocation = new TilePosition(x, y);
                }
            }
            for (Resource r : remainingResources) {
                for (int dy2 = -resourceDepotDimensions.getY() - 10; dy2 < r.getSize().getY() + resourceDepotDimensions.getY() + 10; ++dy2) {
                    for (int dx2 = -resourceDepotDimensions.getX() - 10; dx2 < r.getSize().getX() + resourceDepotDimensions.getX() + 10; ++dx2) {
                        TilePosition deltaTilePosition2 = r.getTopLeft().add(new TilePosition(dx2, dy2));
                        if (!terrainData.getMapData().isValid(deltaTilePosition2)) continue;
                        Tile tileToUpdate = terrainData.getTile(deltaTilePosition2, CheckMode.NO_CHECK);
                        tileToUpdate.setInternalData(0);
                    }
                }
            }
            if (bestScore == 0) break;
            ArrayList<Resource> assignedResources = new ArrayList<Resource>();
            for (Resource r : remainingResources) {
                if (BwemExt.distToRectangle(r.getCenter(), bestLocation.toPosition(), resourceDepotDimensions.toPosition()) + 2 > 320) continue;
                assignedResources.add(r);
            }
            remainingResources.removeIf(assignedResources::contains);
            if (assignedResources.isEmpty()) break;
            this.bases.add(new Base(this, bestLocation, assignedResources, blockingMinerals, this.map.asserter));
        }
    }

    private int computeBaseLocationScore(TerrainData terrainData, TilePosition location) {
        TilePosition dimCC = UnitType.Terran_Command_Center.tileSize();
        int sumScore = 0;
        for (int dy = 0; dy < dimCC.getY(); ++dy) {
            for (int dx = 0; dx < dimCC.getX(); ++dx) {
                Tile tile = terrainData.getTile(location.add(new TilePosition(dx, dy)), CheckMode.NO_CHECK);
                if (!tile.isBuildable()) {
                    return -1;
                }
                if (tile.getInternalData() == -1) {
                    return -1;
                }
                if (!tile.getAreaId().equals(this.getId())) {
                    return -1;
                }
                if (tile.getNeutral() instanceof StaticBuilding) {
                    return -1;
                }
                sumScore += tile.getInternalData();
            }
        }
        return sumScore;
    }

    private boolean validateBaseLocation(TerrainData terrainData, TilePosition location, List<Mineral> blockingMinerals) {
        TilePosition dimCC = UnitType.Terran_Command_Center.tileSize();
        blockingMinerals.clear();
        for (int dy = -3; dy < dimCC.getY() + 3; ++dy) {
            for (int dx = -3; dx < dimCC.getX() + 3; ++dx) {
                Tile deltaTile;
                Neutral deltaTileNeutral;
                TilePosition deltaLocation = location.add(new TilePosition(dx, dy));
                if (!terrainData.getMapData().isValid(deltaLocation) || (deltaTileNeutral = (deltaTile = terrainData.getTile(deltaLocation, CheckMode.NO_CHECK)).getNeutral()) == null) continue;
                if (deltaTileNeutral instanceof Geyser) {
                    return false;
                }
                if (!(deltaTileNeutral instanceof Mineral)) continue;
                Mineral deltaTileMineral = (Mineral)deltaTileNeutral;
                if (deltaTileMineral.getInitialAmount() <= 8) {
                    blockingMinerals.add(deltaTileMineral);
                    continue;
                }
                return false;
            }
        }
        for (Base base : this.getBases()) {
            if (BwemExt.roundedDist(base.getLocation(), location) >= 10) continue;
            return false;
        }
        return true;
    }

    public void onMineralDestroyed(Mineral mineral) {
        if (mineral == null) {
            this.map.asserter.throwIllegalStateException("");
        }
        this.minerals.remove(mineral);
        for (Base base : this.getBases()) {
            base.onMineralDestroyed(mineral);
        }
    }
}

