/*
 * Decompiled with CFR 0.152.
 */
package org.openbw.bwapi4j.util.system;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.openbw.bwapi4j.util.system.OSType;

public class SystemUtils {
    public static boolean isWindowsPlatform() {
        return System.getProperty("os.name").contains("Windows");
    }

    public static boolean systemPropertyEquals(String systemProperty, boolean status) {
        String[] trueValues;
        String systemPropertyValue = System.getProperty(systemProperty);
        if (systemPropertyValue == null) {
            return false;
        }
        for (String trueValue : trueValues = new String[]{status ? "1" : "0", Boolean.valueOf(status).toString()}) {
            if (!systemPropertyValue.equalsIgnoreCase(trueValue)) continue;
            return true;
        }
        return false;
    }

    public static boolean systemPropertyEquals(String systemProperty, String targetPropertyValue) {
        String systemPropertyValue = System.getProperty(systemProperty);
        return systemPropertyValue != null && systemPropertyValue.equalsIgnoreCase(targetPropertyValue);
    }

    public static String resolvePlatformLibraryFilename(String libraryName) {
        switch (OSType.computeType()) {
            case WINDOWS: {
                return libraryName + ".dll";
            }
            case MAC: {
                return "lib" + libraryName + ".dylib";
            }
        }
        return "lib" + libraryName + ".so";
    }

    public static boolean isPathFoundInPathVariable(String path, String pathVariable) {
        String[] paths;
        for (String directory : paths = pathVariable.split(File.pathSeparator)) {
            Path targetPath;
            Path targetDirectory;
            try {
                targetDirectory = Paths.get(directory, new String[0]);
            }
            catch (Exception e) {
                continue;
            }
            try {
                targetPath = Paths.get(targetDirectory.toString(), path);
            }
            catch (Exception e) {
                continue;
            }
            if (!Files.isRegularFile(targetPath, new LinkOption[0]) && !Files.isDirectory(targetPath, new LinkOption[0])) continue;
            return true;
        }
        return false;
    }
}

