/*
 * Decompiled with CFR 0.152.
 */
package org.openbw.bwapi4j.unit;

import java.util.List;
import org.openbw.bwapi4j.BW;
import org.openbw.bwapi4j.Position;
import org.openbw.bwapi4j.TilePosition;
import org.openbw.bwapi4j.type.Order;
import org.openbw.bwapi4j.type.TechType;
import org.openbw.bwapi4j.type.UnitCommandType;
import org.openbw.bwapi4j.type.UnitType;
import org.openbw.bwapi4j.type.UpgradeType;
import org.openbw.bwapi4j.unit.UnitImpl;
import org.openbw.bwapi4j.unit.WeaponBridge;
import org.openbw.bwapi4j.util.BridgeUtils;

public class UnitImplBridge {
    private final BW bw;
    private final WeaponBridge WeaponBridge;
    public static final int ID = 0;
    public static final int INITIAL_HIT_POINTS = 1;
    public static final int INITIAL_POSITION = 2;
    public static final int INITIAL_RESOURCES = 4;
    public static final int INITIAL_TILE_POSITION = 5;
    public static final int TYPE = 7;

    public UnitImplBridge(BW bw, WeaponBridge WeaponBridge2) {
        this.bw = bw;
        this.WeaponBridge = WeaponBridge2;
    }

    public void reset(UnitImpl entity) {
        entity.exists = false;
        entity.visible = false;
    }

    public void initialize(UnitImpl entity, int[] data, int index) {
        entity.iD = data[index + 0];
        entity.initialHitPoints = data[index + 1];
        entity.initialPosition = new Position(data[index + 2 + 0], data[index + 2 + 1]);
        entity.initialResources = data[index + 4];
        entity.initialTilePosition = new TilePosition(data[index + 5 + 0], data[index + 5 + 1]);
        entity.type = UnitType.withId(data[index + 7]);
        this.WeaponBridge.initialize(entity.airWeapon, data, index += 8);
        index = this.WeaponBridge.skip(data, index);
        this.WeaponBridge.initialize(entity.groundWeapon, data, index);
        index = this.WeaponBridge.skip(data, index);
    }

    public int update(UnitImpl entity, int[] data, int index) {
        ++index;
        ++index;
        index += 2;
        ++index;
        index += 2;
        ++index;
        index = this.WeaponBridge.update(entity.airWeapon, data, index);
        index = this.WeaponBridge.update(entity.groundWeapon, data, index);
        entity.accelerating = data[index++] == 1;
        entity.acidSporeCount = data[index++];
        entity.addon = this.bw.getUnit(data[index++]);
        entity.angle = BridgeUtils.parsePreservedDouble(data[index++]);
        entity.attackFrame = data[index++] == 1;
        entity.attacking = data[index++] == 1;
        entity.beingConstructed = data[index++] == 1;
        entity.beingGathered = data[index++] == 1;
        entity.beingHealed = data[index++] == 1;
        entity.blind = data[index++] == 1;
        entity.braking = data[index++] == 1;
        entity.buildType = UnitType.withId(data[index++]);
        entity.buildUnit = this.bw.getUnit(data[index++]);
        entity.burrowed = data[index++] == 1;
        entity.carrier = this.bw.getUnit(data[index++]);
        entity.carryingGas = data[index++] == 1;
        entity.carryingMinerals = data[index++] == 1;
        entity.cloaked = data[index++] == 1;
        entity.completed = data[index++] == 1;
        entity.constructing = data[index++] == 1;
        entity.defenseMatrixed = data[index++] == 1;
        entity.defenseMatrixPoints = data[index++];
        entity.defenseMatrixTimer = data[index++];
        entity.detected = data[index++] == 1;
        entity.energy = data[index++];
        entity.ensnared = data[index++] == 1;
        entity.ensnareTimer = data[index++];
        entity.exists = data[index++] == 1;
        entity.flying = data[index++] == 1;
        entity.following = data[index++] == 1;
        entity.gatheringGas = data[index++] == 1;
        entity.gatheringMinerals = data[index++] == 1;
        entity.hallucination = data[index++] == 1;
        entity.hasNuke = data[index++] == 1;
        entity.hatchery = this.bw.getUnit(data[index++]);
        entity.hitPoints = data[index++];
        entity.holdingPosition = data[index++] == 1;
        entity.idle = data[index++] == 1;
        entity.interceptorCount = data[index++];
        entity.interruptible = data[index++] == 1;
        entity.invincible = data[index++] == 1;
        entity.irradiated = data[index++] == 1;
        entity.irradiateTimer = data[index++];
        entity.killCount = data[index++];
        entity.lastAttackingPlayer = this.bw.getPlayer(data[index++]);
        entity.lastCommand = UnitCommandType.withId(data[index++]);
        entity.lifted = data[index++] == 1;
        entity.loaded = data[index++] == 1;
        entity.loadedUnits.clear();
        int loadedUnitsAmount = data[index++];
        for (int i = 0; i < loadedUnitsAmount; ++i) {
            entity.loadedUnits.add(this.bw.getUnit(data[index++]));
        }
        entity.lockdownTimer = data[index++];
        entity.lockedDown = data[index++] == 1;
        entity.maelstrommed = data[index++] == 1;
        entity.maelstromTimer = data[index++];
        entity.morphing = data[index++] == 1;
        entity.moving = data[index++] == 1;
        entity.nydusExit = this.bw.getUnit(data[index++]);
        entity.order = Order.withId(data[index++]);
        entity.orderTarget = this.bw.getUnit(data[index++]);
        entity.orderTargetPosition = new Position(data[index++], data[index++]);
        entity.orderTimer = data[index++];
        entity.parasited = data[index++] == 1;
        entity.patrolling = data[index++] == 1;
        entity.plagued = data[index++] == 1;
        entity.plagueTimer = data[index++];
        entity.player = this.bw.getPlayer(data[index++]);
        entity.position = new Position(data[index++], data[index++]);
        entity.powered = data[index++] == 1;
        entity.rallyPosition = new Position(data[index++], data[index++]);
        entity.rallyUnit = this.bw.getUnit(data[index++]);
        entity.remainingBuildTime = data[index++];
        entity.remainingResearchTime = data[index++];
        entity.remainingTrainTime = data[index++];
        entity.remainingUpgradeTime = data[index++];
        entity.removeTimer = data[index++];
        entity.repairing = data[index++] == 1;
        entity.replayID = data[index++];
        entity.researching = data[index++] == 1;
        entity.resourceGroup = data[index++];
        entity.resources = data[index++];
        entity.scarabCount = data[index++];
        entity.selected = data[index++] == 1;
        entity.shields = data[index++];
        entity.sieged = data[index++] == 1;
        entity.spaceRemaining = data[index++];
        entity.spellCooldown = data[index++];
        entity.spiderMineCount = data[index++];
        entity.startingAttack = data[index++] == 1;
        entity.stasised = data[index++] == 1;
        entity.stasisTimer = data[index++];
        entity.stimmed = data[index++] == 1;
        entity.stimTimer = data[index++];
        entity.stuck = data[index++] == 1;
        entity.target = this.bw.getUnit(data[index++]);
        entity.targetable = data[index++] == 1;
        entity.targetPosition = new Position(data[index++], data[index++]);
        entity.tech = TechType.withId(data[index++]);
        entity.tilePosition = new TilePosition(data[index++], data[index++]);
        entity.training = data[index++] == 1;
        entity.trainingQueue.clear();
        int trainingQueueAmount = data[index++];
        for (int i = 0; i < trainingQueueAmount; ++i) {
            List<UnitImpl.TrainingSlot> list = entity.trainingQueue;
            UnitImpl unitImpl = entity;
            unitImpl.getClass();
            list.add(unitImpl.new UnitImpl.TrainingSlot(UnitType.withId(data[index++])));
        }
        entity.transport = this.bw.getUnit(data[index++]);
        entity.underAttack = data[index++] == 1;
        entity.underDarkSwarm = data[index++] == 1;
        entity.underDisruptionWeb = data[index++] == 1;
        entity.underStorm = data[index++] == 1;
        entity.upgrade = UpgradeType.withId(data[index++]);
        entity.upgrading = data[index++] == 1;
        entity.velocityX = BridgeUtils.parsePreservedDouble(data[index++]);
        entity.velocityY = BridgeUtils.parsePreservedDouble(data[index++]);
        entity.visible = data[index++] == 1;
        return index;
    }

    public int skip(int[] data, int index) {
        ++index;
        ++index;
        index += 2;
        ++index;
        index += 2;
        ++index;
        index = this.WeaponBridge.skip(data, index);
        index = this.WeaponBridge.skip(data, index);
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        index += data[index] + 1;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        index += 2;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        index += 2;
        ++index;
        index += 2;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        index += 2;
        ++index;
        index += 2;
        ++index;
        index += data[index] + 1;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        ++index;
        return ++index;
    }
}

