/*
 * Decompiled with CFR 0.152.
 */
package org.openbw.bwapi4j.unit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openbw.bwapi4j.BW;
import org.openbw.bwapi4j.DamageEvaluator;
import org.openbw.bwapi4j.Player;
import org.openbw.bwapi4j.Position;
import org.openbw.bwapi4j.TilePosition;
import org.openbw.bwapi4j.type.Order;
import org.openbw.bwapi4j.type.TechType;
import org.openbw.bwapi4j.type.UnitCommandType;
import org.openbw.bwapi4j.type.UnitSizeType;
import org.openbw.bwapi4j.type.UnitType;
import org.openbw.bwapi4j.type.UpgradeType;
import org.openbw.bwapi4j.type.WeaponType;
import org.openbw.bwapi4j.unit.ResearchingFacility;
import org.openbw.bwapi4j.unit.Unit;
import org.openbw.bwapi4j.unit.Weapon;

public abstract class UnitImpl
implements Unit {
    private static final Logger logger = LogManager.getLogger();
    int iD;
    Position initialPosition;
    TilePosition initialTilePosition;
    int initiallySpotted;
    UnitType type;
    Position position;
    TilePosition tilePosition;
    double angle;
    int lastCommandFrame;
    UnitCommandType lastCommand;
    boolean visible;
    boolean exists;
    boolean selected;
    boolean flying;
    boolean upgrading;
    boolean researching;
    int remainingResearchTime;
    int remainingUpgradeTime;
    UpgradeType upgrade;
    TechType tech;
    int initialHitPoints;
    int hitPoints;
    int shields;
    int killCount;
    boolean cloaked;
    boolean detected;
    double velocityX;
    double velocityY;
    boolean idle;
    boolean completed;
    Weapon groundWeapon = new Weapon(WeaponType.None, 0);
    Weapon airWeapon = new Weapon(WeaponType.None, 0);
    int spellCooldown;
    Unit target;
    boolean accelerating;
    boolean attacking;
    boolean attackFrame;
    boolean beingConstructed;
    boolean beingHealed;
    boolean irradiated;
    boolean lockedDown;
    boolean maelstrommed;
    boolean startingAttack;
    boolean underAttack;
    boolean powered;
    boolean interruptible;
    Player player;
    int energy;
    boolean training;
    Unit buildUnit;
    int remainingTrainTime;
    Position rallyPosition;
    Unit rallyUnit;
    List<TrainingSlot> trainingQueue = new ArrayList<TrainingSlot>(){

        @Override
        public boolean add(TrainingSlot trainingSlot) {
            trainingSlot.slotIndex = this.size();
            return super.add(trainingSlot);
        }
    };
    boolean loaded;
    int spaceRemaining;
    List<Unit> loadedUnits = new ArrayList<Unit>();
    int interceptorCount;
    boolean following;
    boolean holdingPosition;
    boolean stuck;
    boolean stasised;
    boolean underDarkSwarm;
    boolean underDisruptionWeb;
    boolean underStorm;
    boolean moving;
    boolean parasited;
    boolean patrolling;
    boolean plagued;
    Position targetPosition;
    Unit transport;
    int acidSporeCount;
    boolean hallucination;
    boolean blind;
    boolean braking;
    boolean defenseMatrixed;
    boolean ensnared;
    Unit addon;
    int remainingBuildTime;
    boolean lifted;
    boolean burrowed;
    UnitType buildType;
    boolean stimmed;
    int initialResources;
    int resources;
    boolean beingGathered;
    Unit carrier;
    Unit hatchery;
    int lastKnownResources;
    boolean hasNuke;
    Unit nydusExit;
    int scarabCount;
    boolean repairing;
    boolean sieged;
    int spiderMineCount;
    boolean constructing;
    boolean gatheringGas;
    boolean gatheringMinerals;
    boolean carryingGas;
    boolean carryingMinerals;
    int stimTimer;
    Position lastKnownPosition;
    TilePosition lastKnownTilePosition;
    int lastKnownHitPoints;
    private BW bw;
    int lastSpotted;
    int replayID;
    int resourceGroup;
    Player lastAttackingPlayer;
    int defenseMatrixPoints;
    int defenseMatrixTimer;
    int ensnareTimer;
    int irradiateTimer;
    int lockdownTimer;
    int maelstromTimer;
    int orderTimer;
    int plagueTimer;
    int removeTimer;
    int stasisTimer;
    Order order;
    Unit orderTarget;
    Position orderTargetPosition;
    Order secondaryOrder;
    boolean morphing;
    boolean targetable;
    boolean invincible;

    protected UnitImpl() {
    }

    final void setBW(BW bw) {
        this.bw = bw;
    }

    @Override
    public int getKillCount() {
        return this.killCount;
    }

    @Override
    public int getLastSpotted() {
        return this.lastSpotted;
    }

    @Override
    public int getInitiallySpotted() {
        return this.initiallySpotted;
    }

    protected Collection<UnitImpl> getAllUnits() {
        return this.bw.getAllUnits();
    }

    protected Unit getUnit(int id) {
        return this.bw.getUnit(id);
    }

    protected DamageEvaluator getDamageEvaluator() {
        return this.bw.getDamageEvaluator();
    }

    protected Player getPlayer() {
        return this.player;
    }

    protected Player getPlayer(int id) {
        return this.bw.getPlayer(id);
    }

    @Override
    public int getId() {
        return this.iD;
    }

    @Override
    public int getLeft() {
        return this.position.getX() - this.type.dimensionLeft();
    }

    @Override
    public int getTop() {
        return this.position.getY() - this.type.dimensionUp();
    }

    @Override
    public int getRight() {
        return this.position.getX() + this.type.dimensionRight();
    }

    @Override
    public int getBottom() {
        return this.position.getY() + this.type.dimensionDown();
    }

    @Override
    public Position getMiddle(Unit unit) {
        int x = this.getPosition().getX();
        int y = this.getPosition().getY();
        int dx = unit.getPosition().getX() - x;
        int dy = unit.getPosition().getY() - y;
        return new Position(x + dx / 2, y + dy / 2);
    }

    @Override
    public double getAngle() {
        return this.angle;
    }

    @Override
    public <T extends Unit> T getClosest(Collection<T> group) {
        Comparator<Unit> comp = Comparator.comparingDouble(this::getDistance);
        return (T)group.stream().min(comp).get();
    }

    @Override
    public <T extends Unit> List<T> getUnitsInRadius(int radius, Collection<T> group) {
        return group.stream().filter(t -> this.getDistance((Unit)t) <= radius).collect(Collectors.toList());
    }

    @Override
    public int getX() {
        return this.position.getX();
    }

    @Override
    public int getY() {
        return this.position.getY();
    }

    @Override
    public int height() {
        return this.type.height();
    }

    @Override
    public int width() {
        return this.type.width();
    }

    @Override
    public int tileHeight() {
        return this.type.tileHeight();
    }

    @Override
    public int tileWidth() {
        return this.type.tileWidth();
    }

    @Override
    public TilePosition getTilePosition() {
        return this.tilePosition;
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    public UnitSizeType getSize() {
        return this.type.size();
    }

    @Override
    public double getDistance(Position target) {
        return this.getDistance(target.getX(), target.getY());
    }

    @Override
    public double getDistance(int x, int y) {
        int yDist;
        int xDist = this.getLeft() - (x + 1);
        if (xDist < 0 && (xDist = x - (this.getRight() + 1)) < 0) {
            xDist = 0;
        }
        if ((yDist = this.getTop() - (y + 1)) < 0 && (yDist = y - (this.getBottom() + 1)) < 0) {
            yDist = 0;
        }
        return new Position(0, 0).getDistance(new Position(xDist, yDist));
    }

    @Override
    public int getDistance(Unit target) {
        int yDist;
        if (this.position == target.getPosition()) {
            return 0;
        }
        int xDist = this.getLeft() - (target.getRight() + 1);
        if (xDist < 0 && (xDist = target.getLeft() - (this.getRight() + 1)) < 0) {
            xDist = 0;
        }
        if ((yDist = this.getTop() - (target.getBottom() + 1)) < 0 && (yDist = target.getTop() - (this.getBottom() + 1)) < 0) {
            yDist = 0;
        }
        logger.trace("dx, dy: {}, {}.", (Object)xDist, (Object)yDist);
        return new Position(0, 0).getDistance(new Position(xDist, yDist));
    }

    boolean lift() {
        return this.issueCommand(this.iD, UnitCommandType.Lift, -1, -1, -1, -1);
    }

    boolean land(Position p) {
        return this.issueCommand(this.iD, UnitCommandType.Land, -1, p.getX(), p.getY(), -1);
    }

    boolean move(Position p) {
        return this.issueCommand(this.iD, UnitCommandType.Move, -1, p.getX(), p.getY(), -1);
    }

    @Override
    public boolean exists() {
        return this.exists;
    }

    @Override
    public UnitType getType() {
        return this.type;
    }

    @Override
    public Position getInitialPosition() {
        return this.initialPosition;
    }

    @Override
    public TilePosition getInitialTilePosition() {
        return this.initialTilePosition;
    }

    protected Order getOrder() {
        return this.order;
    }

    protected Unit getOrderTarget() {
        return this.orderTarget;
    }

    protected Position getOrderTargetPosition() {
        return this.orderTargetPosition;
    }

    protected Order getSecondaryOrder() {
        return this.secondaryOrder;
    }

    protected int getCurrentFrame() {
        return this.bw.getInteractionHandler().getFrameCount();
    }

    protected boolean cancelResearch() {
        return this.issueCommand(this.iD, UnitCommandType.Cancel_Research, -1, -1, -1, -1);
    }

    protected boolean cancelUpgrade() {
        return this.issueCommand(this.iD, UnitCommandType.Cancel_Upgrade, -1, -1, -1, -1);
    }

    protected boolean canResearch(TechType techType) {
        return this.type.equals(techType.whatResearches()) && this.player.canResearch(techType);
    }

    protected boolean canUpgrade(UpgradeType upgradeType) {
        return this.type.equals(upgradeType.whatUpgrades()) && this.player.canUpgrade(upgradeType);
    }

    protected boolean research(TechType techType) {
        return this.issueCommand(this.iD, UnitCommandType.Research, -1, -1, -1, techType.getId());
    }

    protected boolean upgrade(UpgradeType upgrade) {
        return this.issueCommand(this.iD, UnitCommandType.Upgrade, -1, -1, -1, upgrade.getId());
    }

    protected ResearchingFacility.UpgradeInProgress getUpgradeInProgress() {
        if (this.upgrade == UpgradeType.None) {
            return ResearchingFacility.UpgradeInProgress.NONE;
        }
        return new ResearchingFacility.UpgradeInProgress(this.upgrade, this.remainingUpgradeTime);
    }

    protected ResearchingFacility.ResearchInProgress getResearchInProgress() {
        if (this.tech == TechType.None) {
            return ResearchingFacility.ResearchInProgress.NONE;
        }
        return new ResearchingFacility.ResearchInProgress(this.tech, this.remainingResearchTime);
    }

    protected boolean canTrain(UnitType type) {
        return this.type.equals(type.whatBuilds().getUnitType()) && this.player.canMake(type) && type.requiredUnits().keySet().stream().allMatch(ut -> !ut.isAddon() || this.addon != null && this.addon.getType() == ut);
    }

    protected boolean train(UnitType type) {
        return this.issueCommand(this.iD, UnitCommandType.Train, -1, -1, -1, type.getId());
    }

    protected boolean cancelTrain(int slot) {
        return this.issueCommand(this.iD, UnitCommandType.Cancel_Train_Slot, -1, -1, -1, slot);
    }

    protected boolean cancelTrain() {
        return this.issueCommand(this.iD, UnitCommandType.Cancel_Train, -1, -1, -1, -1);
    }

    protected boolean setRallyPoint(Position p) {
        return this.issueCommand(this.iD, UnitCommandType.Set_Rally_Position, -1, p.getX(), p.getY(), -1);
    }

    protected boolean setRallyPoint(Unit target) {
        return this.issueCommand(this.iD, UnitCommandType.Set_Rally_Unit, target.getId(), -1, -1, -1);
    }

    protected Position getRallyPosition() {
        return this.rallyPosition;
    }

    protected Unit getRallyUnit() {
        return this.rallyUnit;
    }

    @Override
    public boolean isFlying() {
        return this.flying;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    public int hashCode() {
        return this.iD;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Unit) {
            return this.getId() == ((Unit)obj).getId();
        }
        return false;
    }

    public String toString() {
        return this.getId() + ":" + this.type;
    }

    @Override
    public int compareTo(Unit otherUnit) {
        return this.getId() - otherUnit.getId();
    }

    protected boolean issueCommand(int unitId, UnitCommandType unitCommandType, int targetUnitId, int x, int y, int extra) {
        if (this.issueCommand(unitId, unitCommandType.ordinal(), targetUnitId, x, y, extra)) {
            this.lastCommandFrame = this.getCurrentFrame();
            this.lastCommand = unitCommandType;
            return true;
        }
        return false;
    }

    private native boolean issueCommand(int var1, int var2, int var3, int var4, int var5, int var6);

    public class TrainingSlot {
        private int slotIndex;
        private final UnitType unitType;

        TrainingSlot(UnitType unitType) {
            this.unitType = unitType;
        }

        public UnitType getUnitType() {
            return this.unitType;
        }

        public boolean cancel() {
            return UnitImpl.this.issueCommand(UnitImpl.this.iD, UnitCommandType.Cancel_Train_Slot, -1, -1, -1, this.slotIndex);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof TrainingSlot)) {
                return false;
            }
            TrainingSlot trainingSlot = (TrainingSlot)object;
            return this.slotIndex == trainingSlot.slotIndex && this.unitType == trainingSlot.unitType;
        }

        public int hashCode() {
            return Objects.hash(this.slotIndex, this.unitType);
        }
    }
}

