/*
 * Decompiled with CFR 0.152.
 */
package org.openbw.bwapi4j.unit;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.openbw.bwapi4j.Player;
import org.openbw.bwapi4j.Position;
import org.openbw.bwapi4j.TilePosition;
import org.openbw.bwapi4j.UnitStatCalculator;
import org.openbw.bwapi4j.type.Order;
import org.openbw.bwapi4j.type.UnitCommandType;
import org.openbw.bwapi4j.unit.AirAttacker;
import org.openbw.bwapi4j.unit.GroundAttacker;
import org.openbw.bwapi4j.unit.PlayerUnit;
import org.openbw.bwapi4j.unit.Unit;
import org.openbw.bwapi4j.unit.UnitImpl;

public abstract class PlayerUnitImpl
extends UnitImpl
implements PlayerUnit {
    @Override
    public PlayerUnit getBuildUnit() {
        return (PlayerUnit)this.buildUnit;
    }

    protected Unit getTargetUnit() {
        return this.target;
    }

    @Override
    public <T extends PlayerUnit> T getWeakestUnitInRadius(int radius, Collection<T> units) {
        PlayerUnit weakestUnit;
        List<T> inRange = this.getUnitsInRadius(radius, units);
        if (inRange.isEmpty()) {
            weakestUnit = (PlayerUnit)this.getClosest(units);
        } else {
            Comparator<PlayerUnit> comp = Comparator.comparingInt(PlayerUnit::getHitPoints);
            weakestUnit = inRange.stream().min(comp).get();
        }
        return (T)weakestUnit;
    }

    @Override
    public boolean rightClick(Position position, boolean queued) {
        return this.issueCommand(this.iD, UnitCommandType.Right_Click_Position, -1, position.getX(), position.getY(), queued ? 1 : 0);
    }

    @Override
    public boolean rightClick(Unit target, boolean queued) {
        return this.issueCommand(this.iD, UnitCommandType.Right_Click_Unit, target.getId(), -1, -1, queued ? 1 : 0);
    }

    @Override
    public boolean isCompleted() {
        return this.completed;
    }

    @Override
    public int maxHitPoints() {
        return this.type.maxHitPoints();
    }

    @Override
    public int getHitPoints() {
        return this.hitPoints;
    }

    public UnitStatCalculator getUnitStatCalculator() {
        return this.player.getUnitStatCalculator();
    }

    protected int getMaxEnergy() {
        return this.getUnitStatCalculator().maxEnergy(this.type);
    }

    @Override
    public int getArmor() {
        return this.getUnitStatCalculator().armor(this.type);
    }

    @Override
    public int maxShields() {
        return this.type.maxShields();
    }

    @Override
    public int getShields() {
        return this.shields;
    }

    @Override
    public int getSpellCooldown() {
        return this.spellCooldown;
    }

    @Override
    public Player getPlayer() {
        return super.getPlayer();
    }

    @Override
    public int getInitialHitPoints() {
        return this.initialHitPoints;
    }

    @Override
    public int getMineralPrice() {
        return this.type.mineralPrice();
    }

    @Override
    public int getGasPrice() {
        return this.type.gasPrice();
    }

    @Override
    public int getLastKnownHitPoints() {
        return this.lastKnownHitPoints;
    }

    @Override
    public Position getLastKnownPosition() {
        return this.lastKnownPosition;
    }

    @Override
    public TilePosition getLastKnownTilePosition() {
        return this.lastKnownTilePosition;
    }

    @Override
    public int getSightRange() {
        return this.getUnitStatCalculator().sightRange(this.type);
    }

    @Override
    public boolean isDetector() {
        return this.type.isDetector();
    }

    @Override
    public boolean isDetected() {
        return this.detected;
    }

    @Override
    public boolean isCloaked() {
        return this.cloaked;
    }

    @Override
    public boolean isFlyer() {
        return this.type.isFlyer();
    }

    @Override
    public boolean isInterruptible() {
        return this.interruptible;
    }

    @Override
    public int tileWidth() {
        return this.type.tileWidth();
    }

    @Override
    public int tileHeight() {
        return this.type.tileHeight();
    }

    protected double getTopSpeed() {
        return this.getUnitStatCalculator().topSpeed(this.type);
    }

    protected int getMaxGroundHits() {
        return this.type.maxGroundHits();
    }

    protected int getMaxAirHits() {
        return this.type.maxAirHits();
    }

    @Override
    public double getVelocityX() {
        return this.velocityX;
    }

    @Override
    public double getVelocityY() {
        return this.velocityY;
    }

    @Override
    public boolean isIdle() {
        return this.idle;
    }

    @Override
    public boolean isAccelerating() {
        return this.accelerating;
    }

    @Override
    public boolean isAttacking() {
        return this.attacking;
    }

    @Override
    public boolean isAttackFrame() {
        return this.attackFrame;
    }

    @Override
    public boolean isBeingConstructed() {
        return this.beingConstructed;
    }

    @Override
    public boolean isBeingHealed() {
        return this.beingHealed;
    }

    @Override
    public boolean isIrradiated() {
        return this.irradiated;
    }

    @Override
    public boolean isLockedDown() {
        return this.lockedDown;
    }

    @Override
    public boolean isMaelstrommed() {
        return this.maelstrommed;
    }

    @Override
    public boolean isStartingAttack() {
        return this.startingAttack;
    }

    @Override
    public boolean isUnderAttack() {
        return this.underAttack;
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    protected int getGroundWeaponMaxRange() {
        return this.getUnitStatCalculator().weaponMaxRange(this.type.groundWeapon());
    }

    protected int getGroundWeaponMaxCooldown() {
        return this.getUnitStatCalculator().groundWeaponDamageMaxCooldown(this.type);
    }

    protected int getGroundWeaponCooldown(GroundAttacker unit) {
        return this.getUnitStatCalculator().groundWeaponDamageCooldown(unit);
    }

    protected int getGroundWeaponDamage() {
        return this.getUnitStatCalculator().damage(this.type.groundWeapon());
    }

    protected int getAirWeaponMaxRange() {
        return this.getUnitStatCalculator().weaponMaxRange(this.type.airWeapon());
    }

    protected int getAirWeaponMaxCooldown() {
        return this.type.airWeapon().damageCooldown();
    }

    protected int getAirWeaponCooldown(AirAttacker unit) {
        return this.getUnitStatCalculator().airWeaponDamageCooldown(unit);
    }

    protected int getAirWeaponDamage() {
        return this.getUnitStatCalculator().damage(this.type.airWeapon());
    }

    @Override
    public int getDamageTo(PlayerUnit to) {
        return this.getDamageEvaluator().getDamageTo(to.getType(), this.type, to.getPlayer(), this.getPlayer());
    }

    @Override
    public int getDamageFrom(PlayerUnit from) {
        return this.getDamageEvaluator().getDamageFrom(from.getType(), this.type, from.getPlayer(), this.getPlayer());
    }

    @Override
    public Order getOrder() {
        return super.getOrder();
    }

    @Override
    public Unit getOrderTarget() {
        return super.getOrderTarget();
    }

    @Override
    public Position getOrderTargetPosition() {
        return super.getOrderTargetPosition();
    }

    @Override
    public Order getSecondaryOrder() {
        return super.getSecondaryOrder();
    }

    @Override
    public int getLastCommandFrame() {
        return this.lastCommandFrame;
    }

    @Override
    public UnitCommandType getLastCommand() {
        return this.lastCommand;
    }
}

