/*
 * Decompiled with CFR 0.152.
 */
package org.openbw.bwapi4j.unit;

import java.util.List;
import java.util.stream.Collectors;
import org.openbw.bwapi4j.type.TechType;
import org.openbw.bwapi4j.type.UnitCommandType;
import org.openbw.bwapi4j.type.UnitType;
import org.openbw.bwapi4j.type.UpgradeType;
import org.openbw.bwapi4j.unit.BuildingImpl;
import org.openbw.bwapi4j.unit.Larva;
import org.openbw.bwapi4j.unit.Morphable;
import org.openbw.bwapi4j.unit.Organic;
import org.openbw.bwapi4j.unit.ResearchingFacility;
import org.openbw.bwapi4j.unit.ResourceDepot;

public class Hatchery
extends BuildingImpl
implements Organic,
ResearchingFacility,
ResourceDepot,
Morphable {
    protected Hatchery(UnitType unitType, int timeSpotted) {
        super(unitType, timeSpotted);
    }

    @Override
    public boolean isReadyForResources() {
        return this.completed;
    }

    @Override
    public boolean trainWorker() {
        return super.train(UnitType.Zerg_Drone);
    }

    public List<Larva> getLarva() {
        return super.getAllUnits().stream().filter(u -> u instanceof Larva && ((Larva)u).getHatchery().getId() == this.getId()).map(u -> (Larva)u).collect(Collectors.toList());
    }

    public boolean researchBurrowing() {
        return super.research(TechType.Burrowing);
    }

    @Override
    public boolean isUpgrading() {
        return this.upgrading;
    }

    @Override
    public boolean isResearching() {
        return this.researching;
    }

    @Override
    public boolean cancelResearch() {
        return super.cancelResearch();
    }

    @Override
    public boolean cancelUpgrade() {
        return super.cancelUpgrade();
    }

    @Override
    public boolean morph(UnitType type) {
        if (type != UnitType.Zerg_Lair) {
            throw new IllegalArgumentException("Cannot morph to " + type);
        }
        return this.issueCommand(this.iD, UnitCommandType.Morph, -1, -1, -1, UnitType.Zerg_Lair.getId());
    }

    public boolean morph() {
        return this.morph(UnitType.Zerg_Lair);
    }

    @Override
    public boolean canResearch(TechType techType) {
        return super.canResearch(techType);
    }

    @Override
    public boolean canUpgrade(UpgradeType upgradeType) {
        return super.canUpgrade(upgradeType);
    }

    @Override
    public boolean research(TechType techType) {
        return super.research(techType);
    }

    @Override
    public boolean upgrade(UpgradeType upgradeType) {
        return super.upgrade(upgradeType);
    }

    @Override
    public ResearchingFacility.UpgradeInProgress getUpgradeInProgress() {
        return super.getUpgradeInProgress();
    }

    @Override
    public ResearchingFacility.ResearchInProgress getResearchInProgress() {
        return super.getResearchInProgress();
    }

    @Override
    public int supplyProvided() {
        return this.type.supplyProvided();
    }
}

