/*
 * Decompiled with CFR 0.152.
 */
package org.openbw.bwapi4j.unit;

import org.openbw.bwapi4j.Position;
import org.openbw.bwapi4j.TilePosition;
import org.openbw.bwapi4j.type.UnitCommandType;
import org.openbw.bwapi4j.type.UnitType;
import org.openbw.bwapi4j.unit.Building;
import org.openbw.bwapi4j.unit.PlayerUnitImpl;
import org.openbw.bwapi4j.unit.Unit;
import org.openbw.bwapi4j.util.MathUtils;

public abstract class BuildingImpl
extends PlayerUnitImpl
implements Building {
    protected int probableConstructionStart;

    @Override
    public boolean cancelConstruction() {
        return this.issueCommand(this.iD, UnitCommandType.Cancel_Construction, -1, -1, -1, -1);
    }

    protected BuildingImpl(UnitType unitType, int timeSpotted) {
        this.type = unitType;
        this.probableConstructionStart = this.calculateProbableConstructionStart(timeSpotted);
    }

    @Override
    public int getBuildTime() {
        return this.type.buildTime();
    }

    @Override
    public int getRemainingBuildTime() {
        return this.remainingBuildTime;
    }

    private int calculateProbableConstructionStart(int currentFrame) {
        int time = 0;
        if (this.isCompleted()) {
            time = currentFrame - this.type.buildTime();
        } else if (this.type.maxHitPoints() > 0) {
            time = currentFrame - this.type.buildTime() * this.getHitPoints() / this.type.maxHitPoints();
        }
        return time;
    }

    @Override
    public int getProbableConstructionStart() {
        return this.probableConstructionStart;
    }

    @Override
    public int getLastKnownDistance(TilePosition tilePosition) {
        int left = this.getLastKnownTilePosition().getX();
        int tileX = tilePosition.getX();
        int top = this.getLastKnownTilePosition().getY();
        int tileY = tilePosition.getY();
        return (int)MathUtils.distanceBetween(left, top, left + this.type.tileWidth(), top + this.type.tileHeight(), tileX, tileY, tileX, tileY);
    }

    @Override
    public double getLastKnownDistance(Position position) {
        int centerX = this.getLastKnownPosition().getX();
        int posX = position.getX();
        int centerY = this.getLastKnownPosition().getY();
        int posY = position.getY();
        return (int)MathUtils.distanceBetween(centerX - this.type.dimensionLeft(), centerY - this.type.dimensionUp(), centerX + this.type.dimensionRight(), centerY + this.type.dimensionDown(), posX - 1, posY - 1, posX + 1, posY + 1);
    }

    @Override
    public double getLastKnownDistance(Unit target) {
        if (this == target) {
            return 0.0;
        }
        int centerX = this.getLastKnownPosition().getX();
        int centerY = this.getLastKnownPosition().getY();
        return MathUtils.estimateDistanceBetween(centerX - this.type.dimensionLeft(), centerY - this.type.dimensionUp(), centerX + this.type.dimensionRight(), centerY + this.type.dimensionDown(), target.getLeft() - 1, target.getTop() - 1, target.getRight() + 1, target.getBottom() + 1);
    }
}

