/*
 * Decompiled with CFR 0.152.
 */
package org.openbw.bwapi4j.type;

import org.openbw.bwapi4j.type.UnitType;

public enum Race {
    Zerg(0),
    Terran(1),
    Protoss(2),
    Other(3),
    Unused(4),
    Select(5),
    Random(6),
    None(7),
    Unknown(8);

    private int id;
    private UnitType worker;
    private UnitType center;
    private UnitType refinery;
    private UnitType transport;
    private UnitType supplyProvider;

    private Race(int id) {
        this.id = id;
        switch (id) {
            case 0: {
                this.worker = UnitType.Zerg_Drone;
                this.center = UnitType.Zerg_Hatchery;
                this.refinery = UnitType.Zerg_Extractor;
                this.transport = UnitType.Zerg_Overlord;
                this.supplyProvider = UnitType.Zerg_Overlord;
                break;
            }
            case 1: {
                this.worker = UnitType.Terran_SCV;
                this.center = UnitType.Terran_Command_Center;
                this.refinery = UnitType.Terran_Refinery;
                this.transport = UnitType.Terran_Dropship;
                this.supplyProvider = UnitType.Terran_Supply_Depot;
                break;
            }
            case 2: {
                this.worker = UnitType.Protoss_Probe;
                this.center = UnitType.Protoss_Nexus;
                this.refinery = UnitType.Protoss_Assimilator;
                this.transport = UnitType.Protoss_Shuttle;
                this.supplyProvider = UnitType.Protoss_Pylon;
            }
        }
    }

    public static Race withId(int id) {
        return Race.values()[id];
    }

    public int getId() {
        return this.id;
    }

    public UnitType getWorker() {
        return this.worker;
    }

    public UnitType getCenter() {
        return this.center;
    }

    public UnitType getRefinery() {
        return this.refinery;
    }

    public UnitType getTransport() {
        return this.transport;
    }

    public UnitType getSupplyProvider() {
        return this.supplyProvider;
    }
}

