/*
 * Decompiled with CFR 0.152.
 */
package org.openbw.bwapi4j.org.xguzm.pathfinding;

import java.util.Comparator;
import org.openbw.bwapi4j.org.xguzm.pathfinding.BHeapNode;

public class BHeap<T extends BHeapNode> {
    public int size = 0;
    private BHeapNode[] nodes;
    Comparator<T> comparator;

    public BHeap(Comparator<T> comparator) {
        this(comparator, 16);
    }

    public BHeap(Comparator<T> comparator, int capacity) {
        this.nodes = new BHeapNode[capacity];
        this.comparator = comparator;
    }

    public T add(T node) {
        if (this.size == this.nodes.length) {
            BHeapNode[] newNodes = new BHeapNode[this.size << 1];
            System.arraycopy(this.nodes, 0, newNodes, 0, this.size);
            this.nodes = newNodes;
        }
        node.setIndex(this.size);
        this.nodes[this.size] = node;
        this.up(this.size++);
        return node;
    }

    public T peek() {
        if (this.size == 0) {
            throw new IllegalStateException("The heap is empty.");
        }
        return (T)this.nodes[0];
    }

    public T pop() {
        BHeapNode[] nodes = this.nodes;
        BHeapNode popped = nodes[0];
        nodes[0] = nodes[--this.size];
        nodes[this.size] = null;
        if (this.size > 0) {
            this.down(0);
        }
        return (T)popped;
    }

    public void clear() {
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            this.nodes[i] = null;
        }
        this.size = 0;
    }

    public void updateNode(T node, float valueComparison) {
        int i = node.getIndex();
        if (valueComparison < 0.0f) {
            this.up(i);
        } else {
            this.down(i);
        }
    }

    private void up(int index) {
        int parentIndex;
        BHeapNode parent;
        BHeapNode[] nodes = this.nodes;
        BHeapNode node = nodes[index];
        while (index > 0 && this.comparator.compare(node, parent = nodes[parentIndex = index - 1 >> 1]) < 0) {
            nodes[index] = parent;
            parent.setIndex(index);
            index = parentIndex;
        }
        nodes[index] = node;
        node.setIndex(index);
    }

    private void down(int index) {
        int leftIndex;
        BHeapNode[] nodes = this.nodes;
        int size = this.size;
        BHeapNode node = nodes[index];
        while ((leftIndex = 1 + (index << 1)) < size) {
            BHeapNode leftNode = nodes[leftIndex];
            int rightIndex = leftIndex + 1;
            BHeapNode rightNode = rightIndex >= size ? null : nodes[rightIndex];
            if (this.comparator.compare(leftNode, rightNode) < 0) {
                if (leftNode == null || this.comparator.compare(leftNode, node) > 0) break;
                nodes[index] = leftNode;
                leftNode.setIndex(index);
                index = leftIndex;
                continue;
            }
            if (rightNode == null || this.comparator.compare(rightNode, node) > 0) break;
            nodes[index] = rightNode;
            rightNode.setIndex(index);
            index = rightIndex;
        }
        nodes[index] = node;
        node.setIndex(index);
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        BHeapNode[] nodes = this.nodes;
        StringBuilder buffer = new StringBuilder(32);
        buffer.append('[');
        buffer.append(nodes[0]);
        for (int i = 1; i < this.size; ++i) {
            buffer.append(", ");
            buffer.append(nodes[i]);
        }
        buffer.append(']');
        return buffer.toString();
    }
}

