/*
 * Decompiled with CFR 0.152.
 */
package org.openbw.bwapi4j;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import org.openbw.bwapi4j.BW;
import org.openbw.bwapi4j.TilePosition;
import org.openbw.bwapi4j.UnitStatCalculator;
import org.openbw.bwapi4j.ap.LookedUp;
import org.openbw.bwapi4j.type.Color;
import org.openbw.bwapi4j.type.PlayerType;
import org.openbw.bwapi4j.type.Race;
import org.openbw.bwapi4j.type.TechType;
import org.openbw.bwapi4j.type.UnitType;
import org.openbw.bwapi4j.type.UpgradeType;
import org.openbw.bwapi4j.unit.ExtendibleByAddon;
import org.openbw.bwapi4j.unit.PlayerUnit;
import org.openbw.bwapi4j.unit.Unit;

@LookedUp(method="getPlayer")
public class Player {
    int iD;
    private String name;
    private final BW bw;
    Race race;
    TilePosition startLocation;
    Color color;
    char textColor;
    PlayerType type;
    boolean neutral;
    boolean victorious;
    boolean defeated;
    boolean leftGame;
    int minerals;
    int gas;
    int gatheredMinerals;
    int gatheredGas;
    int repairedMinerals;
    int repairedGas;
    int refundedMinerals;
    int refundedGas;
    int spentMinerals;
    int spentGas;
    int supplyTotal;
    int unitScore;
    int killScore;
    int buildingScore;
    int razingScore;
    int customScore;
    boolean observer;
    int supplyUsed;
    private int[] supplyTotalRace;
    private int[] supplyUsedRace;
    int allUnitCount;
    int visibleUnitCount;
    int completedUnitCount;
    int incompleteUnitCount;
    int deadUnitCount;
    int killedUnitCount;
    Map<TechType, boolean[]> researchStatus;
    Map<UpgradeType, int[]> upgradeStatus;
    private final UnitStatCalculator unitStatCalculator;
    private boolean ally;
    private boolean enemy;

    Player(int id, String name, BW bw) {
        this.iD = id;
        this.name = name;
        this.bw = bw;
        this.supplyTotalRace = new int[3];
        this.supplyUsedRace = new int[3];
        this.unitStatCalculator = new UnitStatCalculator(this);
    }

    public void initialize() {
        this.researchStatus = new EnumMap<TechType, boolean[]>(TechType.class);
        for (TechType techType : TechType.values()) {
            this.researchStatus.put(techType, new boolean[2]);
        }
        this.upgradeStatus = new EnumMap<UpgradeType, int[]>(UpgradeType.class);
        for (Enum enum_ : UpgradeType.values()) {
            this.upgradeStatus.put((UpgradeType)enum_, new int[2]);
        }
    }

    public void update(int[] extra) {
        int index = 0;
        int upgradeStatusAmount = extra[index++];
        for (int i = 0; i < upgradeStatusAmount; ++i) {
            int[] status = this.upgradeStatus.get(UpgradeType.withId(extra[index++]));
            status[0] = extra[index++];
            status[1] = extra[index++];
        }
        int researchStatusAmount = extra[index++];
        for (int i = 0; i < researchStatusAmount; ++i) {
            boolean[] status = this.researchStatus.get(TechType.withId(extra[index++]));
            status[0] = extra[index++] == 1;
            status[1] = extra[index++] == 1;
        }
        this.ally = extra[index++] == 1;
        this.enemy = extra[index] == 1;
    }

    public boolean isAlly() {
        return this.ally;
    }

    public boolean isEnemy() {
        return this.enemy;
    }

    public int getId() {
        return this.iD;
    }

    public String getName() {
        return this.name;
    }

    public Race getRace() {
        return this.race;
    }

    public PlayerType getType() {
        return this.type;
    }

    public boolean isNeutral() {
        return this.neutral;
    }

    public TilePosition getStartLocation() {
        return this.startLocation;
    }

    public boolean isVictorious() {
        return this.victorious;
    }

    public boolean isDefeated() {
        return this.defeated;
    }

    public boolean leftGame() {
        return this.leftGame;
    }

    public int minerals() {
        return this.minerals;
    }

    public int gas() {
        return this.gas;
    }

    public int gatheredMinerals() {
        return this.gatheredMinerals;
    }

    public int gatheredGas() {
        return this.gatheredGas;
    }

    public int repairedMinerals() {
        return this.repairedMinerals;
    }

    public int repairedGas() {
        return this.repairedGas;
    }

    public int refundedMinerals() {
        return this.refundedMinerals;
    }

    public int refundedGas() {
        return this.refundedGas;
    }

    public int spentMinerals() {
        return this.spentMinerals;
    }

    public int spentGas() {
        return this.spentGas;
    }

    public int supplyTotal() {
        return this.supplyTotal;
    }

    public int supplyTotal(Race race) {
        return this.supplyTotalRace[race.ordinal()];
    }

    public int supplyUsed() {
        return this.supplyUsed;
    }

    public int supplyUsed(Race race) {
        return this.supplyUsedRace[race.ordinal()];
    }

    public int allUnitCount() {
        return this.allUnitCount;
    }

    public int visibleUnitCount() {
        return this.visibleUnitCount;
    }

    public int completedUnitCount() {
        return this.completedUnitCount;
    }

    public int incompleteUnitCount() {
        return this.incompleteUnitCount;
    }

    public int deadUnitCount() {
        return this.deadUnitCount;
    }

    public int killedUnitCount() {
        return this.killedUnitCount;
    }

    public int getUpgradeLevel(UpgradeType upgrade) {
        return this.upgradeStatus.get(upgrade)[0];
    }

    public boolean hasResearched(TechType tech) {
        if (TechType.None.equals(tech)) {
            return true;
        }
        return this.researchStatus.get(tech)[0];
    }

    public boolean isResearching(TechType tech) {
        return this.researchStatus.get(tech)[1];
    }

    public boolean isUpgrading(UpgradeType upgrade) {
        return this.upgradeStatus.get(upgrade)[1] == 1;
    }

    public Color getColor() {
        return this.color;
    }

    public char getTextColor() {
        return this.textColor;
    }

    public UnitStatCalculator getUnitStatCalculator() {
        return this.unitStatCalculator;
    }

    public int getUnitScore() {
        return this.unitScore;
    }

    public int getKillScore() {
        return this.killScore;
    }

    public int getBuildingScore() {
        return this.buildingScore;
    }

    public int getRazingScore() {
        return this.razingScore;
    }

    public int getCustomScore() {
        return this.customScore;
    }

    public boolean isObserver() {
        return this.observer;
    }

    public boolean canMake(UnitType type) {
        int supplyRequired = type.supplyRequired();
        if (type.isTwoUnitsInOneEgg()) {
            supplyRequired *= 2;
        }
        return this.minerals >= type.mineralPrice() && this.gas >= type.gasPrice() && (type.supplyRequired() == 0 || this.supplyUsed + supplyRequired <= this.supplyTotal) && this.hasResearched(type.requiredTech()) && Player.getMissingUnits(this.bw.getUnits(this), type.requiredUnits().keySet()).isEmpty();
    }

    public boolean canMake(Unit builder, UnitType type) {
        if (!this.canMake(type) || builder.getType() != type.whatBuilds().getUnitType()) {
            return false;
        }
        return type.requiredUnits().keySet().stream().filter(UnitType::isAddon).findAny().map(requiredAddon -> {
            ExtendibleByAddon building = (ExtendibleByAddon)builder;
            if (building.getAddon() == null || building.getAddon().getType() != requiredAddon) {
                return false;
            }
            return true;
        }).orElse(true);
    }

    public boolean canResearch(TechType type) {
        if (this.hasResearched(type) || this.isResearching(type)) {
            return false;
        }
        ArrayList<UnitType> requiredUnits = new ArrayList<UnitType>();
        if (type.whatResearches() != UnitType.None) {
            requiredUnits.add(type.whatResearches());
        }
        if (type.requiredUnit() != UnitType.None) {
            requiredUnits.add(type.requiredUnit());
        }
        return this.minerals >= type.mineralPrice() && this.gas >= type.gasPrice() && Player.getMissingUnits(this.bw.getUnits(this), requiredUnits).isEmpty();
    }

    public boolean canUpgrade(UpgradeType type) {
        int upgradeLevel = this.getUpgradeLevel(type);
        if (upgradeLevel >= type.maxRepeats() || this.isUpgrading(type)) {
            return false;
        }
        ArrayList<UnitType> requiredUnits = new ArrayList<UnitType>();
        UnitType whatsRequired = type.whatsRequired(upgradeLevel);
        if (whatsRequired != UnitType.None) {
            requiredUnits.add(whatsRequired);
        }
        requiredUnits.add(type.whatUpgrades());
        return this.minerals >= type.mineralPrice(upgradeLevel) && this.gas >= type.gasPrice(upgradeLevel) && Player.getMissingUnits(this.bw.getUnits(this), requiredUnits).isEmpty();
    }

    public static Collection<UnitType> getMissingUnits(Collection<? extends PlayerUnit> group, Collection<UnitType> types) {
        HashSet<UnitType> result = new HashSet<UnitType>(types);
        group.stream().filter(u -> u.isCompleted()).map(u -> u.getType()).forEach(result::remove);
        return result;
    }
}

