#include "BananaBrain.h"

void ZergStrategy::pick_strategy()
{
	Race race = opponent_model.enemy_race();
	switch (race) {
		case Races::Zerg:
			if (!configuration.ZvZ_opening().empty()) {
				opening_ = configuration.ZvZ_opening();
			} else if (Broodwar->mapHash() == kMapHash_Sparkle) {
				opening_ = kZvZ_Sparkle_3HatchMuta;
			} else {
				opening_ = result_store.pick_strategy({kZvZ_5Pool,kZvZ_2HatchLing,kZvZ_3HatchLing,kZvZ_9Pool,kZvZ_9Gas9Pool,kZvZ_9Gas10Pool});
			}
			break;
		case Races::Terran:
			if (!configuration.ZvT_opening().empty()) {
				opening_ = configuration.ZvT_opening();
			} else if (Broodwar->mapHash() == kMapHash_Sparkle) {
				opening_ = kZvT_Sparkle_3HatchMuta;
			} else {
				opening_ = result_store.pick_strategy({kZvT_4Pool,kZvT_2HatchLing,kZvT_3HatchLing,kZvT_2HatchMuta_12Hatch,kZvT_2HatchMuta_12Pool,kZvT_3HatchMuta});
			}
			break;
		case Races::Protoss:
			if (!configuration.ZvP_opening().empty()) {
				opening_ = configuration.ZvP_opening();
			} else if (Broodwar->mapHash() == kMapHash_Sparkle) {
				opening_ = kZvP_Sparkle_3HatchMuta;
			} else {
				opening_ = result_store.pick_strategy({kZvP_5Pool,kZvP_2HatchLing,kZvP_3HatchLing,kZvP_2HatchMuta,kZvP_3HatchMuta,kZvP_9734});
			}
			break;
		default:
			if (!configuration.ZvU_opening().empty()) {
				opening_ = configuration.ZvU_opening();
			} else if (Broodwar->mapHash() == kMapHash_Sparkle) {
				opening_ = kZvU_Sparkle_3HatchMuta;
			} else {
				opening_ = result_store.pick_strategy({kZvU_4Pool,kZvU_5Pool,kZvU_2HatchLing,kZvU_3HatchLing});
			}
			break;
	}
}

std::string ZergStrategy::mode() const
{
	switch (mode_) {
		case Mode::Opening:
			return "Opening";
		case Mode::DefendFastPool:
			return "Defend fast pool";
		case Mode::Main_MutaHydraLing:
			return "Main Muta/Hydra/Ling";
		case Mode::Main_HydraLing:
			return "Main Hydra/Ling";
		case Mode::Main_UltraLing:
			return "Main Ultra/Ling";
		case Mode::Main_ZvZ:
			return "Main ZvZ";
		case Mode::Main_ZvZLateGame:
			return "Main ZvZ late game";
		default:
			return "?";
	}
}

void ZergStrategy::opening_ZvZ_9pool()
{
	if (opponent_model.enemy_opening() == EnemyOpening::Z_4_5Pool ||
		opponent_model.enemy_opening() == EnemyOpening::Z_9PoolSpeed) {
		mode_ = Mode::DefendFastPool;
		fast_pool_sunken_count_ = 0;
		return;
	}
	if (tactics_manager.enemy_offense_supply() > tactics_manager.defense_supply() ||
		worker_manager.lost_worker_count() >= 2 ||
		building_manager.building_placement_failed()) {
		mode_ = Mode::Main_ZvZ;
		return;
	}
	bool save_larvae = (morphing_building_hp_at_least(UnitTypes::Zerg_Spawning_Pool, 300) ||
						morphing_building_hp_at_least(UnitTypes::Zerg_Spire, 350));
	int supply = opening_supply_count();
	if (supply >= 9) {
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Spawning_Pool, 1);
	}
	if (supply >= 8 && building_manager.building_count_including_planned(UnitTypes::Zerg_Spawning_Pool) >= 1) {
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Extractor, 1);
	}
	if (supply >= 8 &&
		building_manager.building_count_including_planned(UnitTypes::Zerg_Extractor) >= 1 &&
		training_manager.unit_count(UnitTypes::Zerg_Overlord) < 2) {
		training_manager.larva_train_distribution().set(UnitTypes::Zerg_Overlord, 1.0);
	}
	if (building_manager.building_exists(UnitTypes::Zerg_Spawning_Pool) &&
		training_manager.unit_count(UnitTypes::Zerg_Zergling) < 6 && !save_larvae) {
		training_manager.larva_train_distribution().set(UnitTypes::Zerg_Zergling, 1.0);
	}
	if (building_manager.building_exists(UnitTypes::Zerg_Extractor) &&
		training_manager.unit_count(UnitTypes::Zerg_Drone) >= 8) {
		worker_manager.set_force_refinery_workers(true);
	}
	if (building_manager.building_exists(UnitTypes::Zerg_Spawning_Pool) &&
		training_manager.unit_count(UnitTypes::Zerg_Zergling) >= 6) {
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Lair, 1);
	}
	if (building_manager.building_count_including_planned(UnitTypes::Zerg_Lair) >= 1) {
		building_manager.request_upgrade(UpgradeTypes::Metabolic_Boost);
	}
	if (building_manager.building_exists(UnitTypes::Zerg_Lair)) {
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Spire, 1);
	}
	if (supply >= 16 && training_manager.unit_count(UnitTypes::Zerg_Overlord) < 3) {
		training_manager.larva_train_distribution().set(UnitTypes::Zerg_Overlord, 1.0);
	}
	if (building_manager.building_exists(UnitTypes::Zerg_Spire)) {
		if (training_manager.unit_count(UnitTypes::Zerg_Mutalisk) < 3) {
			training_manager.larva_train_distribution().set(UnitTypes::Zerg_Mutalisk, 1.0);
		} else {
			mode_ = Mode::Main_ZvZ;
		}
	}
	if (training_manager.unit_count(UnitTypes::Zerg_Zergling) >= 2 && !opening_attack_started_) {
		attacking_ = true;
		opening_attack_started_ = true;
	}
	if (opening_attack_started_) attack_check_condition();
	if (!save_larvae && training_manager.larva_train_distribution().is_empty()) {
		training_manager.larva_train_distribution().set(UnitTypes::Zerg_Drone, 1.0);
	}
}

void ZergStrategy::opening_ZvZ_9gas9pool()
{
	if (opponent_model.enemy_opening() == EnemyOpening::Z_4_5Pool ||
		opponent_model.enemy_opening() == EnemyOpening::Z_9PoolSpeed) {
		mode_ = Mode::DefendFastPool;
		fast_pool_sunken_count_ = 1;
		return;
	}
	if (tactics_manager.enemy_offense_supply() > tactics_manager.defense_supply() ||
		worker_manager.lost_worker_count() >= 2 ||
		building_manager.building_placement_failed()) {
		mode_ = Mode::Main_ZvZ;
		return;
	}
	int supply = opening_supply_count();
	if (supply >= 9 &&
		training_manager.unit_count(UnitTypes::Zerg_Overlord) < 2) {
		training_manager.larva_train_distribution().set(UnitTypes::Zerg_Overlord, 1.0);
	}
	if (supply >= 9 &&
		training_manager.unit_count(UnitTypes::Zerg_Overlord) >= 2) {
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Extractor, 1);
	}
	if (supply >= 9 &&
		building_manager.building_count_including_planned(UnitTypes::Zerg_Extractor) >= 1) {
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Spawning_Pool, 1);
	}
	if (building_manager.building_exists(UnitTypes::Zerg_Extractor) &&
		training_manager.unit_count(UnitTypes::Zerg_Drone) >= 8) {
		worker_manager.set_force_refinery_workers(true);
	}
	if (supply >= 11 &&
		building_manager.building_exists(UnitTypes::Zerg_Spawning_Pool)) {
		building_manager.request_upgrade(UpgradeTypes::Metabolic_Boost);
		if (done_or_in_progress(UpgradeTypes::Metabolic_Boost)) {
			building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Lair, 1);
		}
		if (building_manager.building_count_including_planned(UnitTypes::Zerg_Lair) >= 1) {
			worker_manager.set_limit_refinery_workers(2);
		}
		if (building_manager.building_exists(UnitTypes::Zerg_Lair)) {
			building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Spire, 1);
		}
		if (building_manager.building_count_including_warping(UnitTypes::Zerg_Spire) >= 1) {
			worker_manager.set_limit_refinery_workers(3);
		}
	}
	if (supply >= 17 &&
		training_manager.unit_count(UnitTypes::Zerg_Overlord) < 3) {
		training_manager.larva_train_distribution().set(UnitTypes::Zerg_Overlord, 1.0);
	}
	if (building_manager.building_exists(UnitTypes::Zerg_Spire)) {
		if (training_manager.unit_count(UnitTypes::Zerg_Mutalisk) < 3) {
			training_manager.larva_train_distribution().set(UnitTypes::Zerg_Mutalisk, 1.0);
		} else {
			mode_ = Mode::Main_ZvZ;
		}
	}
	if (training_manager.unit_count(UnitTypes::Zerg_Zergling) >= 2 && !opening_attack_started_) {
		attacking_ = true;
		opening_attack_started_ = true;
	}
	if (opening_attack_started_) attack_check_condition();
	if (training_manager.larva_train_distribution().is_empty()) {
		int wanted_drone_count = 11;
		if (building_manager.building_count_including_planned(UnitTypes::Zerg_Spire) >= 1) {
			wanted_drone_count--;
		}
		if (training_manager.unit_count(UnitTypes::Zerg_Drone) < wanted_drone_count) {
			training_manager.larva_train_distribution().set(UnitTypes::Zerg_Drone, 1.0);
		} else if (building_manager.building_exists(UnitTypes::Zerg_Spawning_Pool) &&
				   done_or_in_progress(UpgradeTypes::Metabolic_Boost) &&
				   building_manager.building_count_including_planned(UnitTypes::Zerg_Lair) >= 1 &&
				   training_manager.unit_count(UnitTypes::Zerg_Zergling) < 17) {
			training_manager.larva_train_distribution().set(UnitTypes::Zerg_Zergling, 1.0);
		}
	}
}

void ZergStrategy::opening_ZvZ_9gas10pool()
{
	if (opponent_model.enemy_opening() == EnemyOpening::Z_4_5Pool ||
		opponent_model.enemy_opening() == EnemyOpening::Z_9PoolSpeed) {
		mode_ = Mode::DefendFastPool;
		fast_pool_sunken_count_ = 1;
		return;
	}
	if (tactics_manager.enemy_offense_supply() > tactics_manager.defense_supply() ||
		worker_manager.lost_worker_count() >= 2 ||
		building_manager.building_placement_failed()) {
		mode_ = Mode::Main_ZvZ;
		return;
	}
	int supply = opening_supply_count();
	if (supply >= 9 &&
		training_manager.unit_count(UnitTypes::Zerg_Overlord) < 2) {
		training_manager.larva_train_distribution().set(UnitTypes::Zerg_Overlord, 1.0);
	}
	if (supply >= 9 &&
		training_manager.unit_count(UnitTypes::Zerg_Overlord) >= 2) {
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Extractor, 1);
	}
	if (supply >= 10 &&
		building_manager.building_count_including_planned(UnitTypes::Zerg_Extractor) >= 1) {
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Spawning_Pool, 1);
	}
	if (building_manager.building_exists(UnitTypes::Zerg_Extractor) &&
		training_manager.unit_count(UnitTypes::Zerg_Drone) >= 8) {
		worker_manager.set_force_refinery_workers(true);
	}
	if (supply >= 12 &&
		building_manager.building_count_including_planned(UnitTypes::Zerg_Spawning_Pool) >= 1) {
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Lair, 1);
	}
	if (supply >= 14 &&
		building_manager.building_count_including_planned(UnitTypes::Zerg_Lair) >= 1) {
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Hatchery, 2);
		if (building_manager.building_exists(UnitTypes::Zerg_Lair)) {
			building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Spire, 1);
		}
	}
	if (supply >= 17 &&
		building_manager.building_count_including_planned(UnitTypes::Zerg_Spire) >= 1 &&
		training_manager.unit_count(UnitTypes::Zerg_Overlord) < 4) {
		training_manager.larva_train_distribution().set(UnitTypes::Zerg_Overlord, 1.0);
	}
	if (building_manager.building_exists(UnitTypes::Zerg_Spire)) {
		if (training_manager.unit_count(UnitTypes::Zerg_Mutalisk) < 6) {
			training_manager.larva_train_distribution().set(UnitTypes::Zerg_Mutalisk, 1.0);
		} else {
			mode_ = Mode::Main_ZvZ;
		}
	}
	if (training_manager.unit_count(UnitTypes::Zerg_Zergling) >= 2 && !opening_attack_started_) {
		attacking_ = true;
		opening_attack_started_ = true;
	}
	if (opening_attack_started_) attack_check_condition();
	if (training_manager.larva_train_distribution().is_empty()) {
		int wanted_drone_count = 12;
		if (building_manager.building_count_including_planned(UnitTypes::Zerg_Spire) >= 1) {
			wanted_drone_count--;
		}
		if (training_manager.unit_count(UnitTypes::Zerg_Drone) < wanted_drone_count) {
			training_manager.larva_train_distribution().set(UnitTypes::Zerg_Drone, 1.0);
		} else if (building_manager.building_exists(UnitTypes::Zerg_Spawning_Pool) &&
				   building_manager.building_count_including_planned(UnitTypes::Zerg_Lair) >= 1 &&
				   training_manager.unit_count(UnitTypes::Zerg_Zergling) < 21) {
			training_manager.larva_train_distribution().set(UnitTypes::Zerg_Zergling, 1.0);
		}
	}
}

void ZergStrategy::opening_ZvT_2hatchmuta(bool pool_first)
{
	if (tactics_manager.enemy_offense_supply() > tactics_manager.defense_supply() ||
		worker_manager.lost_worker_count() >= 2 ||
		building_manager.building_placement_failed()) {
		mode_ = Mode::Main_MutaHydraLing;
		return;
	}
	bool save_larvae = (morphing_building_hp_at_least(UnitTypes::Zerg_Spawning_Pool, 300) ||
						morphing_building_hp_at_least(UnitTypes::Zerg_Spire, 350));
	int supply = opening_supply_count();
	if (supply >= 9 && training_manager.unit_count(UnitTypes::Zerg_Overlord) < 2) {
		training_manager.larva_train_distribution().set(UnitTypes::Zerg_Overlord, 1.0);
	}
	if (!pool_first) {
		if (supply >= 12) {
			if (!building_manager.request_bases(2)) {
				mode_ = Mode::Main_MutaHydraLing;
				return;
			}
			if (building_manager.building_count_including_planned(UnitTypes::Zerg_Hatchery) >= 2 &&
				base_state.start_base_count() >= 4) worker_manager.send_initial_scout();
		}
		if (supply >= 11 &&
			building_manager.building_count_including_planned(UnitTypes::Zerg_Hatchery) >= 2) {
			building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Spawning_Pool, 1);
		}
		if (supply >= 10 &&
			building_manager.building_count_including_planned(UnitTypes::Zerg_Spawning_Pool) >= 1) {
			building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Extractor, 1);
		}
		if (supply >= 12 &&
			building_manager.building_count_including_planned(UnitTypes::Zerg_Extractor) >= 1 &&
			building_manager.building_exists(UnitTypes::Zerg_Spawning_Pool)) {
			if (training_manager.unit_count(UnitTypes::Zerg_Zergling) < 6 && !save_larvae) {
				training_manager.larva_train_distribution().set(UnitTypes::Zerg_Zergling, 1.0);
			} else {
				building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Lair, 1);
			}
		}
	} else {
		if (supply >= 12) {
			building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Spawning_Pool, 1);
			if (building_manager.building_count_including_planned(UnitTypes::Zerg_Spawning_Pool) >= 1 &&
				base_state.start_base_count() >= 4) worker_manager.send_initial_scout();
		}
		if (supply >= 11 &&
			building_manager.building_count_including_planned(UnitTypes::Zerg_Spawning_Pool) >= 1) {
			building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Extractor, 1);
		}
		if (supply >= 11 &&
			building_manager.building_count_including_planned(UnitTypes::Zerg_Extractor) >= 1) {
			if (!building_manager.request_bases(2)) {
				mode_ = Mode::Main_MutaHydraLing;
				return;
			}
		}
		if (building_manager.building_count_including_planned(UnitTypes::Zerg_Hatchery) >= 2) {
			building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Lair, 1);
		}
		if (building_manager.building_count_including_planned(UnitTypes::Zerg_Lair) >= 1 &&
			training_manager.unit_count(UnitTypes::Zerg_Zergling) < 6) {
			training_manager.larva_train_distribution().set(UnitTypes::Zerg_Zergling, 1.0);
		}
	}
	if (worker_manager.is_scouting() &&
		(information_manager.enemy_building_seen() ||
		 tactics_manager.possible_enemy_start_bases().size() <= 1)) {
		worker_manager.stop_scouting();
	}
	
	if (building_manager.building_exists(UnitTypes::Zerg_Extractor) &&
		training_manager.unit_count(UnitTypes::Zerg_Drone) >= 10) {
		worker_manager.set_force_refinery_workers(true);
	}
	
	if (training_manager.unit_count_completed(UnitTypes::Zerg_Zergling) >= 6 && !opening_attack_started_) {
		attacking_ = true;
		opening_attack_started_ = true;
	}
	if (opening_attack_started_) attack_check_condition();
	
	if (supply >= 16 && training_manager.unit_count(UnitTypes::Zerg_Overlord) < 3) {
		training_manager.larva_train_distribution().set(UnitTypes::Zerg_Overlord, 1.0);
	}
	
	if (supply >= 16 &&
		training_manager.unit_count(UnitTypes::Zerg_Overlord) >= 2 &&
		building_manager.building_count_including_planned(UnitTypes::Zerg_Lair) >= 1 &&
		training_manager.unit_count(UnitTypes::Zerg_Zergling) >= 6) {
		if (!done_or_in_progress(UpgradeTypes::Metabolic_Boost)) {
			building_manager.request_upgrade(UpgradeTypes::Metabolic_Boost);
		}
		if (building_manager.building_exists(UnitTypes::Zerg_Lair)) {
			building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Spire, 1);
		}
		if (building_manager.building_count_including_planned(UnitTypes::Zerg_Spire) >= 1) {
			building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Extractor, 2);
			if (training_manager.unit_count(UnitTypes::Zerg_Overlord) < 5) {
				training_manager.larva_train_distribution().set(UnitTypes::Zerg_Overlord, 1.0);
			}
		}
		if (building_manager.building_exists(UnitTypes::Zerg_Spire) &&
			training_manager.unit_count(UnitTypes::Zerg_Overlord) >= 5 &&
			training_manager.unit_count(UnitTypes::Zerg_Mutalisk) < 6) {
			training_manager.larva_train_distribution().set(UnitTypes::Zerg_Mutalisk, 1.0);
		}
		if (training_manager.unit_count(UnitTypes::Zerg_Mutalisk) >= 6) {
			mode_ = Mode::Main_MutaHydraLing;
		}
	}
	if (!save_larvae && training_manager.larva_train_distribution().is_empty()) {
		training_manager.larva_train_distribution().set(UnitTypes::Zerg_Drone, 1.0);
	}
}

void ZergStrategy::opening_ZvT_3hatchmuta()
{
	if (tactics_manager.enemy_offense_supply() > tactics_manager.defense_supply() ||
		worker_manager.lost_worker_count() >= 2 ||
		building_manager.building_placement_failed()) {
		mode_ = Mode::Main_MutaHydraLing;
		return;
	}
	base_state.set_skip_mineral_only(true);
	bool save_larvae = (morphing_building_hp_at_least(UnitTypes::Zerg_Spawning_Pool, 300) ||
						morphing_building_hp_at_least(UnitTypes::Zerg_Spire, 350));
	int supply = opening_supply_count();
	if (supply >= 9 && training_manager.unit_count(UnitTypes::Zerg_Overlord) < 2) {
		training_manager.larva_train_distribution().set(UnitTypes::Zerg_Overlord, 1.0);
	}
	if (supply >= 12) {
		if (!building_manager.request_bases(2)) {
			mode_ = Mode::Main_MutaHydraLing;
			return;
		}
		if (building_manager.building_count_including_planned(UnitTypes::Zerg_Hatchery) >= 2 &&
			base_state.start_base_count() >= 4) worker_manager.send_initial_scout();
	}
	if (worker_manager.is_scouting() &&
		(information_manager.enemy_building_seen() ||
		 tactics_manager.possible_enemy_start_bases().size() <= 1)) {
		worker_manager.stop_scouting();
	}
	if (supply >= 11 &&
		building_manager.building_count_including_planned(UnitTypes::Zerg_Hatchery) >= 2) {
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Spawning_Pool, 1);
	}
	if (supply >= 13 &&
		building_manager.building_count_including_planned(UnitTypes::Zerg_Spawning_Pool) >= 1) {
		if (!building_manager.request_bases(3)) {
			mode_ = Mode::Main_MutaHydraLing;
			return;
		}
	}
	if (supply >= 12 &&
		building_manager.building_count_including_planned(UnitTypes::Zerg_Hatchery) >= 2 &&
		training_manager.unit_count(UnitTypes::Zerg_Zergling) < 4 && !save_larvae) {
		training_manager.larva_train_distribution().set(UnitTypes::Zerg_Zergling, 1.0);
	}
	if (supply >= 16) {
		if (building_manager.building_count_including_warping(UnitTypes::Zerg_Extractor) == 0) {
			building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Extractor, 1);
		} else if (training_manager.unit_count(UnitTypes::Zerg_Overlord) < 3) {
			training_manager.larva_train_distribution().set(UnitTypes::Zerg_Overlord, 1.0);
		} else {
			building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Lair, 1);
			if (building_manager.building_count_including_planned(UnitTypes::Zerg_Lair) >= 1) {
				building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Extractor, 2);
			}
			if (building_manager.building_count_including_planned(UnitTypes::Zerg_Extractor) >= 2) {
				building_manager.request_upgrade(UpgradeTypes::Metabolic_Boost);
			}
			if (done_or_in_progress(UpgradeTypes::Metabolic_Boost)) {
				building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Spire, 1);
			}
			if (building_manager.building_count_including_planned(UnitTypes::Zerg_Spire) >= 1 &&
				training_manager.unit_count(UnitTypes::Zerg_Overlord) < 4) {
				training_manager.larva_train_distribution().set(UnitTypes::Zerg_Overlord, 1.0);
			}
			if (training_manager.unit_count(UnitTypes::Zerg_Overlord) >= 4) {
				building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Hatchery, 4);
			}
			if (building_manager.building_count_including_planned(UnitTypes::Zerg_Hatchery) >= 4 &&
				training_manager.unit_count(UnitTypes::Zerg_Zergling) < 10) {
				training_manager.larva_train_distribution().set(UnitTypes::Zerg_Zergling, 1.0);
			}
			if (training_manager.unit_count(UnitTypes::Zerg_Zergling) >= 10 &&
				training_manager.unit_count(UnitTypes::Zerg_Overlord) < 6) {
				training_manager.larva_train_distribution().set(UnitTypes::Zerg_Overlord, 1.0);
			}
			if (training_manager.unit_count(UnitTypes::Zerg_Overlord) >= 6 &&
				building_manager.building_exists(UnitTypes::Zerg_Spire)) {
				if (training_manager.unit_count(UnitTypes::Zerg_Mutalisk) < 9) {
					training_manager.larva_train_distribution().set(UnitTypes::Zerg_Mutalisk, 1.0);
				} else {
					mode_ = Mode::Main_MutaHydraLing;
				}
			}
		}
	}
	
	if (building_manager.building_exists(UnitTypes::Zerg_Extractor) &&
		training_manager.unit_count(UnitTypes::Zerg_Drone) >= 10) {
		worker_manager.set_force_refinery_workers(true);
	}
	if (training_manager.unit_count_completed(UnitTypes::Zerg_Zergling) >= 6 && !opening_attack_started_) {
		attacking_ = true;
		opening_attack_started_ = true;
	}
	if (opening_attack_started_) attack_check_condition();
	
	if (!save_larvae && training_manager.larva_train_distribution().is_empty()) {
		training_manager.larva_train_distribution().set(UnitTypes::Zerg_Drone, 1.0);
	}
}

void ZergStrategy::opening_ZvP_2hatchmuta()
{
	if (tactics_manager.enemy_offense_supply() > tactics_manager.defense_supply() ||
		worker_manager.lost_worker_count() >= 2 ||
		building_manager.building_placement_failed()) {
		mode_ = Mode::Main_MutaHydraLing;
		return;
	}
	base_state.set_skip_mineral_only(true);
	bool save_larvae = (morphing_building_hp_at_least(UnitTypes::Zerg_Spawning_Pool, 300) ||
						morphing_building_hp_at_least(UnitTypes::Zerg_Spire, 350));
	int supply = opening_supply_count();
	if (supply >= 9 && training_manager.unit_count(UnitTypes::Zerg_Overlord) < 2) {
		training_manager.larva_train_distribution().set(UnitTypes::Zerg_Overlord, 1.0);
	}
	if (supply >= 12) {
		if (!building_manager.request_bases(2)) {
			mode_ = Mode::Main_MutaHydraLing;
			return;
		}
		if (building_manager.building_count_including_planned(UnitTypes::Zerg_Hatchery) >= 2 &&
			base_state.start_base_count() >= 4) worker_manager.send_initial_scout();
	}
	if (worker_manager.is_scouting() &&
		(information_manager.enemy_building_seen() ||
		 tactics_manager.possible_enemy_start_bases().size() <= 1)) {
		worker_manager.stop_scouting();
	}
	if (supply >= 11 &&
		building_manager.building_count_including_planned(UnitTypes::Zerg_Hatchery) >= 2) {
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Spawning_Pool, 1);
	}
	if (supply >= 12 &&
		building_manager.building_count_including_planned(UnitTypes::Zerg_Spawning_Pool) >= 1) {
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Extractor, 1);
	}
	if (supply >= 12 &&
		building_manager.building_count_including_planned(UnitTypes::Zerg_Extractor) >= 1 &&
		building_manager.building_exists(UnitTypes::Zerg_Spawning_Pool)) {
		if (training_manager.unit_count(UnitTypes::Zerg_Zergling) < 8 && !save_larvae) {
			training_manager.larva_train_distribution().set(UnitTypes::Zerg_Zergling, 1.0);
		} else {
			building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Lair, 1);
		}
	}
	
	if (building_manager.building_exists(UnitTypes::Zerg_Extractor) &&
		training_manager.unit_count(UnitTypes::Zerg_Drone) >= 10) {
		worker_manager.set_force_refinery_workers(true);
	}
	
	if (training_manager.unit_count_completed(UnitTypes::Zerg_Zergling) >= 6 && !opening_attack_started_) {
		attacking_ = true;
		opening_attack_started_ = true;
	}
	if (opening_attack_started_) attack_check_condition();
	
	if (supply >= 16) {
		if (training_manager.unit_count(UnitTypes::Zerg_Overlord) < 3) {
			training_manager.larva_train_distribution().set(UnitTypes::Zerg_Overlord, 1.0);
		} else if (!done_or_in_progress(UpgradeTypes::Metabolic_Boost)) {
			building_manager.request_upgrade(UpgradeTypes::Metabolic_Boost);
		}
	}
	if (building_manager.building_exists(UnitTypes::Zerg_Lair)) {
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Spire, 1);
	}
	bool two_gate = (opponent_model.enemy_opening() == EnemyOpening::P_2Gate ||
					 opponent_model.enemy_opening() == EnemyOpening::P_2GateFast);
	if (supply >= 26) {
		if (!two_gate) {
			if (!building_manager.request_bases(3)) {
				mode_ = Mode::Main_MutaHydraLing;
				return;
			}
		} else {
			building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Extractor, 2);
		}
	}
	if (!two_gate &&
		building_manager.building_count_including_planned(UnitTypes::Zerg_Hatchery) >= 3 &&
		building_manager.building_count(UnitTypes::Zerg_Hatchery) >= 2) {
		building_manager.cancel_buildings_of_type(UnitTypes::Zerg_Hatchery);
	}
	if (!two_gate && building_manager.building_count_including_planned(UnitTypes::Zerg_Hatchery) >= 3) {
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Extractor, 2);
	}
	if (building_manager.building_count_including_planned(UnitTypes::Zerg_Extractor) >= 2 &&
		training_manager.unit_count(UnitTypes::Zerg_Overlord) < 5) {
		training_manager.larva_train_distribution().set(UnitTypes::Zerg_Overlord, 1.0);
	}
	if (training_manager.unit_count(UnitTypes::Zerg_Overlord) >= 5 &&
		training_manager.unit_count(UnitTypes::Zerg_Mutalisk) < 6) {
		training_manager.larva_train_distribution().set(UnitTypes::Zerg_Mutalisk, 1.0);
	}
	if (training_manager.unit_count(UnitTypes::Zerg_Mutalisk) >= 6 &&
		building_manager.building_count(UnitTypes::Zerg_Hatchery) >= 3) {
		if (training_manager.unit_count(UnitTypes::Zerg_Overlord) <= 6) {
			training_manager.larva_train_distribution().clear();
			training_manager.larva_train_distribution().set(UnitTypes::Zerg_Overlord, 1.0);
		}
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Hatchery, 4);
	}
	if (training_manager.unit_count(UnitTypes::Zerg_Overlord) >= 6 &&
		building_manager.building_count_including_planned(UnitTypes::Zerg_Hatchery) >= 4) {
		mode_ = Mode::Main_MutaHydraLing;
	}
	if (!save_larvae && training_manager.larva_train_distribution().is_empty()) {
		training_manager.larva_train_distribution().set(UnitTypes::Zerg_Drone, 1.0);
	}
}

void ZergStrategy::opening_ZvP_3hatchmuta()
{
	if (tactics_manager.enemy_offense_supply() > tactics_manager.defense_supply() ||
		worker_manager.lost_worker_count() >= 2 ||
		building_manager.building_placement_failed()) {
		mode_ = Mode::Main_MutaHydraLing;
		return;
	}
	if (opponent_model.enemy_opening() == EnemyOpening::P_2Gate ||
		opponent_model.enemy_opening() == EnemyOpening::P_2GateFast) {
		if (building_manager.building_count_including_planned(UnitTypes::Zerg_Hatchery) >= 2) {
			building_manager.cancel_buildings_of_type(UnitTypes::Zerg_Hatchery);
		}
		mode_ = Mode::Main_MutaHydraLing;
		return;
	}
	base_state.set_skip_mineral_only(true);
	bool save_larvae = (morphing_building_hp_at_least(UnitTypes::Zerg_Spawning_Pool, 300) ||
						morphing_building_hp_at_least(UnitTypes::Zerg_Spire, 350));
	int supply = opening_supply_count();
	if (supply >= 9 && training_manager.unit_count(UnitTypes::Zerg_Overlord) < 2) {
		training_manager.larva_train_distribution().set(UnitTypes::Zerg_Overlord, 1.0);
	}
	if (supply >= 12) {
		if (!building_manager.request_bases(2)) {
			mode_ = Mode::Main_MutaHydraLing;
			return;
		}
		if (building_manager.building_count_including_planned(UnitTypes::Zerg_Hatchery) >= 2 &&
			base_state.start_base_count() >= 4) worker_manager.send_initial_scout();
	}
	if (worker_manager.is_scouting() &&
		(information_manager.enemy_building_seen() ||
		 tactics_manager.possible_enemy_start_bases().size() <= 1)) {
		worker_manager.stop_scouting();
	}
	if (supply >= 11 &&
		building_manager.building_count_including_planned(UnitTypes::Zerg_Hatchery) >= 2) {
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Spawning_Pool, 1);
	}
	if (supply >= 13 &&
		building_manager.building_count_including_planned(UnitTypes::Zerg_Spawning_Pool) >= 1) {
		if (!building_manager.request_bases(3)) {
			mode_ = Mode::Main_MutaHydraLing;
			return;
		}
	}
	if (supply >= 12 &&
		building_manager.building_count_including_planned(UnitTypes::Zerg_Hatchery) >= 2 &&
		training_manager.unit_count(UnitTypes::Zerg_Zergling) < 6 && !save_larvae) {
		training_manager.larva_train_distribution().set(UnitTypes::Zerg_Zergling, 1.0);
	}
	if (supply >= 16) {
		if (building_manager.building_count_including_warping(UnitTypes::Zerg_Extractor) == 0) {
			building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Extractor, 1);
		} else if (training_manager.unit_count(UnitTypes::Zerg_Overlord) < 3) {
			training_manager.larva_train_distribution().set(UnitTypes::Zerg_Overlord, 1.0);
		} else {
			building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Lair, 1);
			if (building_manager.building_count_including_planned(UnitTypes::Zerg_Lair) >= 1) {
				building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Extractor, 2);
			}
			if (building_manager.building_count_including_planned(UnitTypes::Zerg_Extractor) >= 2) {
				building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Spire, 1);
			}
			if (building_manager.building_count_including_planned(UnitTypes::Zerg_Spire) >= 1) {
				building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Hatchery, 4);
			}
			if (building_manager.building_count_including_planned(UnitTypes::Zerg_Hatchery) >= 4) {
				building_manager.request_upgrade(UpgradeTypes::Pneumatized_Carapace);
			}
			if (done_or_in_progress(UpgradeTypes::Pneumatized_Carapace) &&
				training_manager.unit_count(UnitTypes::Zerg_Overlord) < 6) {
				training_manager.larva_train_distribution().set(UnitTypes::Zerg_Overlord, 1.0);
			}
			if (training_manager.unit_count(UnitTypes::Zerg_Overlord) >= 6 &&
				building_manager.building_exists(UnitTypes::Zerg_Spire)) {
				if (training_manager.unit_count(UnitTypes::Zerg_Mutalisk) < 9) {
					training_manager.larva_train_distribution().set(UnitTypes::Zerg_Mutalisk, 1.0);
				} else {
					mode_ = Mode::Main_MutaHydraLing;
				}
			}
		}
	}
	
	if (building_manager.building_exists(UnitTypes::Zerg_Extractor) &&
		training_manager.unit_count(UnitTypes::Zerg_Drone) >= 10) {
		worker_manager.set_force_refinery_workers(true);
	}
	if (training_manager.unit_count_completed(UnitTypes::Zerg_Zergling) >= 6 && !opening_attack_started_) {
		attacking_ = true;
		opening_attack_started_ = true;
	}
	if (opening_attack_started_) attack_check_condition();
	
	if (!save_larvae && training_manager.larva_train_distribution().is_empty()) {
		training_manager.larva_train_distribution().set(UnitTypes::Zerg_Drone, 1.0);
	}
}

void ZergStrategy::opening_ZvP_9734()
{
	if (tactics_manager.enemy_offense_supply() > tactics_manager.defense_supply() ||
		worker_manager.lost_worker_count() >= 2 ||
		building_manager.building_placement_failed()) {
		mode_ = Mode::Main_HydraLing;
		return;
	}
	if (opponent_model.enemy_opening() != EnemyOpening::Unknown &&
		opponent_model.enemy_opening() != EnemyOpening::P_FastExpand &&
		opponent_model.enemy_opening() != EnemyOpening::P_ForgeFastExpand) {
		if ((opponent_model.enemy_opening() == EnemyOpening::P_2Gate ||
			 opponent_model.enemy_opening() == EnemyOpening::P_2GateFast) &&
			building_manager.building_count_including_planned(UnitTypes::Zerg_Hatchery) >= 2) {
			building_manager.cancel_buildings_of_type(UnitTypes::Zerg_Hatchery);
		}
		mode_ = Mode::Main_MutaHydraLing;
		return;
	}
	base_state.set_skip_mineral_only(true);
	int supply = opening_supply_count();
	if (supply >= 9 && training_manager.unit_count(UnitTypes::Zerg_Overlord) < 2) {
		training_manager.larva_train_distribution().set(UnitTypes::Zerg_Overlord, 1.0);
	}
	if (supply >= 9 && training_manager.unit_count(UnitTypes::Zerg_Overlord) >= 2) {
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Spawning_Pool, 1);
	}
	if (supply >= 11) {
		if (!building_manager.request_bases(2)) {
			mode_ = Mode::Main_HydraLing;
			return;
		}
	}
	if (supply >= 10 &&
		building_manager.building_count_including_planned(UnitTypes::Zerg_Hatchery) >= 2 &&
		training_manager.unit_count(UnitTypes::Zerg_Zergling) < 2 &&
		!opening_attack_started_) {
		training_manager.larva_train_distribution().set(UnitTypes::Zerg_Zergling, 1.0);
	}
	if (supply >= 13) {
		if (!building_manager.request_bases(3)) {
			mode_ = Mode::Main_HydraLing;
			return;
		}
	}
	if (supply >= 12 &&
		building_manager.building_count_including_planned(UnitTypes::Zerg_Hatchery) >= 3) {
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Extractor, 1);
	}
	if (building_manager.building_exists(UnitTypes::Zerg_Extractor)) {
		worker_manager.set_force_refinery_workers(true);
	}
	if (supply >= 17) {
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Hydralisk_Den, 1);
	}
	if (supply >= 16 &&
		building_manager.building_count_including_planned(UnitTypes::Zerg_Hydralisk_Den) >= 1 &&
		training_manager.unit_count(UnitTypes::Zerg_Overlord) < 3) {
		training_manager.larva_train_distribution().set(UnitTypes::Zerg_Overlord, 1.0);
	}
	if (supply >= 18) {
		building_manager.request_upgrade(UpgradeTypes::Muscular_Augments);
	}
	if (supply >= 18 &&
		done_or_in_progress(UpgradeTypes::Muscular_Augments) &&
		training_manager.unit_count(UnitTypes::Zerg_Zergling) < 6 &&
		!opening_attack_started_) {
		training_manager.larva_train_distribution().set(UnitTypes::Zerg_Zergling, 1.0);
	}
	if (supply >= 24 && training_manager.unit_count(UnitTypes::Zerg_Overlord) < 4) {
		training_manager.larva_train_distribution().set(UnitTypes::Zerg_Overlord, 1.0);
	}
	if (supply >= 25 && !opening_attack_started_) {
		training_manager.larva_train_distribution().set(UnitTypes::Zerg_Hydralisk, 1.0);
	}
	if (supply >= 32) {
		building_manager.request_upgrade(UpgradeTypes::Grooved_Spines);
		if (training_manager.unit_count(UnitTypes::Zerg_Overlord) < 5) {
			training_manager.larva_train_distribution().set(UnitTypes::Zerg_Overlord, 1.0);
		}
	}
	if (supply >= 35) {
		if (!opening_attack_started_) {
			attacking_ = true;
			opening_attack_started_ = true;
		}
		if (!building_manager.request_bases(4)) {
			mode_ = Mode::Main_HydraLing;
			return;
		}
	}
	if (opening_attack_started_) attack_check_condition();
	
	if (opening_attack_started_ &&
		building_manager.building_count_including_planned(UnitTypes::Zerg_Hatchery) >= 4) {
		mode_ = Mode::Main_HydraLing;
	}
	if (training_manager.larva_train_distribution().is_empty()) {
		training_manager.larva_train_distribution().set(UnitTypes::Zerg_Drone, 1.0);
	} else if (building_manager.building_exists(UnitTypes::Zerg_Hydralisk_Den) &&
			   building_manager.building_count_including_planned(UnitTypes::Zerg_Hatchery) >= 3 &&
			   training_manager.unit_count(UnitTypes::Zerg_Drone) < 19 &&
			   training_manager.larva_train_distribution().get(UnitTypes::Zerg_Overlord) == 0.0) {
		training_manager.larva_train_distribution().clear();
		training_manager.larva_train_distribution().set(UnitTypes::Zerg_Drone, 1.0);
	}
}

void ZergStrategy::opening_ZvX_4pool()
{
	training_manager.set_automatic_supply(true);
	building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Spawning_Pool, 1);
	training_manager.larva_train_distribution().set(UnitTypes::Zerg_Zergling, 1.0);
	if (training_manager.unit_count_completed(UnitTypes::Zerg_Zergling) >= 6) {
		attacking_ = true;
	}
	if (training_manager.unit_count_built(UnitTypes::Zerg_Zergling) >= 50) {
		mode_ = (opponent_model.enemy_race() == Races::Zerg) ? Mode::Main_ZvZ : Mode::Main_MutaHydraLing;
	}
}

void ZergStrategy::opening_ZvX_5pool()
{
	training_manager.set_automatic_supply(true);
	if (training_manager.unit_count(UnitTypes::Zerg_Drone) >= 5) {
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Spawning_Pool, 1);
	}
	
	int wanted_drone_count;
	if (building_manager.building_count_including_planned(UnitTypes::Zerg_Spawning_Pool) == 0) {
		wanted_drone_count = 5;
	} else if (building_manager.building_count_including_planned(UnitTypes::Zerg_Hatchery) <= 1) {
		wanted_drone_count = 6;
	} else {
		wanted_drone_count = (building_manager.building_count(UnitTypes::Zerg_Hatchery) * 7) / 2 + 1;
	}
	if (training_manager.unit_count(UnitTypes::Zerg_Drone) < wanted_drone_count) {
		training_manager.larva_train_distribution().set(UnitTypes::Zerg_Drone, 1.0);
	} else if (building_manager.building_exists(UnitTypes::Zerg_Spawning_Pool)) {
		training_manager.larva_train_distribution().set(UnitTypes::Zerg_Zergling, 1.0);
	}
	
	if (spending_manager.spendable().minerals >= UnitTypes::Zerg_Hatchery.mineralPrice() && !is_opponent_army_too_large()) {
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Hatchery, 1 + building_manager.building_count(UnitTypes::Zerg_Hatchery));
	}
	
	if (training_manager.unit_count_completed(UnitTypes::Zerg_Zergling) >= 6) {
		attacking_ = true;
	}
	if (!counter_corsairs_with_spore() && training_manager.unit_count_built(UnitTypes::Zerg_Zergling) >= 50) {
		mode_ = (opponent_model.enemy_race() == Races::Zerg) ? Mode::Main_ZvZ : Mode::Main_MutaHydraLing;
	}
}

void ZergStrategy::opening_ZvX_2hatchling()
{
	if (opponent_model.enemy_opening() == EnemyOpening::Z_4_5Pool ||
		opponent_model.enemy_opening() == EnemyOpening::Z_9PoolSpeed) {
		mode_ = Mode::DefendFastPool;
		return;
	}
	int supply = opening_supply_count();
	if (supply >= 9) {
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Spawning_Pool, 1);
	}
	if (supply >= 9 &&
		building_manager.building_count_including_planned(UnitTypes::Zerg_Spawning_Pool) >= 1 &&
		training_manager.unit_count(UnitTypes::Zerg_Overlord) < 2) {
		training_manager.larva_train_distribution().set(UnitTypes::Zerg_Overlord, 1.0);
	}
	if (supply >= 9 &&
		building_manager.building_count_including_planned(UnitTypes::Zerg_Spawning_Pool) >= 1) {
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Hatchery, 2);
	}
	if (building_manager.building_exists(UnitTypes::Zerg_Spawning_Pool) &&
		building_manager.building_count_including_planned(UnitTypes::Zerg_Hatchery) >= 2 &&
		Broodwar->self()->gatheredGas() < UpgradeTypes::Metabolic_Boost.gasPrice()) {
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Extractor, 1);
	}
	if (Broodwar->self()->gatheredGas() >= UpgradeTypes::Metabolic_Boost.gasPrice() - 16) {
		int shortage = UpgradeTypes::Metabolic_Boost.gasPrice() - Broodwar->self()->gatheredGas();
		worker_manager.set_limit_refinery_workers(shortage / 8);
	}
	if (building_manager.building_exists(UnitTypes::Zerg_Spawning_Pool) &&
		building_manager.building_count_including_planned(UnitTypes::Zerg_Hatchery) >= 2 &&
		building_manager.building_exists(UnitTypes::Zerg_Extractor)) {
		building_manager.request_upgrade(UpgradeTypes::Metabolic_Boost);
		training_manager.set_automatic_supply(true);
	}
	
	int wanted_drone_count = 9;
	if (building_manager.building_count_including_planned(UnitTypes::Zerg_Hatchery) >= 2) wanted_drone_count--;
	if (building_manager.building_count_including_planned(UnitTypes::Zerg_Extractor) >= 1 ||
		Broodwar->self()->gatheredGas() >= UpgradeTypes::Metabolic_Boost.gasPrice()) {
		wanted_drone_count--;
	}
	if (training_manager.unit_count(UnitTypes::Zerg_Drone) < wanted_drone_count) {
		training_manager.larva_train_distribution().set(UnitTypes::Zerg_Drone, 1.0);
	} else if (building_manager.building_exists(UnitTypes::Zerg_Spawning_Pool)) {
		training_manager.larva_train_distribution().set(UnitTypes::Zerg_Zergling, 1.0);
	}
	
	if (!counter_corsairs_with_spore() && training_manager.unit_count_completed(UnitTypes::Zerg_Zergling) >= 2) {
		attacking_ = true;
	}
	if (training_manager.unit_count_built(UnitTypes::Zerg_Zergling) >= 50) {
		mode_ = (opponent_model.enemy_race() == Races::Zerg) ? Mode::Main_ZvZ : Mode::Main_MutaHydraLing;
	}
}

void ZergStrategy::opening_ZvX_3hatchling()
{
	if (opponent_model.enemy_opening() == EnemyOpening::Z_4_5Pool ||
		opponent_model.enemy_opening() == EnemyOpening::Z_9PoolSpeed) {
		mode_ = Mode::DefendFastPool;
		return;
	}
	if (tactics_manager.enemy_offense_supply() > tactics_manager.defense_supply() ||
		worker_manager.lost_worker_count() >= 2 ||
		building_manager.building_placement_failed()) {
		mode_ = Mode::Main_MutaHydraLing;
		return;
	}
	int supply = opening_supply_count();
	if (supply >= 8 &&
		training_manager.unit_count(UnitTypes::Zerg_Overlord) < 2) {
		training_manager.larva_train_distribution().clear();
		training_manager.larva_train_distribution().set(UnitTypes::Zerg_Overlord, 1.0);
	}
	if (supply >= 12) {
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Hatchery, 2);
		if (building_manager.building_count_including_planned(UnitTypes::Zerg_Hatchery) >= 2) {
		}
	}
	if (supply >= 11 &&
		building_manager.building_count_including_planned(UnitTypes::Zerg_Hatchery) >= 2) {
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Spawning_Pool, 1);
	}
	if (supply >= 13 &&
		building_manager.building_count_including_planned(UnitTypes::Zerg_Hatchery) >= 2) {
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Hatchery, 3);
	}
	if (supply >= 12 &&
		building_manager.building_count_including_planned(UnitTypes::Zerg_Hatchery) >= 3 &&
		Broodwar->self()->gatheredGas() < UpgradeTypes::Metabolic_Boost.gasPrice()) {
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Extractor, 1);
	}
	if (building_manager.building_count_including_planned(UnitTypes::Zerg_Hatchery) >= 3 &&
		building_manager.building_count_including_planned(UnitTypes::Zerg_Extractor) >= 1 &&
		training_manager.unit_count(UnitTypes::Zerg_Zergling) >= 12) {
		building_manager.request_upgrade(UpgradeTypes::Metabolic_Boost);
		training_manager.set_automatic_supply(true);
	}
	if (building_manager.building_exists(UnitTypes::Zerg_Extractor) &&
		Broodwar->self()->gatheredGas() < UpgradeTypes::Metabolic_Boost.gasPrice()) {
		worker_manager.set_force_refinery_workers(true);
	}
	if (Broodwar->self()->gatheredGas() >= UpgradeTypes::Metabolic_Boost.gasPrice() - 16) {
		int shortage = UpgradeTypes::Metabolic_Boost.gasPrice() - Broodwar->self()->gatheredGas();
		worker_manager.set_limit_refinery_workers(shortage / 8);
	}
	
	int wanted_drone_count = 8;
	if (training_manager.unit_count(UnitTypes::Zerg_Overlord) >= 2) wanted_drone_count += 4;
	if (building_manager.building_count_including_planned(UnitTypes::Zerg_Hatchery) >= 2) wanted_drone_count--;
	if (building_manager.building_count_including_planned(UnitTypes::Zerg_Spawning_Pool) >= 1) wanted_drone_count--;
	if (building_manager.building_count_including_planned(UnitTypes::Zerg_Hatchery) >= 2 &&
		building_manager.building_count_including_planned(UnitTypes::Zerg_Spawning_Pool) >= 1) wanted_drone_count += 3;
	if (building_manager.building_count_including_planned(UnitTypes::Zerg_Hatchery) >= 3) wanted_drone_count--;
	if (building_manager.building_count_including_planned(UnitTypes::Zerg_Extractor) >= 1 ||
		Broodwar->self()->gatheredGas() >= UpgradeTypes::Metabolic_Boost.gasPrice()) {
		wanted_drone_count--;
	}
	if (training_manager.unit_count(UnitTypes::Zerg_Drone) < wanted_drone_count) {
		training_manager.larva_train_distribution().set(UnitTypes::Zerg_Drone, 1.0);
	} else if (building_manager.building_exists(UnitTypes::Zerg_Spawning_Pool)) {
		training_manager.larva_train_distribution().set(UnitTypes::Zerg_Zergling, 1.0);
	}
	
	if (training_manager.unit_count_completed(UnitTypes::Zerg_Zergling) >= 6) {
		attacking_ = true;
	}
	if (!counter_corsairs_with_spore() && training_manager.unit_count_built(UnitTypes::Zerg_Zergling) >= 50) {
		mode_ = (opponent_model.enemy_race() == Races::Zerg) ? Mode::Main_ZvZ : Mode::Main_MutaHydraLing;
	}
}

void ZergStrategy::opening_ZvX_sparkle_3hatchmuta()
{
	base_state.set_skip_mineral_only(true);
	bool save_larvae = (morphing_building_hp_at_least(UnitTypes::Zerg_Spawning_Pool, 300) ||
						morphing_building_hp_at_least(UnitTypes::Zerg_Spire, 350));
	int supply = opening_supply_count();
	if (supply >= 9 && training_manager.unit_count(UnitTypes::Zerg_Overlord) < 2) {
		training_manager.larva_train_distribution().set(UnitTypes::Zerg_Overlord, 1.0);
	}
	if (supply >= 12) {
		building_manager.request_bases(2);
	}
	if (supply >= 11 &&
		building_manager.building_count_including_planned(UnitTypes::Zerg_Hatchery) >= 2) {
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Spawning_Pool, 1);
	}
	if (supply >= 13 &&
		building_manager.building_count_including_planned(UnitTypes::Zerg_Spawning_Pool) >= 1) {
		building_manager.request_bases(3);
	}
	if (supply >= 12 &&
		building_manager.building_count_including_planned(UnitTypes::Zerg_Hatchery) >= 2 &&
		training_manager.unit_count(UnitTypes::Zerg_Zergling) < 6 && !save_larvae) {
		training_manager.larva_train_distribution().set(UnitTypes::Zerg_Zergling, 1.0);
	}
	if (supply >= 16) {
		if (building_manager.building_count_including_warping(UnitTypes::Zerg_Extractor) == 0) {
			building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Extractor, 1);
		} else if (training_manager.unit_count(UnitTypes::Zerg_Overlord) < 3) {
			training_manager.larva_train_distribution().set(UnitTypes::Zerg_Overlord, 1.0);
		} else {
			building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Lair, 1);
			if (building_manager.building_count_including_planned(UnitTypes::Zerg_Lair) >= 1) {
				building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Extractor, 2);
			}
			if (building_manager.building_count_including_planned(UnitTypes::Zerg_Extractor) >= 2) {
				building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Spire, 1);
			}
			if (building_manager.building_count_including_planned(UnitTypes::Zerg_Spire) >= 1) {
				building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Hatchery, 4);
			}
			if (building_manager.building_count_including_planned(UnitTypes::Zerg_Hatchery) >= 4) {
				building_manager.request_upgrade(UpgradeTypes::Pneumatized_Carapace);
			}
			if (done_or_in_progress(UpgradeTypes::Pneumatized_Carapace) &&
				training_manager.unit_count(UnitTypes::Zerg_Overlord) < 6) {
				training_manager.larva_train_distribution().set(UnitTypes::Zerg_Overlord, 1.0);
			}
			if (training_manager.unit_count(UnitTypes::Zerg_Overlord) >= 6 &&
				building_manager.building_exists(UnitTypes::Zerg_Spire) &&
				!opening_attack_started_) {
				opening_attack_started_ = true;
			}
		}
	}
	
	if (building_manager.building_exists(UnitTypes::Zerg_Extractor) &&
		training_manager.unit_count(UnitTypes::Zerg_Drone) >= 10 &&
		!opening_attack_started_) {
		worker_manager.set_force_refinery_workers(true);
	}
	
	if (!save_larvae && training_manager.larva_train_distribution().is_empty()) {
		training_manager.larva_train_distribution().set(UnitTypes::Zerg_Drone, 1.0);
	}
	
	if (building_manager.building_count_including_planned(UnitTypes::Zerg_Hatchery) >= 3) {
		bool found = false;
		for (auto& entry : information_manager.all_units()) {
			const InformationUnit& information_unit = entry.second;
			if (information_unit.type == UnitTypes::Special_Psi_Disrupter &&
				information_unit.base_distance == 0) {
				information_manager.mark_neutral_for_destruction(entry.first);
				found = true;
			}
		}
		if (!found) {
			building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Extractor, 3);
		}
	}
	
	if (opening_attack_started_) {
		UnitType type = UnitTypes::None;
		bool mutalisk_available = building_manager.building_exists(UnitTypes::Zerg_Spire);
		bool zergling_available = building_manager.building_exists(UnitTypes::Zerg_Spawning_Pool);
		if (mutalisk_available) {
			type = UnitTypes::Zerg_Mutalisk;
		} else if (zergling_available) {
			type = UnitTypes::Zerg_Zergling;
		}
		main_boilerplate(type);
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Extractor, 2);
		
		if (!building_manager.building_exists(UnitTypes::Zerg_Evolution_Chamber)) {
			building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Evolution_Chamber, 1);
		} else if (!done_or_in_progress(UpgradeTypes::Pneumatized_Carapace)) {
			building_manager.request_upgrade(UpgradeTypes::Pneumatized_Carapace);
		} else if (Broodwar->self()->supplyUsed() >= 2 * 120) {
			if (!done_or_in_progress(UpgradeTypes::Ventral_Sacs)) {
				building_manager.request_upgrade(UpgradeTypes::Ventral_Sacs);
			} else if (!done_or_in_progress(UpgradeTypes::Metabolic_Boost)) {
				building_manager.request_upgrade(UpgradeTypes::Metabolic_Boost);
			} else if (!building_manager.building_exists(UnitTypes::Zerg_Queens_Nest)) {
				building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Queens_Nest, 1);
			} else if (!building_manager.building_exists(UnitTypes::Zerg_Hive)) {
				building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Hive, 1);
			} else if (!done_or_in_progress(UpgradeTypes::Adrenal_Glands)) {
				building_manager.request_upgrade(UpgradeTypes::Adrenal_Glands);
			}
		}
		
		training_manager.set_automatic_supply(true);
		main_upgrades(true, true);
		if (maxed_out_ &&
			!doom_drop_started_ &&
			Broodwar->self()->getUpgradeLevel(UpgradeTypes::Pneumatized_Carapace) >= 1 &&
			Broodwar->self()->getUpgradeLevel(UpgradeTypes::Ventral_Sacs) >= 1 &&
			Broodwar->self()->getUpgradeLevel(UpgradeTypes::Adrenal_Glands) >= 1) {
			micro_manager.perform_doom_drop();
			doom_drop_started_ = true;
		}
		if (!maxed_out_) doom_drop_started_ = false;
	}
}

bool ZergStrategy::morphing_building_hp_at_least(UnitType building_type,int hp)
{
	return std::any_of(Broodwar->self()->getUnits().begin(),
					   Broodwar->self()->getUnits().end(),
					   [=](Unit unit) {
						   return (!unit->isCompleted() && unit->getType() == building_type && unit->getHitPoints() >= hp);
					   });
}

bool ZergStrategy::counter_corsairs_with_spore()
{
	bool result = false;
	if (information_manager.enemy_exists(UnitTypes::Protoss_Corsair) ||
		information_manager.enemy_exists(UnitTypes::Protoss_Stargate)) {
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Evolution_Chamber, 1, true);
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Spore_Colony, 1, true);
		result = (building_manager.building_count_including_planned(UnitTypes::Zerg_Evolution_Chamber) == 0 ||
				  building_manager.building_count_including_planned(UnitTypes::Zerg_Spore_Colony) == 0);
	}
	return result;
}

void ZergStrategy::mode_opening()
{
	training_manager.set_automatic_supply(false);
	training_manager.set_worker_cut(true);
	training_manager.set_prioritize_training(false);
	training_manager.larva_train_distribution().clear();
	attack_minimum_ = 8;
	if (opening_ == kZvZ_5Pool) opening_ZvX_5pool();
	else if (opening_ == kZvZ_2HatchLing) opening_ZvX_2hatchling();
	else if (opening_ == kZvZ_3HatchLing) opening_ZvX_3hatchling();
	else if (opening_ == kZvZ_9Pool) opening_ZvZ_9pool();
	else if (opening_ == kZvZ_9Gas9Pool) opening_ZvZ_9gas9pool();
	else if (opening_ == kZvZ_9Gas10Pool) opening_ZvZ_9gas10pool();
	else if (opening_ == kZvT_4Pool) opening_ZvX_4pool();
	else if (opening_ == kZvT_2HatchLing) opening_ZvX_2hatchling();
	else if (opening_ == kZvT_3HatchLing) opening_ZvX_3hatchling();
	else if (opening_ == kZvT_2HatchMuta_12Hatch) opening_ZvT_2hatchmuta(false);
	else if (opening_ == kZvT_2HatchMuta_12Pool) opening_ZvT_2hatchmuta(true);
	else if (opening_ == kZvT_3HatchMuta) opening_ZvT_3hatchmuta();
	else if (opening_ == kZvP_5Pool) opening_ZvX_5pool();
	else if (opening_ == kZvP_2HatchMuta) opening_ZvP_2hatchmuta();
	else if (opening_ == kZvP_3HatchMuta) opening_ZvP_3hatchmuta();
	else if (opening_ == kZvP_9734) opening_ZvP_9734();
	else if (opening_ == kZvP_2HatchLing) opening_ZvX_2hatchling();
	else if (opening_ == kZvP_3HatchLing) opening_ZvX_3hatchling();
	else if (opening_ == kZvU_4Pool) opening_ZvX_4pool();
	else if (opening_ == kZvU_5Pool) opening_ZvX_5pool();
	else if (opening_ == kZvU_2HatchLing) opening_ZvX_2hatchling();
	else if (opening_ == kZvU_3HatchLing) opening_ZvX_3hatchling();
	else if (opening_ == kZvZ_Sparkle_3HatchMuta) opening_ZvX_sparkle_3hatchmuta();
	else if (opening_ == kZvT_Sparkle_3HatchMuta) opening_ZvX_sparkle_3hatchmuta();
	else if (opening_ == kZvP_Sparkle_3HatchMuta) opening_ZvX_sparkle_3hatchmuta();
	else if (opening_ == kZvU_Sparkle_3HatchMuta) opening_ZvX_sparkle_3hatchmuta();
}

void ZergStrategy::mode_defend_fast_pool()
{
	if (!fast_pool_handled_) {
		if (building_manager.building_count(UnitTypes::Zerg_Hatchery) >= 1) building_manager.cancel_buildings_of_type(UnitTypes::Zerg_Hatchery);
		building_manager.cancel_buildings_of_type(UnitTypes::Zerg_Extractor);
		building_manager.cancel_buildings_of_type(UnitTypes::Zerg_Lair);
		building_manager.cancel_buildings_of_type(UnitTypes::Zerg_Spire);
		fast_pool_handled_ = true;
	}
	training_manager.larva_train_distribution().clear();
	if (training_manager.unit_count(UnitTypes::Zerg_Drone) < 5) {
		training_manager.larva_train_distribution().set(UnitTypes::Zerg_Drone, 1.0);
	} else if (!building_manager.building_exists(UnitTypes::Zerg_Spawning_Pool)) {
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Spawning_Pool, 1);
	} else {
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Sunken_Colony, fast_pool_sunken_count_, true);
		if (training_manager.unit_count(UnitTypes::Zerg_Zergling) < 8) {
			training_manager.larva_train_distribution().set(UnitTypes::Zerg_Zergling, 1.0);
		}
		if (training_manager.unit_count(UnitTypes::Zerg_Zergling) >= 8 &&
			building_manager.building_count_including_planned(UnitTypes::Zerg_Sunken_Colony) >= fast_pool_sunken_count_) {
			mode_ = Mode::Main_ZvZ;
		}
	}
	training_manager.set_automatic_supply(true);
	worker_manager.set_limit_refinery_workers(0);
}

void ZergStrategy::mode_main_muta_hydra_ling()
{
	UnitType type = UnitTypes::None;
	bool mutalisk_available = building_manager.building_exists(UnitTypes::Zerg_Spire);
	bool hydralisk_available = building_manager.building_exists(UnitTypes::Zerg_Hydralisk_Den);
	bool zergling_available = building_manager.building_exists(UnitTypes::Zerg_Spawning_Pool);
	if (mutalisk_available && training_manager.unit_count(UnitTypes::Zerg_Mutalisk) < 12) {
		type = UnitTypes::Zerg_Mutalisk;
	} else if (hydralisk_available) {
		type = UnitTypes::Zerg_Hydralisk;
	} else if (zergling_available) {
		type = UnitTypes::Zerg_Zergling;
	}
	
	main_boilerplate(type);
	building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Extractor, base_state.controlled_geyser_count());
	
	if ((!building_manager.building_exists(UnitTypes::Zerg_Spire) &&
		 !building_manager.building_exists(UnitTypes::Zerg_Hydralisk_Den) &&
		 training_manager.unit_count(UnitTypes::Zerg_Mutalisk) == 0 &&
		 training_manager.unit_count(UnitTypes::Zerg_Hydralisk) == 0) ||
		started_counter_corsairs_with_spore_) {
		started_counter_corsairs_with_spore_ = counter_corsairs_with_spore();
	}
	
	if (!building_manager.building_exists(UnitTypes::Zerg_Spawning_Pool)) {
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Spawning_Pool, 1);
	} else if (!building_manager.building_exists(UnitTypes::Zerg_Spire)) {
		if (!building_manager.building_exists(UnitTypes::Zerg_Lair)) {
			building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Lair, 1);
		} else {
			building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Spire, 1);
		}
	} else if (training_manager.unit_count(UnitTypes::Zerg_Mutalisk) >= 9 &&
			   !building_manager.building_exists(UnitTypes::Zerg_Hydralisk_Den)) {
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Hydralisk_Den, 1);
	}
	
	if (building_manager.building_exists(UnitTypes::Zerg_Hydralisk_Den) &&
		done_or_in_progress(UpgradeTypes::Muscular_Augments) &&
		done_or_in_progress(UpgradeTypes::Grooved_Spines)) {
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Evolution_Chamber, 1);
		
		if (building_manager.building_exists(UnitTypes::Zerg_Spire) &&
			building_manager.building_exists(UnitTypes::Zerg_Evolution_Chamber) &&
			base_state.mining_base_count() >= 3 &&
			tech_to_ultra_ling()) {
			mode_ = Mode::Main_UltraLing;
		}
	}
	
	main_upgrades(false, true);
	attack_check_condition();
}

void ZergStrategy::mode_main_hydra_ling()
{
	UnitType type = UnitTypes::None;
	bool hydralisk_available = building_manager.building_exists(UnitTypes::Zerg_Hydralisk_Den);
	bool zergling_available = building_manager.building_exists(UnitTypes::Zerg_Spawning_Pool);
	if (hydralisk_available) {
		type = UnitTypes::Zerg_Hydralisk;
	} else if (zergling_available) {
		type = UnitTypes::Zerg_Zergling;
	}
	
	main_boilerplate(type);
	building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Extractor, base_state.controlled_geyser_count());
	
	if (!building_manager.building_exists(UnitTypes::Zerg_Spawning_Pool)) {
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Spawning_Pool, 1);
	} else if (!building_manager.building_exists(UnitTypes::Zerg_Hydralisk_Den)) {
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Hydralisk_Den, 1);
	} else if (!building_manager.building_exists(UnitTypes::Zerg_Lair)) {
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Lair, 1);
	}
	
	if (building_manager.building_exists(UnitTypes::Zerg_Hydralisk_Den) &&
		done_or_in_progress(UpgradeTypes::Muscular_Augments) &&
		done_or_in_progress(UpgradeTypes::Grooved_Spines)) {
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Evolution_Chamber, 1);
		
		if (base_state.mining_base_count() >= 3 &&
			building_manager.building_exists(UnitTypes::Zerg_Evolution_Chamber) &&
			tech_to_ultra_ling()) {
			mode_ = Mode::Main_UltraLing;
		}
	}
	
	main_upgrades(false, false);
	attack_check_condition();
}

void ZergStrategy::mode_main_ultra_ling()
{
	UnitType type = UnitTypes::None;
	bool mutalisk_available = building_manager.building_exists(UnitTypes::Zerg_Spire);
	bool zergling_available = building_manager.building_exists(UnitTypes::Zerg_Spawning_Pool);
	bool ultralisk_available = building_manager.building_exists(UnitTypes::Zerg_Ultralisk_Cavern);
	bool need_more_anti_air = (training_manager.unit_count(UnitTypes::Zerg_Mutalisk) * UnitTypes::Zerg_Mutalisk.supplyRequired() < enemy_air_supply());
	if ((need_more_anti_air || !ultralisk_available) && mutalisk_available) {
		type = UnitTypes::Zerg_Mutalisk;
	} else if (ultralisk_available) {
		type = UnitTypes::Zerg_Ultralisk;
	} else if (zergling_available) {
		type = UnitTypes::Zerg_Zergling;
	}
	
	main_boilerplate(type);
	building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Extractor, base_state.controlled_geyser_count());
	
	if (tech_to_ultra_ling()) {
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Evolution_Chamber, 1);
		if (building_manager.building_exists(UnitTypes::Zerg_Evolution_Chamber) &&
			building_manager.building_exists(UnitTypes::Zerg_Ultralisk_Cavern) &&
			training_manager.unit_count(UnitTypes::Zerg_Ultralisk) >= 2) {
			if (!done_or_in_progress(UpgradeTypes::Chitinous_Plating)) {
				building_manager.request_upgrade(UpgradeTypes::Chitinous_Plating);
			} else if (!done_or_in_progress(UpgradeTypes::Anabolic_Synthesis)) {
				building_manager.request_upgrade(UpgradeTypes::Anabolic_Synthesis);
			} else {
				building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Evolution_Chamber, 2);
			}
		}
	}
	
	main_upgrades(true, false);
	attack_check_condition();
}

void ZergStrategy::mode_main_ZvZ(bool lategame)
{
	UnitType type = UnitTypes::None;
	bool mutalisk_available = building_manager.building_exists(UnitTypes::Zerg_Spire);
	bool zergling_available = building_manager.building_exists(UnitTypes::Zerg_Spawning_Pool);
	if (mutalisk_available) {
		type = UnitTypes::Zerg_Mutalisk;
	} else if (zergling_available) {
		type = UnitTypes::Zerg_Zergling;
	}
	
	if (!lategame) {
		training_manager.larva_train_distribution().clear();
		
		TrainDistribution train_distribution(UnitTypes::Zerg_Larva);
		set_train_distribution(train_distribution, type);
		CostPerMinute cost_per_minute = train_distribution.cost_per_minute(building_manager.building_count(UnitTypes::Zerg_Hatchery));
		
		bool prioritize_units = is_defending_rush() || is_contained() || is_opponent_army_too_large(cost_per_minute.supply);
		training_manager.set_prioritize_training(prioritize_units);
		
		int max_workers = worker_manager.determine_max_workers();
		if (training_manager.unit_count(UnitTypes::Zerg_Drone) < 5) {
			training_manager.larva_train_distribution().set(UnitTypes::Zerg_Drone, 1.0);
		} else if (prioritize_units) {
			set_train_distribution(type);
		} else if (training_manager.unit_count(UnitTypes::Zerg_Drone) < max_workers) {
			training_manager.larva_train_distribution().set(UnitTypes::Zerg_Drone, 1.0);
		} else {
			set_train_distribution(type);
		}
		
		if (additional_hatchery()) {
			if (base_state.mining_base_count() >= 2 || !building_manager.request_next_base()) {
				int requested_hatchery_count = building_manager.building_count(UnitTypes::Zerg_Hatchery) + 1;
				requested_hatchery_count = std::min(requested_hatchery_count, WorkerManager::kWorkerCap / 5);
				building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Hatchery, requested_hatchery_count);
			}
		}
		if (building_manager.building_count_including_planned(UnitTypes::Zerg_Hatchery) == 1 &&
			additional_hatchery()) {
			building_manager.request_next_base();
		}
		if ((!prioritize_units && worker_manager.has_idle_workers()) || base_state.mining_base_count() == 0) {
			building_manager.request_next_base();
			mode_ = Mode::Main_ZvZLateGame;
		}
		if (!prioritize_units && worker_manager.average_workers_per_mineral() >= 1.5) {
			building_manager.request_next_base();
			if (base_state.mining_base_count() >= 2) mode_ = Mode::Main_ZvZLateGame;
		}
	} else {
		main_boilerplate(type);
	}
	building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Extractor, base_state.controlled_geyser_count());
	
	if ((opponent_model.cloaked_present() || expect_lurkers()) &&
		!done_or_in_progress(UpgradeTypes::Pneumatized_Carapace)) {
		building_manager.request_upgrade(UpgradeTypes::Pneumatized_Carapace);
	}
	
	if (!building_manager.building_exists(UnitTypes::Zerg_Spawning_Pool)) {
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Spawning_Pool, 1);
	} else if (!done_or_in_progress(UpgradeTypes::Metabolic_Boost)) {
		building_manager.request_upgrade(UpgradeTypes::Metabolic_Boost);
	} else if (!building_manager.building_exists(UnitTypes::Zerg_Lair)) {
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Lair, 1);
	} else if (!building_manager.building_exists(UnitTypes::Zerg_Spire)) {
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Spire, 1);
	} else if (!building_manager.building_exists(UnitTypes::Zerg_Evolution_Chamber)) {
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Evolution_Chamber, 1);
	} else if (base_state.mining_base_count() >= 3 && tech_to_ultra_ling()) {
		mode_ = Mode::Main_UltraLing;
	}
	
	main_upgrades(true, true);
	attack_check_condition();
}

void ZergStrategy::main_boilerplate(UnitType type)
{
	training_manager.larva_train_distribution().clear();
	
	TrainDistribution train_distribution(UnitTypes::Zerg_Larva);
	set_train_distribution(train_distribution, type);
	CostPerMinute cost_per_minute = train_distribution.cost_per_minute(building_manager.building_count(UnitTypes::Zerg_Hatchery));
	double drones_per_hatchery = calculate_drones_per_hatchery(type);
	
	bool prioritize_units = is_defending_rush() || is_contained();
	training_manager.set_prioritize_training(prioritize_units);
	
	int max_workers = worker_manager.determine_max_workers();
	int wanted_drone_count = max_workers;
	if (!is_opponent_army_too_large(cost_per_minute.supply)) {
		int hatchery_workers = int(drones_per_hatchery * building_manager.building_count_including_planned(UnitTypes::Zerg_Hatchery) + 0.5);
		wanted_drone_count = std::min(hatchery_workers, max_workers);
	}
	if (training_manager.unit_count(UnitTypes::Zerg_Drone) < std::max(5, int(std::ceil(drones_per_hatchery)))) {
		training_manager.larva_train_distribution().set(UnitTypes::Zerg_Drone, 1.0);
	} else if (prioritize_units) {
		set_train_distribution(type);
	} else if (training_manager.unit_count(UnitTypes::Zerg_Drone) < wanted_drone_count) {
		training_manager.larva_train_distribution().set(UnitTypes::Zerg_Drone, 1.0);
	} else {
		set_train_distribution(type);
	}
	
	if (additional_hatchery()) {
		if (prioritize_units || base_state.mining_base_count() >= 5 || !building_manager.request_next_base()) {
			int requested_hatchery_count = building_manager.building_count(UnitTypes::Zerg_Hatchery) + 1;
			int hatchery_limit = int(WorkerManager::kWorkerCap / drones_per_hatchery + 0.5);
			requested_hatchery_count = std::min(requested_hatchery_count, hatchery_limit);
			building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Hatchery, requested_hatchery_count);
		}
	}

	if (!prioritize_units && (worker_manager.has_idle_workers() || worker_manager.average_workers_per_mineral() >= 1.5)) {
		building_manager.request_next_base();
	}
	if (base_state.mining_base_count() == 0) {
		building_manager.request_next_base();
	}
}

void ZergStrategy::main_upgrades(bool melee,bool air)
{
	if (!melee && building_manager.building_exists(UnitTypes::Zerg_Hydralisk_Den)) {
		if (Broodwar->self()->getUpgradeLevel(UpgradeTypes::Muscular_Augments) < 1) {
			building_manager.request_upgrade(UpgradeTypes::Muscular_Augments);
		} else if (Broodwar->self()->getUpgradeLevel(UpgradeTypes::Grooved_Spines) < 1) {
			building_manager.request_upgrade(UpgradeTypes::Grooved_Spines);
		}
	}
	
	if (building_manager.building_exists(UnitTypes::Zerg_Evolution_Chamber)) {
		MineralGas income = spending_manager.income_per_minute();
		int max_simultaneous_upgrades = (income.minerals >= 2357 && income.gas >= 773) ? 2 : 1;
		int max_level;
		if (building_manager.building_exists(UnitTypes::Zerg_Hive)) {
			max_level = 3;
		} else if (building_manager.building_exists(UnitTypes::Zerg_Lair)) {
			max_level = 2;
		} else {
			max_level = 1;
		}
		std::vector<UpgradeType> upgrade_types;
		if (melee) upgrade_types.push_back(UpgradeTypes::Zerg_Melee_Attacks); else upgrade_types.push_back(UpgradeTypes::Zerg_Missile_Attacks);
		upgrade_types.push_back(UpgradeTypes::Zerg_Flyer_Carapace);
		if (air) upgrade_types.push_back(UpgradeTypes::Zerg_Carapace);
		if (air) upgrade_types.push_back(UpgradeTypes::Zerg_Flyer_Attacks);
		for (UpgradeType upgrade_type : upgrade_types) {
			if (max_simultaneous_upgrades == 0) break;
			if (!building_manager.building_exists(upgrade_type.whatUpgrades())) continue;
			if (Broodwar->self()->isUpgrading(upgrade_type)) {
				max_simultaneous_upgrades--;
				continue;
			}
			if (Broodwar->self()->getUpgradeLevel(upgrade_type) >= upgrade_type.maxRepeats()) continue;
			if (Broodwar->self()->getUpgradeLevel(upgrade_type) >= max_level) continue;
			building_manager.request_upgrade(upgrade_type);
			max_simultaneous_upgrades--;
		}
	}
	
	if (opponent_model.cloaked_or_mine_present() &&
		!done_or_in_progress(UpgradeTypes::Pneumatized_Carapace)) {
		building_manager.request_upgrade(UpgradeTypes::Pneumatized_Carapace);
	}
}

bool ZergStrategy::tech_to_ultra_ling()
{
	if (!building_manager.building_exists(UnitTypes::Zerg_Spawning_Pool)) {
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Spawning_Pool, 1);
	} else if (!done_or_in_progress(UpgradeTypes::Metabolic_Boost)) {
		building_manager.request_upgrade(UpgradeTypes::Metabolic_Boost);
	} else if (!building_manager.building_exists(UnitTypes::Zerg_Lair)) {
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Lair, 1);
	} else if (!building_manager.building_exists(UnitTypes::Zerg_Spire)) {
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Spire, 1);
	} else if (!building_manager.building_exists(UnitTypes::Zerg_Queens_Nest)) {
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Queens_Nest, 1);
	} else if (!building_manager.building_exists(UnitTypes::Zerg_Hive)) {
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Hive, 1);
	} else if (!done_or_in_progress(UpgradeTypes::Adrenal_Glands)) {
		building_manager.request_upgrade(UpgradeTypes::Adrenal_Glands);
	} else if (!building_manager.building_exists(UnitTypes::Zerg_Ultralisk_Cavern)) {
		building_manager.set_requested_building_count_at_least(UnitTypes::Zerg_Ultralisk_Cavern, 1);
	}
	
	return (building_manager.building_exists(UnitTypes::Zerg_Spawning_Pool) &&
			Broodwar->self()->getUpgradeLevel(UpgradeTypes::Metabolic_Boost) > 0 &&
			building_manager.building_exists(UnitTypes::Zerg_Lair) &&
			building_manager.building_exists(UnitTypes::Zerg_Spire) &&
			building_manager.building_exists(UnitTypes::Zerg_Queens_Nest) &&
			building_manager.building_exists(UnitTypes::Zerg_Hive) &&
			Broodwar->self()->getUpgradeLevel(UpgradeTypes::Adrenal_Glands) > 0 &&
			building_manager.building_exists(UnitTypes::Zerg_Ultralisk_Cavern));
}

double ZergStrategy::calculate_mineral_gas_ratio()
{
	double minerals = spending_manager.income_per_minute().minerals + spending_manager.spendable().minerals;
	double gas = spending_manager.income_per_minute().gas + spending_manager.spendable().gas;
	return minerals / gas;
}

int ZergStrategy::enemy_air_supply()
{
	int result = 0;
	for (auto type : { UnitTypes::Terran_Wraith, UnitTypes::Terran_Battlecruiser, UnitTypes::Terran_Science_Vessel,
		UnitTypes::Protoss_Scout, UnitTypes::Protoss_Carrier, UnitTypes::Protoss_Arbiter, UnitTypes::Zerg_Mutalisk,
		UnitTypes::Zerg_Scourge, UnitTypes::Zerg_Guardian } ) {
		result += (type.supplyRequired() * information_manager.enemy_count(type));
	}
	if (result > 0) {
		for (auto type : { UnitTypes::Terran_Valkyrie, UnitTypes::Protoss_Corsair, UnitTypes::Zerg_Devourer } ) {
			result += (type.supplyRequired() * information_manager.enemy_count(type));
		}
	}
	return result;
}

void ZergStrategy::set_train_distribution(UnitType type)
{
	set_train_distribution(training_manager.larva_train_distribution(), type);
}

void ZergStrategy::set_train_distribution(TrainDistribution& train_distribution,UnitType type)
{
	if (type != UnitTypes::None) {
		train_distribution.set(type, 1.0);
		double ratio = calculate_mineral_gas_ratio();
		switch (type) {
			case UnitTypes::Zerg_Hydralisk:
				train_distribution.set(UnitTypes::Zerg_Zergling, std::max(ratio * 0.5 - 1.5, 0.0));
				break;
			case UnitTypes::Zerg_Mutalisk:
				train_distribution.set(UnitTypes::Zerg_Zergling, std::max(ratio * 2.0 - 2.0, 0.0));
				break;
			case UnitTypes::Zerg_Ultralisk:
				train_distribution.set(UnitTypes::Zerg_Zergling, std::max(ratio * 4.0 - 4.0, 0.0));
				break;
		}
	}
}

double ZergStrategy::calculate_drones_per_hatchery(UnitType type)
{
	if (type == UnitTypes::None) type = UnitTypes::Zerg_Zergling;
	CostPerMinute cost_per_minute = TrainDistribution::cost_per_minute(type);
	double mineral_drones = cost_per_minute.minerals / 67.1;
	double gas_drones = cost_per_minute.gas / 103.0;
	double max_gas_drones = 3.0 * building_manager.building_count_including_planned(UnitTypes::Zerg_Extractor);
	if (gas_drones > max_gas_drones) {
		CostPerMinute zergling_cost_per_minute = TrainDistribution::cost_per_minute(UnitTypes::Zerg_Zergling);
		double part = max_gas_drones / gas_drones;
		mineral_drones = part * mineral_drones + (1.0 - part) * zergling_cost_per_minute.minerals / 67.1;
		gas_drones = max_gas_drones;
	}
	return 0.5 + mineral_drones + gas_drones;
}

bool ZergStrategy::additional_hatchery()
{
	int frames = 0;
	for (auto& information_unit : information_manager.my_units()) {
		if (information_unit->type.isResourceDepot() &&
			information_unit->type.getRace() == Races::Zerg) {
			int larva_count = int(information_unit->unit->getLarva().size());
			if (larva_count < 3) {
				int last_larva_frame = training_manager.hatchery_last_larva_creation_frame(information_unit->unit);
				int frames_til_next_larva = std::max(TrainDistribution::kLarvaSpawnFrames - last_larva_frame, 0);
				frames = std::max(frames, frames_til_next_larva + (2 - larva_count) * TrainDistribution::kLarvaSpawnFrames);
			}
		}
	}
	
	MineralGas mineral_gas(Broodwar->self());
	MineralGas income = spending_manager.income_per_minute();
	mineral_gas.minerals += frames * income.minerals / (24 * 60);
	mineral_gas.gas += frames * income.gas / (24 * 60);
	return mineral_gas.can_pay(UnitTypes::Zerg_Hatchery);
}

void ZergStrategy::frame_inner()
{
	switch (mode_) {
		case Mode::Opening:
			mode_opening();
			break;
		case Mode::DefendFastPool:
			mode_defend_fast_pool();
			break;
		case Mode::Main_MutaHydraLing:
			mode_main_muta_hydra_ling();
			break;
		case Mode::Main_HydraLing:
			mode_main_hydra_ling();
			break;
		case Mode::Main_UltraLing:
			mode_main_ultra_ling();
			break;
		case Mode::Main_ZvZ:
			mode_main_ZvZ();
			break;
		case Mode::Main_ZvZLateGame:
			mode_main_ZvZ(true);
			break;
	}
}
