#pragma once

class PathFinder : public Singleton<PathFinder>
{
public:
	void init();
	void close_small_chokepoints_if_needed();
	bool execute_path(Unit unit,Position position,std::function<void(void)> command);
	
private:
	struct MineralWalkData
	{
		Unit first_mineral;
		Position first_mineral_position;
		Unit second_mineral;
		Position second_mineral_position;
	};
	
	struct MineralWalkState
	{
		bool done = false;
		int expire_frame;
		Unit target;
		Position position;
	};
	
	bool small_chokepoints_closed_ = false;
	std::map<const BWEM::ChokePoint*,MineralWalkData> mineral_walk_data_;
	std::map<Unit,MineralWalkState> mineral_walk_state_;
	
	Position calculate_position_near_egg(Unit mineral_unit);
	
	int distance_to_chokepoint(Position position,const BWEM::ChokePoint* choke);
	bool mineral_walk_continue(Unit unit);
	bool mineral_walk_start(Unit unit,const BWEM::ChokePoint* choke,Position waypoint);
	bool mineral_walk_to(Unit unit,Unit mineral,Position mineral_position);
};
