/*
 * Decompiled with CFR 0.152.
 */
package yata;

import java.util.ArrayList;
import java.util.List;
import org.openbw.bwapi4j.BWMap;
import org.openbw.bwapi4j.TilePosition;
import org.openbw.bwapi4j.WalkPosition;
import org.openbw.bwapi4j.org.xguzm.pathfinding.NavigationGraph;
import org.openbw.bwapi4j.org.xguzm.pathfinding.finders.AStarFinder;
import org.openbw.bwapi4j.org.xguzm.pathfinding.grid.GridCell;
import org.openbw.bwapi4j.org.xguzm.pathfinding.grid.NavigationGrid;
import org.openbw.bwapi4j.org.xguzm.pathfinding.grid.NavigationGridGraphNode;
import org.openbw.bwapi4j.org.xguzm.pathfinding.grid.finders.AStarGridFinder;
import org.openbw.bwapi4j.org.xguzm.pathfinding.grid.finders.GridFinderOptions;

public final class YATA {
    private final int width;
    private final int height;
    private final GridCell[][] nodes;
    private final GridFinderOptions finderOptions;
    private final NavigationGraph<GridCell> navigationGrid;
    private final AStarFinder<GridCell> finder;

    public YATA(BWMap bwMap) {
        int x;
        int y;
        this.width = bwMap.mapWidth();
        this.height = bwMap.mapHeight();
        this.nodes = new GridCell[this.getWidth()][this.getHeight()];
        for (y = 0; y < this.getHeight(); ++y) {
            for (x = 0; x < this.getWidth(); ++x) {
                this.getNodes()[x][y] = new GridCell();
            }
        }
        for (y = 0; y < this.getHeight(); ++y) {
            for (x = 0; x < this.getWidth(); ++x) {
                WalkPosition[] deltas;
                WalkPosition walkPosition = new TilePosition(x, y).toWalkPosition();
                boolean isTileWalkable = true;
                for (WalkPosition delta : deltas = new WalkPosition[]{walkPosition, walkPosition.add(new WalkPosition(1, 0)), walkPosition.add(new WalkPosition(0, 1)), walkPosition.add(new WalkPosition(1, 1))}) {
                    if (bwMap.isWalkable(delta.getX(), delta.getY())) continue;
                    isTileWalkable = false;
                    break;
                }
                this.getNodes()[x][y].setWalkable(isTileWalkable);
            }
        }
        this.finderOptions = new GridFinderOptions();
        this.finderOptions.allowDiagonal = true;
        this.navigationGrid = new NavigationGrid((NavigationGridGraphNode[][])this.nodes, true);
        this.finder = new AStarGridFinder<GridCell>(GridCell.class, this.finderOptions);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public GridCell[][] getNodes() {
        return this.nodes;
    }

    public List<TilePosition> getPath(TilePosition start, TilePosition end) {
        GridCell startNode = this.nodes[start.getX()][start.getY()];
        GridCell endNode = this.nodes[end.getX()][end.getY()];
        List<GridCell> gridCellPath = this.finder.findPath(startNode, endNode, this.navigationGrid);
        ArrayList<TilePosition> tilePath = new ArrayList<TilePosition>();
        if (gridCellPath != null) {
            for (GridCell cell : gridCellPath) {
                tilePath.add(new TilePosition(cell.x, cell.y));
            }
        }
        return tilePath;
    }
}

