/*
 * Decompiled with CFR 0.152.
 */
package org.openbw.bwapi4j.util;

import java.util.concurrent.Callable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openbw.bwapi4j.InteractionHandler;

public class Cache<T> {
    private static final Logger logger = LogManager.getLogger();
    private T data;
    private int lastFrameUpdate = -1;
    private final int refreshPeriod;
    private final Callable<T> updateFunction;
    private final InteractionHandler interactionHandler;

    public Cache(Callable<T> updateFunction, InteractionHandler interactionHandler) {
        this.refreshPeriod = 1;
        this.updateFunction = updateFunction;
        this.interactionHandler = interactionHandler;
    }

    public T get() {
        int currentFrameCount = this.interactionHandler.getFrameCount();
        if (this.lastFrameUpdate + this.refreshPeriod < currentFrameCount + 1 || this.lastFrameUpdate > currentFrameCount) {
            try {
                this.data = this.updateFunction.call();
            }
            catch (Exception e) {
                logger.warn("Update function failed. Returning null.");
                logger.throwing(e);
                return null;
            }
            this.lastFrameUpdate = currentFrameCount;
        }
        return this.data;
    }
}

