/*
 * Decompiled with CFR 0.152.
 */
package org.openbw.bwapi4j.unit;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openbw.bwapi4j.Position;
import org.openbw.bwapi4j.type.UnitCommandType;
import org.openbw.bwapi4j.unit.Loadable;
import org.openbw.bwapi4j.unit.MobileUnit;
import org.openbw.bwapi4j.unit.MobileUnitImpl;

public abstract class Transporter
extends MobileUnitImpl
implements Loadable {
    private static final Logger logger = LogManager.getLogger();

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    @Override
    public boolean load(MobileUnit target) {
        return this.load(target, false);
    }

    @Override
    public boolean load(MobileUnit target, boolean queued) {
        if (target.isFlyer()) {
            logger.error("Can't load a {} into a transport. Only non-flying units allowed.", (Object)target);
            return false;
        }
        return this.issueCommand(this.iD, UnitCommandType.Load, target.getId(), -1, -1, queued ? 1 : 0);
    }

    @Override
    public boolean unload(MobileUnit target) {
        return this.issueCommand(this.iD, UnitCommandType.Unload, target.getId(), -1, -1, -1);
    }

    @Override
    public boolean unloadAll() {
        return this.unloadAll(false);
    }

    @Override
    public boolean unloadAll(boolean queued) {
        return this.issueCommand(this.iD, UnitCommandType.Unload_All, -1, -1, -1, queued ? 1 : 0);
    }

    public boolean unloadAll(Position p) {
        return this.unloadAll(p, false);
    }

    public boolean unloadAll(Position p, boolean queued) {
        return this.issueCommand(this.iD, UnitCommandType.Unload_All_Position, -1, p.getX(), p.getY(), queued ? 1 : 0);
    }

    @Override
    public int getSpaceRemaining() {
        return this.spaceRemaining;
    }

    @Override
    public List<MobileUnit> getLoadedUnits() {
        return this.loadedUnits;
    }
}

