/*
 * Decompiled with CFR 0.152.
 */
package org.openbw.bwapi4j.unit;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openbw.bwapi4j.Position;
import org.openbw.bwapi4j.type.TechType;
import org.openbw.bwapi4j.type.UnitCommandType;
import org.openbw.bwapi4j.unit.AirAttacker;
import org.openbw.bwapi4j.unit.GroundAttacker;
import org.openbw.bwapi4j.unit.Mechanical;
import org.openbw.bwapi4j.unit.MobileUnitImpl;
import org.openbw.bwapi4j.unit.Organic;
import org.openbw.bwapi4j.unit.SpellCaster;
import org.openbw.bwapi4j.unit.Unit;
import org.openbw.bwapi4j.unit.Weapon;

public class Ghost
extends MobileUnitImpl
implements SpellCaster,
Organic,
GroundAttacker,
AirAttacker {
    private static final Logger logger = LogManager.getLogger();

    @Override
    public int getEnergy() {
        return this.energy;
    }

    @Override
    public int getMaxEnergy() {
        return super.getMaxEnergy();
    }

    public boolean personnelCloaking() {
        return this.issueCommand(this.iD, UnitCommandType.Use_Tech, -1, -1, -1, TechType.Personnel_Cloaking.getId());
    }

    public boolean lockdown(Mechanical unit) {
        if (unit instanceof Unit) {
            return this.issueCommand(this.iD, UnitCommandType.Use_Tech_Unit, unit.getId(), -1, -1, TechType.Lockdown.getId());
        }
        logger.error("unit {} is not a valid target for lockDown.", (Object)unit);
        return false;
    }

    public boolean nuclearStrike(Position p) {
        return this.issueCommand(this.iD, UnitCommandType.Use_Tech_Position, -1, p.getX(), p.getY(), TechType.Nuclear_Strike.getId());
    }

    @Override
    public Weapon getGroundWeapon() {
        return this.groundWeapon;
    }

    @Override
    public Weapon getAirWeapon() {
        return this.airWeapon;
    }

    @Override
    public int getGroundWeaponMaxRange() {
        return super.getGroundWeaponMaxRange();
    }

    @Override
    public int getGroundWeaponMaxCooldown() {
        return super.getGroundWeaponMaxCooldown();
    }

    @Override
    public int getGroundWeaponCooldown() {
        return super.getGroundWeaponCooldown(this);
    }

    @Override
    public int getGroundWeaponDamage() {
        return super.getGroundWeaponDamage();
    }

    @Override
    public int getMaxGroundHits() {
        return super.getMaxGroundHits();
    }

    @Override
    public int getAirWeaponMaxRange() {
        return super.getAirWeaponMaxRange();
    }

    @Override
    public int getAirWeaponMaxCooldown() {
        return super.getAirWeaponMaxCooldown();
    }

    @Override
    public int getAirWeaponCooldown() {
        return super.getAirWeaponCooldown(this);
    }

    @Override
    public int getAirWeaponDamage() {
        return super.getAirWeaponDamage();
    }

    @Override
    public int getMaxAirHits() {
        return super.getMaxAirHits();
    }
}

