/*
 * Decompiled with CFR 0.152.
 */
package org.openbw.bwapi4j.unit;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openbw.bwapi4j.Position;
import org.openbw.bwapi4j.type.Race;
import org.openbw.bwapi4j.type.TechType;
import org.openbw.bwapi4j.type.UnitCommandType;
import org.openbw.bwapi4j.type.UnitType;
import org.openbw.bwapi4j.unit.Burrowable;
import org.openbw.bwapi4j.unit.MobileUnit;
import org.openbw.bwapi4j.unit.MobileUnitImpl;
import org.openbw.bwapi4j.unit.Organic;
import org.openbw.bwapi4j.unit.SpellCaster;

public class Defiler
extends MobileUnitImpl
implements Organic,
SpellCaster,
Burrowable {
    private static final Logger logger = LogManager.getLogger();

    @Override
    public int getEnergy() {
        return this.energy;
    }

    @Override
    public int getMaxEnergy() {
        return super.getMaxEnergy();
    }

    public boolean consume(MobileUnit target) {
        if (this.energy < TechType.Spawn_Broodlings.energyCost()) {
            return false;
        }
        if (target.getType().getRace() != Race.Zerg || target.getType() == UnitType.Zerg_Larva) {
            logger.info("Consume spell does not work on {} (only non-larva Zerg units can be consumed)", (Object)target);
            return false;
        }
        return this.issueCommand(this.iD, UnitCommandType.Use_Tech_Unit, target.getId(), -1, -1, TechType.Spawn_Broodlings.getId());
    }

    public boolean plague(Position position) {
        if (this.energy < TechType.Plague.energyCost()) {
            return false;
        }
        return this.issueCommand(this.iD, UnitCommandType.Use_Tech_Position, -1, position.getX(), position.getY(), TechType.Plague.getId());
    }

    public boolean darkSwarm(Position position) {
        if (this.energy < TechType.Dark_Swarm.energyCost()) {
            return false;
        }
        return this.issueCommand(this.iD, UnitCommandType.Use_Tech_Position, -1, position.getX(), position.getY(), TechType.Dark_Swarm.getId());
    }

    @Override
    public boolean burrow() {
        return this.issueCommand(this.iD, UnitCommandType.Burrow, -1, -1, -1, -1);
    }

    @Override
    public boolean unburrow() {
        return this.issueCommand(this.iD, UnitCommandType.Unburrow, -1, -1, -1, -1);
    }

    @Override
    public boolean isBurrowed() {
        return this.burrowed;
    }
}

