/*
 * Decompiled with CFR 0.152.
 */
package org.openbw.bwapi4j;

import org.openbw.bwapi4j.TilePosition;
import org.openbw.bwapi4j.WalkPosition;
import org.openbw.bwapi4j.util.MathUtils;

public class Position {
    private final int x;
    private final int y;

    public Position(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Position(TilePosition tilePosition) {
        this.x = tilePosition.getX() * 32;
        this.y = tilePosition.getY() * 32;
    }

    public Position(WalkPosition walkPosition) {
        this.x = walkPosition.getX() * 8;
        this.y = walkPosition.getY() * 8;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getDistance(Position position) {
        return MathUtils.estimateDistanceBetween(this.getX(), this.getY(), position.getX(), position.getY());
    }

    public TilePosition toTilePosition() {
        int x = this.getX() / 32;
        int y = this.getY() / 32;
        return new TilePosition(x, y);
    }

    public WalkPosition toWalkPosition() {
        int x = this.getX() / 8;
        int y = this.getY() / 8;
        return new WalkPosition(x, y);
    }

    public Position add(Position position) {
        int x = this.getX() + position.getX();
        int y = this.getY() + position.getY();
        return new Position(x, y);
    }

    public Position subtract(Position position) {
        int x = this.getX() - position.getX();
        int y = this.getY() - position.getY();
        return new Position(x, y);
    }

    public Position multiply(Position position) {
        int x = this.getX() * position.getX();
        int y = this.getY() * position.getY();
        return new Position(x, y);
    }

    public Position divide(Position position) {
        int x = this.getX() / position.getX();
        int y = this.getY() / position.getY();
        return new Position(x, y);
    }

    public String toString() {
        return "[" + this.getX() + ", " + this.getY() + "]";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Position)) {
            return false;
        }
        Position position = (Position)object;
        if (this.getX() != position.getX()) {
            return false;
        }
        return this.getY() == position.getY();
    }

    public int hashCode() {
        return this.getX() * 2048 * 32 + this.getY();
    }
}

