/*
 * Decompiled with CFR 0.152.
 */
package org.openbw.bwapi4j;

import org.openbw.bwapi4j.Position;
import org.openbw.bwapi4j.type.Color;

public final class MapDrawer {
    private native void setTextSize_native(int var1);

    public void setTextSize(TextSize textSize) {
        this.setTextSize_native(textSize.ordinal());
    }

    private native void drawText_native(int var1, int var2, int var3, String var4);

    private native void drawBox_native(int var1, int var2, int var3, int var4, int var5, int var6, boolean var7);

    private native void drawTriangle_native(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, boolean var9);

    private native void drawCircle_native(int var1, int var2, int var3, int var4, int var5, boolean var6);

    private native void drawEllipse_native(int var1, int var2, int var3, int var4, int var5, int var6, boolean var7);

    private native void drawDot_native(int var1, int var2, int var3, int var4);

    private native void drawLine_native(int var1, int var2, int var3, int var4, int var5, int var6);

    public void drawText(CoordinateType ctype, int x, int y, String cstr_format) {
        this.drawText_native(ctype.ordinal(), x, y, cstr_format);
    }

    public void drawTextMap(int x, int y, String cstr_format) {
        this.drawText_native(CoordinateType.Map.ordinal(), x, y, cstr_format);
    }

    public void drawTextMap(Position p, String cstr_format) {
        this.drawText_native(CoordinateType.Map.ordinal(), p.getX(), p.getY(), cstr_format);
    }

    public void drawTextMouse(int x, int y, String cstr_format) {
        this.drawText_native(CoordinateType.Mouse.ordinal(), x, y, cstr_format);
    }

    public void drawTextMouse(Position p, String cstr_format) {
        this.drawText_native(CoordinateType.Mouse.ordinal(), p.getX(), p.getY(), cstr_format);
    }

    public void drawTextScreen(int x, int y, String cstr_format) {
        this.drawText_native(CoordinateType.Screen.ordinal(), x, y, cstr_format);
    }

    public void drawTextScreen(Position p, String cstr_format) {
        this.drawText_native(CoordinateType.Screen.ordinal(), p.getX(), p.getY(), cstr_format);
    }

    public void drawBox(CoordinateType ctype, int left, int top, int right, int bottom, Color color) {
        this.drawBox_native(ctype.ordinal(), left, top, right, bottom, color.getValue(), false);
    }

    public void drawBox(CoordinateType ctype, int left, int top, int right, int bottom, Color color, boolean isSolid) {
        this.drawBox_native(ctype.ordinal(), left, top, right, bottom, color.getValue(), isSolid);
    }

    public void drawBoxMap(int left, int top, int right, int bottom, Color color) {
        this.drawBox_native(CoordinateType.Map.ordinal(), left, top, right, bottom, color.getValue(), false);
    }

    public void drawBoxMap(int left, int top, int right, int bottom, Color color, boolean isSolid) {
        this.drawBox_native(CoordinateType.Map.ordinal(), left, top, right, bottom, color.getValue(), isSolid);
    }

    public void drawBoxMap(Position leftTop, Position rightBottom, Color color) {
        this.drawBox_native(CoordinateType.Map.ordinal(), leftTop.getX(), leftTop.getY(), rightBottom.getX(), rightBottom.getY(), color.getValue(), false);
    }

    public void drawBoxMap(Position leftTop, Position rightBottom, Color color, boolean isSolid) {
        this.drawBox_native(CoordinateType.Map.ordinal(), leftTop.getX(), leftTop.getY(), rightBottom.getX(), rightBottom.getY(), color.getValue(), isSolid);
    }

    public void drawBoxMouse(int left, int top, int right, int bottom, Color color) {
        this.drawBox_native(CoordinateType.Mouse.ordinal(), left, top, right, bottom, color.getValue(), false);
    }

    public void drawBoxMouse(int left, int top, int right, int bottom, Color color, boolean isSolid) {
        this.drawBox_native(CoordinateType.Mouse.ordinal(), left, top, right, bottom, color.getValue(), isSolid);
    }

    public void drawBoxMouse(Position leftTop, Position rightBottom, Color color) {
        this.drawBox_native(CoordinateType.Mouse.ordinal(), leftTop.getX(), leftTop.getY(), rightBottom.getX(), rightBottom.getY(), color.getValue(), false);
    }

    public void drawBoxMouse(Position leftTop, Position rightBottom, Color color, boolean isSolid) {
        this.drawBox_native(CoordinateType.Mouse.ordinal(), leftTop.getX(), leftTop.getY(), rightBottom.getX(), rightBottom.getY(), color.getValue(), isSolid);
    }

    public void drawBoxScreen(int left, int top, int right, int bottom, Color color) {
        this.drawBox_native(CoordinateType.Screen.ordinal(), left, top, right, bottom, color.getValue(), false);
    }

    public void drawBoxScreen(int left, int top, int right, int bottom, Color color, boolean isSolid) {
        this.drawBox_native(CoordinateType.Screen.ordinal(), left, top, right, bottom, color.getValue(), isSolid);
    }

    public void drawBoxScreen(Position leftTop, Position rightBottom, Color color) {
        this.drawBox_native(CoordinateType.Screen.ordinal(), leftTop.getX(), leftTop.getY(), rightBottom.getX(), rightBottom.getY(), color.getValue(), false);
    }

    public void drawBoxScreen(Position leftTop, Position rightBottom, Color color, boolean isSolid) {
        this.drawBox_native(CoordinateType.Screen.ordinal(), leftTop.getX(), leftTop.getY(), rightBottom.getX(), rightBottom.getY(), color.getValue(), isSolid);
    }

    public void drawTriangle(CoordinateType ctype, int ax, int ay, int bx, int by, int cx, int cy, Color color) {
        this.drawTriangle_native(ctype.ordinal(), ax, ay, bx, by, cx, cy, color.getValue(), false);
    }

    public void drawTriangle(CoordinateType ctype, int ax, int ay, int bx, int by, int cx, int cy, Color color, boolean isSolid) {
        this.drawTriangle_native(ctype.ordinal(), ax, ay, bx, by, cx, cy, color.getValue(), isSolid);
    }

    public void drawTriangleMap(int ax, int ay, int bx, int by, int cx, int cy, Color color) {
        this.drawTriangle_native(CoordinateType.Map.ordinal(), ax, ay, bx, by, cx, cy, color.getValue(), false);
    }

    public void drawTriangleMap(int ax, int ay, int bx, int by, int cx, int cy, Color color, boolean isSolid) {
        this.drawTriangle_native(CoordinateType.Map.ordinal(), ax, ay, bx, by, cx, cy, color.getValue(), isSolid);
    }

    public void drawTriangleMap(Position a, Position b, Position c, Color color) {
        this.drawTriangle_native(CoordinateType.Map.ordinal(), a.getX(), a.getY(), b.getX(), b.getY(), c.getX(), c.getY(), color.getValue(), false);
    }

    public void drawTriangleMap(Position a, Position b, Position c, Color color, boolean isSolid) {
        this.drawTriangle_native(CoordinateType.Map.ordinal(), a.getX(), a.getY(), b.getX(), b.getY(), c.getX(), c.getY(), color.getValue(), isSolid);
    }

    public void drawTriangleMouse(int ax, int ay, int bx, int by, int cx, int cy, Color color) {
        this.drawTriangle_native(CoordinateType.Mouse.ordinal(), ax, ay, bx, by, cx, cy, color.getValue(), false);
    }

    public void drawTriangleMouse(int ax, int ay, int bx, int by, int cx, int cy, Color color, boolean isSolid) {
        this.drawTriangle_native(CoordinateType.Mouse.ordinal(), ax, ay, bx, by, cx, cy, color.getValue(), isSolid);
    }

    public void drawTriangleMouse(Position a, Position b, Position c, Color color) {
        this.drawTriangle_native(CoordinateType.Mouse.ordinal(), a.getX(), a.getY(), b.getX(), b.getY(), c.getX(), c.getY(), color.getValue(), false);
    }

    public void drawTriangleMouse(Position a, Position b, Position c, Color color, boolean isSolid) {
        this.drawTriangle_native(CoordinateType.Mouse.ordinal(), a.getX(), a.getY(), b.getX(), b.getY(), c.getX(), c.getY(), color.getValue(), isSolid);
    }

    public void drawTriangleScreen(int ax, int ay, int bx, int by, int cx, int cy, Color color) {
        this.drawTriangle_native(CoordinateType.Screen.ordinal(), ax, ay, bx, by, cx, cy, color.getValue(), false);
    }

    public void drawTriangleScreen(int ax, int ay, int bx, int by, int cx, int cy, Color color, boolean isSolid) {
        this.drawTriangle_native(CoordinateType.Screen.ordinal(), ax, ay, bx, by, cx, cy, color.getValue(), isSolid);
    }

    public void drawTriangleScreen(Position a, Position b, Position c, Color color) {
        this.drawTriangle_native(CoordinateType.Screen.ordinal(), a.getX(), a.getY(), b.getX(), b.getY(), c.getX(), c.getY(), color.getValue(), false);
    }

    public void drawTriangleScreen(Position a, Position b, Position c, Color color, boolean isSolid) {
        this.drawTriangle_native(CoordinateType.Screen.ordinal(), a.getX(), a.getY(), b.getX(), b.getY(), c.getX(), c.getY(), color.getValue(), isSolid);
    }

    public void drawCircle(CoordinateType ctype, int x, int y, int radius, Color color) {
        this.drawCircle_native(ctype.ordinal(), x, y, radius, color.getValue(), false);
    }

    public void drawCircle(CoordinateType ctype, int x, int y, int radius, Color color, boolean isSolid) {
        this.drawCircle_native(ctype.ordinal(), x, y, radius, color.getValue(), isSolid);
    }

    public void drawCircleMap(int x, int y, int radius, Color color) {
        this.drawCircle_native(CoordinateType.Map.ordinal(), x, y, radius, color.getValue(), false);
    }

    public void drawCircleMap(int x, int y, int radius, Color color, boolean isSolid) {
        this.drawCircle_native(CoordinateType.Map.ordinal(), x, y, radius, color.getValue(), isSolid);
    }

    public void drawCircleMap(Position p, int radius, Color color) {
        this.drawCircle_native(CoordinateType.Map.ordinal(), p.getX(), p.getY(), radius, color.getValue(), false);
    }

    public void drawCircleMap(Position p, int radius, Color color, boolean isSolid) {
        this.drawCircle_native(CoordinateType.Map.ordinal(), p.getX(), p.getY(), radius, color.getValue(), isSolid);
    }

    public void drawCircleMouse(int x, int y, int radius, Color color) {
        this.drawCircle_native(CoordinateType.Mouse.ordinal(), x, y, radius, color.getValue(), false);
    }

    public void drawCircleMouse(int x, int y, int radius, Color color, boolean isSolid) {
        this.drawCircle_native(CoordinateType.Mouse.ordinal(), x, y, radius, color.getValue(), isSolid);
    }

    public void drawCircleMouse(Position p, int radius, Color color) {
        this.drawCircle_native(CoordinateType.Mouse.ordinal(), p.getX(), p.getY(), radius, color.getValue(), false);
    }

    public void drawCircleMouse(Position p, int radius, Color color, boolean isSolid) {
        this.drawCircle_native(CoordinateType.Mouse.ordinal(), p.getX(), p.getY(), radius, color.getValue(), isSolid);
    }

    public void drawCircleScreen(int x, int y, int radius, Color color) {
        this.drawCircle_native(CoordinateType.Screen.ordinal(), x, y, radius, color.getValue(), false);
    }

    public void drawCircleScreen(int x, int y, int radius, Color color, boolean isSolid) {
        this.drawCircle_native(CoordinateType.Screen.ordinal(), x, y, radius, color.getValue(), isSolid);
    }

    public void drawCircleScreen(Position p, int radius, Color color) {
        this.drawCircle_native(CoordinateType.Screen.ordinal(), p.getX(), p.getY(), radius, color.getValue(), false);
    }

    public void drawCircleScreen(Position p, int radius, Color color, boolean isSolid) {
        this.drawCircle_native(CoordinateType.Screen.ordinal(), p.getX(), p.getY(), radius, color.getValue(), isSolid);
    }

    public void drawEllipse(CoordinateType ctype, int x, int y, int xrad, int yrad, Color color) {
        this.drawEllipse_native(ctype.ordinal(), x, y, xrad, yrad, color.getValue(), false);
    }

    public void drawEllipse(CoordinateType ctype, int x, int y, int xrad, int yrad, Color color, boolean isSolid) {
        this.drawEllipse_native(ctype.ordinal(), x, y, xrad, yrad, color.getValue(), isSolid);
    }

    public void drawEllipseMap(int x, int y, int xrad, int yrad, Color color) {
        this.drawEllipse_native(CoordinateType.Map.ordinal(), x, y, xrad, yrad, color.getValue(), false);
    }

    public void drawEllipseMap(int x, int y, int xrad, int yrad, Color color, boolean isSolid) {
        this.drawEllipse_native(CoordinateType.Map.ordinal(), x, y, xrad, yrad, color.getValue(), isSolid);
    }

    public void drawEllipseMap(Position p, int xrad, int yrad, Color color) {
        this.drawEllipse_native(CoordinateType.Map.ordinal(), p.getX(), p.getY(), xrad, yrad, color.getValue(), false);
    }

    public void drawEllipseMap(Position p, int xrad, int yrad, Color color, boolean isSolid) {
        this.drawEllipse_native(CoordinateType.Map.ordinal(), p.getX(), p.getY(), xrad, yrad, color.getValue(), isSolid);
    }

    public void drawEllipseMouse(int x, int y, int xrad, int yrad, Color color) {
        this.drawEllipse_native(CoordinateType.Mouse.ordinal(), x, y, xrad, yrad, color.getValue(), false);
    }

    public void drawEllipseMouse(int x, int y, int xrad, int yrad, Color color, boolean isSolid) {
        this.drawEllipse_native(CoordinateType.Mouse.ordinal(), x, y, xrad, yrad, color.getValue(), isSolid);
    }

    public void drawEllipseMouse(Position p, int xrad, int yrad, Color color) {
        this.drawEllipse_native(CoordinateType.Mouse.ordinal(), p.getX(), p.getY(), xrad, yrad, color.getValue(), false);
    }

    public void drawEllipseMouse(Position p, int xrad, int yrad, Color color, boolean isSolid) {
        this.drawEllipse_native(CoordinateType.Mouse.ordinal(), p.getX(), p.getY(), xrad, yrad, color.getValue(), isSolid);
    }

    public void drawEllipseScreen(int x, int y, int xrad, int yrad, Color color) {
        this.drawEllipse_native(CoordinateType.Screen.ordinal(), x, y, xrad, yrad, color.getValue(), false);
    }

    public void drawEllipseScreen(int x, int y, int xrad, int yrad, Color color, boolean isSolid) {
        this.drawEllipse_native(CoordinateType.Screen.ordinal(), x, y, xrad, yrad, color.getValue(), isSolid);
    }

    public void drawEllipseScreen(Position p, int xrad, int yrad, Color color) {
        this.drawEllipse_native(CoordinateType.Screen.ordinal(), p.getX(), p.getY(), xrad, yrad, color.getValue(), false);
    }

    public void drawEllipseScreen(Position p, int xrad, int yrad, Color color, boolean isSolid) {
        this.drawEllipse_native(CoordinateType.Screen.ordinal(), p.getX(), p.getY(), xrad, yrad, color.getValue(), isSolid);
    }

    public void drawDot(CoordinateType ctype, int x, int y, Color color) {
        this.drawDot_native(ctype.ordinal(), x, y, color.getValue());
    }

    public void drawDotMap(int x, int y, Color color) {
        this.drawDot_native(CoordinateType.Map.ordinal(), x, y, color.getValue());
    }

    public void drawDotMap(Position p, Color color) {
        this.drawDot_native(CoordinateType.Map.ordinal(), p.getX(), p.getY(), color.getValue());
    }

    public void drawDotMouse(int x, int y, Color color) {
        this.drawDot_native(CoordinateType.Mouse.ordinal(), x, y, color.getValue());
    }

    public void drawDotMouse(Position p, Color color) {
        this.drawDot_native(CoordinateType.Mouse.ordinal(), p.getX(), p.getY(), color.getValue());
    }

    public void drawDotScreen(int x, int y, Color color) {
        this.drawDot_native(CoordinateType.Screen.ordinal(), x, y, color.getValue());
    }

    public void drawDotScreen(Position p, Color color) {
        this.drawDot_native(CoordinateType.Screen.ordinal(), p.getX(), p.getY(), color.getValue());
    }

    public void drawLine(CoordinateType ctype, int x1, int y1, int x2, int y2, Color color) {
        this.drawLine_native(ctype.ordinal(), x1, y1, x2, y2, color.getValue());
    }

    public void drawLineMap(int x1, int y1, int x2, int y2, Color color) {
        this.drawLine_native(CoordinateType.Map.ordinal(), x1, y1, x2, y2, color.getValue());
    }

    public void drawLineMap(Position a, Position b, Color color) {
        this.drawLine_native(CoordinateType.Map.ordinal(), a.getX(), a.getY(), b.getX(), b.getY(), color.getValue());
    }

    public void drawLineMouse(int x1, int y1, int x2, int y2, Color color) {
        this.drawLine_native(CoordinateType.Mouse.ordinal(), x1, y1, x2, y2, color.getValue());
    }

    public void drawLineMouse(Position a, Position b, Color color) {
        this.drawLine_native(CoordinateType.Mouse.ordinal(), a.getX(), a.getY(), b.getX(), b.getY(), color.getValue());
    }

    public void drawLineScreen(int x1, int y1, int x2, int y2, Color color) {
        this.drawLine_native(CoordinateType.Screen.ordinal(), x1, y1, x2, y2, color.getValue());
    }

    public void drawLineScreen(Position a, Position b, Color color) {
        this.drawLine_native(CoordinateType.Screen.ordinal(), a.getX(), a.getY(), b.getX(), b.getY(), color.getValue());
    }

    public static enum TextSize {
        Small,
        Default,
        Large,
        Huge;

    }

    public static enum Shape {
        None,
        Text,
        Box,
        Triangle,
        Circle,
        Ellipse,
        Dot,
        Line;

    }

    public static enum CoordinateType {
        None,
        Screen,
        Map,
        Mouse;

    }
}

