/*
 * Decompiled with CFR 0.152.
 */
package ecgberht;

import ecgberht.ConfigManager;
import ecgberht.Ecgberht;
import ecgberht.IntelligenceAgency;
import ecgberht.LearningManager;
import ecgberht.Strategies.BioGreedyFE;
import ecgberht.Strategies.BioMech;
import ecgberht.Strategies.BioMechFE;
import ecgberht.Strategies.BioMechGreedyFE;
import ecgberht.Strategies.FastCC;
import ecgberht.Strategies.FullBio;
import ecgberht.Strategies.FullBioFE;
import ecgberht.Strategies.FullMech;
import ecgberht.Strategies.JoyORush;
import ecgberht.Strategies.MechGreedyFE;
import ecgberht.Strategies.PlasmaWraithHell;
import ecgberht.Strategies.ProxyBBS;
import ecgberht.Strategies.ProxyEightRax;
import ecgberht.Strategies.TheNitekat;
import ecgberht.Strategies.TwoPortWraith;
import ecgberht.Strategies.VultureRush;
import ecgberht.Strategy;
import ecgberht.Util.MutablePair;
import ecgberht.Util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import org.openbw.bwapi4j.type.Race;
import org.openbw.bwapi4j.type.UnitType;

public class StrategyManager {
    private FullBio b = new FullBio();
    private ProxyBBS bbs = new ProxyBBS();
    private BioMech bM = new BioMech();
    private FullBioFE bFE = new FullBioFE();
    private BioMechFE bMFE = new BioMechFE();
    private FullMech FM = new FullMech();
    private BioGreedyFE bGFE = new BioGreedyFE();
    private MechGreedyFE mGFE = new MechGreedyFE();
    private BioMechGreedyFE bMGFE = new BioMechGreedyFE();
    private TwoPortWraith tPW = new TwoPortWraith();
    private ProxyEightRax pER = new ProxyEightRax();
    private VultureRush vR = new VultureRush();
    private TheNitekat tNK = new TheNitekat();
    private JoyORush jOR = new JoyORush();
    private FastCC fastCC = new FastCC();
    public Strategy strat;
    private Map<String, MutablePair<Integer, Integer>> strategies = new LinkedHashMap<String, MutablePair<Integer, Integer>>();
    private Map<String, Strategy> nameStrat = new LinkedHashMap<String, Strategy>();

    StrategyManager() {
        this.initBaseStrategies();
        this.strat = this.initStrat();
        this.AddSpecialUnitsIfParticularMap();
    }

    private void AddSpecialUnitsIfParticularMap() {
        if (Ecgberht.getGs().getGame().getBWMap().mapHash().equals("666dd28cd3c85223ebc749a481fc281e58221e4a")) {
            this.strat.trainUnits.add(UnitType.Terran_Wraith);
        }
    }

    private void initBaseStrategies() {
        Consumer<Strategy> addStrat = strat -> {
            this.strategies.put(strat.name, new MutablePair<Integer, Integer>(0, 0));
            this.nameStrat.put(strat.name, (Strategy)strat);
        };
        switch (Ecgberht.getGs().enemyRace) {
            case Zerg: {
                addStrat.accept(this.bGFE);
                addStrat.accept(this.tPW);
                addStrat.accept(this.pER);
                addStrat.accept(this.bFE);
                addStrat.accept(this.fastCC);
                addStrat.accept(this.bMGFE);
                addStrat.accept(this.bbs);
                addStrat.accept(this.bM);
                addStrat.accept(this.FM);
                addStrat.accept(this.b);
                addStrat.accept(this.bMFE);
                addStrat.accept(this.vR);
                addStrat.accept(this.tNK);
                break;
            }
            case Terran: {
                addStrat.accept(this.FM);
                addStrat.accept(this.fastCC);
                addStrat.accept(this.pER);
                addStrat.accept(this.bMGFE);
                addStrat.accept(this.tPW);
                addStrat.accept(this.bM);
                addStrat.accept(this.mGFE);
                addStrat.accept(this.bbs);
                addStrat.accept(this.bFE);
                addStrat.accept(this.bGFE);
                addStrat.accept(this.b);
                addStrat.accept(this.bMFE);
                addStrat.accept(this.vR);
                addStrat.accept(this.tNK);
                break;
            }
            case Protoss: {
                addStrat.accept(this.FM);
                addStrat.accept(this.jOR);
                addStrat.accept(this.pER);
                addStrat.accept(this.fastCC);
                addStrat.accept(this.mGFE);
                addStrat.accept(this.bM);
                addStrat.accept(this.bMGFE);
                addStrat.accept(this.b);
                addStrat.accept(this.bGFE);
                addStrat.accept(this.bMFE);
                addStrat.accept(this.bFE);
                addStrat.accept(this.vR);
                addStrat.accept(this.tNK);
                break;
            }
            case Unknown: {
                addStrat.accept(this.b);
                addStrat.accept(this.FM);
                addStrat.accept(this.bM);
                addStrat.accept(this.bGFE);
                addStrat.accept(this.bMGFE);
                addStrat.accept(this.bbs);
                addStrat.accept(this.mGFE);
                addStrat.accept(this.jOR);
                addStrat.accept(this.bMFE);
                addStrat.accept(this.bFE);
            }
        }
    }

    void choose14CCTransition() {
        double C = 0.75;
        int totalGamesPlayed = Ecgberht.getGs().learningManager.getEnemyInfo().wins + Ecgberht.getGs().learningManager.getEnemyInfo().losses;
        ArrayList<String> validTransitions = new ArrayList<String>();
        switch (Ecgberht.getGs().enemyRace) {
            case Zerg: {
                validTransitions.addAll(Arrays.asList(this.bGFE.name, this.bMGFE.name, this.tPW.name));
                break;
            }
            case Terran: 
            case Protoss: {
                validTransitions.addAll(Arrays.asList(this.FM.name, this.bMGFE.name, this.bGFE.name));
            }
        }
        String bestUCBStrategy = null;
        double bestUCBStrategyVal = Double.MIN_VALUE;
        for (Map.Entry<String, MutablePair<Integer, Integer>> strat : this.strategies.entrySet()) {
            if (!validTransitions.contains(strat.getKey())) continue;
            int sGamesPlayed = (Integer)strat.getValue().first + (Integer)strat.getValue().second;
            double sWinRate = sGamesPlayed > 0 ? (double)((Integer)strat.getValue().first).intValue() / (double)sGamesPlayed : 0.0;
            double d = sGamesPlayed == 0 ? 0.85 : C * Math.sqrt(Math.log((double)totalGamesPlayed / (double)sGamesPlayed));
            double ucbVal = d;
            double val = sWinRate + ucbVal;
            if (!(val > bestUCBStrategyVal)) continue;
            bestUCBStrategy = strat.getKey();
            bestUCBStrategyVal = val;
        }
        Util.sendText("Transitioning from 14CC to " + bestUCBStrategy + " with UCB: " + bestUCBStrategyVal);
        this.strat = this.nameStrat.get(bestUCBStrategy);
        if (Ecgberht.getGs().naturalChoke != null) {
            Ecgberht.getGs().defendPosition = Ecgberht.getGs().naturalChoke.getCenter().toPosition();
        }
    }

    void chooseProxyTransition() {
        double C = 0.8;
        int totalGamesPlayed = Ecgberht.getGs().learningManager.getEnemyInfo().wins + Ecgberht.getGs().learningManager.getEnemyInfo().losses;
        ArrayList<String> validTransitions = new ArrayList<String>(Arrays.asList(this.b.name, this.bMFE.name, this.FM.name));
        if (Ecgberht.getGs().enemyRace == Race.Zerg) {
            validTransitions.add(this.tPW.name);
        }
        String bestUCBStrategy = null;
        double bestUCBStrategyVal = Double.MIN_VALUE;
        for (Map.Entry<String, MutablePair<Integer, Integer>> strat : this.strategies.entrySet()) {
            if (!validTransitions.contains(strat.getKey())) continue;
            int sGamesPlayed = (Integer)strat.getValue().first + (Integer)strat.getValue().second;
            double sWinRate = sGamesPlayed > 0 ? (double)((Integer)strat.getValue().first).intValue() / (double)sGamesPlayed : 0.0;
            double d = sGamesPlayed == 0 ? 0.85 : C * Math.sqrt(Math.log((double)totalGamesPlayed / (double)sGamesPlayed));
            double ucbVal = d;
            double val = sWinRate + ucbVal;
            if (!(val > bestUCBStrategyVal)) continue;
            bestUCBStrategy = strat.getKey();
            bestUCBStrategyVal = val;
        }
        Util.sendText("Transitioning from Proxy to " + bestUCBStrategy + " with UCB: " + bestUCBStrategyVal);
        this.strat = this.nameStrat.get(bestUCBStrategy);
        if (Ecgberht.getGs().naturalChoke != null) {
            Ecgberht.getGs().defendPosition = Ecgberht.getGs().naturalChoke.getCenter().toPosition();
        }
    }

    void updateStrat() {
        Ecgberht.getGs().maxBats = this.strat.trainUnits.contains(UnitType.Terran_Firebat) && Ecgberht.getGs().enemyRace == Race.Zerg ? 3 : 0;
        if (this.strat.trainUnits.contains(UnitType.Terran_Goliath)) {
            Ecgberht.getGs().maxGoliaths = 0;
        }
    }

    private boolean alwaysZealotRushes() {
        if (Ecgberht.getGs().enemyRace != Race.Protoss) {
            return false;
        }
        ArrayList<String> zealots = new ArrayList<String>(Arrays.asList("purplewavelet", "wulibot", "flash", "carstennielsen"));
        return zealots.contains(Ecgberht.getGs().learningManager.getEnemyInfo().opponent.toLowerCase().replace(" ", ""));
    }

    private Strategy getRandomStrategy() {
        int index = new Random().nextInt(this.nameStrat.entrySet().size());
        Iterator<Map.Entry<String, Strategy>> iter = this.nameStrat.entrySet().iterator();
        for (int i = 0; i < index; ++i) {
            iter.next();
        }
        return iter.next().getValue();
    }

    private Strategy initStrat() {
        try {
            LearningManager.EnemyInfo EI = Ecgberht.getGs().learningManager.getEnemyInfo();
            String forcedStrat = ConfigManager.getConfig().ecgConfig.forceStrat;
            if (!forcedStrat.equals("")) {
                if (forcedStrat.toLowerCase().equals("random")) {
                    Strategy randomStrategy = this.getRandomStrategy();
                    Util.sendText("Picked random strategy " + randomStrategy.name);
                    return randomStrategy;
                }
                if (this.nameStrat.containsKey(forcedStrat)) {
                    Util.sendText("Picked forced strategy " + forcedStrat);
                    if (forcedStrat.equals("14CC")) {
                        for (LearningManager.EnemyInfo.StrategyOpponentHistory r : EI.history) {
                            if (!this.strategies.containsKey(r.strategyName)) continue;
                            MutablePair<Integer, Integer> mutablePair = this.strategies.get(r.strategyName);
                            Integer.valueOf((Integer)mutablePair.first + r.wins);
                            mutablePair.first = mutablePair.first;
                            mutablePair = this.strategies.get(r.strategyName);
                            Integer.valueOf((Integer)mutablePair.second + r.losses);
                            mutablePair.second = mutablePair.second;
                        }
                    }
                    return this.nameStrat.get(forcedStrat);
                }
            }
            if (ConfigManager.getConfig().ecgConfig.humanMode && Math.round(Math.random() * 10.0) < 5L) {
                return this.getRandomStrategy();
            }
            if (Ecgberht.getGs().enemyRace == Race.Zerg && EI.naughty) {
                return this.b;
            }
            if (Ecgberht.getGs().bw.getBWMap().mapHash().equals("6f5295624a7e3887470f3f2e14727b1411321a67")) {
                Ecgberht.getGs().maxWraiths = 200;
                return new PlasmaWraithHell();
            }
            if (this.alwaysZealotRushes()) {
                IntelligenceAgency.setEnemyStrat(IntelligenceAgency.EnemyStrats.ZealotRush);
                this.bFE.armyForExpand += 5;
                this.bFE.workerGas = 2;
                return this.bFE;
            }
            this.removeStrategiesMapSpecific();
            int totalGamesPlayed = EI.wins + EI.losses;
            for (LearningManager.EnemyInfo.StrategyOpponentHistory r : EI.history) {
                if (!this.strategies.containsKey(r.strategyName)) continue;
                MutablePair<Integer, Integer> mutablePair = this.strategies.get(r.strategyName);
                Integer.valueOf((Integer)mutablePair.first + r.wins);
                mutablePair.first = mutablePair.first;
                mutablePair = this.strategies.get(r.strategyName);
                Integer.valueOf((Integer)mutablePair.second + r.losses);
                mutablePair.second = mutablePair.second;
            }
            double maxWinRate = 0.0;
            String bestStrat = null;
            int totalGamesBestS = 0;
            for (Map.Entry<String, MutablePair<Integer, Integer>> s : this.strategies.entrySet()) {
                double winRate;
                int totalGames = (Integer)s.getValue().first + (Integer)s.getValue().second;
                if (totalGames < 2 || !((winRate = (double)((Integer)s.getValue().first).intValue() / (double)totalGames) >= 0.75) || !(winRate > maxWinRate)) continue;
                maxWinRate = winRate;
                bestStrat = s.getKey();
                totalGamesBestS = totalGames;
            }
            if (maxWinRate != 0.0 && bestStrat != null) {
                Util.sendText("Using best Strategy: " + bestStrat + " with winrate " + maxWinRate * 100.0 + "% and " + totalGamesBestS + " games played");
                return this.nameStrat.get(bestStrat);
            }
            double C = 0.7;
            String bestUCBStrategy = null;
            double bestUCBStrategyVal = Double.MIN_VALUE;
            for (Map.Entry<String, MutablePair<Integer, Integer>> strat : this.strategies.entrySet()) {
                double val;
                double ucbVal;
                int sGamesPlayed = (Integer)strat.getValue().first + (Integer)strat.getValue().second;
                double sWinRate = sGamesPlayed > 0 ? (double)((Integer)strat.getValue().first).intValue() / (double)sGamesPlayed : 0.0;
                double d = ucbVal = sGamesPlayed == 0 ? 0.85 : C * Math.sqrt(Math.log((double)totalGamesPlayed / (double)sGamesPlayed));
                if (totalGamesPlayed > 0 && this.nameStrat.get((Object)strat.getKey()).proxy && Ecgberht.getGs().mapSize == 2) {
                    ucbVal += 0.03;
                }
                if (totalGamesPlayed > 0 && strat.getKey().equals("14CC") && Ecgberht.getGs().mapSize == 4) {
                    ucbVal += 0.03;
                }
                if (!((val = sWinRate + ucbVal) > bestUCBStrategyVal)) continue;
                bestUCBStrategy = strat.getKey();
                bestUCBStrategyVal = val;
            }
            if (totalGamesPlayed < 1) {
                Util.sendText("I dont know you that well yet, lets pick " + bestUCBStrategy);
            } else {
                Util.sendText("Chose: " + bestUCBStrategy + " with UCB: " + bestUCBStrategyVal);
            }
            return this.nameStrat.get(bestUCBStrategy);
        }
        catch (Exception e) {
            System.err.println("Error initStrat, using default strategy");
            e.printStackTrace();
            return this.b;
        }
    }

    private void removeStrategiesMapSpecific() {
        Consumer<Strategy> removeStrat = strat -> {
            this.strategies.remove(strat.name);
            this.nameStrat.remove(strat.name);
        };
        if (Ecgberht.getGs().getGame().getBWMap().mapHash().equals("666dd28cd3c85223ebc749a481fc281e58221e4a")) {
            removeStrat.accept(this.pER);
            removeStrat.accept(this.bbs);
            removeStrat.accept(this.tNK);
            removeStrat.accept(this.jOR);
        }
    }
}

