/*
 * Decompiled with CFR 0.152.
 */
package ecgberht.Simulation;

import ecgberht.Clustering.Cluster;
import ecgberht.Clustering.MeanShift;
import ecgberht.ConfigManager;
import ecgberht.Ecgberht;
import ecgberht.IntelligenceAgency;
import ecgberht.Simulation.SimInfo;
import ecgberht.UnitInfo;
import ecgberht.Util.MutablePair;
import ecgberht.Util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import org.bk.ass.sim.Agent;
import org.bk.ass.sim.BWAPI4JAgentFactory;
import org.bk.ass.sim.Evaluator;
import org.bk.ass.sim.Simulator;
import org.openbw.bwapi4j.BW;
import org.openbw.bwapi4j.Position;
import org.openbw.bwapi4j.type.Color;
import org.openbw.bwapi4j.type.Order;
import org.openbw.bwapi4j.type.TechType;
import org.openbw.bwapi4j.type.UnitType;
import org.openbw.bwapi4j.type.WeaponType;
import org.openbw.bwapi4j.unit.AirAttacker;
import org.openbw.bwapi4j.unit.Attacker;
import org.openbw.bwapi4j.unit.DarkTemplar;
import org.openbw.bwapi4j.unit.Dropship;
import org.openbw.bwapi4j.unit.Firebat;
import org.openbw.bwapi4j.unit.Goliath;
import org.openbw.bwapi4j.unit.GroundAttacker;
import org.openbw.bwapi4j.unit.Marine;
import org.openbw.bwapi4j.unit.Medic;
import org.openbw.bwapi4j.unit.MobileUnit;
import org.openbw.bwapi4j.unit.PlayerUnit;
import org.openbw.bwapi4j.unit.SCV;
import org.openbw.bwapi4j.unit.SiegeTank;
import org.openbw.bwapi4j.unit.Unit;
import org.openbw.bwapi4j.unit.Vulture;
import org.openbw.bwapi4j.unit.Worker;
import org.openbw.bwapi4j.unit.Wraith;

public class SimulationTheory {
    public long time;
    private List<Cluster> friendly = new ArrayList<Cluster>();
    private List<Cluster> enemies = new ArrayList<Cluster>();
    private List<SimInfo> simulations = new ArrayList<SimInfo>();
    private Simulator simulator;
    private BWAPI4JAgentFactory factory;
    private Evaluator evaluator;
    private int radius = UnitType.Terran_Siege_Tank_Siege_Mode.groundWeapon().maxRange();
    private int simFrames = 500;
    private int iterations = 10;

    public SimulationTheory(BW bw) {
        this.simulator = new Simulator.Builder().build();
        this.evaluator = new Evaluator();
        this.factory = new BWAPI4JAgentFactory(bw.getBWMap());
        if (ConfigManager.getConfig().ecgConfig.sscait) {
            this.simFrames = 300;
            this.iterations = 0;
        }
        switch (bw.getInteractionHandler().enemy().getRace()) {
            case Zerg: {
                this.radius = UnitType.Zerg_Sunken_Colony.groundWeapon().maxRange();
                break;
            }
            case Terran: {
                this.radius = UnitType.Terran_Missile_Turret.airWeapon().maxRange();
                break;
            }
            case Protoss: {
                this.radius = UnitType.Protoss_Photon_Cannon.groundWeapon().maxRange();
                break;
            }
            case Unknown: {
                this.radius = UnitType.Terran_Siege_Tank_Siege_Mode.groundWeapon().maxRange();
            }
        }
    }

    private void updateRadius() {
        if (this.radius == UnitType.Terran_Siege_Tank_Siege_Mode.groundWeapon().maxRange()) {
            return;
        }
        if (Util.countUnitTypeSelf(UnitType.Terran_Siege_Tank_Tank_Mode) > 0 && Ecgberht.getGs().getPlayer().hasResearched(TechType.Tank_Siege_Mode)) {
            this.radius = UnitType.Terran_Siege_Tank_Siege_Mode.groundWeapon().maxRange();
            return;
        }
        switch (Ecgberht.getGs().enemyRace) {
            case Zerg: {
                if (!Ecgberht.getGs().getPlayer().hasResearched(TechType.Irradiate)) break;
                this.radius = WeaponType.Irradiate.maxRange();
                return;
            }
            case Terran: {
                if (Ecgberht.getGs().getStrat() != null && Ecgberht.getGs().getStrat().proxy && this.radius == UnitType.Terran_Missile_Turret.airWeapon().maxRange()) {
                    this.radius -= 32;
                }
                if (!IntelligenceAgency.enemyHasType(UnitType.Terran_Siege_Tank_Tank_Mode)) break;
                this.radius = UnitType.Terran_Siege_Tank_Siege_Mode.groundWeapon().maxRange();
                return;
            }
            case Protoss: {
                if (!Ecgberht.getGs().getPlayer().hasResearched(TechType.EMP_Shockwave)) break;
                this.radius = WeaponType.EMP_Shockwave.maxRange();
                return;
            }
        }
    }

    private void reset() {
        this.friendly.clear();
        this.enemies.clear();
        this.simulations.clear();
    }

    private void createClusters() {
        ArrayList<UnitInfo> myUnits = new ArrayList<UnitInfo>();
        for (UnitInfo u : Ecgberht.getGs().myArmy) {
            if (!this.isArmyUnit(u.unit)) continue;
            myUnits.add(u);
        }
        Ecgberht.getGs().DBs.keySet().stream().map(b -> Ecgberht.getGs().unitStorage.getAllyUnits().get(b)).forEach(myUnits::add);
        Ecgberht.getGs().agents.values().stream().map(g -> g.unitInfo).forEach(myUnits::add);
        MeanShift clustering = new MeanShift(myUnits, this.radius);
        this.friendly = clustering.run(this.iterations);
        ArrayList<UnitInfo> enemyUnits = new ArrayList<UnitInfo>();
        for (UnitInfo u : Ecgberht.getGs().unitStorage.getEnemyUnits().values()) {
            if (Ecgberht.getGs().getStrat().proxy && u.unitType.isWorker() && Util.isInOurBases(u) && !u.unit.isAttacking() || u.unitType == UnitType.Zerg_Larva || u.unitType == UnitType.Zerg_Egg && !u.player.isNeutral() || !Util.isStaticDefense(u.unitType) && !u.burrowed && u.unitType != UnitType.Terran_Siege_Tank_Siege_Mode && Ecgberht.getGs().frameCount - u.lastVisibleFrame > 96) continue;
            enemyUnits.add(u);
        }
        clustering = new MeanShift(enemyUnits, this.radius);
        this.enemies = clustering.run(this.iterations);
    }

    private boolean isArmyUnit(Unit u) {
        try {
            if (u == null || !u.exists()) {
                return false;
            }
            if (u instanceof SCV && (Ecgberht.getGs().getStrat().name.equals("ProxyBBS") || Ecgberht.getGs().getStrat().name.equals("ProxyEightRax"))) {
                return true;
            }
            if (u instanceof MobileUnit && ((MobileUnit)u).getTransport() != null) {
                return false;
            }
            return u instanceof Marine || u instanceof Medic || u instanceof SiegeTank || u instanceof Firebat || u instanceof Vulture || u instanceof Wraith || u instanceof Goliath || u instanceof Dropship;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void onFrameSim() {
        this.time = System.currentTimeMillis();
        this.updateRadius();
        this.reset();
        this.createClusters();
        if (!this.friendly.isEmpty()) {
            this.createSimInfos();
            this.doSimASS();
            Ecgberht.getGs().sqManager.createSquads(this.friendly);
        }
        this.time = System.currentTimeMillis() - this.time;
    }

    private boolean noNeedForSim() {
        int workerThreats = 0;
        if ((this.friendly.isEmpty() || this.enemies.isEmpty()) && Ecgberht.getGs().agents.isEmpty()) {
            return true;
        }
        for (Comparable<Unit> u2 : Ecgberht.getGs().enemyCombatUnitMemory) {
            if (u2 instanceof Attacker && !(u2 instanceof Worker) || workerThreats > 1) {
                return false;
            }
            if (!(u2 instanceof Worker) || !((Worker)u2).isAttacking()) continue;
            ++workerThreats;
        }
        for (Comparable<Unit> u2 : Ecgberht.getGs().unitStorage.getEnemyUnits().values().stream().filter(u -> u.unitType.isBuilding()).collect(Collectors.toSet())) {
            if (!(((UnitInfo)u2).unit instanceof Attacker) || !((UnitInfo)u2).visible) continue;
            return false;
        }
        return true;
    }

    private boolean closeClusters(Cluster c1, Cluster c2) {
        return Util.broodWarDistance(c1.mode(), c2.mode()) <= (double)this.radius + Math.max(c1.maxDistFromCenter, c2.maxDistFromCenter) * 1.3;
    }

    private void createSimInfos() {
        for (Cluster friend : this.friendly) {
            if (friend.units.isEmpty()) continue;
            SimInfo aux = new SimInfo(friend);
            for (Cluster enemy : this.enemies) {
                if (enemy.units.isEmpty() || !this.closeClusters(friend, enemy)) continue;
                aux.enemies.addAll(enemy.units);
            }
            aux.allies.addAll(friend.units);
            this.simulations.add(aux);
        }
        ArrayList<SimInfo> newSims = new ArrayList<SimInfo>();
        for (SimInfo s : this.simulations) {
            SimInfo air = new SimInfo();
            SimInfo ground = new SimInfo();
            for (UnitInfo u : s.allies) {
                if (u.flying) {
                    air.allies.add(u);
                    continue;
                }
                ground.allies.add(u);
            }
            boolean emptyAir = air.allies.isEmpty();
            boolean emptyGround = ground.allies.isEmpty();
            if (emptyAir && emptyGround) continue;
            for (UnitInfo u : s.enemies) {
                if (u.unit instanceof AirAttacker || u.unitType == UnitType.Terran_Bunker) {
                    air.enemies.add(u);
                }
                if (!(u.unit instanceof GroundAttacker) && u.unitType != UnitType.Terran_Bunker && u.unitType != UnitType.Zerg_Creep_Colony) continue;
                ground.enemies.add(u);
            }
            air.type = SimInfo.SimType.AIR;
            newSims.add(air);
            ground.type = SimInfo.SimType.GROUND;
            newSims.add(ground);
        }
        if (!newSims.isEmpty()) {
            this.simulations.addAll(newSims);
        }
    }

    private MutablePair<Integer, Integer> scores() {
        ToIntFunction<Agent> score = a -> {
            PlayerUnit unit = (PlayerUnit)a.getUserObject();
            if (unit == null) {
                return 0;
            }
            UnitType unitType = unit.getType();
            int result = unitType.destroyScore() * (a.getHealth() * 3 + a.getShields() + 1) / (unitType.maxHitPoints() * 3 + unitType.maxShields());
            if (unitType == UnitType.Terran_Bunker) {
                result += UnitType.Terran_Marine.destroyScore() * 4;
            }
            return result;
        };
        return new MutablePair<Integer, Integer>(this.simulator.getAgentsA().stream().mapToInt(score).sum(), this.simulator.getAgentsB().stream().mapToInt(score).sum());
    }

    private void doSimASS() {
        int energy = Ecgberht.getGs().CSs.stream().filter(s -> s.getOrder() != Order.CastScannerSweep).mapToInt(s -> s.getEnergy() / 50).sum();
        for (SimInfo s2 : this.simulations) {
            try {
                Agent jU;
                this.simulator.reset();
                if (s2.enemies.isEmpty()) continue;
                for (UnitInfo u : s2.allies) {
                    jU = this.factory.of(u.unit);
                    this.simulator.addAgentA(jU);
                    ((Collection)s2.stateBefore.first).add(jU);
                }
                for (UnitInfo u : s2.enemies) {
                    if (u.unitType.isWorker() && u.visible && !u.unit.isAttacking() || u.unitType.isBuilding() && !u.completed || u.unitType == UnitType.Zerg_Creep_Colony || !Util.isStaticDefense(u) && !u.unitType.canAttack()) continue;
                    if (!u.unit.isDetected() && (u.unit instanceof DarkTemplar || u.burrowed)) {
                        if (energy >= 1) {
                            --energy;
                        } else {
                            s2.lose = true;
                            break;
                        }
                    }
                    jU = this.factory.of(u.unit);
                    this.simulator.addAgentB(jU);
                    ((Collection)s2.stateBefore.second).add(jU);
                }
                if (s2.lose) continue;
                s2.preSimScore = this.scores();
                double estimate = this.evaluator.evaluate((Collection)s2.stateBefore.first, (Collection)s2.stateBefore.second);
                if (estimate < 0.1) {
                    s2.lose = true;
                    continue;
                }
                if (estimate > 0.6) continue;
                this.simulator.simulate(this.simFrames);
                s2.postSimScore = this.scores();
                s2.stateAfter = new MutablePair<Collection<Agent>, Collection<Agent>>(this.simulator.getAgentsA(), this.simulator.getAgentsB());
                int ourLosses = (Integer)s2.preSimScore.first - (Integer)s2.postSimScore.first;
                int enemyLosses = (Integer)s2.preSimScore.second - (Integer)s2.postSimScore.second;
                if (((Collection)s2.stateAfter.first).isEmpty()) {
                    s2.lose = true;
                    continue;
                }
                if ((double)enemyLosses > (double)ourLosses * 1.35) continue;
                this.simulator.simulate(this.simFrames);
                s2.postSimScore = this.scores();
                s2.stateAfter = new MutablePair<Collection<Agent>, Collection<Agent>>(this.simulator.getAgentsA(), this.simulator.getAgentsB());
                if (((Collection)s2.stateAfter.first).isEmpty()) {
                    s2.lose = true;
                    continue;
                }
                if (Ecgberht.getGs().getStrat().name.equals("ProxyBBS")) {
                    s2.lose = !this.scoreCalcASS(s2, 1.2);
                    continue;
                }
                if (Ecgberht.getGs().getStrat().name.equals("ProxyEightRax")) {
                    s2.lose = !this.scoreCalcASS(s2, 1.35);
                    continue;
                }
                s2.lose = !this.scoreCalcASS(s2, 2.0);
            }
            catch (Exception e) {
                System.err.println("Simulator ASS exception");
                e.printStackTrace();
            }
        }
    }

    private boolean scoreCalcASS(SimInfo s, double rate) {
        return (double)((Integer)s.preSimScore.second - (Integer)s.postSimScore.second) * rate <= (double)((Integer)s.preSimScore.first - (Integer)s.postSimScore.first);
    }

    private void drawCluster(Cluster c, boolean ally, int id) {
        Color color = Color.RED;
        if (ally) {
            color = Color.GREEN;
        }
        Position centroid = new Position((int)c.modeX, (int)c.modeY);
        Ecgberht.getGs().getGame().getMapDrawer().drawCircleMap(centroid, 4, color, true);
        for (UnitInfo u : c.units) {
            Ecgberht.getGs().getGame().getMapDrawer().drawLineMap(u.lastPosition, centroid, color);
        }
    }

    public void drawClusters() {
        int cluster = 0;
        for (Cluster c : this.friendly) {
            this.drawCluster(c, true, cluster);
            ++cluster;
        }
        cluster = 0;
        for (Cluster c : this.enemies) {
            this.drawCluster(c, false, cluster);
            ++cluster;
        }
    }

    public MutablePair<Boolean, Boolean> simulateDefenseBattle(Set<UnitInfo> friends, Set<Unit> enemies, int frames, boolean bunker) {
        this.simulator.reset();
        MutablePair<Boolean, Boolean> result = new MutablePair<Boolean, Boolean>(true, false);
        for (UnitInfo unitInfo : friends) {
            this.simulator.addAgentA(this.factory.of(unitInfo.unit));
        }
        for (Unit unit : enemies) {
            this.simulator.addAgentB(this.factory.of((PlayerUnit)unit));
        }
        MutablePair<Integer, Integer> presim_scores = this.scores();
        this.simulator.simulate(frames);
        MutablePair<Integer, Integer> mutablePair = this.scores();
        int my_score_diff = (Integer)presim_scores.first - (Integer)mutablePair.first;
        int enemy_score_diff = (Integer)presim_scores.second - (Integer)mutablePair.second;
        if (enemy_score_diff * 2 < my_score_diff) {
            result.first = false;
        }
        if (bunker) {
            boolean bunkerDead = true;
            for (Agent unit : this.simulator.getAgentsA()) {
                if (unit == null || unit.getUserObject() == null || ((Unit)unit.getUserObject()).getType() != UnitType.Terran_Bunker) continue;
                bunkerDead = false;
                break;
            }
            if (bunkerDead) {
                result.second = true;
            }
        }
        return result;
    }

    public boolean simulateHarass(Unit harasser, Set<UnitInfo> enemies, int frames) {
        this.simulator.reset();
        this.simulator.addAgentA(this.factory.of((PlayerUnit)harasser));
        for (UnitInfo u : enemies) {
            this.simulator.addAgentB(this.factory.of(u.unit));
        }
        int preSimFriendlyUnitCount = this.simulator.getAgentsA().size();
        this.simulator.simulate(frames);
        int postSimFriendlyUnitCount = this.simulator.getAgentsA().size();
        int myLosses = preSimFriendlyUnitCount - postSimFriendlyUnitCount;
        return myLosses <= 0;
    }

    public SimInfo getSimulation(UnitInfo unit, SimInfo.SimType type) {
        for (SimInfo s : this.simulations) {
            if (s.type != type || !s.allies.contains(unit)) continue;
            return s;
        }
        return new SimInfo();
    }

    public SimInfo getSimulation(UnitInfo unit, boolean enemy) {
        for (SimInfo s : this.simulations) {
            if (!enemy && s.allies.contains(unit)) {
                return s;
            }
            if (!enemy || !s.enemies.contains(unit)) continue;
            return s;
        }
        return new SimInfo();
    }

    public boolean farFromFight(UnitInfo u, SimInfo s, boolean melee) {
        if (u == null || !u.unit.exists()) {
            return true;
        }
        if (s.enemies.isEmpty()) {
            return true;
        }
        for (UnitInfo e : s.enemies) {
            boolean isThreat = Util.canAttack(e, u);
            if (!isThreat || u.getDistance(e) > (!melee ? 32 : 96) + Util.getAttackRange(e, u)) continue;
            return false;
        }
        return true;
    }

    public SimInfo getSimulation(Cluster c) {
        for (SimInfo s : this.simulations) {
            if (!s.allyCluster.equals(c)) continue;
            return s;
        }
        return new SimInfo();
    }
}

