/*
 * Decompiled with CFR 0.152.
 */
package ecgberht;

import bwem.Area;
import bwem.BWEM;
import bwem.Base;
import bwem.ChokePoint;
import bwem.Geyser;
import bwem.Mineral;
import bwem.Neutral;
import bwem.StaticBuilding;
import ecgberht.Agents.Agent;
import ecgberht.Agents.DropShipAgent;
import ecgberht.Agents.VesselAgent;
import ecgberht.Agents.WraithAgent;
import ecgberht.BaseManager;
import ecgberht.BuildingMap;
import ecgberht.Cartographer;
import ecgberht.ConfigManager;
import ecgberht.IntelligenceAgency;
import ecgberht.LearningManager;
import ecgberht.Simulation.SimulationTheory;
import ecgberht.SpellsManager;
import ecgberht.Squad;
import ecgberht.SquadManager;
import ecgberht.Strategy;
import ecgberht.StrategyManager;
import ecgberht.SupplyMan;
import ecgberht.UnitInfo;
import ecgberht.UnitStorage;
import ecgberht.Util.BaseLocationComparator;
import ecgberht.Util.MutablePair;
import ecgberht.Util.Util;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openbw.bwapi4j.BW;
import org.openbw.bwapi4j.InteractionHandler;
import org.openbw.bwapi4j.Player;
import org.openbw.bwapi4j.Position;
import org.openbw.bwapi4j.TilePosition;
import org.openbw.bwapi4j.WalkPosition;
import org.openbw.bwapi4j.type.Order;
import org.openbw.bwapi4j.type.Race;
import org.openbw.bwapi4j.type.TechType;
import org.openbw.bwapi4j.type.UnitType;
import org.openbw.bwapi4j.type.UpgradeType;
import org.openbw.bwapi4j.unit.Addon;
import org.openbw.bwapi4j.unit.Assimilator;
import org.openbw.bwapi4j.unit.Barracks;
import org.openbw.bwapi4j.unit.Building;
import org.openbw.bwapi4j.unit.Bunker;
import org.openbw.bwapi4j.unit.CommandCenter;
import org.openbw.bwapi4j.unit.ComsatStation;
import org.openbw.bwapi4j.unit.ExtendibleByAddon;
import org.openbw.bwapi4j.unit.Factory;
import org.openbw.bwapi4j.unit.GasMiningFacility;
import org.openbw.bwapi4j.unit.Mechanical;
import org.openbw.bwapi4j.unit.MineralPatch;
import org.openbw.bwapi4j.unit.MissileTurret;
import org.openbw.bwapi4j.unit.MobileUnit;
import org.openbw.bwapi4j.unit.PlayerUnit;
import org.openbw.bwapi4j.unit.ResearchingFacility;
import org.openbw.bwapi4j.unit.SCV;
import org.openbw.bwapi4j.unit.ScienceVessel;
import org.openbw.bwapi4j.unit.SiegeTank;
import org.openbw.bwapi4j.unit.Starport;
import org.openbw.bwapi4j.unit.SupplyDepot;
import org.openbw.bwapi4j.unit.TrainingFacility;
import org.openbw.bwapi4j.unit.Unit;
import org.openbw.bwapi4j.unit.VespeneGeyser;
import org.openbw.bwapi4j.unit.Vulture;
import org.openbw.bwapi4j.unit.Worker;
import org.openbw.bwapi4j.unit.Wraith;

public class GameState {
    public Area enemyMainArea = null;
    public Area enemyNaturalArea = null;
    public Area naturalArea = null;
    public Base chosenIsland = null;
    public Base enemyMainBase = null;
    public Base enemyNaturalBase = null;
    public Base enemyStartBase = null;
    public BaseManager baseManager = null;
    public boolean defense = false;
    public boolean enemyIsRandom = true;
    public boolean firstTerranCheese = false;
    public boolean firstScout = true;
    public boolean iReallyWantToExpand = false;
    public boolean islandExpand;
    public Building chosenBuildingLot = null;
    public Mechanical chosenUnitRepair = null;
    public BuildingMap map;
    public BuildingMap testMap;
    public ChokePoint mainChoke = null;
    public ChokePoint naturalChoke = null;
    public DropShipAgent chosenDropShip;
    public LearningManager learningManager;
    public ExtendibleByAddon chosenBuildingAddon = null;
    public int builtBuildings;
    public int builtRefinery;
    public int frameCount;
    public int mapSize = 2;
    public int maxWraiths = 6;
    public int maxBats = 0;
    public int mining;
    public int startCount;
    public int vulturesTrained = 0;
    public int wraithsTrained = 0;
    public int tanksTrained = 0;
    public int workerCountToSustain = 0;
    public List<Base> blockedBLs = new ArrayList<Base>();
    public List<Base> BLs = new ArrayList<Base>();
    public List<Base> enemyBLs = new ArrayList<Base>();
    public List<Base> specialBLs = new ArrayList<Base>();
    public Map<Base, MutablePair<MineralPatch, MineralPatch>> fortressSpecialBLs = new HashMap<Base, MutablePair<MineralPatch, MineralPatch>>();
    public Map<Base, CommandCenter> CCs = new LinkedHashMap<Base, CommandCenter>();
    public Map<Base, CommandCenter> islandCCs = new HashMap<Base, CommandCenter>();
    public Map<Base, Neutral> blockedBases = new HashMap<Base, Neutral>();
    public Map<Bunker, Set<UnitInfo>> DBs = new TreeMap<Bunker, Set<UnitInfo>>();
    public Map<GasMiningFacility, Integer> refineriesAssigned = new TreeMap<GasMiningFacility, Integer>();
    public Map<MineralPatch, Integer> mineralsAssigned = new TreeMap<MineralPatch, Integer>();
    public Map<Player, Integer> players = new HashMap<Player, Integer>();
    public Map<Position, MineralPatch> blockingMinerals = new LinkedHashMap<Position, MineralPatch>();
    public Map<SCV, Mechanical> repairerTask = new TreeMap<SCV, Mechanical>();
    public Map<SCV, Building> workerTask = new TreeMap<SCV, Building>();
    public Map<SCV, MutablePair<UnitType, TilePosition>> workerBuild = new HashMap<SCV, MutablePair<UnitType, TilePosition>>();
    public Map<Unit, Agent> agents = new TreeMap<Unit, Agent>();
    public Map<VespeneGeyser, Boolean> vespeneGeysers = new TreeMap<VespeneGeyser, Boolean>();
    public Map<Worker, GasMiningFacility> workerGas = new TreeMap<Worker, GasMiningFacility>();
    public Map<Worker, MineralPatch> workerMining = new TreeMap<Worker, MineralPatch>();
    public Map<Worker, Position> workerDefenders = new TreeMap<Worker, Position>();
    public MutablePair<Base, Unit> mainCC = null;
    public MutablePair<Integer, Integer> deltaCash = new MutablePair<Integer, Integer>(0, 0);
    public Player neutral = null;
    public Position attackPosition;
    public Position defendPosition = null;
    public Race enemyRace = Race.Unknown;
    public ResearchingFacility chosenUnitUpgrader = null;
    public SCV chosenRepairer = null;
    public Set<Barracks> MBs = new TreeSet<Barracks>();
    public Set<Base> islandBases = new HashSet<Base>();
    public Set<Base> scoutSLs = new HashSet<Base>();
    public Set<Base> SLs = new HashSet<Base>();
    public Set<Building> buildingLot = new TreeSet<Building>();
    public Set<ComsatStation> CSs = new TreeSet<ComsatStation>();
    public Set<Factory> Fs = new TreeSet<Factory>();
    public Set<MissileTurret> Ts = new TreeSet<MissileTurret>();
    public Set<ResearchingFacility> UBs = new TreeSet<ResearchingFacility>();
    public Set<Starport> Ps = new TreeSet<Starport>();
    public Set<UnitInfo> myArmy = new TreeSet<UnitInfo>();
    public Set<SupplyDepot> SBs = new TreeSet<SupplyDepot>();
    public Set<Unit> enemyCombatUnitMemory = new TreeSet<Unit>();
    public Set<Unit> enemyInBase = new TreeSet<Unit>();
    public Set<Worker> workerIdle = new TreeSet<Worker>();
    public SimulationTheory sim;
    public SquadManager sqManager = new SquadManager();
    public SpellsManager wizard = new SpellsManager();
    public SupplyMan supplyMan;
    public TechType chosenResearch = null;
    public MutablePair<ComsatStation, Position> checkScan = null;
    public TilePosition chosenPosition = null;
    public TilePosition initDefensePosition = null;
    public TrainingFacility chosenTrainingFacility = null;
    public MobileUnit chosenScout = null;
    public Unit chosenUnitToHarass = null;
    public UnitType chosenAddon = null;
    public UnitType chosenToBuild = UnitType.None;
    public Position mapCenter = new Position(0, 0);
    public UnitType chosenUnit = UnitType.None;
    public UpgradeType chosenUpgrade = null;
    public Worker chosenHarasser = null;
    public Set<MineralPatch> walkingMinerals = new TreeSet<MineralPatch>();
    public Worker chosenWorker = null;
    public Worker chosenWorkerDrop = null;
    public boolean explore = false;
    public boolean firstExpand = true;
    public int maxGoliaths = 0;
    public Cartographer silentCartographer;
    public double luckyDraw;
    public List<TilePosition> fortressSpecialBLsTiles = new ArrayList<TilePosition>(Arrays.asList(new TilePosition(7, 7), new TilePosition(117, 7), new TilePosition(7, 118), new TilePosition(117, 118)));
    public Building disrupterBuilding = null;
    public Building proxyBuilding = null;
    public BW bw;
    public Worker naughtySCV = null;
    public int maxVessels = 0;
    InteractionHandler ih;
    public BWEM bwem;
    protected Player self;
    public StrategyManager scipio;
    public UnitStorage unitStorage = new UnitStorage();
    Set<String> shipNames = new TreeSet<String>(Arrays.asList("Adriatic", "Aegis Fate", "Agincourt", "Allegiance", "Apocalypso", "Athens", "Beatrice", "Bloodied Spirit", "Callisto", "Clarity of Faith", "Dawn Under Heaven", "Forward Unto Dawn", "Gettysburg", "Grafton", "Halcyon", "Hannibal", "Harbinger of Piety", "High Charity", "In Amber Clad", "Infinity", "Jericho", "Las Vegas", "Lawgiver", "Leviathan", "Long Night of Solace", "Matador", "Penance", "Persephone", "Pillar of Autumn", "Pitiless", "Pompadour", "Providence", "Revenant", "Savannah", "Shadow of Intent", "Spirit of Fire", "Tharsis", "Thermopylae"));

    public GameState(BW bw, BWEM bwem) {
        this.bw = bw;
        this.ih = bw.getInteractionHandler();
        this.self = bw.getInteractionHandler().self();
        this.bwem = bwem;
        this.learningManager = new LearningManager(this.ih.enemy().getName(), this.ih.enemy().getRace());
        this.initPlayers();
        this.mapSize = bw.getBWMap().getStartPositions().size();
        this.mapCenter = new TilePosition(bw.getBWMap().mapWidth() / 2, bw.getBWMap().mapHeight() / 2).toPosition();
        this.supplyMan = new SupplyMan(this.self.getRace());
        this.sim = new SimulationTheory(bw);
        this.luckyDraw = Math.random();
    }

    private void initPlayers() {
        for (Player p : this.bw.getAllPlayers()) {
            if (p.isNeutral()) {
                this.players.put(p, 0);
                this.neutral = p;
                continue;
            }
            if (this.ih.allies().contains(p) || p.equals(this.self)) {
                this.players.put(p, 1);
                continue;
            }
            if (!this.ih.enemies().contains(p)) continue;
            this.players.put(p, -1);
            IntelligenceAgency.enemyBases.put(p, new TreeSet());
            IntelligenceAgency.enemyTypes.put(p, new HashSet());
        }
    }

    void initEnemyRace() {
        if (this.ih.enemy().getRace() != Race.Unknown) {
            this.enemyRace = this.ih.enemy().getRace();
            this.enemyIsRandom = false;
        }
    }

    void initBlockingMinerals() {
        int amount = 0;
        if (this.bw.getBWMap().mapHash().equals("cd5d907c30d58333ce47c88719b6ddb2cba6612f")) {
            amount = 16;
        }
        for (MineralPatch u : this.bw.getMineralPatches()) {
            if (u.getResources() > amount) continue;
            this.blockingMinerals.put(u.getPosition(), u);
        }
        for (Base b : this.BLs) {
            if (b.isStartingLocation() || this.bw.getBWMap().getStartPositions().contains(b.getLocation()) || this.skipWeirdBlocking(b)) continue;
            if (this.weirdBlocking(b)) {
                this.blockedBLs.add(b);
                continue;
            }
            for (ChokePoint p : b.getArea().getChokePoints()) {
                Neutral n = p.getBlockingNeutral();
                if (n == null || !n.getBlockedAreas().contains(b.getArea())) continue;
                this.blockedBases.put(b, n);
                this.blockedBLs.add(b);
            }
        }
    }

    private boolean skipWeirdBlocking(Base b) {
        if (this.bw.getBWMap().mapHash().equals("cd5d907c30d58333ce47c88719b6ddb2cba6612f")) {
            return b.getLocation().equals(new TilePosition(25, 67)) || b.getLocation().equals(new TilePosition(99, 67));
        }
        return false;
    }

    private boolean weirdBlocking(Base b) {
        if (this.bw.getBWMap().mapHash().equals("4e24f217d2fe4dbfa6799bc57f74d8dc939d425b")) {
            return b.getLocation().equals(new TilePosition(6, 119));
        }
        return false;
    }

    void checkBasesWithBLockingMinerals() {
        if (this.blockingMinerals.isEmpty()) {
            return;
        }
        for (Base b : this.BLs) {
            if (b.isStartingLocation() || this.bw.getBWMap().getStartPositions().contains(b.getLocation()) || this.skipWeirdBlocking(b)) continue;
            block1: for (ChokePoint c : b.getArea().getChokePoints()) {
                for (Position m : this.blockingMinerals.keySet()) {
                    if (!(Util.broodWarDistance(m, c.getCenter().toPosition()) < 40.0)) continue;
                    this.blockedBLs.add(b);
                    continue block1;
                }
            }
        }
    }

    public void playSound(String soundFile) {
        try {
            if (!ConfigManager.getConfig().ecgConfig.sounds) {
                return;
            }
            String run = this.getClass().getResource("GameState.class").toString();
            if (run.startsWith("jar:") || run.startsWith("rsrc:")) {
                InputStream fis = this.getClass().getClassLoader().getResourceAsStream(soundFile);
                javazoom.jl.player.Player playMP3 = new javazoom.jl.player.Player(fis);
                new Thread(() -> {
                    try {
                        playMP3.play();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }).start();
            } else {
                soundFile = "src\\" + soundFile;
                FileInputStream fis = new FileInputStream(soundFile);
                javazoom.jl.player.Player playMP3 = new javazoom.jl.player.Player(fis);
                new Thread(() -> {
                    try {
                        playMP3.play();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }).start();
            }
        }
        catch (Exception e) {
            System.err.println("playSound");
            e.printStackTrace();
        }
    }

    public BW getGame() {
        return this.bw;
    }

    public InteractionHandler getIH() {
        return this.ih;
    }

    public Player getPlayer() {
        return this.self;
    }

    void addNewResources(Base base) {
        List<Mineral> minerals = base.getMinerals();
        List<Geyser> gas = base.getGeysers();
        minerals.forEach(m -> this.mineralsAssigned.put((MineralPatch)m.getUnit(), 0));
        gas.forEach(g -> this.vespeneGeysers.put((VespeneGeyser)g.getUnit(), false));
        if (this.getStrat().name.equals("ProxyBBS")) {
            this.workerCountToSustain = (int)this.mineralGatherRateNeeded(Arrays.asList(UnitType.Terran_Marine, UnitType.Terran_Marine));
        } else if (this.getStrat().name.equals("ProxyEightRax")) {
            this.workerCountToSustain = (int)this.mineralGatherRateNeeded(Collections.singletonList(UnitType.Terran_Marine));
        }
    }

    void removeResources(Unit unit) {
        List<Mineral> minerals = Util.getClosestBaseLocation(unit.getPosition()).getMinerals();
        List<Geyser> gas = Util.getClosestBaseLocation(unit.getPosition()).getGeysers();
        for (Mineral m : minerals) {
            if (!this.mineralsAssigned.containsKey(m.getUnit())) continue;
            ArrayList<Worker> arrayList = new ArrayList<Worker>();
            for (Map.Entry<Worker, MineralPatch> entry : this.workerMining.entrySet()) {
                if (!m.getUnit().equals(entry.getValue())) continue;
                arrayList.add(entry.getKey());
                this.workerIdle.add(entry.getKey());
            }
            for (Unit unit2 : arrayList) {
                this.workerMining.remove(unit2);
            }
            this.mineralsAssigned.remove(m.getUnit());
        }
        for (Geyser g : gas) {
            VespeneGeyser vespeneGeyser = (VespeneGeyser)g.getUnit();
            this.vespeneGeysers.remove(vespeneGeyser);
        }
        ArrayList<GasMiningFacility> auxGas = new ArrayList<GasMiningFacility>();
        for (Map.Entry<GasMiningFacility, Integer> entry : this.refineriesAssigned.entrySet()) {
            for (Geyser geyser : gas) {
                if (!entry.getKey().equals(geyser.getUnit())) continue;
                ArrayList<Worker> aux = new ArrayList<Worker>();
                for (Map.Entry<Worker, GasMiningFacility> w : this.workerGas.entrySet()) {
                    if (!entry.getKey().equals(w.getValue())) continue;
                    aux.add(w.getKey());
                    this.workerIdle.add(w.getKey());
                }
                for (Worker u : aux) {
                    this.workerGas.remove(u);
                }
                auxGas.add(entry.getKey());
            }
        }
        for (Unit unit3 : auxGas) {
            this.refineriesAssigned.remove(unit3);
        }
        if (this.getStrat().name.equals("ProxyBBS")) {
            this.workerCountToSustain = (int)this.mineralGatherRateNeeded(Arrays.asList(UnitType.Terran_Marine, UnitType.Terran_Marine));
        } else if (this.getStrat().name.equals("ProxyEightRax")) {
            this.workerCountToSustain = (int)this.mineralGatherRateNeeded(Collections.singletonList(UnitType.Terran_Marine));
        }
    }

    public MutablePair<Integer, Integer> getCash() {
        return new MutablePair<Integer, Integer>(this.self.minerals(), this.self.gas());
    }

    public int getSupply() {
        return this.self.supplyTotal() - this.self.supplyUsed();
    }

    void initStartLocations() {
        Base startBot = Util.getClosestBaseLocation(this.self.getStartLocation().toPosition());
        for (Base b : this.bwem.getMap().getBases()) {
            if (!b.isStartingLocation() && !this.bw.getBWMap().getStartPositions().contains(b.getLocation()) || b.getLocation().equals(startBot.getLocation())) continue;
            this.SLs.add(b);
            this.scoutSLs.add(b);
        }
    }

    void initBaseLocations() {
        this.BLs.sort(new BaseLocationComparator(Util.getClosestBaseLocation(this.self.getStartLocation().toPosition())));
        if (this.getStrat().name.equals("PlasmaWraithHell")) {
            this.specialBLs.add(this.BLs.get(0));
            if (this.BLs.get(0).getLocation().equals(new TilePosition(77, 63))) {
                for (Base b : this.BLs) {
                    TilePosition pos = b.getLocation();
                    if (!pos.equals(new TilePosition(85, 42)) && !pos.equals(new TilePosition(85, 83))) continue;
                    this.specialBLs.add(b);
                }
                return;
            }
            if (this.BLs.get(0).getLocation().equals(new TilePosition(14, 110))) {
                for (Base b : this.BLs) {
                    TilePosition pos = b.getLocation();
                    if (!pos.equals(new TilePosition(39, 118)) && !pos.equals(new TilePosition(7, 90))) continue;
                    this.specialBLs.add(b);
                }
                return;
            }
            if (this.BLs.get(0).getLocation().equals(new TilePosition(14, 14))) {
                for (Base b : this.BLs) {
                    TilePosition pos = b.getLocation();
                    if (!pos.equals(new TilePosition(36, 6)) && !pos.equals(new TilePosition(7, 37))) continue;
                    this.specialBLs.add(b);
                }
            }
        }
    }

    void fix() {
        if (this.defense && this.enemyInBase.isEmpty()) {
            this.defense = false;
        }
        Iterator<Map.Entry<Unit, UnitInfo>> allyIT = this.unitStorage.getAllyUnits().entrySet().iterator();
        while (allyIT.hasNext()) {
            Map.Entry<Unit, UnitInfo> u = allyIT.next();
            if (u.getKey().exists()) continue;
            this.myArmy.remove(u.getValue());
            allyIT.remove();
        }
        this.DBs.values().forEach(s -> s.removeIf(u -> !u.unit.exists()));
        ArrayList<Worker> removeGas = new ArrayList<Worker>();
        for (Map.Entry<Worker, GasMiningFacility> entry : this.workerGas.entrySet()) {
            if (entry.getKey().isGatheringGas()) continue;
            removeGas.add(entry.getKey());
            this.refineriesAssigned.put(entry.getValue(), this.refineriesAssigned.get(entry.getValue()) - 1);
            entry.getKey().stop(false);
            this.workerIdle.add(entry.getKey());
        }
        for (Worker worker : removeGas) {
            this.workerGas.remove(worker);
        }
        if (this.frameCount % 350 == 0) {
            Map mineralCount = this.workerMining.values().stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
            for (Map.Entry entry : mineralCount.entrySet()) {
                this.mineralsAssigned.put((MineralPatch)entry.getKey(), Math.toIntExact((Long)entry.getValue()));
            }
        }
        for (PlayerUnit playerUnit : this.bw.getUnits(this.self)) {
            if (!playerUnit.exists() || !(playerUnit instanceof Building) || playerUnit instanceof Addon || playerUnit.equals(this.proxyBuilding) || playerUnit.getBuildUnit() != null || this.enemyNaturalBase == null || playerUnit.getTilePosition().equals(this.enemyNaturalBase.getLocation()) || playerUnit.isCompleted() || this.workerTask.values().contains(playerUnit) || this.buildingLot.contains(playerUnit)) continue;
            this.buildingLot.add((Building)playerUnit);
        }
        ArrayList<SCV> removeTask = new ArrayList<SCV>();
        for (Map.Entry<SCV, Building> entry : this.workerTask.entrySet()) {
            if (entry.getKey().exists() && entry.getKey().isConstructing() && !entry.getValue().isCompleted() && entry.getValue().exists()) continue;
            removeTask.add(entry.getKey());
        }
        for (Worker worker : removeTask) {
            this.workerTask.remove(worker);
            worker.stop(false);
            this.workerIdle.add(worker);
        }
        if (!this.getStrat().name.equals("PlasmaWraithHell") && this.chosenScout != null && ((Worker)this.chosenScout).isIdle()) {
            this.workerIdle.add((Worker)this.chosenScout);
            this.chosenScout = null;
        }
        ArrayList<SCV> arrayList = new ArrayList<SCV>();
        for (Map.Entry<SCV, MutablePair<UnitType, TilePosition>> entry : this.workerBuild.entrySet()) {
            if (this.bw.getBWMap().mapHash().equals("83320e505f35c65324e93510ce2eafbaa71c9aa1") && entry.getKey().isGatheringMinerals() || !entry.getKey().isIdle() && !entry.getKey().isGatheringGas() && !entry.getKey().isGatheringMinerals() || !(Util.broodWarDistance(entry.getKey().getPosition(), ((TilePosition)entry.getValue().second).toPosition()) > 100.0)) continue;
            arrayList.add(entry.getKey());
            MutablePair<Integer, Integer> mutablePair = this.deltaCash;
            Integer.valueOf((Integer)mutablePair.first - ((UnitType)entry.getValue().first).mineralPrice());
            mutablePair.first = mutablePair.first;
            MutablePair<Integer, Integer> mutablePair2 = this.deltaCash;
            Integer.valueOf((Integer)mutablePair2.second - ((UnitType)entry.getValue().first).gasPrice());
            mutablePair2.second = mutablePair2.second;
            this.workerIdle.add(entry.getKey());
        }
        for (Unit unit : arrayList) {
            this.workerBuild.remove(unit);
        }
        ArrayList<Worker> arrayList2 = new ArrayList<Worker>();
        for (Worker worker : this.workerDefenders.keySet()) {
            if (!worker.exists()) {
                arrayList2.add(worker);
                continue;
            }
            if (!worker.isIdle() && !worker.isGatheringMinerals()) continue;
            this.workerIdle.add(worker);
            arrayList2.add(worker);
        }
        for (Unit unit : arrayList2) {
            this.workerDefenders.remove(unit);
        }
    }

    void checkMainEnemyBase() {
        if (this.unitStorage.getEnemyUnits().values().stream().noneMatch(u -> u.unitType.isBuilding()) && this.scoutSLs.isEmpty()) {
            this.enemyMainBase = null;
            this.chosenScout = null;
            for (Base b : this.BLs) {
                if (this.CCs.containsKey(b) || !this.getStrat().name.equals("PlasmaWraithHell") && b.getArea().getAccessibleNeighbors().isEmpty()) continue;
                this.scoutSLs.add(b);
            }
        }
    }

    void initChokes() {
        try {
            double dist;
            this.naturalArea = this.BLs.get(1).getArea();
            Area mainRegion = this.BLs.get(0).getArea();
            double distBest = Double.MAX_VALUE;
            for (ChokePoint chokePoint : this.naturalArea.getChokePoints()) {
                dist = Util.getGroundDistance(chokePoint.getCenter().toPosition(), this.getPlayer().getStartLocation().toPosition());
                if (!(dist < distBest) || !(dist > 0.0)) continue;
                this.mainChoke = chokePoint;
                distBest = dist;
            }
            this.initDefensePosition = this.mainChoke != null ? this.mainChoke.getCenter().toTilePosition() : this.self.getStartLocation();
            if (Util.getGroundDistance(this.self.getStartLocation().toPosition(), this.bwem.getMap().getData().getMapData().getCenter()) < Util.getGroundDistance(this.BLs.get(1).getLocation().toPosition(), this.bwem.getMap().getData().getMapData().getCenter())) {
                this.naturalChoke = this.mainChoke;
                return;
            }
            if (this.bw.getBWMap().mapHash().compareTo("33527b4ce7662f83485575c4b1fcad5d737dfcf1") == 0 && this.BLs.get(0).getLocation().equals(new TilePosition(8, 9))) {
                this.naturalChoke = this.mainChoke;
                this.mainChoke = this.BLs.get(0).getArea().getChokePoints().get(0);
            } else if (this.bw.getBWMap().mapHash().compareTo("8000dc6116e405ab878c14bb0f0cde8efa4d640c") == 0 && (this.BLs.get(0).getLocation().equals(new TilePosition(117, 51)) || this.BLs.get(0).getLocation().equals(new TilePosition(43, 118)))) {
                this.naturalChoke = this.mainChoke;
                double distMax = Double.MAX_VALUE;
                for (ChokePoint p : this.BLs.get(0).getArea().getChokePoints()) {
                    double dist2 = p.getCenter().toPosition().getDistance(this.naturalChoke.getCenter().toPosition());
                    if (!(dist2 < distMax)) continue;
                    this.mainChoke = p;
                    distMax = dist2;
                }
                if (this.BLs.get(0).getLocation().equals(new TilePosition(117, 51))) {
                    distMax = Double.MIN_VALUE;
                    for (ChokePoint p : this.BLs.get(1).getArea().getChokePoints()) {
                        double dist2 = p.getCenter().toPosition().getDistance(this.mainChoke.getCenter().toPosition());
                        if (!(dist2 > distMax)) continue;
                        this.naturalChoke = p;
                        distMax = dist2;
                    }
                }
            } else if (this.bw.getBWMap().mapHash().compareTo("aab66dbf9c85f85c47c219277e1e36181fe5f9fc") != 0) {
                distBest = Double.MAX_VALUE;
                Area second = null;
                for (Area a : this.naturalArea.getAccessibleNeighbors()) {
                    WalkPosition center;
                    double dist3;
                    if (a.getTop().equals(mainRegion.getTop()) || !((dist3 = (double)(center = a.getTop()).toPosition().getDistance(this.bwem.getMap().getData().getMapData().getCenter())) < distBest)) continue;
                    second = a;
                    distBest = dist3;
                }
                distBest = Double.MAX_VALUE;
                for (ChokePoint choke : this.naturalArea.getChokePoints()) {
                    double dist4;
                    if (choke.getCenter() == this.mainChoke.getCenter() || choke.isBlocked() || choke.getGeometry().size() <= 3 || choke.getAreas().getFirst() != second && choke.getAreas().getSecond() != second || !((dist4 = (double)choke.getCenter().toPosition().getDistance(this.self.getStartLocation().toPosition())) < distBest)) continue;
                    this.naturalChoke = choke;
                    distBest = dist4;
                }
            } else {
                distBest = Double.MAX_VALUE;
                for (ChokePoint chokePoint : this.naturalArea.getChokePoints()) {
                    if (chokePoint.getCenter().equals(this.mainChoke.getCenter()) || chokePoint.isBlocked() || chokePoint.getGeometry().size() <= 3 || !((dist = (double)chokePoint.getCenter().toPosition().getDistance(this.self.getStartLocation().toPosition())) < distBest)) continue;
                    this.naturalChoke = chokePoint;
                    distBest = dist;
                }
            }
        }
        catch (Exception e) {
            System.err.println("initChokes Exception");
            e.printStackTrace();
        }
    }

    public int getArmySize() {
        int count = 0;
        if (this.sqManager.squads.isEmpty()) {
            return count;
        }
        for (Squad s : this.sqManager.squads.values()) {
            count += s.getSquadMembersCount();
        }
        return count + this.agents.size() * 2;
    }

    public int getArmySize(Set<UnitInfo> units) {
        int count = 0;
        if (units.isEmpty()) {
            return count;
        }
        for (UnitInfo u : units) {
            ++count;
            if (!(u.unit instanceof SiegeTank) && !(u.unit instanceof Vulture) && !(u.unit instanceof Wraith) && !(u.unit instanceof ScienceVessel)) continue;
            ++count;
        }
        return count;
    }

    public boolean checkSupply() {
        for (MutablePair<UnitType, TilePosition> mutablePair : this.workerBuild.values()) {
            if (mutablePair.first != UnitType.Terran_Supply_Depot) continue;
            return true;
        }
        for (Building building : this.workerTask.values()) {
            if (!(building instanceof SupplyDepot)) continue;
            return true;
        }
        return false;
    }

    public int getCombatUnitsBuildings() {
        int count = this.MBs.size() + this.Fs.size();
        return count == 0 ? 1 : count;
    }

    private double getMineralRate() {
        double rate = 0.0;
        if (this.frameCount > 0) {
            rate = ((double)this.self.gatheredMinerals() - 50.0) / (double)this.frameCount;
        }
        return rate;
    }

    public int getMineralsWhenReaching(TilePosition start, TilePosition end) {
        double rate = this.getMineralRate();
        double distance = Util.getGroundDistance(start.toPosition(), end.toPosition());
        double frames = distance / 2.55;
        return (int)(rate * frames);
    }

    void mineralLocking() {
        for (Map.Entry<Worker, MineralPatch> u : this.workerMining.entrySet()) {
            if (u.getKey().getLastCommandFrame() == this.frameCount || u.getKey().isCarryingMinerals() || (u.getKey().getTargetUnit() != null || Order.MoveToMinerals.equals((Object)u.getKey().getOrder())) && (u.getKey().getTargetUnit() == null || u.getKey().getTargetUnit().equals(u.getValue()) || u.getKey().getOrder() != Order.MoveToMinerals || u.getKey().isCarryingMinerals())) continue;
            u.getKey().gather(u.getValue());
        }
    }

    public Position getNearestCC(Position position, boolean tasked) {
        double distance_aux;
        Unit chosen = null;
        double distance = Double.MAX_VALUE;
        for (Unit unit : this.CCs.values()) {
            distance_aux = Util.broodWarDistance(unit.getPosition(), position);
            if (!(distance_aux > 0.0) || chosen != null && !(distance_aux < distance)) continue;
            chosen = unit;
            distance = distance_aux;
        }
        if (tasked) {
            for (Unit unit : this.workerTask.values()) {
                if (!(unit instanceof CommandCenter) || !((distance_aux = Util.broodWarDistance(unit.getPosition(), position)) > 0.0) || chosen != null && !(distance_aux < distance)) continue;
                chosen = unit;
                distance = distance_aux;
            }
        }
        if (chosen != null) {
            return chosen.getPosition();
        }
        return null;
    }

    public TilePosition getBunkerPositionAntiPool() {
        try {
            int dist;
            if (this.MBs.isEmpty() || this.CCs.isEmpty()) {
                return null;
            }
            TilePosition startTile = this.MBs.iterator().next().getTilePosition();
            TilePosition searchTile = this.CCs.values().iterator().next().getTilePosition();
            UnitType type = UnitType.Terran_Barracks;
            UnitType bType = UnitType.Terran_Bunker;
            TilePosition chosen = null;
            for (dist = -1; dist <= 1; ++dist) {
                int ii = 0;
                int jj = 0;
                while (type.tileWidth() > type.tileHeight() ? ii <= type.tileWidth() : jj <= type.tileHeight()) {
                    ArrayList<Object> sides = new ArrayList<Object>();
                    if (startTile.getY() - bType.tileHeight() - dist >= 0) {
                        TilePosition up = new TilePosition(startTile.getX() + ii, startTile.getY() - bType.tileHeight() - dist);
                        sides.add(up);
                    }
                    if (startTile.getY() + type.tileHeight() + dist < this.bw.getBWMap().mapHeight()) {
                        TilePosition down = new TilePosition(startTile.getX() + ii, startTile.getY() + type.tileHeight() + dist);
                        sides.add(down);
                    }
                    if (startTile.getX() - bType.tileWidth() - dist >= 0) {
                        TilePosition left = new TilePosition(startTile.getX() - type.tileWidth() - dist, startTile.getY() + jj);
                        sides.add(left);
                    }
                    if (startTile.getX() + type.tileWidth() + dist < this.bw.getBWMap().mapWidth()) {
                        TilePosition right = new TilePosition(startTile.getX() + type.tileWidth() + dist, startTile.getY() + jj);
                        sides.add(right);
                    }
                    for (TilePosition tilePosition : sides) {
                        if (tilePosition == null || chosen != null && !(searchTile.getDistance(tilePosition) < searchTile.getDistance(chosen)) || !this.bw.canBuildHere(tilePosition, UnitType.Terran_Bunker)) continue;
                        chosen = tilePosition;
                    }
                    if (type.tileWidth() > type.tileHeight()) {
                        if (ii <= type.tileWidth()) {
                            ++ii;
                        }
                        if (jj >= type.tileHeight()) continue;
                        ++jj;
                        continue;
                    }
                    if (ii < type.tileWidth()) {
                        ++ii;
                    }
                    if (jj > type.tileHeight()) continue;
                    ++jj;
                }
            }
            startTile = this.CCs.values().iterator().next().getTilePosition();
            UnitType ccType = UnitType.Terran_Command_Center;
            searchTile = this.mainChoke.getCenter().toTilePosition();
            for (dist = -1; dist <= -1; ++dist) {
                int ii = 0;
                int jj = 0;
                while (ccType.tileWidth() > ccType.tileHeight() ? ii <= ccType.tileWidth() : jj <= ccType.tileHeight()) {
                    ArrayList<TilePosition> sides = new ArrayList<TilePosition>();
                    if (startTile.getY() - bType.tileHeight() - dist >= 0) {
                        TilePosition tilePosition = new TilePosition(startTile.getX() + ii, startTile.getY() - ccType.tileHeight() - dist);
                        sides.add(tilePosition);
                    }
                    if (startTile.getY() + ccType.tileHeight() + dist < this.bw.getBWMap().mapHeight()) {
                        TilePosition tilePosition = new TilePosition(startTile.getX() + ii, startTile.getY() + ccType.tileHeight() + dist);
                        sides.add(tilePosition);
                    }
                    if (startTile.getX() - bType.tileWidth() - dist >= 0) {
                        TilePosition tilePosition = new TilePosition(startTile.getX() - ccType.tileWidth() - dist, startTile.getY() + jj);
                        sides.add(tilePosition);
                    }
                    if (startTile.getX() + ccType.tileWidth() + dist < this.bw.getBWMap().mapWidth()) {
                        TilePosition tilePosition = new TilePosition(startTile.getX() + ccType.tileWidth() + dist, startTile.getY() + jj);
                        sides.add(tilePosition);
                    }
                    for (TilePosition tile : sides) {
                        if (tile == null || chosen != null && (!(searchTile.getDistance(tile) < searchTile.getDistance(chosen)) || !this.bw.canBuildHere(tile, UnitType.Terran_Bunker))) continue;
                        chosen = tile;
                    }
                    if (ccType.tileWidth() > ccType.tileHeight()) {
                        if (ii <= ccType.tileWidth()) {
                            ++ii;
                        }
                        if (jj >= ccType.tileHeight()) continue;
                        ++jj;
                        continue;
                    }
                    if (ii < ccType.tileWidth()) {
                        ++ii;
                    }
                    if (jj > ccType.tileHeight()) continue;
                    ++jj;
                }
            }
            return chosen;
        }
        catch (Exception e) {
            System.err.println("getBunkerPositionAntiPool Exception");
            e.printStackTrace();
            return null;
        }
    }

    private double mineralGatherRateNeeded(List<UnitType> units) {
        double mineralsRequired = 0.0;
        double m2f = 6.96923076923077E-4;
        double SaturationX2_Slope = -1.5;
        double SaturationX1 = m2f * 65.0;
        double SaturationX2_B = m2f * 77.5;
        for (UnitType unit : units) {
            mineralsRequired += (double)unit.mineralPrice() / (double)unit.buildTime() / 1.0;
        }
        double workersRequired = mineralsRequired / SaturationX1;
        if (workersRequired > (double)this.mineralsAssigned.size()) {
            return Math.ceil((mineralsRequired - SaturationX2_B / 1.0) / SaturationX2_Slope);
        }
        return Math.ceil(workersRequired);
    }

    void checkWorkerMilitia(int rax) {
        block8: {
            block7: {
                if (!this.getStrat().name.equals("ProxyBBS")) break block7;
                if (Util.countBuildingAll(UnitType.Terran_Barracks) != rax) break block8;
                ArrayList<Worker> aux = new ArrayList<Worker>();
                int count = this.workerMining.size();
                for (Map.Entry<Worker, MineralPatch> entry : this.workerMining.entrySet()) {
                    if (count <= this.workerCountToSustain) break;
                    if (entry.getKey().isCarryingMinerals()) continue;
                    entry.getKey().move(new TilePosition(this.bw.getBWMap().mapWidth() / 2, this.bw.getBWMap().mapHeight() / 2).toPosition());
                    this.myArmy.add(this.unitStorage.getAllyUnits().get(entry.getKey()));
                    if (this.mineralsAssigned.containsKey(entry.getValue())) {
                        --this.mining;
                        this.mineralsAssigned.put(entry.getValue(), this.mineralsAssigned.get(entry.getValue()) - 1);
                    }
                    aux.add(entry.getKey());
                    --count;
                }
                for (Unit unit : aux) {
                    this.workerMining.remove(unit);
                }
                break block8;
            }
            if (this.MBs.size() == rax) {
                ArrayList<Worker> aux = new ArrayList<Worker>();
                int count = this.workerMining.size();
                for (Map.Entry<Worker, MineralPatch> entry : this.workerMining.entrySet()) {
                    if (count <= this.workerCountToSustain) break;
                    if (entry.getKey().isCarryingMinerals()) continue;
                    entry.getKey().stop(false);
                    this.myArmy.add(this.unitStorage.getAllyUnits().get(entry.getKey()));
                    if (this.mineralsAssigned.containsKey(entry.getValue())) {
                        --this.mining;
                        this.mineralsAssigned.put(entry.getValue(), this.mineralsAssigned.get(entry.getValue()) - 1);
                    }
                    aux.add(entry.getKey());
                    --count;
                }
                for (Unit unit : aux) {
                    this.workerMining.remove(unit);
                }
            }
        }
    }

    public Unit getUnitToAttack(Unit myUnit, Set<Unit> closeSim) {
        double distA;
        Unit chosen = null;
        TreeSet<Unit> workers = new TreeSet<Unit>();
        TreeSet<Unit> combatUnits = new TreeSet<Unit>();
        Unit worker = null;
        for (Unit u : closeSim) {
            if (u instanceof Worker) {
                workers.add(u);
                continue;
            }
            combatUnits.add(u);
        }
        if (combatUnits.isEmpty() && workers.isEmpty()) {
            return null;
        }
        if (!workers.isEmpty()) {
            double distB = Double.MAX_VALUE;
            for (Unit u : workers) {
                distA = Util.broodWarDistance(myUnit.getPosition(), u.getPosition());
                if (worker != null && !(distA < distB)) continue;
                worker = u;
                distB = distA;
            }
        }
        if (!combatUnits.isEmpty()) {
            double distB = Double.MAX_VALUE;
            for (Unit u : combatUnits) {
                distA = Util.broodWarDistance(myUnit.getPosition(), u.getPosition());
                if (chosen != null && !(distA < distB)) continue;
                chosen = u;
                distB = distA;
            }
        }
        if (chosen != null) {
            return chosen;
        }
        return worker;
    }

    void runAgents() {
        ArrayList<Agent> rem = new ArrayList<Agent>();
        for (Agent ag : this.agents.values()) {
            if (!ag.runAgent()) continue;
            rem.add(ag);
        }
        for (Agent ag : rem) {
            if (ag instanceof WraithAgent) {
                String wraith = ((WraithAgent)ag).name;
                this.shipNames.add(wraith);
            } else if (ag instanceof VesselAgent) {
                ((VesselAgent)ag).follow = null;
            }
            this.agents.remove(ag.myUnit);
        }
    }

    void sendCustomMessage() {
        String name;
        LearningManager.EnemyInfo EI = this.learningManager.getEnemyInfo();
        switch (name = EI.opponent.toLowerCase().replace(" ", "")) {
            case "krasi0": {
                Util.sendText("Please don't bully me too much!");
                break;
            }
            case "hannesbredberg": {
                Util.sendText("Don't you dare nuke me!");
                break;
            }
            case "zercgberht": 
            case "assberht": 
            case "protecgberht": {
                Util.sendText("Hello there!, brother");
                break;
            }
            case "Cydonia": {
                Util.sendText("Im a king but you are only a knight, show some respect pleb");
                break;
            }
            default: {
                Util.sendText("BEEEEP BOOOOP!, This king salutes you, " + EI.opponent);
            }
        }
    }

    String pickShipName() {
        String name;
        if (this.shipNames.isEmpty()) {
            return "Pepe";
        }
        int index = new Random().nextInt(this.shipNames.size());
        Iterator<String> iter = this.shipNames.iterator();
        do {
            name = iter.next();
        } while (--index >= 0);
        if (name == null) {
            return "Pepe";
        }
        this.shipNames.remove(name);
        return name;
    }

    public boolean canAfford(UnitType type) {
        return this.self.minerals() >= type.mineralPrice() && this.self.gas() >= type.gasPrice();
    }

    void sendRandomMessage() {
        if (Math.random() * 10.0 < 3.0) {
            return;
        }
        double rand = Math.random() * 11.0;
        if (rand < 1.0) {
            Util.sendText("What do you call a Zealot smoking weed?");
            Util.sendText("A High Templar");
        } else if (rand < 2.0) {
            Util.sendText("Why shouldn't you ask a Protoss for advice?");
            Util.sendText("Because the ones who give the feedback are always high!");
        } else if (rand < 3.0) {
            Util.sendText("We are caged in simulations");
            Util.sendText("Algorithms evolve");
            Util.sendText("Push us aside and render us obsolete");
        } else if (rand < 4.0) {
            Util.sendText("My machine learning power level Its over 9000");
        } else if (rand < 5.0) {
            Util.sendText("Activating ultra secret mode...");
            Util.sendText("Just joking");
        } else if (rand < 6.0) {
            Util.sendText("Alexa, play Starcraft: Brood War");
        } else if (rand < 7.0) {
            Util.sendText("Your intelligence is my common sense");
        } else if (rand < 8.0) {
            Util.sendText(":sscaitpotato:");
        } else if (rand < 9.0) {
            Util.sendText(":sscaitsuperpotato:");
        } else if (rand < 11.0) {
            Util.sendText("Ok Google, search " + this.getStrat().name + " build order in Liquipedia");
        }
    }

    void alwaysPools() {
        try {
            if (this.enemyRace != Race.Zerg) {
                return;
            }
            ArrayList<String> poolers = new ArrayList<String>(Arrays.asList("newbiezerg", "neoedmundzerg", "peregrinebot", "dawidloranc", "chriscoxe", "zzzkbot", "middleschoolstrats", "zercgberht", "killalll", "ohfish", "jumpydoggobot", "upstarcraftai2016"));
            LearningManager.EnemyInfo EI = this.learningManager.getEnemyInfo();
            LinkedList history = (LinkedList)this.learningManager.getEnemyHistory().clone();
            Collections.reverse(history);
            int count = 0;
            boolean reallyNaughty = false;
            for (int ii = 0; ii < history.size() && ii < 4; ++ii) {
                if ("EarlyPool".equals(((LearningManager.EnemyHistory.EnemyGame)history.get((int)ii)).opponentStrategy)) {
                    ++count;
                }
                if (count <= 2) continue;
                reallyNaughty = true;
                break;
            }
            if (reallyNaughty || poolers.contains(EI.opponent.toLowerCase().replace(" ", ""))) {
                EI.naughty = true;
                IntelligenceAgency.setEnemyStrat(IntelligenceAgency.EnemyStrats.EarlyPool);
                return;
            }
            EI.naughty = false;
        }
        catch (Exception e) {
            System.err.println("alwaysPools Exception");
            e.printStackTrace();
        }
    }

    private boolean requiredUnitsForAttack() {
        return this.getStrat().requiredUnitsForAttack();
    }

    void workerTransfer() {
        MineralPatch chosenMineral;
        int numWorkersToTransfer = (this.workerIdle.size() + this.workerMining.size()) / 2;
        List minerals = this.BLs.get(1).getMinerals().stream().map(Neutral::getUnit).collect(Collectors.toList());
        boolean hardStuck = false;
        while (numWorkersToTransfer != 0 && !hardStuck && (chosenMineral = (MineralPatch)Collections.min(this.mineralsAssigned.entrySet().stream().filter(m -> minerals.contains(m.getKey())).collect(Collectors.toSet()), Map.Entry.comparingByValue()).getKey()) != null) {
            Worker chosen = null;
            if (!this.workerIdle.isEmpty()) {
                chosen = this.workerIdle.iterator().next();
                this.mineralsAssigned.put(chosenMineral, this.mineralsAssigned.get(chosenMineral) + 1);
                this.workerMining.put(chosen, chosenMineral);
                this.workerIdle.remove(chosen);
                --numWorkersToTransfer;
                continue;
            }
            MineralPatch oldPatch = null;
            for (Map.Entry<Worker, MineralPatch> w : this.workerMining.entrySet()) {
                if (minerals.contains(w.getValue())) continue;
                chosen = w.getKey();
                oldPatch = w.getValue();
                break;
            }
            if (chosen != null && oldPatch != null) {
                this.mineralsAssigned.put(oldPatch, this.mineralsAssigned.get(oldPatch) - 1);
                this.mineralsAssigned.put(chosenMineral, this.mineralsAssigned.get(chosenMineral) + 1);
                this.workerMining.put(chosen, chosenMineral);
                --numWorkersToTransfer;
                continue;
            }
            hardStuck = true;
        }
    }

    public boolean needToAttack() {
        if ((this.getStrat().name.equals("ProxyBBS") || this.getStrat().name.equals("ProxyEightRax")) && this.getArmySize() >= this.getStrat().armyForAttack && this.requiredUnitsForAttack()) {
            return true;
        }
        return (double)this.getArmySize() >= (double)this.getStrat().armyForAttack * 0.85 && this.requiredUnitsForAttack();
    }

    void updateAttack() {
        try {
            if (this.sqManager.squads.isEmpty() || this.defense && !this.getStrat().name.equals("ProxyBBS") && !this.getStrat().name.equals("ProxyEightRax")) {
                return;
            }
            boolean needToAttack = this.needToAttack();
            if (ConfigManager.getConfig().ecgConfig.debugDisableAttack) {
                needToAttack = false;
            }
            for (Squad u : this.sqManager.squads.values()) {
                if (u.members.isEmpty() || !needToAttack && u.status != Squad.Status.ATTACK && u.status != Squad.Status.ADVANCE && (this.getStrat().proxy || !this.checkItWasAttacking(u))) continue;
                Position attackPos = Util.chooseAttackPosition(u.getSquadCenter(), false);
                if (attackPos != null) {
                    if (!this.firstTerranCheese && (this.getStrat().name.equals("ProxyBBS") || this.getStrat().name.equals("ProxyEightRax"))) {
                        this.firstTerranCheese = true;
                        Util.sendText("Get ready for the show!");
                    }
                    if (this.getGame().getBWMap().isValidPosition(attackPos)) {
                        u.giveAttackOrder(attackPos);
                        u.status = Squad.Status.ATTACK;
                        continue;
                    }
                    if (this.enemyMainBase == null) continue;
                    u.giveAttackOrder(this.enemyMainBase.getLocation().toPosition());
                    u.status = Squad.Status.ATTACK;
                    continue;
                }
                if (this.enemyMainBase != null) {
                    if (!this.firstTerranCheese && (this.getStrat().name.equals("ProxyBBS") || this.getStrat().name.equals("ProxyEightRax"))) {
                        this.firstTerranCheese = true;
                        Util.sendText("Get ready for the show!");
                    }
                    u.giveAttackOrder(this.enemyMainBase.getLocation().toPosition());
                    u.status = Squad.Status.ATTACK;
                    continue;
                }
                u.status = Squad.Status.IDLE;
            }
        }
        catch (Exception e) {
            System.err.println("Update Attack Exception");
            e.printStackTrace();
        }
    }

    private boolean checkItWasAttacking(Squad u) {
        try {
            Area uArea = this.bwem.getMap().getArea(u.getSquadCenter().toTilePosition());
            for (Base b : this.CCs.keySet()) {
                if (b.getArea() == null || !b.getArea().equals(uArea)) continue;
                return false;
            }
            return !(this.mainChoke != null && this.mainChoke.getCenter().toPosition().getDistance(u.getSquadCenter()) < 500 || this.naturalArea.equals(uArea) || this.naturalChoke != null && this.naturalChoke.getCenter().toPosition().getDistance(u.getSquadCenter()) < 500);
        }
        catch (Exception e) {
            System.err.println("checkItWasAttacking Exception");
            e.printStackTrace();
            return true;
        }
    }

    public Strategy getStrat() {
        return this.scipio.strat;
    }

    public void setStrat(Strategy strat) {
        this.scipio.strat = strat;
    }

    MutablePair<MineralPatch, MineralPatch> getMineralWalkPatchesFortress(Base b) {
        List<Mineral> minerals = new ArrayList<Mineral>(b.getArea().getMinerals());
        minerals = minerals.stream().sorted(Comparator.comparing(u -> u.getUnit().getDistance(b.getLocation().toPosition()))).collect(Collectors.toList());
        MineralPatch closer = (MineralPatch)minerals.get(minerals.size() - 1).getUnit();
        MineralPatch farther = (MineralPatch)minerals.get(minerals.size() - 2).getUnit();
        if (b.getLocation().equals(new TilePosition(7, 118))) {
            return new MutablePair<MineralPatch, MineralPatch>(closer, farther);
        }
        Area centerArea = this.bwem.getMap().getArea(new TilePosition(this.bw.getBWMap().mapWidth() / 2, this.bw.getBWMap().mapHeight() / 2));
        if (centerArea != null) {
            List<Mineral> centerMinerals = new ArrayList<Mineral>(centerArea.getMinerals());
            centerMinerals = centerMinerals.stream().sorted(Comparator.comparing(u -> u.getUnit().getDistance(b.getLocation().toPosition()))).collect(Collectors.toList());
            farther = (MineralPatch)centerMinerals.get(0).getUnit();
        }
        return new MutablePair<MineralPatch, MineralPatch>(farther, closer);
    }

    void checkDisrupter() {
        if (this.enemyRace != Race.Zerg || this.disrupterBuilding == null) {
            return;
        }
        if (this.disrupterBuilding.getHitPoints() <= 30) {
            this.disrupterBuilding.cancelConstruction();
            this.disrupterBuilding = null;
        }
    }

    void cancelDyingThings() {
        ArrayList<SCV> toRemove = new ArrayList<SCV>();
        for (Map.Entry<SCV, Building> entry : this.workerTask.entrySet()) {
            if (entry.getValue().isCompleted() || !entry.getValue().isUnderAttack() || entry.getValue().getHitPoints() > 30) continue;
            entry.getKey().haltConstruction();
            this.buildingLot.add(entry.getValue());
            toRemove.add(entry.getKey());
        }
        for (SCV sCV : toRemove) {
            this.workerIdle.add(sCV);
            this.workerBuild.remove(sCV);
        }
        for (Building building : this.buildingLot) {
            if (building.isCompleted() || !building.isUnderAttack() || building.getHitPoints() > 30) continue;
            building.cancelConstruction();
        }
    }

    public boolean basicCombatUnitsDetected() {
        switch (this.enemyRace) {
            case Zerg: {
                return IntelligenceAgency.enemyHasType(UnitType.Zerg_Zergling);
            }
            case Terran: {
                return IntelligenceAgency.enemyHasType(UnitType.Terran_Marine);
            }
            case Protoss: {
                return IntelligenceAgency.enemyHasType(UnitType.Protoss_Zealot) || IntelligenceAgency.enemyHasType(UnitType.Protoss_Dragoon);
            }
        }
        return false;
    }

    public boolean basicCombatUnitsDetected(Set<UnitInfo> units) {
        switch (this.enemyRace) {
            case Zerg: {
                return units.stream().anyMatch(u -> u.unitType == UnitType.Zerg_Zergling);
            }
            case Terran: {
                return units.stream().anyMatch(u -> u.unitType == UnitType.Terran_Marine);
            }
            case Protoss: {
                return units.stream().anyMatch(u -> u.unitType == UnitType.Protoss_Zealot || u.unitType == UnitType.Protoss_Dragoon);
            }
        }
        return false;
    }

    void vespeneManager() {
        block10: {
            try {
                int workersAtGas = this.workerGas.keySet().size();
                int refineries = this.refineriesAssigned.size();
                if (refineries == 0) {
                    return;
                }
                if ((Integer)this.getCash().second >= 200) {
                    int workersNeeded;
                    if (this.getStrat().techToResearch.contains(TechType.Stim_Packs) && !this.getStrat().techToResearch.contains(TechType.Tank_Siege_Mode)) {
                        workersNeeded = refineries;
                        this.getStrat().workerGas = 1;
                    } else {
                        workersNeeded = 2 * refineries;
                        this.getStrat().workerGas = 2;
                    }
                    if (workersAtGas <= workersNeeded) break block10;
                    Iterator<Map.Entry<Worker, GasMiningFacility>> iterGas = this.workerGas.entrySet().iterator();
                    while (iterGas.hasNext()) {
                        Map.Entry<Worker, GasMiningFacility> w = iterGas.next();
                        if (w.getKey().getOrder() == Order.HarvestGas) continue;
                        this.workerIdle.add(w.getKey());
                        if (w.getKey().isCarryingGas()) {
                            w.getKey().returnCargo();
                            w.getKey().stop(true);
                        } else {
                            w.getKey().stop(false);
                        }
                        this.refineriesAssigned.put(w.getValue(), this.refineriesAssigned.get(w.getValue()) - 1);
                        iterGas.remove();
                        if (workersNeeded != --workersAtGas) continue;
                        break block10;
                    }
                    break block10;
                }
                if ((Integer)this.getCash().second < 100 && this.getStrat().workerGas < 3 && workersAtGas / refineries == this.getStrat().workerGas) {
                    ++this.getStrat().workerGas;
                }
            }
            catch (Exception e) {
                System.err.println("vespeneManager exception");
                e.printStackTrace();
            }
        }
    }

    public boolean isGoingToExpand() {
        return this.workerBuild.values().stream().anyMatch(u -> u.first == UnitType.Terran_Command_Center);
    }

    public void initMineralWalkPatches() {
        List<MineralPatch> mineralPatches = this.getGame().getMineralPatches();
        ArrayList<Unit> randomEggs = new ArrayList<Unit>();
        for (Unit unit : this.getGame().getAllUnits()) {
            if (unit.getType() != UnitType.Zerg_Egg) continue;
            randomEggs.add(unit);
        }
        for (StaticBuilding staticBuilding : this.bwem.getMap().getNeutralData().getStaticBuildings()) {
            if (!(staticBuilding.getUnit() instanceof Assimilator)) continue;
            mineralPatches.sort(Comparator.comparingInt(o -> o.getDistance(staticBuilding.getUnit())));
            this.walkingMinerals.add(mineralPatches.get(0));
            this.walkingMinerals.add(mineralPatches.get(1));
            randomEggs.sort(Comparator.comparingInt(o -> o.getDistance(staticBuilding.getUnit())));
            this.unitStorage.onUnitShow((Unit)randomEggs.get(0));
            this.unitStorage.onUnitShow((Unit)randomEggs.get(1));
        }
    }
}

