/*
 * Decompiled with CFR 0.152.
 */
package ecgberht.Clustering;

import ecgberht.Clustering.Cluster;
import ecgberht.UnitInfo;
import ecgberht.Util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openbw.bwapi4j.Position;
import org.openbw.bwapi4j.unit.Building;

public class MeanShift {
    public long time = 0L;
    private double radius;
    private List<UnitPos> points = new ArrayList<UnitPos>();

    public MeanShift(Collection<UnitInfo> units, double radius) {
        this.radius = Math.pow(radius, 2.0);
        for (UnitInfo u : units) {
            if (u.unit instanceof Building && !Util.isStaticDefense(u) && !u.visible) continue;
            Position p = u.lastPosition;
            this.points.add(new UnitPos(u, p.getX(), p.getY()));
        }
    }

    public List<Cluster> run(int iterations) {
        try {
            this.time = System.currentTimeMillis();
            int bandwidth = 2;
            for (int iter = 0; iter < iterations; ++iter) {
                for (int i = 0; i < this.points.size(); ++i) {
                    UnitPos aux = this.points.get(i);
                    double initialX = aux.x;
                    double initialY = aux.y;
                    List<double[]> neighbours = this.getNeighbours(aux.unit, initialX, initialY);
                    double numeratorX = 0.0;
                    double numeratorY = 0.0;
                    double denominator = 0.0;
                    for (double[] neighbour : neighbours) {
                        double distanceSquared = this.euclideanDistanceSquared(neighbour[0], neighbour[1], initialX, initialY);
                        double weight = this.gaussianKernel2(distanceSquared, bandwidth);
                        numeratorX += weight * neighbour[0];
                        numeratorY += weight * neighbour[1];
                        denominator += weight;
                    }
                    double newPointX = numeratorX / denominator;
                    double newPointY = numeratorY / denominator;
                    if (neighbours.isEmpty()) {
                        newPointX = initialX;
                        newPointY = initialY;
                    }
                    if (Double.isInfinite(newPointX) || Double.isNaN(newPointX)) {
                        newPointX = initialX;
                    }
                    if (Double.isInfinite(newPointY) || Double.isNaN(newPointY)) {
                        newPointY = initialY;
                    }
                    this.points.set(i, new UnitPos(aux.unit, newPointX, newPointY));
                }
            }
            ArrayList<Cluster> clusters = new ArrayList<Cluster>();
            for (UnitPos i : this.points) {
                int c = 0;
                for (Cluster cluster : clusters) {
                    if (this.euclideanDistanceSquared(i.x, i.y, cluster.modeX, cluster.modeY) <= 160000.0) break;
                    ++c;
                }
                if (c == clusters.size()) {
                    Cluster cluster = new Cluster();
                    cluster.modeX = i.x;
                    cluster.modeY = i.y;
                    clusters.add(cluster);
                }
                ((Cluster)clusters.get((int)c)).units.add(i.unit);
                ((Cluster)clusters.get(c)).updateCentroid();
            }
            this.time = System.currentTimeMillis() - this.time;
            clusters.forEach(Cluster::updateCMaxDistFromCenter);
            return clusters;
        }
        catch (Exception e) {
            System.err.println("MeanShift run exception");
            e.printStackTrace();
            return new ArrayList<Cluster>();
        }
    }

    private double gaussianKernel2(double distanceSquared, double bandwidth) {
        return Math.exp(-0.5 * distanceSquared / (bandwidth * bandwidth));
    }

    private List<double[]> getNeighbours(UnitInfo unit, double pointX, double pointY) {
        ArrayList<double[]> neighbours = new ArrayList<double[]>();
        for (UnitPos u : this.points) {
            double dist;
            if (unit.equals(u.unit) || !((dist = this.euclideanDistanceSquared(pointX, pointY, u.x, u.y)) <= this.radius)) continue;
            neighbours.add(new double[]{u.x, u.y});
        }
        return neighbours;
    }

    private double euclideanDistanceSquared(double point1X, double point1Y, double point2X, double point2Y) {
        return Math.pow(point1X - point2X, 2.0) + Math.pow(point1Y - point2Y, 2.0);
    }

    static class UnitPos {
        UnitInfo unit;
        double x;
        double y;

        UnitPos(UnitInfo unit, double x, double y) {
            this.unit = unit;
            this.x = x;
            this.y = y;
        }
    }
}

