/*
 * Decompiled with CFR 0.152.
 */
package ecgberht.Clustering;

import ecgberht.UnitInfo;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import org.openbw.bwapi4j.Position;

public class Cluster {
    public Set<UnitInfo> units = new TreeSet<UnitInfo>();
    public double modeX = 0.0;
    public double modeY = 0.0;
    public double maxDistFromCenter = 0.0;

    void updateCentroid() {
        if (this.units.isEmpty()) {
            return;
        }
        int size = this.units.size();
        int x = 0;
        int y = 0;
        for (UnitInfo u : this.units) {
            if (u.visible) {
                x += u.position.getX();
                y += u.position.getY();
                continue;
            }
            x += u.lastPosition.getX();
            y += u.lastPosition.getY();
        }
        this.modeX = (double)x / (double)size;
        this.modeY = (double)y / (double)size;
    }

    void updateCMaxDistFromCenter() {
        if (this.units.isEmpty() || this.units.size() == 1) {
            this.maxDistFromCenter = 0.0;
            return;
        }
        for (UnitInfo u : this.units) {
            double d = u.visible ? (double)u.position.getDistance(new Position((int)this.mode()[0], (int)this.mode()[1])) : (double)u.lastPosition.getDistance(new Position((int)this.mode()[0], (int)this.mode()[1]));
            double dist = d;
            if (!(dist > this.maxDistFromCenter)) continue;
            this.maxDistFromCenter = dist;
        }
    }

    public double[] mode() {
        return new double[]{this.modeX, this.modeY};
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Cluster)) {
            return false;
        }
        Cluster cluster = (Cluster)object;
        return Arrays.equals(this.mode(), cluster.mode());
    }
}

