/*
 * Decompiled with CFR 0.152.
 */
package ecgberht.CherryVis;

import com.github.luben.zstd.Zstd;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import ecgberht.CherryVis.TraceData;
import ecgberht.CherryVis.UnitSeenInfo;
import ecgberht.ConfigManager;
import ecgberht.GameState;
import ecgberht.Util.Util;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import org.openbw.bwapi4j.unit.Unit;

public class CherryVisDumper {
    private GameState gameState;
    private TraceData traceData;
    private final String dir = "bwapi-data/write/cherryvis";

    public CherryVisDumper(GameState gameState) {
        this.gameState = gameState;
        this.traceData = new TraceData();
    }

    public void onFrame() {
        String frame = String.valueOf(this.gameState.frameCount);
        this.fillBoard(frame);
    }

    public void onUnitShow(Unit u) {
        String frame = String.valueOf(this.gameState.getIH().getFrameCount());
        UnitSeenInfo unitSeenInfo = new UnitSeenInfo(u);
        this.traceData.units_first_seen.computeIfAbsent(frame, s -> new ArrayList()).add(unitSeenInfo);
    }

    private void writeJSONCompressed(Object content, String path) {
        Gson aux = new GsonBuilder().create();
        String data = aux.toJson(content);
        byte[] compressedData = Zstd.compress(data.getBytes());
        try (FileOutputStream writer = new FileOutputStream(new File(path));){
            ((OutputStream)writer).write(compressedData);
        }
        catch (IOException e) {
            System.err.println("writeJSONCompressed");
            e.printStackTrace();
        }
    }

    private void writeJSON(Object content, String path) {
        Gson aux = new GsonBuilder().create();
        try (FileWriter writer = new FileWriter(path);){
            aux.toJson(content, (Appendable)writer);
        }
        catch (IOException e) {
            System.err.println("writeJSON");
            e.printStackTrace();
        }
    }

    private String getDumpDirectory(String opponentName) {
        int i = 1;
        while (i <= 1000) {
            String path = "bwapi-data/write/cherryvis/" + this.gameState.getPlayer().getName() + "_vs_" + opponentName + "_" + i + ".rep.cvis/";
            File directory = new File(path);
            if (directory.exists()) {
                ++i;
                continue;
            }
            boolean created = directory.mkdir();
            if (!created) continue;
            return path;
        }
        return null;
    }

    public void onEnd(boolean win, String startStrat) {
        if (!ConfigManager.getConfig().ecgConfig.enableCherryVisDump) {
            return;
        }
        File directory = new File("bwapi-data/write/cherryvis");
        boolean created = directory.exists();
        if (!created) {
            created = directory.mkdir();
        }
        if (!created) {
            System.err.println("Couldnt create CherryVis dump folder");
            return;
        }
        String opponentName = this.gameState.getIH().enemy().getName();
        String path = this.getDumpDirectory(opponentName);
        if (path != null) {
            Util.sendText("Writing traceData to: " + path);
            this.writeJSONCompressed(this.traceData, path + "trace.json");
        }
    }

    private void fillBoard(String frame) {
        HashMap board = this.traceData.board_updates.computeIfAbsent(frame, s -> new HashMap());
        board.put("chosenUpgrade", this.getStringObject(this.gameState.chosenUpgrade));
        board.put("chosenResearch", this.getStringObject(this.gameState.chosenResearch));
        board.put("chosenTrainingFacility", this.getStringUnitTypeUnit(this.gameState.chosenTrainingFacility));
        board.put("explore", this.getStringObject(this.gameState.explore));
        board.put("firstExpand", this.getStringObject(this.gameState.firstExpand));
        board.put("maxFirebats", this.getStringObject(this.gameState.maxBats));
        board.put("maxGoliaths", this.getStringObject(this.gameState.maxGoliaths));
        board.put("maxVessels", this.getStringObject(this.gameState.maxVessels));
        board.put("maxWraiths", this.getStringObject(this.gameState.maxWraiths));
        board.put("iReallyWantToExpand", this.getStringObject(this.gameState.iReallyWantToExpand));
        board.put("firstScout", this.getStringObject(this.gameState.firstScout));
        board.put("chosenToBuild", this.getStringObject(this.gameState.chosenToBuild));
        board.put("deltaCash", this.getStringObject(this.gameState.deltaCash));
        board.put("proxyBuilding", this.getStringUnitTypeUnit(this.gameState.proxyBuilding));
        board.put("islandExpand", this.getStringObject(this.gameState.islandExpand));
        board.put("APM", this.getStringObject(this.gameState.getIH().getFrameCount()));
        board.put("islandBases", this.getStringObject(this.gameState.islandBases.size()));
    }

    private String getStringObject(Object obj) {
        return Objects.toString(obj, "None");
    }

    private String getStringUnitTypeUnit(Unit unit) {
        return unit != null ? unit.getType().toString() : "None";
    }
}

