/*
 * Decompiled with CFR 0.152.
 */
package ecgberht;

import bwem.Area;
import bwem.BWEM;
import bwem.Base;
import bwem.ChokePoint;
import ecgberht.Ecgberht;
import ecgberht.Util.Util;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.openbw.bwapi4j.BW;
import org.openbw.bwapi4j.Player;
import org.openbw.bwapi4j.Position;
import org.openbw.bwapi4j.TilePosition;
import org.openbw.bwapi4j.type.UnitType;
import org.openbw.bwapi4j.unit.MineralPatch;
import org.openbw.bwapi4j.unit.PlayerUnit;
import org.openbw.bwapi4j.unit.SpecialBuilding;
import org.openbw.bwapi4j.unit.Unit;
import org.openbw.bwapi4j.unit.VespeneGeyser;
import org.openbw.bwapi4j.unit.Worker;

public class BuildingMap
implements Cloneable {
    public static final Map<Area, Set<TilePosition>> tilesArea = new HashMap<Area, Set<TilePosition>>();
    private Player self;
    private int height;
    private int width;
    private String[][] map;
    private BW bw;
    private BWEM bwem;

    BuildingMap(BW bw, Player self, BWEM bwem) {
        this.bw = bw;
        this.self = self;
        this.height = bw.getBWMap().mapHeight();
        this.width = bw.getBWMap().mapWidth();
        this.map = new String[this.height][this.width];
        this.bwem = bwem;
        if (tilesArea.isEmpty()) {
            this.initTilesArea();
        }
    }

    private BuildingMap(BW bw, Player self, int height, int width, String[][] map, BWEM bwem) {
        this.bw = bw;
        this.self = self;
        this.height = height;
        this.width = width;
        this.map = this.copyMap(map);
        this.bwem = bwem;
        if (tilesArea.isEmpty()) {
            this.initTilesArea();
        }
    }

    private void initTilesArea() {
        boolean startOrdered = false;
        boolean naturalOrdered = false;
        TilePosition startTile = this.self.getStartLocation();
        for (Area a : this.bwem.getMap().getAreas()) {
            if (!startOrdered && this.bwem.getMap().getArea(startTile).equals(a)) {
                tilesArea.put(a, new TreeSet<TilePosition>(new tilesAreaComparator(startTile)));
                startOrdered = true;
                continue;
            }
            if (!naturalOrdered && Ecgberht.getGs().naturalArea.equals(a)) {
                tilesArea.put(a, new TreeSet<TilePosition>(new tilesAreaComparator(Ecgberht.getGs().BLs.get(1).getLocation())));
                naturalOrdered = true;
                continue;
            }
            if (a.getBases().size() == 1) {
                tilesArea.put(a, new TreeSet<TilePosition>(new tilesAreaComparator(a.getBases().get(0).getLocation())));
                continue;
            }
            tilesArea.put(a, new TreeSet<TilePosition>(new tilesAreaComparator(a.getTop().toTilePosition())));
        }
        for (int jj = 0; jj < this.height; ++jj) {
            for (int ii = 0; ii < this.width; ++ii) {
                TilePosition x = new TilePosition(ii, jj);
                Area a = this.bwem.getMap().getArea(x);
                if (a == null) continue;
                tilesArea.get(a).add(x);
            }
        }
    }

    public Set<TilePosition> getTilesArea(Area area) {
        return tilesArea.get(area);
    }

    private String[][] copyMap(String[][] map) {
        String[][] copiedMap = new String[map.length][map[0].length];
        for (int ii = 0; ii < map.length; ++ii) {
            System.arraycopy(map[ii], 0, copiedMap[ii], 0, map[0].length);
        }
        return copiedMap;
    }

    public String[][] getMap() {
        return this.map;
    }

    public BuildingMap clone() {
        return new BuildingMap(this.bw, this.self, this.height, this.width, this.map, this.bwem);
    }

    void initMap() {
        int j;
        int i;
        TilePosition resourceSize;
        TilePosition resourceTile;
        for (int jj = 0; jj < this.height; ++jj) {
            for (int k = 0; k < this.width; ++k) {
                TilePosition x = new TilePosition(k, jj);
                this.map[jj][k] = this.bw.getBWMap().isBuildable(x, true) ? "6" : "0";
            }
        }
        for (MineralPatch mineralPatch : this.bw.getMineralPatches()) {
            resourceTile = mineralPatch.getTilePosition();
            resourceSize = mineralPatch.getType().tileSize();
            for (i = resourceTile.getY(); i < resourceTile.getY() + resourceSize.getY(); ++i) {
                for (j = resourceTile.getX(); j < resourceTile.getX() + resourceSize.getX(); ++j) {
                    if (i < 0 || i >= this.height || j < 0 || j >= this.width || this.map[i][j].equals("V")) continue;
                    this.map[i][j] = "M";
                }
            }
        }
        for (VespeneGeyser vespeneGeyser : this.bw.getVespeneGeysers()) {
            resourceTile = vespeneGeyser.getTilePosition();
            resourceSize = vespeneGeyser.getType().tileSize();
            for (i = resourceTile.getY(); i < resourceTile.getY() + resourceSize.getY(); ++i) {
                for (j = resourceTile.getX(); j < resourceTile.getX() + resourceSize.getX(); ++j) {
                    if (i < 0 || i >= this.height || j < 0 || j >= this.width) continue;
                    this.map[i][j] = "V";
                }
            }
        }
        for (Unit unit : this.bw.getAllUnits()) {
            if (!(unit instanceof SpecialBuilding)) continue;
            resourceTile = unit.getTilePosition();
            resourceSize = unit.getType().tileSize();
            for (i = resourceTile.getY(); i < resourceTile.getY() + resourceSize.getY(); ++i) {
                for (j = resourceTile.getX(); j < resourceTile.getX() + resourceSize.getX(); ++j) {
                    if (i < 0 || i >= this.height || j < 0 || j >= this.width) continue;
                    this.map[i][j] = "E";
                }
            }
        }
        for (Area area : this.bwem.getMap().getAreas()) {
            for (Base b : area.getBases()) {
                TilePosition starting = b.getLocation();
                for (int i2 = starting.getY(); i2 < starting.getY() + UnitType.Terran_Command_Center.tileHeight(); ++i2) {
                    for (int j2 = starting.getX(); j2 < starting.getX() + UnitType.Terran_Command_Center.tileWidth(); ++j2) {
                        if (i2 < 0 || i2 >= this.height || j2 < 0 || j2 >= this.width) continue;
                        this.map[i2][j2] = "E";
                    }
                }
                this.map[starting.getY() + 1][starting.getX() + UnitType.Terran_Command_Center.tileWidth()] = "E";
                this.map[starting.getY() + 2][starting.getX() + UnitType.Terran_Command_Center.tileWidth()] = "E";
                this.map[starting.getY() + 1][starting.getX() + UnitType.Terran_Command_Center.tileWidth() + 1] = "E";
                this.map[starting.getY() + 2][starting.getX() + UnitType.Terran_Command_Center.tileWidth() + 1] = "E";
            }
        }
        this.map = this.fillMap(this.map);
    }

    private String[][] fillMap(String[][] map) {
        int ii;
        int jj;
        int height = map.length;
        int width = map[0].length;
        for (jj = height - 1; jj >= 0; --jj) {
            if (map[jj][width - 1].equals("M") || map[jj][width - 1].equals("V") || map[jj][width - 1].equals("0") || map[jj][width - 1].equals("E") || map[jj][width - 1].equals("B") || jj != this.height - 1 && width - 1 != this.width - 1) continue;
            map[jj][width - 1] = "1";
        }
        for (int ii2 = width - 1; ii2 >= 0; --ii2) {
            if (map[height - 1][ii2].equals("M") || map[height - 1][ii2].equals("V") || map[height - 1][ii2].equals("0") || map[height - 1][ii2].equals("E") || map[height - 1][ii2].equals("B") || height - 1 != this.height - 1 && ii2 != this.width - 1) continue;
            map[height - 1][ii2] = "1";
        }
        for (jj = height - 1; jj >= 0; --jj) {
            for (ii = width - 1; ii >= 0; --ii) {
                if (!map[jj][ii].equals("E") && !map[jj][ii].equals("M") && !map[jj][ii].equals("V")) continue;
                if (jj - 1 >= 0 && map[jj - 1][ii].equals("6")) {
                    map[jj - 1][ii] = "B";
                }
                if (ii - 1 >= 0 && map[jj][ii - 1].equals("6")) {
                    map[jj][ii - 1] = "B";
                }
                if (jj - 1 >= 0 && ii - 1 >= 0 && map[jj - 1][ii - 1].equals("6")) {
                    map[jj - 1][ii - 1] = "B";
                }
                if (jj + 1 < height && map[jj + 1][ii].equals("6")) {
                    map[jj + 1][ii] = "B";
                }
                if (ii + 1 < width && map[jj][ii + 1].equals("6")) {
                    map[jj][ii + 1] = "B";
                }
                if (jj + 1 < height && ii + 1 < width && map[jj + 1][ii + 1].equals("6")) {
                    map[jj + 1][ii + 1] = "B";
                }
                if (jj - 1 >= 0 && ii + 1 < width && map[jj - 1][ii + 1].equals("6")) {
                    map[jj - 1][ii + 1] = "B";
                }
                if (jj + 1 >= height || ii - 1 < 0 || !map[jj + 1][ii - 1].equals("6")) continue;
                map[jj + 1][ii - 1] = "B";
            }
        }
        for (jj = height - 1; jj > 0; --jj) {
            for (ii = width - 1; ii > 0; --ii) {
                if (!map[jj][ii].equals("B") && !map[jj][ii].equals("0") && !map[jj][ii].equals("M") && !map[jj][ii].equals("V") && !map[jj][ii].equals("E")) continue;
                if (map[jj - 1][ii].equals("6")) {
                    map[jj - 1][ii] = "1";
                }
                if (map[jj][ii - 1].equals("6")) {
                    map[jj][ii - 1] = "1";
                }
                if (!map[jj - 1][ii - 1].equals("6")) continue;
                map[jj - 1][ii - 1] = "1";
            }
        }
        for (jj = height - 1; jj > 0; --jj) {
            for (ii = width - 1; ii > 0; --ii) {
                if (!map[jj][ii].equals("1")) continue;
                if (map[jj - 1][ii].equals("6")) {
                    map[jj - 1][ii] = "2";
                }
                if (map[jj][ii - 1].equals("6")) {
                    map[jj][ii - 1] = "2";
                }
                if (!map[jj - 1][ii - 1].equals("6")) continue;
                map[jj - 1][ii - 1] = "2";
            }
        }
        for (jj = height - 1; jj > 0; --jj) {
            for (ii = width - 1; ii > 0; --ii) {
                if (!map[jj][ii].equals("2")) continue;
                if (map[jj - 1][ii].equals("6")) {
                    map[jj - 1][ii] = "3";
                }
                if (map[jj][ii - 1].equals("6")) {
                    map[jj][ii - 1] = "3";
                }
                if (!map[jj - 1][ii - 1].equals("6")) continue;
                map[jj - 1][ii - 1] = "3";
            }
        }
        for (jj = height - 1; jj > 0; --jj) {
            for (ii = width - 1; ii > 0; --ii) {
                if (!map[jj][ii].equals("3")) continue;
                if (map[jj - 1][ii].equals("6")) {
                    map[jj - 1][ii] = "4";
                }
                if (map[jj][ii - 1].equals("6")) {
                    map[jj][ii - 1] = "4";
                }
                if (!map[jj - 1][ii - 1].equals("6")) continue;
                map[jj - 1][ii - 1] = "4";
            }
        }
        for (jj = height - 1; jj > 0; --jj) {
            for (ii = width - 1; ii > 0; --ii) {
                if (!map[jj][ii].equals("4")) continue;
                if (map[jj - 1][ii].equals("6")) {
                    map[jj - 1][ii] = "5";
                }
                if (map[jj][ii - 1].equals("6")) {
                    map[jj][ii - 1] = "5";
                }
                if (!map[jj - 1][ii - 1].equals("6")) continue;
                map[jj - 1][ii - 1] = "5";
            }
        }
        return map;
    }

    public void updateMap(TilePosition position, UnitType building, boolean destroyed) {
        int jj;
        int j;
        int ii;
        int j2;
        int i;
        TilePosition buildingSize = building.tileSize();
        int tamY = buildingSize.getY();
        int tamX = buildingSize.getX();
        for (i = position.getY() - 1; i < position.getY() + tamY + 1; ++i) {
            for (j2 = position.getX() - 1; j2 < position.getX() + tamX + 1; ++j2) {
                if (i < 0 || i >= this.height || j2 < 0 || j2 >= this.width) continue;
                if (destroyed) {
                    if (i == position.getY() - 1 || i == position.getY() + tamY || j2 == position.getX() - 1 || j2 == position.getX() + tamX) {
                        if (this.map[i][j2].equals("0")) continue;
                        this.map[i][j2] = "6";
                        continue;
                    }
                    if (this.map[i][j2].equals("V")) continue;
                    this.map[i][j2] = "6";
                    continue;
                }
                if (i == position.getY() - 1 || i == position.getY() + tamY || j2 == position.getX() - 1 || j2 == position.getX() + tamX || this.map[i][j2].equals("M") || this.map[i][j2].equals("V") || this.map[i][j2].equals("0") || this.map[i][j2].equals("E") || this.map[i][j2].equals("B")) continue;
                this.map[i][j2] = building == UnitType.Terran_Bunker ? "0" : "E";
            }
        }
        if (building.canBuildAddon()) {
            for (i = position.getY() + tamY; i > position.getY() + tamY - 4; --i) {
                for (j2 = position.getX() + tamX - 1; j2 < position.getX() + tamX + 3; ++j2) {
                    if (i < 0 || i >= this.height || j2 < 0 || j2 >= this.width) continue;
                    if (destroyed) {
                        if (i == position.getY() + tamY - 3 || i == position.getY() + tamY || j2 == position.getX() + tamX + 2 || j2 == position.getX() + tamX - 1) {
                            if (this.map[i][j2].equals("0")) continue;
                            this.map[i][j2] = "6";
                            continue;
                        }
                        if (this.map[i][j2].equals("V")) continue;
                        this.map[i][j2] = "6";
                        continue;
                    }
                    if (i == position.getY() + tamY - 3 || i == position.getY() + tamY || j2 == position.getX() + tamX + 2 || j2 == position.getX() + tamX - 1 || this.map[i][j2].equals("M") || this.map[i][j2].equals("V") || this.map[i][j2].equals("0") || this.map[i][j2].equals("E") || this.map[i][j2].equals("B")) continue;
                    this.map[i][j2] = "E";
                }
            }
        }
        int init_i = 0;
        if (position.getY() - this.height > 0) {
            init_i = position.getY() - this.height;
        }
        int end_i = this.height;
        if (position.getY() + tamY + this.height < this.height) {
            end_i = position.getY() + tamY + this.height;
        }
        int init_j = 0;
        if (position.getX() - this.width > 0) {
            init_j = position.getX() - this.width;
        }
        int fin_j = this.width;
        if (position.getX() + tamX + this.width < this.width) {
            fin_j = position.getX() + tamX + this.width;
        }
        String[][] submap = new String[end_i - init_i][fin_j - init_j];
        int i2 = 0;
        for (ii = init_i; ii < end_i; ++ii) {
            j = 0;
            for (jj = init_j; jj < fin_j; ++jj) {
                submap[i2][j] = this.map[ii][jj].equals("M") || this.map[ii][jj].equals("V") || this.map[ii][jj].equals("0") || this.map[ii][jj].equals("E") || this.map[ii][jj].equals("B") ? this.map[ii][jj] : "6";
                ++j;
            }
            ++i2;
        }
        submap = this.fillMap(submap);
        i2 = 0;
        for (ii = init_i; ii < end_i; ++ii) {
            j = 0;
            for (jj = init_j; jj < fin_j; ++jj) {
                this.map[ii][jj] = submap[i2][j];
                ++j;
            }
            ++i2;
        }
    }

    private TilePosition findPositionArea(UnitType buildingType, Area a) {
        TilePosition buildingSize = buildingType.tileSize();
        int size = Math.max(buildingSize.getY(), buildingSize.getX());
        if (buildingType.canBuildAddon()) {
            size = Math.max(buildingSize.getY(), buildingSize.getX() + 2);
        }
        Set<TilePosition> tilesToCheck = tilesArea.get(a);
        for (TilePosition t : tilesToCheck) {
            int jj;
            int ii = t.getY();
            if (this.map[ii][jj = t.getX()].equals("M") || this.map[ii][jj].equals("V") || this.map[ii][jj].equals("E") || this.map[ii][jj].equals("B") || Integer.parseInt(this.map[ii][jj]) < size || !this.checkUnitsChosenBuildingGrid(t, buildingType)) continue;
            return t;
        }
        return null;
    }

    public TilePosition findPositionNew(UnitType buildingType, TilePosition starting) {
        if (buildingType == UnitType.Terran_Bunker || buildingType == UnitType.Terran_Missile_Turret) {
            return this.findPosition(buildingType, starting);
        }
        Area find = this.bwem.getMap().getArea(starting);
        if (find == null) {
            return this.findPosition(buildingType, starting);
        }
        TilePosition tile = this.findPositionArea(buildingType, find);
        if (tile != null) {
            return tile;
        }
        for (Base b : Ecgberht.getGs().CCs.keySet()) {
            if (find.equals(b.getArea()) || Ecgberht.getGs().fortressSpecialBLs.containsKey(b) && buildingType != UnitType.Terran_Starport || (tile = this.findPositionArea(buildingType, b.getArea())) == null) continue;
            return tile;
        }
        return this.findPosition(buildingType, starting);
    }

    private TilePosition findPosition(UnitType buildingType, TilePosition starting) {
        TilePosition buildingSize = buildingType.tileSize();
        int size = Math.max(buildingSize.getY(), buildingSize.getX());
        if (buildingType.canBuildAddon()) {
            size = Math.max(buildingSize.getY(), buildingSize.getX() + 2);
        }
        if (starting == null) {
            starting = Ecgberht.getGs().getPlayer().getStartLocation();
        }
        int x = starting.getY();
        int y = starting.getX();
        int[] coord = new int[2];
        int i = 2;
        int j = 2;
        boolean control = false;
        while (!control) {
            for (int ii = x - i; ii <= x + i; ++ii) {
                for (int jj = y - j; jj <= y + j; ++jj) {
                    Area bunk;
                    if (ii < 0 || ii >= this.height || jj < 0 || jj >= this.width || this.map[ii][jj].equals("M") || this.map[ii][jj].equals("V") || this.map[ii][jj].equals("E") || this.map[ii][jj].equals("B") || Integer.parseInt(this.map[ii][jj]) < size || buildingType == UnitType.Terran_Bunker && (bunk = this.bwem.getMap().getArea(new TilePosition(jj, ii))) != null && !bunk.equals(this.bwem.getMap().getArea(this.self.getStartLocation())) || !this.checkUnitsChosenBuildingGrid(new TilePosition(jj, ii), buildingType)) continue;
                    coord[0] = ii;
                    coord[1] = jj;
                    control = true;
                    break;
                }
                if (control) break;
            }
            ++i;
            ++j;
        }
        return new TilePosition(coord[1], coord[0]);
    }

    public boolean tileBuildable(TilePosition pos, UnitType type) {
        int x = pos.getY();
        int y = pos.getX();
        int size = Math.max(type.tileSize().getY(), type.tileSize().getX());
        return !this.map[x][y].equals("M") && !this.map[x][y].equals("V") && !this.map[x][y].equals("E") && !this.map[x][y].equals("B") && Integer.parseInt(this.map[x][y]) >= size;
    }

    public TilePosition findBunkerPosition(ChokePoint choke) {
        TilePosition buildingSize = UnitType.Terran_Bunker.tileSize();
        int size = Math.max(buildingSize.getY(), buildingSize.getX());
        double chokeWidth = Util.getChokeWidth(choke);
        Position starting = choke.getCenter().toPosition();
        int x = starting.toTilePosition().getY();
        int y = starting.toTilePosition().getX();
        int i = 10;
        int j = 10;
        boolean expandBunker = choke.equals(Ecgberht.getGs().naturalChoke);
        TilePosition position = null;
        double dist = Double.MAX_VALUE;
        for (int ii = x - i; ii <= x + i; ++ii) {
            for (int jj = y - j; jj <= y + j; ++jj) {
                Area area;
                if (ii < 0 || ii >= this.height || jj < 0 || jj >= this.width || this.map[ii][jj].equals("M") || this.map[ii][jj].equals("V") || this.map[ii][jj].equals("E") || this.map[ii][jj].equals("B") || Integer.parseInt(this.map[ii][jj]) < size || (area = this.bwem.getMap().getArea(new TilePosition(jj, ii))) != null && area.equals(Ecgberht.getGs().naturalArea) && !expandBunker || area != null && !area.equals(Ecgberht.getGs().naturalArea) && expandBunker || !this.checkUnitsChosenBuildingGrid(new TilePosition(jj, ii), UnitType.Terran_Bunker)) continue;
                TilePosition newPosition = new TilePosition(jj, ii);
                Position centerBunker = Util.getUnitCenterPosition(newPosition.toPosition(), UnitType.Terran_Bunker);
                if (chokeWidth <= 64.0 && Util.broodWarDistance(choke.getCenter().toPosition(), centerBunker) <= 64.0) continue;
                double newDist = Util.broodWarDistance(centerBunker, starting);
                if (position != null && !(newDist < dist)) continue;
                position = newPosition;
                dist = newDist;
            }
        }
        return position;
    }

    private boolean checkUnitsChosenBuildingGrid(TilePosition BL, UnitType type) {
        try {
            Position topLeft = new Position(BL.getX() * 32, BL.getY() * 32);
            Position bottomRight = new Position(topLeft.getX() + type.tileWidth() * 32, topLeft.getY() + type.tileHeight() * 32);
            List<Unit> blockers = Util.getUnitsInRectangle(topLeft, bottomRight);
            if (blockers.isEmpty() && !Ecgberht.getGs().getGame().canBuildHere(BL, type)) {
                return false;
            }
            if (blockers.isEmpty()) {
                return true;
            }
            if (blockers.size() > 1) {
                return false;
            }
            Unit blocker = blockers.get(0);
            return blocker instanceof PlayerUnit && ((PlayerUnit)blocker).getPlayer().getId() == this.self.getId() && blocker instanceof Worker && ((Worker)blocker).getBuildType() == type;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public TilePosition findBunkerPositionAntiPool() {
        TilePosition starting = Ecgberht.getGs().MBs.iterator().next().getTilePosition();
        TilePosition buildingSize = UnitType.Terran_Bunker.tileSize();
        int size = Math.max(buildingSize.getY(), buildingSize.getX());
        int x = starting.getY();
        int y = starting.getX();
        ChokePoint choke = Ecgberht.getGs().mainChoke;
        int i = 4;
        int j = 4;
        TilePosition bunkerPlace = null;
        double dist = Double.MAX_VALUE;
        for (int ii = x - i; ii <= x + i; ++ii) {
            for (int jj = y - j; jj <= y + j; ++jj) {
                if (ii < 0 || ii >= this.height || jj < 0 || jj >= this.width || this.map[ii][jj].equals("M") || this.map[ii][jj].equals("V") || this.map[ii][jj].equals("E") || this.map[ii][jj].equals("B") || Integer.parseInt(this.map[ii][jj]) < size || this.bwem.getMap().getArea(new TilePosition(jj, ii)).equals(Ecgberht.getGs().naturalArea) || !this.checkUnitsChosenBuildingGrid(new TilePosition(jj, ii), UnitType.Terran_Bunker)) continue;
                TilePosition newPosition = new TilePosition(jj, ii);
                double newDist = Util.broodWarDistance(Util.getUnitCenterPosition(newPosition.toPosition(), UnitType.Terran_Bunker), choke.getCenter().toPosition());
                if (bunkerPlace != null && !(newDist < dist)) continue;
                bunkerPlace = newPosition;
                dist = newDist;
            }
        }
        return bunkerPlace;
    }

    public void writeMap(String fileName) {
        FileWriter sw = null;
        try {
            sw = new FileWriter(fileName);
            for (int ii = 0; ii < this.height; ++ii) {
                for (int jj = 0; jj < this.width; ++jj) {
                    try {
                        sw.write(this.map[ii][jj]);
                        continue;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (ii == this.height - 1) continue;
                try {
                    sw.write("\n");
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            sw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static class tilesAreaComparator
    implements Comparator<TilePosition> {
        private TilePosition center;

        private tilesAreaComparator(TilePosition center) {
            this.center = center;
        }

        @Override
        public int compare(TilePosition o1, TilePosition o2) {
            double dist2;
            if (o1.equals(o2)) {
                return 0;
            }
            double dist1 = o1.getDistance(this.center);
            return dist1 < (dist2 = o2.getDistance(this.center)) ? -1 : 1;
        }
    }
}

