/*
 * Decompiled with CFR 0.152.
 */
package ecgberht.BehaviourTrees.Training;

import ecgberht.GameState;
import ecgberht.Util.MutablePair;
import ecgberht.Util.Util;
import org.iaie.btree.BehavioralTree;
import org.iaie.btree.task.leaf.Action;
import org.openbw.bwapi4j.TilePosition;
import org.openbw.bwapi4j.type.UnitType;
import org.openbw.bwapi4j.unit.TrainingFacility;

public class TrainUnit
extends Action {
    public TrainUnit(String name, GameState gh) {
        super(name, gh);
    }

    @Override
    public BehavioralTree.State execute() {
        try {
            if (this.gameState.chosenUnit == UnitType.None) {
                return BehavioralTree.State.FAILURE;
            }
            TrainingFacility chosen = this.gameState.chosenTrainingFacility;
            if (this.gameState.getStrat().name.equals("ProxyBBS")) {
                if (Util.countBuildingAll(UnitType.Terran_Barracks) == 2 && Util.countBuildingAll(UnitType.Terran_Supply_Depot) == 0) {
                    this.gameState.chosenTrainingFacility = null;
                    this.gameState.chosenToBuild = UnitType.None;
                    return BehavioralTree.State.FAILURE;
                }
                if (this.gameState.getSupply() > 0) {
                    chosen.train(this.gameState.chosenUnit);
                    return BehavioralTree.State.SUCCESS;
                }
            }
            if (this.gameState.getStrat().name.equals("ProxyEightRax")) {
                if (Util.countBuildingAll(UnitType.Terran_Barracks) == 0 && this.gameState.supplyMan.getSupplyUsed() >= 16) {
                    this.gameState.chosenTrainingFacility = null;
                    this.gameState.chosenToBuild = UnitType.None;
                    return BehavioralTree.State.FAILURE;
                }
                if (this.gameState.getSupply() > 0) {
                    chosen.train(this.gameState.chosenUnit);
                    return BehavioralTree.State.SUCCESS;
                }
            }
            if (this.gameState.getSupply() > 4 || this.gameState.checkSupply() || this.gameState.getPlayer().supplyTotal() >= 400) {
                if (!this.gameState.defense && this.gameState.chosenToBuild == UnitType.Terran_Command_Center) {
                    boolean found = false;
                    for (MutablePair<UnitType, TilePosition> w : this.gameState.workerBuild.values()) {
                        if (w.first != UnitType.Terran_Command_Center) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        this.gameState.chosenTrainingFacility = null;
                        this.gameState.chosenUnit = UnitType.None;
                        return BehavioralTree.State.FAILURE;
                    }
                }
                chosen.train(this.gameState.chosenUnit);
                return BehavioralTree.State.SUCCESS;
            }
            return BehavioralTree.State.FAILURE;
        }
        catch (Exception e) {
            System.err.println(this.getClass().getSimpleName());
            e.printStackTrace();
            return BehavioralTree.State.ERROR;
        }
    }
}

