/*
 * Decompiled with CFR 0.152.
 */
package ecgberht.BehaviourTrees.Training;

import ecgberht.GameState;
import ecgberht.Util.MutablePair;
import ecgberht.Util.Util;
import org.iaie.btree.BehavioralTree;
import org.iaie.btree.task.leaf.Action;
import org.openbw.bwapi4j.type.UnitType;
import org.openbw.bwapi4j.unit.Factory;

public class ChooseTank
extends Action {
    public ChooseTank(String name, GameState gh) {
        super(name, gh);
    }

    @Override
    public BehavioralTree.State execute() {
        try {
            if (!this.gameState.Fs.isEmpty()) {
                if (this.gameState.getStrat().trainUnits.contains(UnitType.Terran_Wraith) && this.gameState.maxWraiths - Util.countUnitTypeSelf(UnitType.Terran_Wraith) > 0 && Math.random() * 10.0 <= 1.0) {
                    return BehavioralTree.State.FAILURE;
                }
                int multiplier = 2;
                String strat = this.gameState.getStrat().name;
                if (strat.equals("JoyORush") && this.gameState.tanksTrained == 3 && Util.countUnitTypeSelf(UnitType.Terran_Siege_Tank_Tank_Mode) == 3) {
                    return BehavioralTree.State.FAILURE;
                }
                if (strat.equals("FullMech") || strat.equals("MechGreedyFE")) {
                    multiplier = 15;
                }
                if (Util.countUnitTypeSelf(UnitType.Terran_Siege_Tank_Siege_Mode) + Util.countUnitTypeSelf(UnitType.Terran_Siege_Tank_Tank_Mode) < Util.countUnitTypeSelf(UnitType.Terran_Marine) * multiplier) {
                    MutablePair<Integer, Integer> cash = this.gameState.getCash();
                    if ((Integer)cash.second < UnitType.Terran_Siege_Tank_Tank_Mode.gasPrice()) {
                        return BehavioralTree.State.FAILURE;
                    }
                    for (Factory b : this.gameState.Fs) {
                        if (b.isTraining() || !b.canTrain(UnitType.Terran_Siege_Tank_Tank_Mode)) continue;
                        this.gameState.chosenUnit = UnitType.Terran_Siege_Tank_Tank_Mode;
                        this.gameState.chosenTrainingFacility = b;
                        return BehavioralTree.State.SUCCESS;
                    }
                }
            }
            return BehavioralTree.State.FAILURE;
        }
        catch (Exception e) {
            System.err.println(this.getClass().getSimpleName());
            e.printStackTrace();
            return BehavioralTree.State.ERROR;
        }
    }
}

