/*
 * Decompiled with CFR 0.152.
 */
package ecgberht.BehaviourTrees.Training;

import ecgberht.GameState;
import org.iaie.btree.BehavioralTree;
import org.iaie.btree.task.leaf.Action;
import org.openbw.bwapi4j.type.UnitType;
import org.openbw.bwapi4j.unit.Armory;
import org.openbw.bwapi4j.unit.Factory;
import org.openbw.bwapi4j.unit.Unit;

public class ChooseGoliath
extends Action {
    public ChooseGoliath(String name, GameState gh) {
        super(name, gh);
    }

    @Override
    public BehavioralTree.State execute() {
        try {
            if (this.gameState.UBs.stream().filter(unit -> unit instanceof Armory).count() < 1L) {
                return BehavioralTree.State.FAILURE;
            }
            int count = 0;
            for (Unit unit2 : this.gameState.getGame().getUnits(this.gameState.getPlayer())) {
                if (!unit2.exists()) continue;
                if (unit2.getType() == UnitType.Terran_Goliath) {
                    ++count;
                }
                if (count < this.gameState.maxGoliaths) continue;
                return BehavioralTree.State.FAILURE;
            }
            if (!this.gameState.Fs.isEmpty()) {
                for (Factory factory : this.gameState.Fs) {
                    if (factory.isTraining() || !factory.canTrain(UnitType.Terran_Goliath)) continue;
                    this.gameState.chosenUnit = UnitType.Terran_Goliath;
                    this.gameState.chosenTrainingFacility = factory;
                    return BehavioralTree.State.SUCCESS;
                }
            }
            return BehavioralTree.State.FAILURE;
        }
        catch (Exception e) {
            System.err.println(this.getClass().getSimpleName());
            e.printStackTrace();
            return BehavioralTree.State.ERROR;
        }
    }
}

